/*
 * Copyright (C) 1995 by CERN/CN/PDP/CS
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)mstatus.c	1.3 07/20/95 CERN CN-PDP/CS Felix Hassine";
#endif /* not lint */

/* mstatus.c : get status of file for many of them by inputting a list  */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#define RFIO_KERNEL 1
#include "rfio.h"
#include "log.h"

/*
 * This is also a test for mstat() calls.
 */


main(argc,argv)
int argc ;
char *argv[] ;
{
	FILE * fs ;
	char *host,*filename ;
	char fbuf[1024];
	struct stat statbuf1 ;
	int rc ;

	if ( argc != 2 ) {
		fprintf(stderr,"Usage : %s <list_of_files>\n",argv[0]);
		exit(1);
	}
	fs = fopen(argv[1], "r") ;
	if (fs == NULL ) {
		perror("Cannot open input file");
		exit(1);
	}

	printf(" FILE\tSIZE\tUID\tGID\n");
	while( fscanf(fs, "%s%*[^\n]\n", fbuf) != EOF ) {
		rc = rfio_mstat(fbuf,&statbuf1);
		if ( !rc ) {
			printf(" %s\t%d\t%d\t%d\n",fbuf,statbuf1.st_size,statbuf1.st_uid,statbuf1.st_gid);
	/*
	 * Uncomment the following lines depending on the 
	 * Information you need to get about the file
	 *
	 
                	printf(" dev = %d \n",statbuf1.st_dev);
                	printf(" st_ino = %d\n",statbuf1.st_ino );
                	printf(" st_mode = %d\n",statbuf1.st_mode );
                	printf(" st_nlink = %d\n",statbuf1.st_nlink);
                	printf(" st_uid = %d \n",statbuf1.st_uid );
                	printf("st_gid = %d \n",statbuf1.st_gid) ;
                	printf("st_size = %d\n",statbuf1.st_size);
                	printf("st_atime = %d\n",statbuf1.st_atime );
                	printf("st_blksize = %d\n",statbuf1.st_blksize);
                	printf("st_blocks = %d\n",statbuf1.st_blocks );
	 *
	 *
	 */
		}
		else
			printf("error in file %s: errno %d, rfio_errno=%d\n", fbuf,errno,rfio_errno );

		log(LOG_INFO,"file %s gave status at rfio_mstat():%d\n",fbuf,rc);
	}
	fclose(fs) ;
	rfio_end() ;
	exit(0);
}
