/*
 * Copyright (C) 1992 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)fhsreq.c	1.3 05/04/93 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/* 	fhsreq - test FHS exits */
/*
 *	options on the command line
 *
 *	-D	device name
 *	-o	function
 *	-V	vid
*/
#include <stdio.h>
#include <sys/types.h>
#if cray
#include <sys/jtab.h>
#endif
#include <signal.h>
#include <time.h>
#include TAPEINC
#include "fhs.h"
extern char *optarg;
#if cray
char msgfn[MAXPATH]="";
#else
int fhs_mount_failed;
char repbuf[FHPRTBUFSZ];
#endif
struct vsn_req vsn_req;
main(argc, argv)
int argc;
char **argv;
{
	int c;
	void cleanup();
	int errflg = 0;
	struct fhdqrep fhdqrep;
	struct fhdqreq *fqrp;
	char *getenv();
#if cray
	struct jtab jtab;
#endif
	char *qptr;
	struct fhdreq qreq;
	int repsize;
	int type = 0;

	memset ((char *)&vsn_req, 0, sizeof(struct vsn_req));
	while ((c = getopt (argc, argv, "D:o:V:")) != EOF) {
		switch (c) {
			case 'D':
				strcpy (vsn_req.dvn, optarg);
				break;
			case 'o':
				if (!strcmp (optarg, "MV"))
					type = FHMOUNTV;
				else if (!strcmp (optarg, "DM"))
					type = FHDMOUNTV;
				else if (!strcmp (optarg, "FD"))
					type = FHFRCDMNT;
				else
					errflg++;
				break;
			case 'V':
				strcpy (vsn_req.vid[0], optarg);
				strcpy (vsn_req.vsn[0], optarg);
				vsn_req.num = 1;
				break;
			default:
				errflg++;
		}
	}
	if (vsn_req.dvn[0] == '\0' || type == 0 ||
	   (vsn_req.num == 0 && type != FHFRCDMNT)) {
		fprintf (stderr, "-D, -o and -V parameters are mandatory\n");
		errflg++;
	}
	if (errflg) {
		usage (argv[0]);
		exit (38);
	}
	vsn_req.uid = getuid();
	vsn_req.gid = getgid();
#if cray
	vsn_req.jid = getjtab(&jtab);
#else
	vsn_req.jid = findpgrp();
#endif
	if ((qptr = getenv("QSUB_REQID")) != NULL) {    /* NQS batch job id */
		strcpy(vsn_req.nqsid, qptr);
	} else {
		vsn_req.nqsid[0] = '\0';
	}
	vsn_req.path[0] = '\0';

	signal (SIGHUP, cleanup);
	signal (SIGINT, cleanup);
	signal (SIGQUIT, cleanup);
	signal (SIGTERM, cleanup);

	/* send MOUNT/DEMOUNT request */

	c = fhsexit (&vsn_req, type);
#ifndef cray
	if (repbuf[0]) fprintf (stderr, "%s\n", repbuf);
#endif
	/* if DEMOUNT request, does not wait for reply */

	if (type != FHMOUNTV) exit (0);

	/* build query block */

	memset ((char *)&qreq, 0, sizeof(struct fhdrqhdr) + sizeof(struct fhdqreq));
	qreq.rh.size = sizeof(struct fhdrqhdr) + sizeof(struct fhdqreq);
	qreq.rh.code = FHSQUERY;
	fqrp = (struct fhdqreq *) qreq.data;
	fqrp->jid = vsn_req.jid;
	strcpy (fqrp->dvn, vsn_req.dvn);
	strcpy (fqrp->vid, vsn_req.vid[0]);

	while (1) {
		if (sleep (10) != 0) exit (1);		/* interrupted */
		c = send2fhsd (&qreq, &fhdqrep, &repsize);
		if (c != 0) continue;
		if (fhdqrep.rtype == 'F' &&
		    fhdqrep.status == 0) break;	/* request completed */
	}
	exit (0);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "-D device -o [MV, DM, FD] -V vid\n");
}

void cleanup(sig)
int sig;
{
	int c;

	signal (sig, SIG_IGN);
	c = fhsexit (&vsn_req, FHDMOUNTV);
	fprintf (stderr, "fhsexit(DM), rc = %d\n", c);
	if (c != 0) exit (1);
	exit (0);
}

#if cray
#include <fcntl.h>
errmsg(func, ec, msg, p1, p2, p3, p4, p5)
char *func;
int ec;
char *msg;
{
	char prtbuf[FHPRTBUFSZ];
	struct tm *tm;
	time_t current_time;
	int fd_log;

	if (msgfn[0] != '\0') {
		time (&current_time);		/* Get current time */
		tm = localtime (&current_time);
		sprintf (prtbuf, "%02d/%02d %02d:%02d:%02d ", tm->tm_mon+1,
			tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec);
		sprintf (prtbuf+strlen(prtbuf), msg, p1, p2, p3, p4, p5);
		strcat (prtbuf, "\n");
		fd_log = open (msgfn, O_WRONLY | O_CREAT | O_APPEND, 0664);
		write (fd_log, prtbuf, strlen(prtbuf));
		close (fd_log);
	} else {
		fprintf (stderr, msg, p1, p2, p3, p4, p5);
		fprintf (stderr, "\n");
	}
}

usrmsg(func, msg, p1, p2, p3, p4, p5)
char *func;
char *msg;
{
	extern char msgfn[];
	char prtbuf[FHPRTBUFSZ];
	struct tm *tm;
	time_t current_time;
	int fd_log;

	if (msgfn[0] != '\0') {
		time (&current_time);		/* Get current time */
		tm = localtime (&current_time);
		sprintf (prtbuf, "%02d/%02d %02d:%02d:%02d ", tm->tm_mon+1,
			tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec);
		sprintf (prtbuf+strlen(prtbuf), msg, p1, p2, p3, p4, p5);
		strcat (prtbuf, "\n");
		fd_log = open (msgfn, O_WRONLY | O_CREAT | O_APPEND, 0664);
		write (fd_log, prtbuf, strlen(prtbuf));
		close (fd_log);
	}
}
#endif
