/*
 * Copyright (C) 1992 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)send2fhsd.c	1.3 02/14/94 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	send2fhsd - send request to fhs daemon and get reply */

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#if _AIX
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/un.h>
#endif
#include "fhs.h"
send2fhsd(treqp, trepp, repsize)
struct fhdreq *treqp;
char *trepp;
int *repsize;
{
	int c;
	char func[16];
	struct fhdrphdr fhdrphdr;
#if _AIX
	int s;
	struct sockaddr_un sname;
#else
	int rpfd, rqfd;
	char *tempnam();
#endif

	strcpy (func, "send2fhsd");

#if _AIX
	/* create socket to communicate with fhsdaemon */

	if ((s = socket (AF_UNIX, SOCK_STREAM, 0)) < 0) {
		fhslogit (func, FHS01, REQPIPE, "socket", errno);
		return (EFHSSYS);
	}
	sname.sun_family = AF_UNIX;
	strcpy (sname.sun_path, REQPIPE);
	if (connect (s, (struct sockaddr *) &sname, sizeof(sname)) < 0) {
		if (errno == ECONNREFUSED) {
			fhslogit (func, FHS00);
			close (s);
			return (EFHSSYS);
		} else {
			fhslogit (func, FHS01, REQPIPE, "connect", errno);
			close (s);
			return (EFHSSYS);
		}
	}

	/* send request to fhsdaemon */

	if (WRITE (s, (char *) treqp, treqp->rh.size) < 0) {
		fhslogit (func, FHS01, REQPIPE, "send", errno);
		close (s);
		return (EFHSSYS);
	}

	/* get reply */

	c = READ (s, (char *) &fhdrphdr, sizeof(struct fhdrphdr));

	if (c != sizeof(struct fhdrphdr)) {
		fhslogit (func, FHS01, REQPIPE, "recv", errno);
		close (s);
		return (EFHSSYS);
	}
	if ((*repsize = fhdrphdr.size - sizeof(struct fhdrphdr)) != 0)
		if (READ (s, trepp, *repsize) != *repsize) {
			fhslogit (func, FHS01, REQPIPE, "recv", errno);
			close (s);
			return (EFHSSYS);
		}
	close (s);
#else
	/* make reply pipe */

	strcpy (treqp->rh.rpn, tempnam(NULL, "fhs"));
	if (mknod (treqp->rh.rpn, 0010700, 0) < 0) {
		fhslogit (func, FHS01, treqp->rh.rpn, "mknod", errno);
		return (EFHSSYS);
	}
	if ((rpfd = open (treqp->rh.rpn, O_RDWR)) < 0) {
		fhslogit (func, FHS01, treqp->rh.rpn, "open", errno);
		return (EFHSSYS);
	}

	/* open request pipe to fhsdaemon */

	while ((rqfd = open (REQPIPE, O_WRONLY | O_NDELAY)) < 0) {
		switch (errno) {
			case ENFILE:
				sleep (1);
				continue;
			case ENOENT:
			case ENXIO:
				fhslogit (func, FHS00);
				close (rpfd);
				unlink (treqp->rh.rpn);
				return (EFHSSYS);
			default:
				fhslogit (func, FHS01, REQPIPE, "open", errno);
				close (rpfd);
				unlink (treqp->rh.rpn);
				return (EFHSSYS);
		}
	}

	/* send request to fhsdaemon */

	if (write (rqfd, (char *) treqp, treqp->rh.size) != treqp->rh.size) {
		fhslogit (func, FHS01, REQPIPE, "write", errno);
		close (rqfd);
		close (rpfd);
		unlink (treqp->rh.rpn);
		return (EFHSSYS);
	}
	close (rqfd);

	/* get reply */

	c = READ (rpfd, (char *) &fhdrphdr, sizeof(struct fhdrphdr));

	if (c != sizeof(struct fhdrphdr)) {
		fhslogit (func, FHS01, treqp->rh.rpn, "read", errno);
		close (rpfd);
		unlink (treqp->rh.rpn);
		return (EFHSSYS);
	}
	if ((*repsize = fhdrphdr.size - sizeof(struct fhdrphdr)) != 0)
		if (read (rpfd, trepp, *repsize) != *repsize) {
			fhslogit (func, FHS01, treqp->rh.rpn, "read", errno);
			close (rpfd);
			unlink (treqp->rh.rpn);
			return (EFHSSYS);
		}
	close (rpfd);
	unlink (treqp->rh.rpn);
#endif
	return (fhdrphdr.rc);
}
