/*
 * Copyright (C) 1990-1999 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)dktotpU.c	2.36 11/10/99 CERN CN-SW/DC Antoine Trannoy";
#endif /* not lint */

/* dktotp.c             SHIFT transferring data from remote disk to local tape.          */

#include <stdio.h>
#include <fcntl.h>
#include <malloc.h>
#include <sys/errno.h>
#include <serrno.h>

#if defined(apollo)
#include <strings.h>
#else
#include <string.h>
#endif	/* apollo */
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include "rtcopy.h"
#include <rfio.h>

extern char * getconfent() ;
extern char * getifnam() ;
extern int errno ; 		/* Error number		*/
extern int rfio_errno ;		/* Rfio error number 	*/
extern int serrno ;		/* Special error number */
#ifndef linux
extern char *sys_errlist[];
#endif /* linux */
#if defined (SONYRAW)
extern int sonyraw ; /* If this flag is raised, choose sony_read,sony_write ...*/
#endif /* SONYRAW */

/*
 * Static definitions
 */
static int dskon = 0 ;		/* Is disk file open ? */
int tpon = 0 ;			/* Is tape device open ? */
static int dskfd = 20 ; 	/* Fortran file number */
static int tpfd ;		/* Tape file descriptor */
static int irc = 0 ;		/* return status	*/
static struct stat statbuf ;
char tpdevtyp[9] = "";		/* Device type          */

#ifndef min
#define min(a,b)      (((a)<(b)) ? (a):(b))
#endif

#define	PAGE	4096
/*
 * Handler for signal SIGPIPE
 */
void hand() { (void) fprintf(stderr, RT136, "CPDSKTP") ; 
	      if ( getconfent("RTCOPYD","NETRETRY",0) != NULL && 
		     stat(NOMORETAPES, &statbuf) < 0)  {
				if ( dskon ) close(rfio_xysock(dskfd)) ;
				if ( tpon ) tcloserr(tpfd) ;
				exit(SYRETRY) ;
			}
			else {
				if ( dskon ) close(rfio_xysock(dskfd)) ;
				if ( tpon ) tcloserr(tpfd) ;
				exit(SYERR) ;
			}
	    }

/*
 * Transfer program
 */
main(argc,argv)
	int     argc ; 
	char ** argv ;
{
	/*
	 * To parse options.
	 */
	extern char   * optarg ; 
	extern int      optind ;
	extern long   strtol() ;
	extern char  *getenv() ;
	char 	          * cp ;
	int 		     c ; 	
	int         maxsiz = 0 ;
	int 	     free = -1 ;
	int 	 undersctl = 0 ;
	int	         error ;
	int 	 underNctl = 0 ;
	int 	     a2ebc = 0 ;
	static char tpden[8] = "" ;        /* Tape density         */

	/*
	 *  To log
	 */ 
	char  		  *ifce ;
	char 		ptr[10] ;

	/*
	 * To store options.
	 */
	int  blksiz=32760 ;		/* Block size		*/
	int 	nread= -1 ; 		/* Max nb of records	*/

	/*
	 * Buffer
	 */
	char 	    * buffer ;		/* Pointer to buffer	*/
	int 	      buflen ; 		/* Buffer length	*/

	/*
	 * Files 
	 */
	char  * dskfil ;		/* Disk file name	*/
	char  *  tpfil ; 		/* Tape file name	*/

	/*
	 * Counters
	 */
	int	total= 0 ; 		/* Total number of bytes transfered	*/
	int	 irec= 0 ; 		/* Index of the current record		*/
	time_t stime,etime ;


        /*
         * For storing the uid & gid & key of an external user
         */
        char    *special_uid = NULL;
        char    *special_gid = NULL;
        char    *special_key = NULL;
	char 	*reqhost     = NULL;

	/*
	 * Return code for system call.
	 */
	int 	irc,rc ; 
#if defined(linux)
        float   compress ;
        COMPRESSION_STATS compstats ;
#endif

	(void)signal(SIGPIPE,(void (*)())hand);

	/* 
	 * Input parameter analysis
	 */
	(void) fprintf(stderr, RT209, "CPDSKTP", 'U') ; 
	while( (c= getopt(argc,argv, "d:C:xb:t:N:X:s:T:")) != EOF ) {
		switch(c) {
			case 'x':
				break ;
                        case 'd':
                                strcpy(tpden,optarg) ;
                                break;
			case 'b':
				blksiz= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr, RT129, "CPDSKTP") ;
					exit(USERR) ;
				}
				(void) fprintf(stderr, RT204, "CPDSKTP", blksiz) ;
				break ; 
			case 't':
				tpfil= optarg ;
				break ; 
			case 'N':
				nread= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr, RT133, "CPDSKTP") ;
					exit(USERR) ;
				}
				if ( nread > 0 )  {
					(void) fprintf(stderr, RT207, "CPDSKTP", nread) ;
					underNctl ++ ;
				}
				break ; 
			case 's':
                                maxsiz= (int) strtol(optarg,&cp,10) ;
                                if ( *cp != '\0' ) {
                                        (void) fprintf(stderr, RT132, "CPDSKTP") ;
                                        exit(USERR) ;
                                }
                                if ( maxsiz > 0 )
                                        (void) fprintf(stderr, RT208, "CPDSKTP", maxsiz) ;
                                if ( maxsiz >= 2048 ) {
                                        (void) fprintf(stderr, RT220, "CPTPDSK") ;
                                        free = MAXFILESZ ;
                                }
                                else
                                        free = maxsiz*1024*1024 ;

				undersctl++ ;
				break ;
                        case 'C':
                                if ( !strcmp (optarg,"ebcdic") || !strcmp (optarg,"EBCDIC") ) {
                                        a2ebc ++ ;
#if defined(TRACE1)
                                fprintf(stderr," ebcdic conversion requested \n");
#endif  /* TRACE1 */
				(void) fprintf(stderr, RT213, "CPDSKTP") ;
                                }
                                break ;
		        case 'T':
			        strcpy(tpdevtyp,optarg);
				break;

			case '?':
				(void) fprintf(stderr, RT102, "CPDSKTP"); 
				exit(USERR) ;
		}
	}

	setdevtype(tpdevtyp,tpden);
#if defined(SONYRAW)
	if ( !strcmp(tpden,"RAW") || !strcmp(tpden,"raw") ) {
		sonyraw++ ;
	}
#endif /* SONYRAW */
	/*
	 * Buffer allocation
	 */
	buflen= ((blksiz+PAGE-1)/PAGE)*PAGE ;
	if ( ( buffer= ( char *) malloc((unsigned) buflen)) == NULL ) {
		(void) fprintf(stderr, RT105, "CPDSKTP", sys_errlist[errno]) ;
		exit(SYERR) ;
	}	

	/*
	 * Opening tape file as output.
	 */
	tpfd= topen(tpfil,O_RDWR) ;
	tpon ++ ;
	special_uid=getenv("ORI_UID");
	special_gid=getenv("ORI_GID");
	special_key=getenv("KEY");
	reqhost = getenv("REQHOST");

	/* 
	 * Reading one after the other all
	 * the disk files in order to read
	 * them.
	 */
	for(;optind<argc;optind++) {
		/*
		 * Opening the current disk file.
		 */
		dskfil= argv[optind] ;
		if ( special_uid != NULL && special_gid != NULL && special_key !=NULL && reqhost != NULL )
			rc= rfio_xyopen_ext(dskfil," ",dskfd,0,"US",&irc,
                                        (uid_t)atol(special_uid),
                                        (gid_t)atol(special_gid),
					 atoi(special_key),
					 reqhost) ;
		else
			rc= rfio_xyopen(dskfil," ",dskfd,0,"US",&irc) ;
		error = rc ? rc : irc ;
		if ( rc || irc ) {
			rtcplogit(argv[0],"rfio_xyopen() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
			(void) fprintf(stderr, RT110, "CPDSKTP", rfio_serror()) ;
			(void) tcloserr(tpfd) ; 
			switch ( error ) {
				case ENOENT:
				case EISDIR:
				case EPERM:
				case EACCES:
					exit(USERR);
				default:
					exit(UNERR) ;
			}
		}
		dskon ++ ;

		/*
		 * writing interface name
		 */

		if ( (ifce=getifnam(rfio_xysock(dskfd)))==NULL ) 
			strcpy( ptr, "unknown") ;
		else 
			strcpy( ptr, ifce ) ;


		(void) time(&stime) ;

		/*
		 * Loop of reading and writing
		 */
		for(;;) {
			int	 ngot ; 	/* Number of bytes just read	*/
			int     nwant ;		/* Number of bytes to read	*/

			nwant = blksiz ;
			if ( undersctl ) 
				if ( free < blksiz && free > 0 )  {
					(void) time(&etime) ;
					tclose(tpfd) ;
					rfio_xyclose(dskfd," ",&irc) ;
					(void) printf("%d:%d:%s\n",irec,total,ptr) ; 
					(void) fprintf(stderr, RT206, "CPDSKTP") ;
					(void) fprintf(stderr, RT201, "CPDSKTP", total) ; 
					(void) fprintf(stderr, RT202, "CPDSKTP", irec) ; 
					(void) fprintf(stderr, RT212, "CPDSKTP");
					total/=1024 ;
			       		if ( etime-stime > 0 )
						(void) fprintf(stderr, RT221,"CPDSKTP",total,ptr,total/(etime-stime));
					rtcplogit(argv[0],"Exiting with code %d",LIMBYSZ);
					exit(LIMBYSZ) ;
				}

			rc= rfio_xyread(dskfd,buffer,0,nwant,&ngot,"U",&irc) ;
			if ( irc == 2 ) {
				/* 
				 * End of file has been reached.
				 */
				break ; 
			}
                        if ( irc == SEBADFFORM ) {
                                (void) fprintf(stderr, RT106, "CPDSKTP");
				rtcplogit(argv[0],"rfio_xyread() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
                                (void) tcloserr(tpfd) ;
				rfio_xyclose(dskfd," ",&irc) ;
                                exit(USERR) ;
                        }
			else if ( irc == -1 && rc == -1 ) {
				(void) fprintf(stderr, RT123, "CPDSKTP", blksiz);
				rtcplogit(argv[0],"rfio_xyread() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
				(void) tcloserr(tpfd) ;
				rfio_xyclose(dskfd," ",&irc) ;
				exit(USERR);
			}
			else if ( irc || rc ) {
				(void) fprintf(stderr, RT112, "CPDSKTP", rfio_serror()) ; 
				rtcplogit(argv[0],"rfio_xyread() : errno = %d, serrno = %d, rfio_errno = %d", errno, serrno, rfio_errno ) ;
				(void) tcloserr(tpfd) ; 
				rfio_xyclose(dskfd," ",&irc) ;
				exit(UNERR) ;
			}

			
                       /* Write the tape in edcdic format ,disk file is ascii */

                        if ( ngot > 0 && a2ebc ) {
                                asc2ebc(buffer,ngot);
			}

			(void) twrite(tpfd,buffer,ngot) ;
			total += ngot ;
			irec ++ ;
			free -= ngot ;
			if ( nread != -1 ) {
				nread -- ;
				if ( nread == 0 ) {
					(void) rfio_xyclose(dskfd," ",&irc) ; 
					goto endtransfer ;
				}
			}	
		}
	(void) time(&etime) ;
	(void) rfio_xyclose(dskfd," ",&irc) ; 
	}

/*
 * End of transfer
 */
endtransfer:

	if ( total ) {
		(void) printf("%d:%d:%s\n",nread,total,ptr) ; 
		(void) fprintf(stderr, RT206, "CPDSKTP") ;
		(void) fprintf(stderr, RT201, "CPDSKTP", total) ; 
		(void) fprintf(stderr, RT202, "CPDSKTP", irec) ; 
		total/=1024 ;
	        if ( etime-stime > 0 ) 
			(void) fprintf(stderr, RT221, "CPDSKTP",total,ptr,total/(etime-stime));
		(void) tclose(tpfd) ; 
		if ( nread == 0 && underNctl ) {
			(void) fprintf(stderr, RT212, "CPDSKTP");
			fflush (stderr) ;
			exit(LIMBYSZ) ;
		}
		else
			exit(0) ;
	}
	else	{
		/*
		 * No data has been written to tape.
		 */ 
		(void) fprintf(stderr, RT121, "CPDSKTP") ; 
		(void) tclose(tpfd) ; 
		exit(USERR) ; 
	}
}
