/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tpsinfod.c	1.7 05/08/98 CERN CN-SW/DC Frederic Hemmer";
#endif /* not lint */

/* info  SHIFT remote file access super server                   */

#include <signal.h>			/* Signal handling		*/
#include <syslog.h>			/* System logger		*/
#include <log.h>                        /* Genralized error logger      */
#include <sys/param.h>                  /* System parameters            */
#if defined(sun) || defined(ultrix) || defined(_AIX)
#include <sys/wait.h>			/* wait, wait3, wait4 (BSD)	*/
#include <sgtty.h>			/* Terminal ioctl's		*/
#include <sys/time.h>                   /* time definitions             */
#include <sys/resource.h>               /* resources usage definitions  */
#include <sys/types.h>                  /* System Types and Macros      */
#include <sys/socket.h>
#ifndef sun
#include <sys/termio.h>                 /* tty ioctl()'s                */
#endif
#endif /* sun || ultrix || _AIX */
#if defined(sgi)
#include <sys/types.h>                  /* System Types and Macros      */
#include <sys/termio.h>                 /* tty ioctl()'s                */
#include <sys/prctl.h>                  /* Process data area defs.      */
#include <sys/schedctl.h>               /* Scheduling definitions       */
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif /* sgi */

#include "tpsinfo.h"

extern char     *malloc();		/* Some systems forget this	*/
#ifndef linux
extern char     *sys_errlist[];         /* External error list          */
#endif /* linux */
static int srinfo() ;

#define SO_BUFSIZE      20*1024         /* Default socket buffer size   */

static int      standalone=0;   /* standalone flag                      */
static char     logfile[128];   /* log file name buffer                 */

int     doit();                 /* doit() forward reference             */
#if defined(sun) || defined(ultrix) || defined(_AIX)
static void    serv_reaper();   /* reaper() forward reference           */
#endif /* sun || ultrix */

#ifndef WTERMSIG
#define WTERMSIG(x)     (((union wait *)&(x))->w_termsig)
#endif /* WTERMSIG */
#ifndef WSTOPSIG
#define WSTOPSIG(x)     (((union wait *)&(x))->w_stopsig)
#endif /* WSTOPSIG */

#ifndef TPSLOGFILE
#define TPSLOGFILE "/usr/spool/info/tpsinfod.log"
#endif

main (argc,argv)
int     argc;
char    **argv;
{
	extern int      opterr, optind;         /* required by getopt(3)*/
	extern char     *optarg;                /* required by getopt(3)*/
	register int    option;
	int             loglevel = LOG_INFO ;   /* Default log level    */
	int             debug=0;                /* Debug flag           */
	int             port=0;                 /* Non-standard port    */
	int             logging=0;              /* Default not to log   */
	int             singlethread=0;         /* Single threaded      */
	int             lfname=0;               /* log file given       */
	register int    s, ns;
	register int    i, pid;
	struct servent  *sp;
	struct sockaddr_in sin, from;
	int             fromlen;
	char     localhost[MAXHOSTNAMELEN];     /* Local host name      */
	int             mode;
	register int    maxfds;                 /* max. # of file descr.*/
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
	struct sigvec   sv;
#endif /* sun || ultrix || _AIX */

	strcpy(logfile, "syslog"); /* default logfile */
	opterr++;

	while ((option = getopt(argc,argv,"sdltf:p:")) != EOF)        {
		switch (option) {
			case 'd': debug++;
				break;
			case 's': standalone++;
				break;
			case 'f':
				lfname++;
				strcpy(logfile,optarg);
				break;
			case 'l':
				logging++;
				break;
			case 't':
				singlethread++;
				break;
			case 'p':
				port=atoi(optarg);
				break;
		}
	}
	if (debug)      {
		loglevel = LOG_DEBUG;
	}
	if (logging && !lfname)  {
		strcpy(logfile, TPSLOGFILE);
	}
	if (!(strcmp(logfile,"stderr")))       {
		strcpy(logfile,"");
	}
	if (standalone) {
/*
 * Trap SIGCLD, SIGCHLD
 */
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
		sv.sv_mask = sigmask(SIGCHLD)|sigmask(SIGHUP)|sigmask(SIGALRM);
		sv.sv_handler = serv_reaper;
		sigvec(SIGCHLD, &sv, (struct sigvec *)0);
		maxfds=getdtablesize();
#endif /* sun || ultrix || _AIX */
#if defined(CRAY) || defined(sgi) || defined(hpux) || defined(SOLARIS)
/* FH */ /* Should trap SIGCLD for kid status */
		if (signal(SIGCLD, SIG_IGN) == SIG_ERR) {
			perror("signal (SIGCLD)");
			exit(1);
		}
		maxfds=_NFILE;
#endif /* CRAY || sgi || hpux || SOLARIS */
/*
 * disassociate controlling terminal
 */
		if (!debug)     {

			for (i=0; i< maxfds; i++) (void) close(i);

#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX) || defined(sgi)
			(void) open("/dev/null", O_RDONLY);
			dup2(0,1);
			dup2(0,2);
			i = open("/dev/tty", O_RDWR);
			if (i>0)        {
				ioctl(i, TIOCNOTTY, 0);
				close(i);
			}
#endif /* sun || ultrix || _AIX || sgi */

/*
 * Finally fork ourselves
 */
			pid = fork();
			if (pid == -1)   {
				perror("main fork");
				exit(1);
			}
			if (pid > 0) exit(0);
#if HPUX10
			setpgrp3();
#else
			setpgrp();
#endif
		}

		(void) initlog("tpsinfod", loglevel, logfile);
#if defined(__DATE__) && defined (__TIME__)
		log(LOG_ERR, "%s generated on %s %s\n",argv[0],__DATE__,__TIME__);
#else
		log(LOG_ERR, "%s\n",argv[0]);
#endif /* __DATE__ && __TIME__ */
		if (gethostname(localhost,sizeof(localhost)))   {
			log(LOG_ERR, "gethostname(): %s\n",sys_errlist[errno]);
			exit(1);
		}
		log(LOG_ERR, "starting on %s\n", localhost);

		if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)  {
			log(LOG_ERR, "socket(): %s\n",sys_errlist[errno]);
			exit(1);
		}
		if (!port)       {
			sp = getservbyname("tpsinfo", "tcp");
			if (sp == NULL) {
				log(LOG_ERR, "tpsinfo/tcp: no such service\n");
				serrno = SENOSSERV;
				log(LOG_ERR, "tpsinfo/tcp: %s\n",sys_serrlist[SERRNO]);
				exit(1);
			}
			sin.sin_port = sp->s_port;
		}
		else    {
			sin.sin_port = htons(port);
		}
		sin.sin_addr.s_addr = htonl(INADDR_ANY);
		sin.sin_family = AF_INET;
		if (bind(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
			log(LOG_ERR, "bind(): %s\n",sys_errlist[errno]);
			exit(1);
		}
		listen(s, 5);
		for (;;) {
			fromlen = sizeof(from);
			ns = accept(s, (struct sockaddr *)&from, &fromlen);
			if (ns < 0) {
				if (errno != EINTR) {
					log(LOG_ERR, "accept(): %s\n",sys_errlist[errno]);
					exit(1);
				}
				log(LOG_DEBUG, "accept(): %s\n",sys_errlist[errno]);
				continue;
			}
			log(LOG_DEBUG, "accepting requests\n");
			if (getpeername(ns,(struct sockaddr *)&from, &fromlen)<0)        {
				log(LOG_ERR, "getpeername: %s\n",sys_errlist[errno]);
				(void) close(ns);
				continue;
			}
			if (!singlethread)      {
				pid = fork();
				switch (pid)    {
					case -1:
						log(LOG_ERR,"fork(): %s \n",sys_errlist[errno]);
						close(ns);
						exit(1);
					case 0:                         /* Child */
						close(s);
						mode = 0;
						doit(ns, &from, mode);
						exit(0);
				}
				close(ns);                      /* Parent */
			}
			else    {
				mode = 1;
				doit(ns, &from, mode);
			}
		}
	}
	else    {       /* ! standalone */
		(void) initlog("tpsinfod", loglevel, logfile);
		fromlen = sizeof(from);
		log(LOG_DEBUG, "accepting requests\n");
		if (getpeername(0,(struct sockaddr *)&from, &fromlen)<0)        {
			log(LOG_ERR, "getpeername: %s\n",sys_errlist[errno]);
			exit(1);
		}
#if defined(_AIX) && defined(_IBMESA)
		if ( setluid (0) == -1 ) {
			log(LOG_ERR, "setluid: %s\n",sys_errlist[errno]);
			exit(1);
		}
#endif
		mode = 0;
		doit(0, &from, mode);
	}
	exit(0);
}

#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
static void serv_reaper()
{
#if !defined(_AIX)
	union wait      status;
#else
	int             status;
#endif /* _AIX */
	int             pid;
	for (;;)        {
		pid = wait3(&status, WNOHANG, (struct rusage *)0);
		if (pid <=0)    break;
		log(LOG_DEBUG," %d reaped\n", pid);
		if (WIFSIGNALED(status))        {
			log(LOG_ERR, "%d signaled by signal %d\n",pid, WTERMSIG(status));
		}
		if (WIFSTOPPED(status))        {
			log(LOG_ERR, "%d stopped by signal %d\n",pid, WSTOPSIG(status));
		}
	}
}
#endif /* sun || ultrix || _AIX */
#if defined(sgi) || defined(hpux) || defined(SOLARIS)
static void serv_reaper()
{
	int status;

	wait (&status);
}
#endif  /* sgi || hpux || SOLARIS */

doit(s, fromp, mode)
int     s, mode;
struct sockaddr_in *fromp;
{
	int     request;
	struct  hostent *hp;
	char 	from_host[MAXHOSTNAMELEN]; /* Where the request comes from   */

	/*
	 * Use to solve an UltraNet bug
	 */
	if (setnetio(s) <0)     {
		shutdown(s, 2);
		close(s);
		exit(1);
	}
	/*
	 * Getting the client host name.
	 */
	if ((hp = gethostbyaddr((char *)(&fromp->sin_addr), sizeof(struct in_addr),
	    fromp->sin_family)) == NULL){
		strcpy(from_host,(char *)inet_ntoa(fromp->sin_addr));
		log(LOG_INFO, "connection from %s\n", inet_ntoa(fromp->sin_addr));
	}
	else    {
		strcpy(from_host,hp->h_name);
		log(LOG_INFO, "connection from %s\n", hp->h_name);
	}

	/*
	 * Ignoring SIGPIPE signal.
	 */
	(void) signal(SIGPIPE,SIG_IGN) ;

	/*
	 * Setting read timeout to 2 hours.
	 */
	/* (void) setrtimo(60*60*2) ;   disabled for now */

	/*
	 * Loop on request.
	 */
		request = srrequest(s);
		if (request < 0)        {
			log(LOG_ERR, "fatal: %s\n", sys_errlist[errno]);
			shutdown(s,2); close(s) ;
			exit(1);
		}
	  switch ((int)request)        {
		int rc ;
		case RQST_TPSERV  :
			log(LOG_DEBUG, "request type <info()>\n");
			rc = srinfo(s);
			log(LOG_DEBUG, "info() returned: %x\n",rc);
			break;
		default :
			log(LOG_ERR, "unknown request type %x(hex)\n", request);
			if (mode) return(0); else exit(0);
	  }
}

static int     srinfo(s)
int     s ;
{
        char * p        ;
        int status = 0  ;
        char *ptr       ;
        char buf [256]  ;
        int msglen      ;
	char sitename[20] ;
	char devicetype[20] ;
	char st[256] 	;
	int n ;

        if ((n = netread(s,buf,RQSTSIZE)) != RQSTSIZE) {
                if (n == 0)      {
                        return 0 ;
                }
                else {
                        log(LOG_ERR, "srinfo(): read(): %s\n", sys_errlist[errno]);
                        return -1 ;
                }
        }
	ptr= buf ;
	unmarshall_STRING(ptr,sitename) ;
	unmarshall_STRING(ptr, devicetype) ;

	log(LOG_DEBUG,"Site name received : %s\n",sitename);
	log(LOG_DEBUG,"device type received : %s\n",devicetype);

	sprintf(st,"TPSERVER-%s",sitename);
	log(LOG_DEBUG,"Executing: getconfent(%s,%s,1)\n",st,devicetype);
	if ( (p = getconfent(st,devicetype,1)) == NULL ) {
                status = -1 ; /* No info found */
                msglen = 0 ;
        }
	else
		msglen = strlen(p) ;
        ptr = buf ;
        marshall_LONG ( ptr, RQST_TPSERV) ;
        marshall_LONG ( ptr ,status );
        marshall_LONG ( ptr, msglen );
        if ( msglen ) {
                marshall_STRING ( ptr,p ) ;
                log(LOG_DEBUG,"info() : sent back info : %s\n",p);
        }
        if (netwrite(s,buf,msglen+3*LONGSIZE+1) != msglen+3*LONGSIZE+1) {
                log(LOG_ERR, "info() : netwrite(): %s\n", sys_errlist[errno]);
                return(-1);
        }
        return 0 ;
}

int     srrequest(s)
int     s;
{
        char    * p ;
        WORD  magic ;
        WORD   code ;
        int       n ;
	char    rqstbuf[1024] ;

        log(LOG_DEBUG, "rrequest: reading %d bytes\n",RQSTSIZE) ;
        if ((n = netread(s,rqstbuf,RQSTSIZE)) != RQSTSIZE) {
                if (n == 0)      {
                        return 0 ;
                }
                else {
                        log(LOG_ERR, "rrequest: read(): %s\n", sys_errlist[errno]);
                        return -1 ;
                }
        }
        p= rqstbuf ;
        unmarshall_WORD(p,magic) ;
        unmarshall_WORD(p,code) ;
        log(LOG_DEBUG,"rrequest:  magic: %x code: %x\n",magic,code) ;
        return code ;
}

