.\" @(#)sysreq.man	1.4     CERN CN-SW/DC Frederic Hemmer 12/09/96
.\" Copyright (C) 1990-1994 by CERN/CN/SW/DC
.\" All rights reserved
.\"
.TH SYSREQ l "12/09/96"
.SH NAME
sysreq \- issue a sysreq request
.SH SYNOPSIS
.B sysreq
[
.BI -n
] [
.BI -c
] [
.BI -u <user>
] [
.BI -a <account>
]
.I service
.I command
.SH DESCRIPTION
.IX "\fLsysreq\fR"
.IX  tcp
Issue a call to the specified sysreq service.
.LP
The remote machine is defined by the "sysreq" entry in /etc/services.
\fIcommand\fP depends on the \fIservice\fP specified.
.LP
Various configuration parameters are defined in /etc/shift.conf.
.LP
By default, sysreq does retries if the server host is found but
not reachable or if the requested sysreq service is currently 
unavailable. This behaviour can be changed by setting the environment
variable \fBSYSREQ_NORETRY\fP (see below). The total retry-time before
giving up is about one hour.
.LP
Some environment variable overwrites defaults :
.ta +.10i
.nf
\fBSYSREQ_HOST\fP send request to the specified host
\fBSYSREQ_PORT\fP use this port instead of the default one
\fBSYSREQ_TRACE\fP print verbose debug messages
\fBSYSREQ_NORETRY\fP do not retry in case of problems
.fi
.SH OPTIONS
.TP
.BI \-c
requests  the SYSREQ  interface to  manage the  continuation
mechanism if the reply  doesn't fit in one reply buffer.
This behaviour is the default.
.TP
.BI \-n
returns only  the first  reply  buffer and  ends the  service
command.  This  allows you  to avoid  long undesired  responses.
Code 2 is returned if the answer does not fit in the buffer,
and the last returned line contains the command to be sent in order
to get the remaining answers.
.TP
.BI \-u<user>
performs the request on behalf of user <user>. This is a
command requiring root privileges.
.TP
.BI \-u<account>
performs the request on behalf of account <account>. This is a
command requiring root privileges.
.SH "SEE ALSO"
services(5), tcp(4)
.SH "AUTHOR"
Frederic Hemmer, CERN-CN Division CH-1211 Geneva 23, Switzerland
(hemmer@cernvm.cern.ch)
