/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] =
"@(#)sysreqc.c	1.13 08/20/97 CERN CN-SW/DC Frederic Hemmer";
#endif /* not lint */

/* sysreqc.c    C interface to the SYSREQ communication system          */
 
#include "config.h"             /* configuration parameters             */
#include "sysreq.h"             /* sysreq specific definitions          */
#if !defined(vms)
#include <serrno.h>             /* special error numbers                */
#include <trace.h>              /* tracing definitions                  */
#else
#include "serrno.h"             /* special Error numbers                */
#include "trace.h"              /* tracing definitions                  */
#endif /* vms */

#if defined(_WIN32)
#define _POSIX_                 /* for L_cuserid                        */
#endif
#include <stdio.h>              /* Standard Input/Output definitions    */
#if defined(unix) || (defined(_AIX) && defined(_IBMR2))
#include <pwd.h>                /* Password file definitions            */
#endif /* unix || (_AIX && _IBMR2) */
#include <errno.h>              /* Standard error numbers               */

#if defined(vms) && defined(__alpha) && defined(COMPILE_NOPREFIX)
#define cuserid DECC$CUSERID
#endif /* vms && __alpha && COMPILE_NOPREFIX */

static int sysreq_tracing = 0;
extern int _sysreq();   /* Actual call to sysreq                        */
extern char *getacct(); /* get account string                           */
#if defined(_WIN32)
extern char *cuserid();
#endif

int
sysreq(sernam, comtxt, comtxtl, reptxt, arysz)
char    *sernam;        /* service name                                 */
char    *comtxt;        /* command text                                 */
int     *comtxtl;       /* command text length                          */
char    *reptxt;        /* reply text                                   */
int     *arysz;         /* reply array size, actual size on return      */
{
	char    *acct;  /* account string pointer                       */
	int     rc;     /* sysreq return code                           */
	int     do_retry = 0; /* don't retry                            */
#if defined(unix) || (defined(_AIX) && defined(_IBMR2))
	struct  passwd  *pw;    /* password entry buffer pointer        */
#endif /* unix || (_AIX && _IBMR2) */
#if defined(vms) || defined(_WIN32)
	char    name[L_cuserid];        /* username buffer              */
#endif /* vms || _WIN32 */

	INIT_TRACE("SYSREQ_TRACE");
	TRACE(1, "sysreq", "sysreq(%s,%s,%d,%x,%d) entered",
		 sernam, comtxt, *comtxtl, reptxt, *arysz);

	if (( acct = getacct()) == NULL) acct = "        ";

#if defined(unix) || (defined(_AIX) && defined(_IBMR2))
        pw = getpwuid(geteuid());
	rc = _sysreq(pw->pw_name, acct,sernam, comtxt, *comtxtl, reptxt,
		     arysz,do_retry);
#endif /* unix || (_AIX && _IBMR2) */
#if defined(vms) || defined(_WIN32)
	cuserid(name);
	rc =_sysreq(name, acct, sernam, comtxt, *comtxtl, reptxt, arysz,
		    do_retry);
#endif /* vms || _WIN32 */
	END_TRACE();
	return(rc);
}
