/*
 * Copyright (C) 1993-1997 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)cvtden.c	1.11 03/28/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	cvtden - check and convert alphanumeric densities to integer */
#include <sys/types.h>
#include "tape.h"
static char adens[18][6] = {"0", "800", "1600", "6250", "38000",
	"8200", "8500", "38KD", "2G", "6G", "10G", "FMT", "RAW", "DDS",
	"20G", "25G", "35G", "50G"};
static char adensc[18][6] = {"", "", "", "", "38KC",
	"8200C", "8500C", "38KDC", "", "", "10GC", "", "", "DDSC",
	"20GC", "25GC", "35GC", "50GC"};
cvtden(aden)
char	*aden;
{
	int i;

	for (i = 0; i < 18; i++)
		if (strcmp (aden, adens[i]) == 0) return (i);
	for (i = 0; i < 18; i++)
		if (strcmp (aden, adensc[i]) == 0) return (i | IDRC);
	if (!strcmp (aden, "38K")) return (D38000);
	if (!strcmp (aden, "43200")) return (D8200);
	if (!strcmp (aden, "86400")) return (D8500);
	return (-1);
}

/*	den2aden - convert integer densities to alphanumeric */
char *
den2aden(den)
int	den;
{
	if (den & IDRC)
		return (adensc[den & ~IDRC]);
	else
		return (adens[den]);
}
