/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)reserv.c	1.3 05/27/92 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	reserv - reserve tape units */
#include <stdio.h>
#include <sys/types.h>
#include "tape.h"
int jid;
struct tprsv req;

main(argc, argv)
int	argc;
char	**argv;
{
	char repbuf[1];
	int c, i, n;
	char *dp;

	if (argc == 1 || ((argc - 1) / 2) > MAXDGP || ((argc - 1) % 2) != 0) {
		usage (argv[0]);
		exit (ETPRM);
	}
	jid = findpgrp();
	req.rh.size = sizeof(struct tprsv);
	req.rh.code = TPRSV;
	req.uid = getuid();
	req.jid = jid;
	n = 0;
	for (i = 1; i < argc -1; i += 2) {
		strcpy (req.dg[n].name, argv[i]);
		req.dg[n].num = strtol (argv[i+1], &dp, 10);
		if (*dp != '\0') {
			usage (argv[0]);
			exit (ETPRM);
		}
		n++;
	}
	req.count = n;
	c = send2tpd (&req, repbuf, &n);
	switch (c) {
	case ETDNP:
		fprintf (stderr, "%s\n", TP000);
		break;
	case ETSYS:
		fprintf (stderr, "%s\n", TP026);
		break;
	case ETTMO:
		fprintf (stderr, "%s\n", TP001);
		break;
	case ETRSV:
		fprintf (stderr, TP010);
		break;
	case ETMUSR:
		fprintf (stderr, TP011);
		break;
	case ETNDV:
		fprintf (stderr, TP012);
		break;
	case ETIDG:
		fprintf (stderr, TP013);
		break;
	}
	exit (c);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "dgn count [dgn count] ...\n");
}

