.\" @(#)rls.man	1.4	04/28/93 CERN CN-SW/CU Jean-Philippe Baud
.\" Copyright (C) 1990,1991 by CERN/CN/SW/CU
.\" All rights reserved
.\"
.TH RLS l "04/28/93"
.SH NAME
rls \- release tape resources
.SH SYNOPSIS
.B rls
[
.BI -a
] [
.BI -d " device_name"
] [
.BI -k
] [
.BI -p " pathname"
]
.SH DESCRIPTION
.B rls
unloads the tape(s) used by the job, tells TMS that the tape
is free for use by other jobs, frees the corresponding tape unit(s)
and decrements the corresponding device group(s) reservation.
It removes the label information from the file
.B .tplabel
for the corresponding path and then deletes
.B .tplabel
if empty.
.SH OPTIONS
.TP
.BI \-a
Releases all resources reserved by the job.
.TP
.BI \-d " devname"
Releases an explicit device.
.TP
.BI \-k
Keeps the current reservation. A path or a device name must also be specified.
.TP
.BI \-p " pathname"
Releases an explicit path, as specified in a previous
.BR tpmnt .
.TP 0
One and only one of -a, -d or -p options must be present.
.SH RETURN CODES
\ 
.br
0	Ok.
.br
200	Tape daemon is not running.
.br
201	System or communication error.
.br
203	Bad parameter.
.br
215	Release pending.
