/*
 * Copyright (C) 1994 by CERN/CN/PDP/DH
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tplblinfo.c	1.3 08/16/94 CERN CN-PDP/DH Jean-Philippe Baud";
#endif /* not lint */

/*	tplblinfo - get information from header labels */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "tape.h"
extern	int	optind;
extern	char	*optarg;

main(argc, argv)
int	argc;
char	**argv;
{
	int aflag = 1;
	int bflag = 0;
	int blksize;
	int c;
	int errflg = 0;
	int Fflag = 0;
	int fflag = 0;
	char fid[18];
	int fseq;
	int Lflag = 0;
	int lrecl;
	char path[MAXPATH];
	int qflag = 0;
	char recfm[4];

	path[0] = '\0';
	while ((c = getopt (argc, argv, "bFfLP:q")) != EOF) {
		switch (c) {
		case 'b':
			aflag = 0;
			bflag++;
			break;
		case 'F':
			aflag = 0;
			Fflag++;
			break;
		case 'f':
			aflag = 0;
			fflag++;
			break;
		case 'L':
			aflag = 0;
			Lflag++;
			break;
                case 'P':
			if (path[0] == '\0') {
				if (strlen(optarg) < sizeof(path)) {
					strcpy (path, optarg);
				} else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'q':
			aflag = 0;
			qflag++;
			break;
		case '?':
			errflg++;
			break;
		}
	}
	if (path[0] == '\0') {
		fprintf (stderr, TP029);
		errflg++;
	}
	if (errflg) {
		usage (argv[0]);
		exit (ETPRM);
	}

	if ((c = gethdrinfo (path, fid, &fseq, recfm, &blksize, &lrecl)) < 0)
		exit (-c);
	if (c == 0) {
		if (aflag || bflag)
			printf ("-b %d ", blksize);
		if (aflag || Fflag)
			printf ("-F %s ", recfm);
		if (aflag || fflag)
			printf ("-f %s ", fid);
		if (aflag || Lflag)
			printf ("-L %d ", lrecl);
	}
	if (aflag || qflag)
		printf ("-q %d ", fseq);
	exit (c);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "%s",
		"[-b] [-F] [-f] [-L] -P path_name [-q]\n");
}
