/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tprstat.c	1.5 05/13/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	tprstat - unit reservation status display */
#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include "tape.h"
int jid;
struct tpst req;
struct tprstr rep[MAXUSER];

main(argc, argv)
int	argc;
char	**argv;
{
	int c, i, j, n;
	struct passwd *pwd;
	struct tprstr *trstp;
	char name[15];
	char jobid[7];

	if (argc != 1) {
		usage (argv[0]);
		exit (ETPRM);
	}
	jid = findpgrp();
	req.rh.size = sizeof(struct tpst);
	req.rh.code = TPRSTAT;
	req.uid = getuid();
	c = send2tpd (&req, rep, &n);
	if (c == 0) {
		printf ("userid      jid dgn        rsvd used queued\n");
		n = n / sizeof(struct tprstr);
		trstp = rep;
		for (i = 0; i < n; i++) {
			if (i == 0)
				strcpy (name, "tpdaemon");
			else {
				pwd = getpwuid (trstp->uid);
				strcpy (name, pwd->pw_name);
			}
			sprintf (jobid, "%d", trstp->jid);
			for (j = 0; j < trstp->count; j++) {
				if (j) {
					name[0] = '\0';
					jobid[0] = '\0';
				}
				printf ("%-8s %6s %-8s   %4d %4d %4d\n",
					name, jobid, trstp->dg[j].name, trstp->dg[j].rsvd,
					trstp->dg[j].used, trstp->dg[j].wait);
			}
			trstp++;
		}
	}
	switch (c) {
	case ETDNP:
		fprintf (stderr, "%s\n", TP000);
		break;
	case ETSYS:
		fprintf (stderr, "%s\n", TP026);
		break;
	case ETTMO:
		fprintf (stderr, "%s\n", TP001);
		break;
	}
	exit (c);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s\n", cmd);
}

