/*
 * Copyright (C) 1990-1994 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)usrmsg.c	1.3 02/17/94 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#ifdef NOTRACE
#include <stdio.h>
#endif
#include <sys/types.h>
#include <varargs.h>
#include "tape.h"

usrmsg(va_alist) va_dcl
{
	va_list args;
	char *func;
	char *msg;
#ifdef NOTRACE
	char prtbuf[PRTBUFSZ];
#else
	char *p;
	extern struct tpdrep rep;
#endif
	int save_errno;

	save_errno = errno;
	va_start (args);
	func = va_arg (args, char *);
	msg = va_arg (args, char *);
#ifdef NOTRACE
	vsprintf (prtbuf, msg, args);
	fprintf (stderr, "%s: %s\n", func, prtbuf);
#else
	sprintf (rep.data, "%s: ", func);
	p = rep.data + strlen (rep.data);
	vsprintf (p, msg, args);
	tplogit (func, "%s", p);
#endif
	va_end (args);
	errno = save_errno;
}
