*
* $Id: c322m.F,v 1.1.1.1 1996/04/01 15:01:16 mclareni Exp $
*
* $Log: c322m.F,v $
* Revision 1.1.1.1  1996/04/01 15:01:16  mclareni
* Mathlib gen
*
*
      SUBROUTINE C322M
C     This program tests the GENLIB routines DFRSIN,DFRCOS,FRSIN,FRCOS,
C     (C322) by comparing computed results against those obtained from
C     another source of numerical integration.
C     Written by T Hepworth, Brunel University, England, 23.4.90
C     Revised by B. Damgaard Sept. 1992
*
* $Id: imp64.inc,v 1.1.1.1 1996/04/01 15:02:59 mclareni Exp $
*
* $Log: imp64.inc,v $
* Revision 1.1.1.1  1996/04/01 15:02:59  mclareni
* Mathlib gen
*
*
* imp64.inc
*
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      REAL FRCOS, FRSIN,SX(7),SEXACT(7,0:1),SRESULT(7,0:1)
      REAL STSTERR,SERRMAX,SERROR(7,0:1)
*
* $Id: def64.inc,v 1.1.1.1 1996/04/01 15:02:59 mclareni Exp $
*
* $Log: def64.inc,v $
* Revision 1.1.1.1  1996/04/01 15:02:59  mclareni
* Mathlib gen
*
*
*
* def64.inc
*
      DOUBLE PRECISION
     +     DFRCOS,DFRSIN
*
* $Id: def64.inc,v 1.1.1.1 1996/04/01 15:02:59 mclareni Exp $
*
* $Log: def64.inc,v $
* Revision 1.1.1.1  1996/04/01 15:02:59  mclareni
* Mathlib gen
*
*
*
* def64.inc
*
      DOUBLE PRECISION
     +      TSTERR,ERRMAX
      DIMENSION  X(7),EXACT(7,0:1),RESULT(7,0:1),ERROR(7,0:1)
C     Set the maximum error allowed for the test to still be considered
C     successful
      PARAMETER ( TSTERR=1D-13 )
      PARAMETER (STSTERR=1D-6  )
      LOGICAL LTEST
*
* $Id: iorc.inc,v 1.1.1.1 1996/04/01 15:01:31 mclareni Exp $
*
* $Log: iorc.inc,v $
* Revision 1.1.1.1  1996/04/01 15:01:31  mclareni
* Mathlib gen
*
*
*
* iorc.inc
*
      COMMON/IOLUNS/LIN,LOUT
      COMMON/GTSTAT/NTEST,NFAIL,IRC
C     Set up test data and theoretical solutions
C     DFRSIN (or FRSIN) test data
      DATA X(1),EXACT(1,0) /  0.0D0,  0D0                  /
      DATA X(2),EXACT(2,0) / -0.4D0, -0.1667371102944582D0 /
      DATA X(3),EXACT(3,0) /  0.4D0,  0.1667371102944582D0 /
      DATA X(4),EXACT(4,0) /  2.0D0,  1.4108529827013918D0 /
      DATA X(5),EXACT(5,0) /  7.6D0,  1.1413499262090459D0 /
      DATA X(6),EXACT(6,0) /  8.0D0,  1.2834177865335759D0 /
      DATA X(7),EXACT(7,0) / 12.4D0,  0.9764064367978704D0 /
C     DFRCOS (or FRCOS) test data
      DATA EXACT(1,1) /  0D0                     /
      DATA EXACT(2,1) / -1.2448218501015764D0    /
      DATA EXACT(3,1) /  1.2448218501015764D0    /
      DATA EXACT(4,1) /  1.8882490336945132D0    /
      DATA EXACT(5,1) /  1.5946919390901555D0    /
      DATA EXACT(6,1) /  1.6024905840697365D0    /
      DATA EXACT(7,1) /  1.1954629800381893D0    /
      CALL HEADER('C322',0)
      LTEST= .TRUE.
C     Initialise maximum error
      ERRMAX=0D0
      SERRMAX=0E0
      WRITE(LOUT,'(/5X,''X'',7X,''DFRSIN/DFRCOS'',11X,
     +        ''Exact Value'',10X,''FRSIN/FRCOS'',5X,
     +        ''Exact '',7X,''DError'',4X,''SError'')')
      DO 100 I=1,7
      SX(I)=X(I)
      SEXACT(I,0)=EXACT(I,0)
      SEXACT(I,1)=EXACT(I,1)
         RESULT(I,0)=DFRSIN(X(I))
         RESULT(I,1)=DFRCOS(X(I))
        SRESULT(I,0)= FRSIN(SX(I))
        SRESULT(I,1)= FRCOS(SX(I))
C        Calculate absolute errors
         ERROR(I,0)= ABS ( RESULT(I,0)-EXACT(I,0) )
         ERROR(I,1)= ABS ( RESULT(I,1)-EXACT(I,1) )
        SERROR(I,0)= ABS (SRESULT(I,0)-SEXACT(I,0) )
        SERROR(I,1)= ABS (SRESULT(I,1)-SEXACT(I,1) )
        SERRMAX=MAX (SERRMAX,SERROR(I,0),SERROR(I,1) )
         ERRMAX=MAX ( ERRMAX,ERROR(I,0),ERROR(I,1) )
         WRITE(LOUT,'(F6.1,2F24.18,2F15.9,1P,2D10.1)')X(I),RESULT(I,0),
     +   EXACT(I,0),SRESULT(I,0),SEXACT(I,0),
     +   ERROR(I,0),SERROR(I,0)
         WRITE(LOUT,'(6X,2F24.18,2F15.9,1P,2D10.1)') RESULT(I,1),
     +   EXACT(I,1),
     +   SRESULT(I,1),SEXACT(I,1),ERROR(I,1),SERROR(I,1)
100   CONTINUE
      WRITE(LOUT,'(/''Double Precision largest Error'',1P,D10.1)')ERRMAX
      WRITE(LOUT,'(''Single Precision largest Error'',1P,D10.1)')SERRMAX
      LTEST=LTEST .AND. (ERRMAX .LE. TSTERR)
      LTEST=LTEST .AND. (SERRMAX .LE. STSTERR)
      WRITE(LOUT,'(1X)')
C     Check if the test was successful
      IRC=ITEST('C322',LTEST)
      CALL PAGEND('C322')
      RETURN
      END
