.\" @(#)log.man	1.1     CERN CN-SW/DC Frederic Hemmer 08/10/91
.\" Copyright (C) 1990,1991 by CERN/CN/SW/DC
.\" All rights reserved
.\"
.TH LOG l "08/10/91"
.SH NAME
log, initlog  \- log messages
.SH SYNOPSIS
.nf
.B #include <log.h>
.LP
.B initlog(ident, level, output)
.B char \(**ident;
.B int \(*level;
.B char \(**output;
.LP
.B log(level, format, message, parameters, \&.\|.\|. )
.B int \(*level;
.B char \(**format;
.B char \(**message;
.fi
.IX  "openlog function"  ""  "\fLinitlog\fP \(em initialize log file"
.IX  "log function"  ""  "\fLlog\fP \(em write message to log file"
.SH DESCRIPTION
.LP
.B log(\|)
logs
.I message
to
an appropriate log file, opened by
.BR initlog (l).
on another host over the network.
The message is tagged with a priority of
.IR level .
The message looks like a
.BR printf (3S)
string.
Priorities are encoded as a
.IR level .
The level is selected from an ordered list:
.RS
.TP 20
.SB LOG_EMERG
A panic condition.  This is normally broadcast to all users.
.TP
.SB LOG_ALERT
A condition that should be corrected immediately,
such as a corrupted system database.
.TP
.SB LOG_CRIT
Critical conditions, such as hard device errors.
.TP
.SB LOG_ERR
Errors.
.TP
.SB LOG_WARNING
Warning messages.
.TP
.SB LOG_NOTICE
Conditions that are not error conditions,
but that may require special handling.
.TP
.SB LOG_INFO
Informational messages.
.TP
.SB LOG_DEBUG
Messages that contain information
normally of use only when debugging a program.
.RE
.LP
If special processing is needed,
.B initlog(\|)
can be called to initialize the log file.
The parameter
.I ident
is a string that is prepended to every message.
.I level
is a indicating the level logging.
.RE
.SH "SEE ALSO"
.BR syslog (3),
