/*
 * Copyright (C) 1995-1997 by CERN/CN/PDP/DS
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)sendrep.c	1.4 02/12/97 CERN CN-PDP/DS Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <sys/types.h>
#include <string.h>
#include <varargs.h>
#include <netinet/in.h>
#include "copytape.h"
#include "marshall.h"
#include "net.h"
extern char *sys_errlist[];
sendrep(va_alist) va_dcl
{
	va_list args;
	char *file1, *file2;
	char func[16];
	char *msg;
	char *p;
	char prtbuf[PRTBUFSZ];
	char *q;
	char *rbp;
	int rc;
	int rep_type;
	int req_type;
	char repbuf[REPBUFSZ];
	int repsize;
	int rpfd;
	static char savebuf[256];
	static int saveflag = 0;

	strcpy (func, "sendrep");
	rbp = repbuf;
	marshall_LONG (rbp, CTPMAGIC);
	va_start (args);
	rpfd = va_arg (args, int);
	rep_type = va_arg (args, int);
	marshall_LONG (rbp, rep_type);
	switch (rep_type) {
	case MSG_OUT:
	case MSG_ERR:
	case STAGE_OUT:
	case UPD_VIDMAP:
		msg = va_arg (args, char *);
		vsprintf (prtbuf, msg, args);
		marshall_LONG (rbp, strlen (prtbuf) + 1);
		marshall_STRING (rbp, prtbuf);
		if ((rep_type == MSG_ERR || rep_type == UPD_VIDMAP) && prtbuf[0] != '\n')
			ctplogit (func, "%s", prtbuf);
		break;
	case COPYTAPERC:
		req_type = va_arg (args, int);
		rc = va_arg (args, int);
		marshall_LONG (rbp, rc);
		if (req_type != CTPQRY)
			ctplogit (func, CTP99, rc);
		break;
	}
	va_end (args);
	repsize = rbp - repbuf;
	if (netwrite (rpfd, repbuf, repsize) != repsize) {
		ctplogit (func, CTP08, "", "write", sys_errlist[errno]);
		if (rep_type == COPYTAPERC)
			close (rpfd);
		return (-1);
	}
	if (rep_type == COPYTAPERC)
		close (rpfd);
	return (0);
}
