/*
 * @(#)hpss_errno.h	1.1 11/04/98 CERN IT-PDP/DM Olof Barring
 */

/* static char SccsId[] = "include/hpss_errno.h, gen, 3v2   3/17/97   19:23:53   "; */
/*=============================================================================
 *
 * Include Name:  hpss_errno.h
 *
 * Description:   Define common HPSS error codes.
 *
 * Traceability:
 *      Version   Author     Date    Description
 *      -------  --------  --------  ------------------------------------------
 *         0.1a    R Ruef  05/25/93  Initial version
 *         0.1b       HDJ  07/06/93  Different name convention
 *	   0.1c    RPR     09/16/93  Added some new errors for the SS.
 *         01.d    JKD     09/22/93  Added an error for the PVR
 *	   0.1e   smkelly  10/12/93  Added more codes derived from errno.h
 *	   0.1f	  RAH	   11/12/93  Added error code for security (EMSGSIZE)
 *	   0.1g   KWE      01/07/94  Additional codes for MVR
 *	   0.1h   DSF	   01/10/94  HPSS_EMUTEX for OFD stuff.
 *	   0.1i	  dpc,dmb  01/19/94  BFS error codes plus HPSS codes
 *         1.4    tyler    05/03/94  Changed #if !defined for dependency tool
 *         1.x             07/05/94  Copyright Update
 *         1.7    NHS      08/01/94  Added new errors for the PVL.
 *         1.9    minton   02/13/95  Added CNS errors.
 *         2.1    minton   02/24/95  Moving to version 2.1, adding a D2 Name
 *                                   Server error, and removing D1 Name Server
 *                                   errors.
 *         2.2    kwe      03/04/95  Added HPSS_EABORT for aborted requests.
 *	   2.3    llc      04/17/95  Added error code for mps.
 *         2.4    hdj      06/15/95  New errors for startup daemon
 *         2.6    hdj      06/20/95  More startup daemon
 *         3.1    kwe      09/14/95  HPSS_EWRPROTECT for mvr/pvl.
 *         3.2    dsf      09/14/95  HPSS_ESRC, ESINK, EINCONSISTENT
 *         3.3    nhs      09/25/95  HPSS_EDISABLED
 *	   3.4    million  01/11/96  fixed a value conflict with HPSS_EABORT
 *         3.5    dsf      01/31/96  Added HPSS_ENOTPERMITTED.
 *         3.6    jad      02/07/96  Added HPSS_ETIMEDOUT
 *	   3.8    llc      02/13/96  Added HPSS_EBUILDCOSHIER
 *         3.9    dsf      02/15/96  Added HPSS_EIOSPAN
 *         3.10   minton   03/19/96  Made NS error numbers consistent with
 *                                   HPSS error number formats.
 *         3.11   minton   03/19/96  Messed up the KeyWords.
 *         3.12   teaff    01/08/97  Replace HPSS_ETABLE_FULL w/ HPSS_LIST_ALLOC
 *         3.13   kwe      01/16/97  Add HPSS_BUSY_RETRY.
 *
 *  Notes:
 *       Licensed Materials
 *
 *       (C) Copyright International Business Machines Corp. 1994
 *       (C) Copyright Martin Marietta Energy Systems, Inc. and
 *                     Oak Ridge National Laboratory 1994
 *                     under CRADA No. Y1293-0203
 *       (C) Copyright Regents of The University of California and
 *                     Lawrence Livermore National Laboratory 1994
 *                     under CRADA No. T-253-92-C (as modified by T-325-92-C)
 *       (C) Copyright Regents of The University of California and
 *                     Los Alamos National Laboratory 1994
 *                     under CRADA No. LA93C10085
 *       (C) Copyright Sandia Corporation and Sandia National Laboratories 1994
 *                     under CRADA No. SC93/01198
 * 
 *       All rights reserved.
 * 
 *
 *============================================================================*/

#ifndef hpss_errno_h
#define hpss_errno_h

#include <sys/errno.h>

#define HPSS_E_NOERROR          0

/* Error codes derived from errno.h */
#define HPSS_EPERM              (-1)
#define HPSS_ENOENT             (-2)
#define HPSS_EIO		(-5)
#define HPSS_EBADF		(-9)
#define HPSS_EAGAIN             (-11)
#define HPSS_ENOMEM             (-12)
#define HPSS_EACCES             (-13)
#define HPSS_EFAULT             (-14)
#define HPSS_EBUSY              (-16)
#define HPSS_EEXIST             (-17)
#define HPSS_ENODEV             (-19)
#define HPSS_ENOTDIR		(-20)
#define HPSS_EISDIR		(-21)
#define HPSS_EINVAL             (-22)
#define HPSS_EMFILE             (-24)
#define HPSS_ENOSPACE           (-28)
#define HPSS_EMLINK		(-31)
#define HPSS_EDOM               (-33)
#define HPSS_ERANGE		(-34)
#define HPSS_EWRPROTECT		(-47)
#define HPSS_ECONN              (-50)
#define HPSS_ESTALE		(-52)
#define HPSS_EMSGSIZE		(-59)
#define HPSS_EOPNOTSUPP		(-64)
#define HPSS_ETIMEDOUT		(-78)
#define HPSS_ENAMETOOLONG	(-86)
#define HPSS_ENOTEMPTY          (-87)

/* Error codes for NS */
#define HPSS_EGROUPVECTOOLONG     (-1000)       /* Name Server Internal Error*/
#define HPSS_EBADATTRINDEX        (-1001)
#define HPSS_EBADCONFIGINDEX      (-1002)
#define HPSS_EENTERCONN           (-1003)
#define HPSS_EWRONGUID            (-1004)
#define HPSS_EBITFILEIDNOTEMPTY   (-1005)
#define HPSS_EBADCREDS            (-1006)

/* BFS errors */
#define BFS_EMAXBFOPEN          (-1402)
#define BFS_EBADBFHANDLE        (-1403)         /* Bad bfs_ConvertBfHandle */
#define BFS_EMAXREVMAPS         (-1404)
#define HPSS_ENOSSAVAIL         (-1405)         /* no available SS for req. */
#define HPSS_ENOTALLMOVED       (-1406)         /* for bfs_Move */
#define HPSS_ENOTALLCOPIED      (-1407)         /* for bfs_Copy */
#define HPSS_ENOTALLPURGED      (-1408)         /* for bfs_Purge */
#define BFS_EPERMTIME           (-1409)         /* change time perms error */ 
#define HPSS_BUSY_RETRY         (-1410)         /* no threads avail - retry */
#define BFS_STAGE_IN_PROGRESS   (-1411)         /* stage in progress     */

/* SS errors (also seen in bfs and pvl) */
#define HPSS_EBADPVLIST 	(-1601)		/* Metadata inconsistentcy */
#define HPSS_ECONFLICT          (-1602)		/* Resource busy elsewhere */
#define HPSS_EOWNER             (-1603)		/* Wrong number of owners  */
#define HPSS_ENOMOUNT           (-1604)		/* Resource not mounted    */
#define HPSS_ETAPEAPPEND        (-1605)		/* Unused??                */
#define HPSS_EINUSE             (-1606)		/* Resource in use         */
#define HPSS_EPOSERROR          (-1607)		/* Error positioning volume*/
#define HPSS_EAPPEND            (-1608)		/* Bad position for append */
#define HPSS_ENOTSEQ            (-1609)		/* Bad position for write  */
#define HPSS_ESRC		(-1610)		/* Error reading src in copy */
#define HPSS_ESINK		(-1611)		/* Error writng sink in copy */
#define HPSS_EINCONSISTENT	(-1612)		/* Inconsistent mvr replies */
#define HPSS_ENOTPERMITTED	(-1613)		/* Requested change not permitted */
#define HPSS_EIOSPAN		(-1614)		/* I/O request spans volumes */
#define HPSS_EMOUNTMISMATCH	(-1615)		/* Error reconnecting PVs  */

/* Encina errors */
#define HPSS_EMMDELETE   	(-2000)
#define HPSS_EMMUPDATE   	(-2001)
#define HPSS_EMMINSERT   	(-2002)
#define HPSS_EMMREAD     	(-2003)
#define HPSS_E_OFD_ALLOC        (-2004)
#define HPSS_EMUTEX		(-2005)
#define HPSS_EMDATA             (-2006)         /* error on metadata oper   */
#define HPSS_EOFDGET            (-2007)         /* error in allocate OFD    */
#define HPSS_EOFDFREE           (-2008)         /* error in releasing an OFD*/
#define HPSS_ECOND              (-2009)         /* error on op. cond. var   */
#define HPSS_EUUID              (-2010)         /* error in processing uuid */


/* Error codes for Security */
#define IS_AUTHORIZED		(0)		/* authorization success      */
#define NOT_AUTHORIZED		(-3001)		/* authorization not allowed  */
#define BAD_SUBJECT		(-3002)		/* invalid subject specified  */
#define BAD_OBJECT		(-3003)		/* invalid object specified   */
#define BAD_AUTHZ		(-3004)		/* invalid authorization tkt. */
#define BAD_EVENT		(-3005)		/* invalid audit event        */
#define HSEC_ERGY		(-3006)		/* error contacting sec. reg. */
#define HSEC_EACL		(-3007)		/* error contacting acl mngr. */
#define HSEC_ENOTINIT		(-3008)		/* HSEC lib. not initialized  */
#define HSEC_EAUTH		(-3009)		/* authentication error       */
#define HSEC_EAUTHZ		(-3010)		/* authorization error	      */
#define HSEC_EAUTH_SERVICE	(-3011)		/* Invalid Authentication SVC */
#define HSEC_EAUTH_LEVEL	(-3012)		/* Invalid Protection Level   */
#define HSEC_EAUTHZ_SERVICE	(-3013)		/* Invalid Authorization svc  */
#define HSEC_EAUD		(-3014)		/* cs_LogInit Failure         */

/* Error codes for TBD */
#define HPSS_ESYSTEM            (-5000)
#define HPSS_ETRANSFER          (-5001)
#define HPSS_E_DCE_EXC		(-5002)
#define HPSS_ESOIDCREATE        (-5003)         /* error in creating a SOID */
#define HPSS_EINVALCOS          (-5004)         /* bad class of service     */
#define HPSS_EINVALCOSTABLE     (-5005)         /* class of service and hier*/
#define HPSS_ENOSUPPORT         (-5006)         /* unsupported option       */
#define HPSS_EREQLIST           (-5007)         /* Request List error */
#define HPSS_ECOMMUNICATION     (-5008)         /* Communication error */
#define HPSS_EINVALHINTS        (-5009)         /* invalid COS hints   */
#define HPSS_ENOCOS             (-5010)         /* class of service not found*/
#define HPSS_EABORT		(-5011)		/* request aborted */
#define HPSS_EINVALHIER         (-5012)         /* invalid hierarchy info    */
#define HPSS_EINVALSCLASS       (-5013)         /* invalid sclass info       */
#define HPSS_EINVALMIGRPOLICY   (-5014)         /* invalid migrationpolicy  info  */
#define HPSS_EINVALPURGEPOLICY  (-5015)         /* invalid purgepolicy info       */




/* Error codes for PVR */
#define HPSS_EMDM               (-6001)         /* Metadata failure         */
#define HPSS_EHARDWARE          (-6002)         /* Hardware failure         */
#define HPSS_ESHUTDOWN          (-6003)         /* PVR is shutting down     */
#define HPSS_EMEDIA             (-6004)         /* Media error              */
#define HPSS_EINPROGRESS        (-6005)         /* Operation is in progress */

/* Error codes for PVL */
#define HPSS_ENOTYET            (-7001)         /* PVL not accepting jobs */
#define HPSS_EEXPORT            (-7002)         /* scheduled for export */
#define HPSS_ECANCEL            (-7003)         /* job was cancelled */
#define HPSS_EPVRFAILURE        (-7004)
#define HPSS_EDRIVEFAILURE      (-7005)
#define HPSS_ETOOMANY           (-7006)         /* #vols exceeds #drives */
#define HPSS_EEMPTY             (-7007)         /* no volumes to mount */
#define HPSS_ESRCH              (-7008)         /* not found */
#define HPSS_EALREADY           (-7009)         /* already (de)allocated */
#define HPSS_ENOTSUPPORTED      (-7010)         /* not supported by PVL */
#define HPSS_ESOCKET            (-7011)         /* socket error */
#define HPSS_EUNLABELED         (-7012)         /* unlabeled volume */
#define HPSS_EFOREIGN           (-7013)         /* NON HPSS label */
#define HPSS_EDISABLED          (-7014)         /* Drive is disabled */

/* Error codes for MOVER */
#define HPSS_ENOTREADY          (-8001)
#define HPSS_ENOTELEVATED       (-8002)

/* Error codes for TBD */
#define HPSS_EOM                (-9000)         /* EOM? */

/* Error codes for DCE Subsystem */
#define HPSS_ECOMM              (-10000)        /* Communication failure */
#define HPSS_EGENERIC           (-10001)        /* Generic HPSS failure */
#define HPSS_ESUSP              (-10002)        /* Connection suspended */
#define HPSS_EAUTH              (-10003)        /* Authentication error */
#define HPSS_ECONINIT           (-10004)        /* Con. Mgr. initializn. err */
#define HPSS_ENOCONN            (-10005)        /* Connection table is full */
#define HPSS_EBADCONN           (-10006)        /* Bad connection handle */
#define HPSS_ECONBUSY           (-10007)        /* Connection is busy */
#define HPSS_EHOST              (-10008)        /* gethostbyname failure */
#define HPSS_EALREADY_RUNNING   (-10009)        /* Server already running */
#define HPSS_ENOT_MONITORING    (-10010)        /* Server not being monitored */
#define HPSS_LIST_ALLOC         (-10011)        /* SUD server list alloc err */
#define HPSS_ENO_LOCKS		(-10012)	/* Too many servers, not enuf locks */
#define HPSS_EIS_RUNNING	(-10013)	/* Server is running */
#define HPSS_ENOT_RUNNING	(-10014)	/* Server is not running */
#define HPSS_ECLONE_RUNNING	(-10015)	/* Server is already running */
#define HPSS_EFORMAT_LOCKFILE	(-10016)	/* Lockfile has bad format */
#define HPSS_EOPEN_LOCKFILE	(-10017)	/* Cannot open lockfile */
#define HPSS_EMUTEX_PROBLEM	(-10018)	/* Can't init/lock/unlock mutex */


/* Error codes for RPC Wrappers */
#define HPSS_RPC_AUTH           (-11001)
#define HPSS_RPC_EAGAIN         (-11002)
#define HPSS_RPC_FAULT          (-11003)
#define HPSS_RPC_STALE_BH       (-11004)
#define HPSS_RPC_STALE_CH       (-11005)


/* Error codes for migration-purge server */
#define  HPSS_EMPSCMDLINE         -12001 /* incorrect number of arguments */
#define  HPSS_EMPSINITFAILED      -12002 /* mps init failed */
#define  HPSS_ENOTSUPPORTSC       -12003 /* storage class is not supported */
#define  HPSS_ESCDELETED          -12004 /* storage class is deleted */
#define  HPSS_ENOMIGRPOLICY       -12005 /* no associated migration policy */ 
#define  HPSS_ENOPURGEPOLICY      -12006 /* no associated purge policy */
#define  HPSS_ENOTDISKPURGE       -12007 /* not allow purge on non-disk media*/
#define  HPSS_EMIGRISRUNNING      -12008 /* The migration is running. */
#define  HPSS_EPURGEISRUNNING     -12009 /* The purge is running. */
#define  HPSS_EABORTMPS           -12010 /* abort the mps server */
#define  HPSS_EABORTMIGRRUN       -12011 /* abort the migration run */
#define  HPSS_EABORTPURGERUN      -12012 /* abort the migration run */
#define  HPSS_ECOSHIERISBUSY      -12013 /* someone is writing to COSHIER list*/
#define  HPSS_EOUTOFRANGE         -12014 /* argment for api is out of range */
#define  HPSS_EBUILDCOSHIER       -12015 /* failed to rebuild COSHier table */


#endif /* hpss_errno_h */

