/*
 * @(#)pdata.h	1.1 11/04/98 CERN IT-PDP/DM Olof Barring
 */
 
/* static char SccsId[] = "include/pdata.h, gen, 3v2   12/3/97   14:23:49   "; */
/*============================================================================
 *
 * Include Name:        pdata.h
 *
 * Description:
 *	This file contains the structures necessary to identify parallel
 *	data that is being sent across a network socket.
 *
 * Traceability:
 *      Version         Author          Date            Description
 *      -------         ------          ----            -----------
 *      0.1             RPR         	03/18/93	Initial pdata_hdr
 *      1.2             tyler           05/03/94        Changed #if !defined 
 *                                                      for dependency tool
 *      1.x     			07/05/94   	Copyright Update
 *	3.1		kwe		10/04/95	New prototypes
 *	4.2	WHR	06/20/97	Added SETPDATADELIMITER and
 *					CHECKPDATADELIMITER for unicos ports.
 *	4.4		kwe		11/12/97	Interoperability mods.
 *
 *  Notes:
 *       Licensed Materials
 *
 *       (C) Copyright International Business Machines Corp. 1994
 *       (C) Copyright Martin Marietta Energy Systems, Inc. and
 *                     Oak Ridge National Laboratory 1994
 *                     under CRADA No. Y1293-0203
 *       (C) Copyright Regents of The University of California and
 *                     Lawrence Livermore National Laboratory 1994
 *                     under CRADA No. T-253-92-C (as modified by T-325-92-C)
 *       (C) Copyright Regents of The University of California and
 *                     Los Alamos National Laboratory 1994
 *                     under CRADA No. LA93C10085
 *       (C) Copyright Sandia Corporation and Sandia National Laboratories 1994
 *                     under CRADA No. SC93/01198
 * 
 *       All rights reserved.
 * 
 *		This structure is not portable. This structure will only work
 *		on 32-bit big-endian machines.
 *		
 *
 *--------------------------------------------------------------------------*/

#ifndef pdata_h
#define pdata_h

#define PDATA_TICKET_LENGTH		(8)
#define PDATA_HDR_SIZE			(48)

typedef struct pdata_hdr{
	u_signed64	PdataDelimiter;	/* Field for packet boundry */
	u_signed64	XferID;		/* Transfer ID for this packet */
	u_signed64	Offset;		/* Byte offset into transfer */
	u_signed64	Length;		/* # of bytes to transfer */
	char	SecurityTicket[PDATA_TICKET_LENGTH];
					/* kerberos style ticket */
	u_signed64	CheckSum;	/* Packet check sum */
}pdata_hdr_t;

#define PDATA_DELIM_OFFSET	(0)
#define PDATA_XFERID_OFFSET	(8)
#define PDATA_OFFS_OFFSET	(16)
#define PDATA_LENGTH_OFFSET	(24)
#define PDATA_SECTKT_OFFSET	(32)
#define PDATA_CHKSUM_OFFSET	(40)

/*
 * 	macros to set the PdataDemimiter field and check to make sure it is
 *	set correctly.
 */

#if defined(unicos) || defined(DIGITAL_UNIX)
#define SETPDATADELIMITER(PD)   ((PD) = (0x0123456789ABCDEF))
#define CHECKPDATADELIMITER(PD) (((PD) == 0x0123456789ABCDEF))
#else	/* unicos || DIGITAL_UNIX */
#define SETPDATADELIMITER(PD)	((PD) = bld64m(0x01234567,0x89ABCDEF))
#define CHECKPDATADELIMITER(PD)	(((PD).high == 0x01234567)&&((PD).low == 0x89ABCDEF))
#endif	/* unicos || DIGITAL_UNIX */

extern int
pdata_recv_hdr(
int		SocketDescriptor,	/* socket to receive the header */
pdata_hdr_t	*PdataHeaderPtr		/* Memory to receive the header */
);

extern int
pdata_send_hdr(
int		SocketDescriptor,	/* socket to send the header */
pdata_hdr_t	*PdataHeaderPtr		/* Memory location of the header */
);

extern int
pdata_send_hdr_and_data(
int		SocketDescriptor,	/* socket to send the header */
pdata_hdr_t	*PdataHeaderPtr,	/* Memory location of the header */
char		*DataBuffer,		/* Data location */
int		DataLength		/* # of bytes to send */
);

extern int
pdata_recv_hdr_timeout(
int		SocketDescriptor,	/* socket to receive the header */
pdata_hdr_t	*PdataHeaderPtr,	/* Memory to receive the header */
int		SecTimeout		/* socket timeout in seconds */
);

extern int
pdata_send_hdr_timeout(
int		SocketDescriptor,	/* socket to send the header */
pdata_hdr_t	*PdataHeaderPtr,	/* Memory location of the header */
int		SecTimeout		/* socket timeout in seconds */
);

extern int
pdata_send_hdr_and_data_timeout(
int		SocketDescriptor,	/* socket to send the header */
pdata_hdr_t	*PdataHeaderPtr,	/* Memory location of the header */
char		*DataBuffer,		/* Data location */
int		DataLength,		/* # of bytes to send */
int		SecTimeout		/* socket timeout in seconds */
);

int
mover_socket_send_buffer(
int		SD,		/* socket for data transfer */
u_signed64	XferID,		/* transfer ID that identifies the data */
u_signed64	Offset,		/* offset of the data into the transfer */
char		*Buffer,	/* data to be sent */
int		Length,		/* # bytes to be transferred */
char		*Ticket		/* kerberos style ticket for security */
);

int
mover_socket_send_buffer_timeout(
int		SD,		/* socket for data transfer */
u_signed64	XferID,		/* transfer ID that identifies the data */
u_signed64	Offset,		/* offset of the data into the transfer */
char		*Buffer,	/* data to be sent */
int		Length,		/* # bytes to be transferred */
char		*Ticket,	/* kerberos style ticket for security */
int		SecTimeout	/* socket timeout in seconds */
);

int
mover_socket_get_buffer(
int		SD,		/* socket for data transfer */
u_signed64	XferID,		/* transfer ID that identifies the data */
u_signed64	Offset,		/* offset of the data into the transfer */
char		*Buffer,	/* where data is to be received */
int		Length,		/* # bytes to be transferred */
char		*Ticket		/* kerberos style ticket for security */
);

int
mover_socket_get_buffer_timeout(
int		SD,		/* socket for data transfer */
u_signed64	XferID,		/* transfer ID that identifies the data */
u_signed64	Offset,		/* offset of the data into the transfer */
char		*Buffer,	/* where data is to be received */
int		Length,		/* # bytes to be transferred */
char		*Ticket,	/* kerberos style ticket for security */
int		SecTimeout	/* socket timeout in seconds */
);

int
mover_socket_recv_data(
int		SD,		/* socket for data transfer */
u_signed64	XferID,		/* transfer ID that identifies the data */
u_signed64	Offset,		/* offset of the data into the transfer */
char		*Buffer,	/* where data is to be received */
int		BufSize,	/* Size of the buffer */
int		*BytesRecvd,	/* # bytes received (0 <= BytesRecvd <= BufSize) */
int		NumOfPackets	/* # of packets to receive before return */
);

int
mover_socket_recv_data_timeout(
int		SD,		/* socket for data transfer */
u_signed64	XferID,		/* transfer ID that identifies the data */
u_signed64	Offset,		/* offset of the data into the transfer */
char		*Buffer,	/* where data is to be received */
int		BufSize,	/* Size of the buffer */
int		*BytesRecvd,	/* # bytes received (0 <= BytesRecvd <= BufSize) */
int		NumOfPackets,	/* # of packets to receive before return */
int		SecTimeout	/* socket timeout in seconds */
);

int
mover_socket_send_requested_data(
int		SD,		/* socket for data transfer */
u_signed64	XferID,		/* transfer ID that identifies the data */
u_signed64	Offset,		/* offset of the data into the transfer */
char		*Buffer,	/* where data is to be sent from */
int		BufSize,	/* Size of the buffer */
int		*BytesSent,	/* # bytes sent (0 <= Bytessent <= BufSize) */
int		NumOfPackets	/* # of packets to wait for */
);

int
mover_socket_send_requested_data_timeout(
int		SD,		/* socket for data transfer */
u_signed64	XferID,		/* transfer ID that identifies the data */
u_signed64	Offset,		/* offset of the data into the transfer */
char		*Buffer,	/* where data is to be sent from */
int		BufSize,	/* Size of the buffer */
int		*BytesSent,	/* # bytes sent (0 <= Bytessent <= BufSize) */
int		NumOfPackets,	/* # of packets to wait for */
int		SecTimeout	/* socket timeout in seconds */
);

int
mover_waitfor_data(
int		SD,		/*  Socket we are listening on  */
u_signed64	XferID,		/*  ID of the transfer  */
u_signed64	Offset,		/*  Start of transfer offset  */
char		*Buffer,	/*  where to receive data  */
int		BufSize,	/*  # of bytes to expect  */
int		*BytesMoved 	/*  return value of bytes moved  */
);

int
mover_waitfor_data_timeout(
int		SD,		/*  Socket we are listening on  */
u_signed64	XferID,		/*  ID of the transfer  */
u_signed64	Offset,		/*  Start of transfer offset  */
char		*Buffer,	/*  where to receive data  */
int		BufSize,	/*  # of bytes to expect  */
int		*BytesMoved, 	/*  return value of bytes moved  */
int		SecTimeout	/*  socket timeout in seconds */
);

int
mover_waitfor_requests(
int		SD,		/*  Socket we are listening on  */
u_signed64	XferID,		/*  ID of the transfer  */
u_signed64	Offset,		/*  Start of transfer offset  */
char		*Buffer,	/*  where to receive data  */
int		BufSize,	/*  # of bytes to expect  */
int		*BytesMoved 	/*  return value of bytes moved  */
);

int
mover_waitfor_requests_timeout(
int		SD,		/*  Socket we are listening on  */
u_signed64	XferID,		/*  ID of the transfer  */
u_signed64	Offset,		/*  Start of transfer offset  */
char		*Buffer,	/*  where to receive data  */
int		BufSize,	/*  # of bytes to expect  */
int		*BytesMoved, 	/*  return value of bytes moved  */
int		SecTimeout	/*  socket timeout in seconds */
);

#endif
