/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)parse.c	3.19 06/30/99 CERN CN-SW/DC Frederic Hemmer";
#endif /* not lint */

/* parse.c      Remote File I/O - parse file path                       */

#define RFIO_KERNEL     1       /* system part of Remote File I/O       */

#if defined(_WIN32)
#define MAXHOSTNAMELEN 64
#else
#include <sys/param.h>		/* system dependent parameters		*/
#endif
#include <string.h>
#include "rfio.h"               /* remote file I/O definitions          */

#if defined(_WIN32)
__declspec(thread)
#endif
static char     buffer[MAXFILENAMSIZE];    /* To hold temporary strings */

int rfio_parseln(name, host, path, ln)        /* parse name to host and path  */
char    *name;
char    **host;
char    **path;
int   	ln ; 	/* solve links or not ? */
{
   char    *cp1, *cp2, *cp3;
   register int i;
   char	localhost[MAXHOSTNAMELEN];
   int 	n;
   static char 	name_1[MAXFILENAMSIZE];

/*
 * forms recognized: host:<unix path name>
 *                   /<prefix>/host/<unix path name>
 *
 * where prefix is defined in /etc/shift.conf :
 *      RFIO  NFS_ROOT          /.....
 */

   if ( rfioreadopt(RFIO_CONNECTOPT) == RFIO_FORCELOCAL )  {
      TRACE (2,"rfio","rfio_parseln(): Forcing local calls");
      *host = NULL;
      *path = name;
      return(0) ;
   }
   if (gethostname(localhost, sizeof(localhost)) < 0)	{
      return(-1);
   }

   if (ln != NORDLINKS ) {
      int countln = 0 ;
      char     buffer1[MAXFILENAMSIZE],buffer2[MAXFILENAMSIZE];

      strcpy ( buffer1, name );
#if defined(FollowRtLinks)
      while ( (n= rfio_readlink(buffer1,buffer,MAXFILENAMSIZE)) > 0  && countln < 4 ) 
#else
#if !defined(_WIN32)
	 while ( (n= readlink(buffer1,buffer,MAXFILENAMSIZE)) > 0  && countln < 4 ) 
#else
	    if (countln) 	/* i.e. never, because links are not impl. */
#endif
#endif /* FollowRtLinks */
	    {
	       /* save original filename */
	       strcpy(buffer2,buffer1);
	       countln ++ ;
	       buffer[n]='\0';
	       /* Is it a relative path ? */
	       if (buffer[0] != '/')  {
		  char *last_slash;
		  /* Is the relative link of the form host:/path ? */
		  if (strstr(buffer,":/") != NULL) {
		     /* Simply replace name */
		     strcpy(buffer1,buffer);
		  }  else  {
		     /* Host name is NOT like XXXX:/YYYYY */
		     if (strchr(buffer,'$') != NULL &&
			 (cp3 = (char *)strchr(buffer,':')) != NULL ) {
			/* This is a VMS syntax ! */
			strcpy(buffer1,buffer);
		     }
		     if ((last_slash =  strrchr(buffer1,'/')) == NULL) {
			/* Simply replace name */
			strcpy(buffer1,buffer);
		     }  else  {
			/* Concat basename of old name with new name */
			strcpy(last_slash + 1,buffer);
		     }
		  }
	       }    else
		  strcpy(buffer1, buffer);
	       TRACE (3,"rfio","rfio_parseln(): %s converted to %s",buffer2,buffer1);	
	    }
      strcpy(name_1,buffer1);
   }
   else
      strcpy(name_1,name);

   if ((cp1 = (char *)strstr(name_1,":/")) == NULL  ){
      /* Host name is NOT like XXXX:/YYYYY */
      cp1 = name_1;
      if ( strchr(name_1,'$') != NULL && (cp3=(char *)strchr(name_1,':')) != NULL ) {
	 /* This is a VMS syntax ! */
	 *host= name_1 ;
	 *path= cp3+1 ;
	 cp3[0]='\0' ;
	 return (1) ;
      }
      if ((cp2 = getconfent("RFIO","NFS_ROOT", 0)) == NULL)     {
	 *host = NULL;
	 *path = name_1;
	 serrno=0; /* reset error */
	 return(0);
      }
      /* compare the 2 strings        */
      for (i=0;i< (int)strlen(cp2);i++)     {
	 if (*(cp1+i) != *(cp2+i))       {
	    *host = NULL;
	    *path = name_1;
	    return(0);
	 }
      }
      cp1 += strlen(cp2);
      /* cp2 may be matching cp1 but being shorted */
      if (*cp1 != '/')        {
	 *host = NULL;
	 *path = name_1;
	 return(0);
      }
      /* cp1 now points to rooted nfs_path_name     */
      /* next token must be the node name prefixed by '/' */
      if ((cp2 = strchr(++cp1,'/')) == NULL)   {
	 /* incomplete name: /prefix/node  */
	 *host = NULL;
	 *path = name_1;
	 return(0);
      }

      strncpy(buffer,cp1,(int)(cp2-cp1));
      buffer[cp2-cp1] = '\0';
      *host = buffer;
      *path = name_1;
      /* is it localhost ? */
      if (strcmp(localhost, buffer) == 0)  {
	 *host = NULL;
	 return(0);
      }
      else    {
	 return(1);
      }
   }
   else    {
      /* first check if the path is in DOS format, e.g. hostname:x:/path/name */
      if( ((cp2 = strchr(name_1, ':')) != NULL) && (cp1 == cp2+2))  {
	 strncpy(buffer, name_1, cp2-name_1);
	 buffer[cp2-name_1] = '\0';
	 *host = buffer;
	 *path = cp2+1;
	 return(1);
      }  else  {
	 strncpy(buffer,name_1,cp1-name_1);
	 buffer[cp1-name_1] = '\0';
	 *host = buffer;
	 *path = cp1+1;
	 /* is it localhost ? */
	 if (strcmp(localhost, buffer) == 0)  {
	    *host = NULL;
	    return(0);
	 }
	 else    {
	    return(1);
	 }
      }
   }
}

int rfio_parse(name, host, path)        /* parse name to host and path  */
char    *name;
char    **host;
char    **path;
{
   return ( rfio_parseln(name, host, path, RDLINKS) );
}
