/*
 * Copyright (C) 1990-1999 by CERN/IT/PDP/IP
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)rfio_calls.c	3.77 07/26/99  CERN IT-PDP/IP Frederic Hemmer";
#endif /* not lint */

/*
 * Remote file I/O flags and declarations.
 */
#define DEBUG           0
#define RFIO_KERNEL     1   
#ifndef DOMAINNAME
#define DOMAINNAME "cern.ch"
#endif
#include <pwd.h>
#include <grp.h>
#if defined(_WIN32)
#include "syslog.h"
#else
#include <sys/param.h>
#include <syslog.h>                     /* System logger                */
#include <sys/time.h>
#endif
#if defined(_AIX) || defined(hpux) || defined(SOLARIS) || defined(linux)
#include <signal.h>
#endif

#include "rfio.h"	
#include "rfcntl.h"
#include "log.h"

#if defined(_AIX) && defined(_IBMR2)
#include <sys/select.h>
#endif
#include <sys/types.h>
#if !defined(_WIN32)
#include <netinet/in.h>
#include <netinet/tcp.h>
#endif
#include <sys/stat.h>

#ifdef linux
#include <sys/uio.h>
#endif

#ifdef CS2
#include <nfs/nfsio.h>
#endif

#if defined(_WIN32)
#include <fcntl.h>
#endif

#if defined(HPSS)
#include <dirent.h>
#include <dce/pthread.h>
#include <rfio_hpss.h>
#include "../h/marshall.h"  /* A must on AIX because of clash with dce/marshall.h */
extern struct global_defs global[];
/*
 * Override some system calls which cannot be used in a threaded version
 */
#define setuid(X) 0
#define setgid(X) 0
#define setgroups(X,Y) 0
/*
 * Override the simplest I/O and filesystem calls with HPSS interface
 * Note that the following cannot be overridden: read(), write() and close() because
 * they may be used on sockets as well as normal filedescriptors.
 * The macros below all assumes that the socket "s" and the client "uid" are defined 
 * in calling routine (same rule for global[] declared above). If this is not the 
 * case, the precompiler will hopefully complain otherwise (e.g. s is defined but not 
 * the accept socket) the result will be unpredictable at run-time....
 */
#define unlink(X) rhpss_unlink(X,s,uid,gid)
#define symlink(X,Y) rhpss_symlink(X,Y,s,uid,gid)
#define readlink(X,Y,Z) rhpss_readlink(X,Y,Z,s,uid,gid)
#define chown(X,Y,Z) rhpss_chown(X,Y,Z,s,uid,gid)
#define chmod(X,Y) rhpss_chmod(X,Y,s,uid,gid)
#define umask(X) rhpss_umask(X,s,0,0)
#define mkdir(X,Y) rhpss_mkdir(X,Y,s,uid,gid)
#define rmdir(X) rhpss_rmdir(X,s,uid,gid)
#define rename(X,Y) rhpss_rename(X,Y,s,uid,gid)
#define lockf(X,Y,Z) rhpss_lockf(X,Y,Z,s,uid,gid)
#define lstat(X,Y) rhpss_lstat(X,Y,s,uid,gid)
#define stat(X,Y) rhpss_stat(X,Y,s,uid,gid)
#define fstat(X,Y) rhpss_fstat(X,Y,s,0,0)
#define access(X,Y) rhpss_access(X,Y,s,uid,gid)
#define open(X,Y,Z) rhpss_open(X,Y,Z,s,uid,gid)
#define opendir(X) rhpss_opendir(X,s,uid,gid)
#define readdir(X) rhpss_readdir(X,s,0,0)
#define closedir(X) rhpss_closedir(X,s,0,0)
#define lseek(X,Y,Z) rhpss_lseek(X,Y,Z,s,0,0)
#define popen(X,Y) rhpss_popen(X,Y,s,uid,gid)
#endif /* HPSS */

/* For real time stuff under Digital Unix V4 */
#ifdef DUXV4
#ifdef RFIODaemonRealTime
#include <sched.h>
#endif
#endif

/*
 * External declaration for error handling 
 * and space allocation.
 */
#ifndef linux
extern char     *sys_errlist[];         /* External error list          */
#endif
extern int      sys_nerr;               /* Number of error messages     */
#if !defined(_WIN32)
extern char     *malloc();		/* Some systems forget this	*/
#endif

extern int 	checkkey();
static int 	chsuser() ;		/* Forward declaration 		*/

#if !defined(HPSS)
#if defined(_WIN32)
#if !defined (MAX_THREADS)
#define MAX_THREADS 64			
#endif /* MAX_THREADS */

extern 	DWORD tls_i;			/* thread local storage index */  
extern struct thData {
  SOCKET ns;    	/* control socket */
  struct sockaddr_in from;
  int mode;
  int _is_remote;
  int fd;
/* all globals, which have to be local for thread */
  char *rqstbuf;        /* Request buffer		*/
  char *filename;        /* file name            	*/  
  char *iobuffer; 		/* Data communication buffer    */
  int  iobufsiz;		/* Current io buffer size       */
  SOCKET data_s;     	/* Data listen socket (v3) */
  SOCKET data_sock;  	/* Data accept socket (v3) */
  SOCKET ctrl_sock;  	/* the control socket (v3) */
  int first_write;
  int first_read;
  int byte_read_from_network;
  struct rfiostat myinfo;
  char	from_host[MAXHOSTNAMELEN];
} *td;

#define rqstbuf td->rqstbuf
#define filename td->filename
#define iobuffer td->iobuffer
#define iobufsiz td->iobufsiz
#define data_s td->data_s
#define data_sock td->data_sock
#define ctrl_sock td->ctrl_sock
#define first_write td->first_write
#define first_read td->first_read
#define byte_read_from_network td->byte_read_from_network
#define is_remote td->_is_remote
#define myinfo td->myinfo

#else
/*
 * Buffer declarations
 */
char 	rqstbuf[BUFSIZ] ;		/* Request buffer		*/
char    filename[MAXFILENAMSIZE];       /* file name            	*/

static char     *iobuffer ;		/* Data communication buffer    */
static int      iobufsiz= 0;		/* Current io buffer size       */
#endif 	/* WIN32 */
#endif /* HPSS */

/*
 * Communication limits.
 */
#define SO_BUFSIZE      20*1024         /* Default socket buffer size   */
#define MAXXFERSIZE     200*1024        /* Maximum transfer size        */

#if defined(_WIN32)
#define ECONNRESET WSAECONNRESET
#endif 	/* WIN32 */

/************************************************************************/
/*                                                                      */
/*                              IO HANDLERS                             */
/*                                                                      */
/************************************************************************/

int     srrequest(s,bet)
#if defined(_WIN32)
SOCKET	s;
#else
int     s;
#endif
int 	*bet;
{
   char 	* p ;
   WORD  magic ;
   WORD   code ;
   int       n ; 

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   log(LOG_DEBUG, "rrequest: reading %d bytes\n",RQSTSIZE) ;
   if ((n = netread(s,rqstbuf,RQSTSIZE)) != RQSTSIZE) {
      if (n == 0)      {
	 return 0 ; 
      }
      else {
#if defined(_WIN32)
	 log(LOG_ERR, "rrequest: read(): %s\n", geterr());
#else	 
	 log(LOG_ERR, "rrequest: read(): %s\n", sys_errlist[errno]);
#endif	 
	 return -1 ;
      }
   }
   p= rqstbuf ; 
   unmarshall_WORD(p,magic) ;
   unmarshall_WORD(p,code) ;
   log(LOG_DEBUG,"rrequest:  magic: %x code: %x\n",magic,code) ;
   *bet= ( magic == RFIO_MAGIC ? 0 : 1 ) ;
   return code ;
}

int  srchk(s)
#if defined(_WIN32)
SOCKET	s;
#else
int     s;
#endif
{
   char * p        ;
   int status = 0  ;
#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   p = rqstbuf ;
   marshall_LONG(p,status);
   if ( netwrite(s, rqstbuf ,LONGSIZE) != LONGSIZE )  {
#if defined(_WIN32)
      log(LOG_ERR,"srchk(): write(): %s\n", geterr());
#else
      log(LOG_ERR,"srchk() : write(): %s\n",sys_errlist[errno]) ;
#endif
      return -1 ;
   }
   return 0 ;
}

#if !defined(_WIN32)
int srsymlink(s,rt, host)
int s ;
int     rt; /* Is it a remote site call ?   */
char *host; /* Where the request comes from */

{
   char * p        ;
   int status=0    ;
   int len         ;
   char user[20]	;
   char name1[MAXFILENAMSIZE] ;
   char name2[MAXFILENAMSIZE] ;
   int rcode       ;
   int uid,gid ;

   p= rqstbuf + 2*WORDSIZE ;
   unmarshall_LONG(p, len) ;
   /*
    * Reading open request.
    */
   log(LOG_DEBUG,"rlink: reading %d bytes\n",len) ;
   log(LOG_DEBUG,"remote ? %s\n", (rt?"yes":"no"));
   if (netread(s,rqstbuf,len) != len) {
      log(LOG_ERR,"rlink:  read() error: %s\n",sys_errlist[errno]);
      return -1 ;
   }
   p= rqstbuf ;
   unmarshall_WORD(p, uid) ;
   unmarshall_WORD(p, gid) ;
   unmarshall_STRING( p, name1 ) ;
   unmarshall_STRING( p, name2 ) ;
   unmarshall_STRING( p, user) ;

   /*
    * Mapping of user if call is issued from another site.
    */ 

   if ( (status==0) && rt ) {
      char to[100];
      int rcd;
      int to_uid, to_gid ;

      if ( (rcd = get_user(host,user,uid,gid,to,&to_uid,&to_gid)) == -ENOENT ) {
	 log(LOG_ERR,"r%slink: get_user(): Error opening mapping file\n",(name1[0]=='\0' ? "un":"sym")) ;
	 status= -1;
	 errno = EINVAL;
	 rcode = errno ;
      }

      if ( !status && abs(rcd) == 1 ) {
	 log(LOG_ERR,"No entry in mapping file for (%s,%s,%d,%d)\n", host,user,uid,gid);
	 status= -1;
	 errno=EACCES;
	 rcode=errno;
      }
      else {
	 log(LOG_DEBUG,"(%s,%s,%d,%d) mapped to %s(%d,%d)\n",
	     host,user,uid,gid,to,to_uid,to_gid) ;
	 uid = to_uid ;
	 gid = to_gid ;
      }	
   }

   if ( status == 0 && (status = chsuser(uid,gid,host,&rcode,"LINKTRUST")) < 0 ) {
      if ( status == -2 )
	 log(LOG_ERR,"srsymlink(): UID %d not allowed to r%slink().\n",uid,(name1[0]=='\0' ? "un":"sym")) ;
      else
	 log(LOG_ERR,"srsymlink(): failed, rcode = %d\n",rcode);
			
   }
   if ( status == 0 ) {
      if (name1[0]=='\0') {
	 status = unlink(name2) ;
	 rcode = (status < 0 ? errno: 0) ;
	 log(LOG_INFO ,"runlink(): unlink(%s) returned %d, rcode=%d\n",name2,status,rcode);
      }
      else {
	 log(LOG_INFO, "unlink for (%d, %d)\n",getuid(), getgid()) ;
	 status = symlink( name1, name2 ) ;
	 rcode = (status < 0 ? errno: 0) ;
	 log(LOG_INFO ,"rsymlink(): symlink(%s,%s) returned %d,rcode=%d\n",name1, name2, status,rcode ) ;
      }
   }

   /*
    * Sending back status.
    */
   p= rqstbuf ;
   marshall_WORD(p,RQST_SYMLINK) ;
   marshall_LONG(p,status);
   marshall_LONG(p,rcode) ;
#if defined(SACCT)
   rfioacct(RQST_SYMLINK,uid,gid,s,0,0,status,rcode,NULL,name1,name2);
#endif /* SACCT */
   log(LOG_DEBUG, "rlink: sending back status(%d) and errno (%d) \n",status,rcode);
   if (netwrite(s,rqstbuf,WORDSIZE+2*LONGSIZE) != WORDSIZE+2*LONGSIZE) {
      log(LOG_ERR,"rlink: write(): %s\n",sys_errlist[errno]) ;
      return -1 ;
   }
   return status ;
}


int srreadlink(s)
int s ;

{
   char * p        ;
   int status=0    ;
   int len         ;
   char path[MAXFILENAMSIZE] ;	/* link file path to read      	*/
   char lpath[MAXFILENAMSIZE] ;	/* link returned by readlink() 	*/
   int rcode       ;
   int uid,gid     ;		/* Requestor's uid & gid 	*/

   p= rqstbuf + 2*WORDSIZE ;
   unmarshall_LONG(p, len) ;
   /*
    * Reading open request.
    */
   log(LOG_DEBUG,"srreadlink(): reading %d bytes\n",len) ;
   if (netread(s,rqstbuf,len) != len) {
      log(LOG_ERR,"srreadlink() :  read() error: %s\n",sys_errlist[errno]);
      return -1 ;
   }
   p= rqstbuf ;
   unmarshall_WORD(p, uid) ;
   unmarshall_WORD(p, gid) ;
   unmarshall_STRING( p, path ) ;
   if ( (setgid(gid)<0) || (setuid(uid)<0) )  {
      status= errno ;
      log(LOG_ERR,"srreadlink(): unable to setuid,gid(%d,%d): %s\n",uid,gid,sys_errlist[errno]) ;
   }

#if ( defined ( _AIX ) && defined(_IBMR2))
   /* 
    * for RS6000, setgid() and setuid() is not enough 
    */
   if ( !status && setgroups( 0 , NULL) <0 ) {
      status = errno ;
      log(LOG_ERR,"srreadlink(): Unable to setup the process to group ID\n");
   }
#endif
   log(LOG_INFO,"srreadlink() : Solving %s\n",path);
   if (status == 0) {
      rcode = readlink( path, lpath, MAXFILENAMSIZE) ;
      if (rcode < 0) {
	 lpath[0]='\0' ;
	 status = -1 ;
	 rcode = errno ;
      }
      else {
	 lpath[rcode]='\0' ;
      }
   } 
   p= rqstbuf ;
   len = strlen(lpath) + 1 ;
   marshall_LONG(p,len) ;
   marshall_LONG(p,status);
   marshall_LONG(p,rcode);
   if (status == 0 )
      marshall_STRING(p,lpath);

#if defined(SACCT)
   rfioacct(RQST_READLINK,uid,gid,s,0,0,status,rcode,NULL,path,lpath);
#endif /* SACCT */
   if (netwrite(s,rqstbuf,len+3*LONGSIZE) != len+3*LONGSIZE) {
      log(LOG_ERR, "srreadlink(): write(): %s\n", sys_errlist[errno]);
      return(-1);
   }
   return (status) ;

}

int     srchown(s,host,rt)
int     s;
char *host ;
int rt ;
{
   char 	*p ;
   LONG	status = 0;
   LONG	len ;
   int 	uid,gid ;
   int 	owner, group ;
   int 	rcode = 0 ;

   p = rqstbuf + (2*WORDSIZE) ;
   unmarshall_WORD(p, uid) ;
   unmarshall_WORD(p, gid) ;
   unmarshall_LONG(p, len) ;
   /*
    * Reading chown request.
    */
   log(LOG_DEBUG, "rchown for (%d,%d): reading %d bytes\n", uid,gid,len);
   /* chown() is not for remote users */
   if ( rt ) { 
      status = -1;
      rcode = EACCES ;
      log(LOG_ERR,"Attempt to srchown() from %s denied\n",host);
   }
   else {
      if ( (status = chsuser(uid,gid,host,&rcode,"CHOWNTRUST")) < 0 ) {
	 if (status == -2)
	    log(LOG_ERR,"srchown(): UID %d not allowed to chown\n",uid);
	 else
	    log(LOG_ERR,"srchown(): failed, rcode = %d\n",rcode);
	 status = -1 ;
      }
      if (netread(s, rqstbuf, len) != len) {
	 log(LOG_ERR, "srchown(): read(): %s\n", sys_errlist[errno]);
	 return -1;
      }
      p = rqstbuf ;
      unmarshall_STRING(p, filename) ;
      unmarshall_WORD(p,owner);
      unmarshall_WORD(p,group);
      log(LOG_INFO,"rchown: filename: %s, uid: %d ,gid: %d\n",filename,owner,group);
      if (status == 0 ) {
	 if ( (status =  chown(filename,owner,group)) < 0 ) 
	    rcode = errno ;
	 else
	    status = 0 ;
      }
   }
   p = rqstbuf ;
   marshall_LONG(p, status);
   marshall_LONG(p, rcode);
#if defined(SACCT)
   rfioacct(RQST_CHOWN,uid,gid,s,(int)owner,(int)group,status,rcode,NULL,filename,NULL);
#endif /* SACCT */
   log(LOG_DEBUG, "srchown: sending back status %d rcode %d\n", status,rcode);
   if (netwrite(s, rqstbuf, 2*LONGSIZE) != 2*LONGSIZE)  {
      log(LOG_ERR, "srchown(): write(): %s\n", sys_errlist[errno]);
      return -1 ; 
   }
   return status ; 
}
#endif  /* !WIN32 */

int     srchmod(s,host,rt)
#if defined(_WIN32)
SOCKET	s;
#else
int     s;
#endif
char *host ;
int rt ;
{
   char 	*p ;
   LONG	status = 0;
   LONG	len ;
   LONG 	mode ;
   int 	uid,gid ;
   int 	rcode = 0 ;
   
#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   
   p = rqstbuf + (2*WORDSIZE) ;
   unmarshall_WORD(p, uid) ;
   unmarshall_WORD(p, gid) ;
   unmarshall_LONG(p, len) ;
   /*
    * Reading chmod request.
    */
   log(LOG_DEBUG, "rchmod for (%d,%d): reading %d bytes\n", uid,gid,len);
   /* chmod() is not for remote users */
   (void)umask(0) ;
   if ( rt ) { 
      status = -1;
      rcode = EACCES ;
      log(LOG_ERR,"Attempt to srchmod() from %s denied\n",host);
   }
   else {
      if ( (status=chsuser(uid,gid,host,&rcode,"CHMODTRUST")) < 0 ) {
	 if (status == -1)
	    log(LOG_ERR,"srchmod(): UID %d not allowed to chmod()\n",uid);
	 else
	    log(LOG_ERR,"srchmod(): failed, rcode = %d\n",rcode);
	 status = -1 ;
      }
      if (netread(s, rqstbuf, len) != len) {
#if defined(_WIN32)
	 log(LOG_ERR, "srchmod(): read(): %s\n", geterr());
#else	 
	 log(LOG_ERR, "srchmod(): read(): %s\n", sys_errlist[errno]);
#endif 	/* WIN32 */	 
	 return -1;
      }
      p = rqstbuf ;
      unmarshall_STRING(p, filename) ;
      unmarshall_LONG(p, mode) ;
      log(LOG_INFO,"chmod: filename: %s, mode: %o\n", filename, mode) ;
      if (status == 0 ) {
	 if ( (status =  chmod(filename, mode)) < 0 ) 
	    rcode = errno ;
	 else
	    status = 0 ;
      }
   }
   p = rqstbuf ;
   marshall_LONG(p, status);
   marshall_LONG(p, rcode);
#if defined(SACCT)
   rfioacct(RQST_CHMOD,uid,gid,s,0,(int)mode,status,rcode,NULL,filename,NULL);
#endif /* SACCT */
   log(LOG_DEBUG, "srchmod: sending back status %d rcode %d\n", status,rcode);
   if (netwrite(s, rqstbuf, 2*LONGSIZE) != 2*LONGSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR, "srchmod(): write(): %s\n", geterr());
#else      
      log(LOG_ERR, "srchmod(): write(): %s\n", sys_errlist[errno]);
#endif      
      return -1 ; 
   }
   return status ; 
}

int     srmkdir(s,host,rt)
#if defined(_WIN32)
SOCKET	s;
#else
int     s;
#endif
char *host ;
int rt ;
{
   char 	*p ;
   LONG	status = 0;
   LONG	len ;
   LONG 	mode ;
   int 	uid,gid ;
   int 	rcode = 0 ;
   
#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   
   p = rqstbuf + (2*WORDSIZE) ;
   unmarshall_WORD(p, uid) ;
   unmarshall_WORD(p, gid) ;
   unmarshall_LONG(p, len) ;
   /*
    * Reading mkdir request.
    */
   log(LOG_DEBUG, "rmkdir for (%d,%d): reading %d bytes\n", uid,gid,len);
   /* mkdir() is not for remote users */
   (void)umask(0) ;
   if ( rt ) { 
      status = -1;
      rcode = EACCES ;
      log(LOG_ERR,"Attempt to srmkdir() from %s denied\n",host);
   }
   else {
      if ( (status=chsuser(uid,gid,host,&rcode,"MKDIRTRUST")) < 0 ) {
	 if (status == -1)
	    log(LOG_ERR,"srmkdir(): UID %d not allowed to mkdir()\n",uid);
	 else
	    log(LOG_ERR,"srmkdir(): failed, rcode = %d\n",rcode);
	 status = -1 ;
      }
      if (netread(s, rqstbuf, len) != len) {
#if defined(_WIN32)
	 log(LOG_ERR, "srmkdir(): read(): %s\n", geterr());
#else	 
	 log(LOG_ERR, "srmkdir(): read(): %s\n", sys_errlist[errno]);
#endif	 
	 return -1;
      }
      p = rqstbuf ;
      unmarshall_STRING(p, filename) ;
      unmarshall_LONG(p, mode) ;
      log(LOG_INFO,"rmkdir: filename: %s, mode: %o\n", filename, mode) ;
      if (status == 0 ) {
	 if ( (status =  mkdir(filename, mode)) < 0 ) 
	    rcode = errno ;
	 else
	    status = 0 ;
      }
   }
   p = rqstbuf ;
   marshall_LONG(p, status);
   marshall_LONG(p, rcode);
#if defined(SACCT)
   rfioacct(RQST_MKDIR,uid,gid,s,0,(int)mode,status,rcode,NULL,filename,NULL);
#endif /* SACCT */
   log(LOG_DEBUG, "srmkdir: sending back status %d rcode %d\n", status,rcode);
   if (netwrite(s, rqstbuf, 2*LONGSIZE) != 2*LONGSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR, "srmkdir(): write(): %s\n", geterr());
#else      
      log(LOG_ERR, "srmkdir(): write(): %s\n", sys_errlist[errno]);
#endif      
      return -1 ; 
   }
   return status ; 
}

int     srrmdir(s,host,rt)
#if defined(_WIN32)
SOCKET	s;
#else
int     s;
#endif
char *host ;
int rt ;
{
   char 	*p ;
   LONG	status = 0;
   LONG	len ;
   int 	uid,gid ;
   int 	rcode = 0 ;
   
#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   
   p = rqstbuf + (2*WORDSIZE) ;
   unmarshall_WORD(p, uid) ;
   unmarshall_WORD(p, gid) ;
   unmarshall_LONG(p, len) ;
   /*
    * Reading rmdir request.
    */
   log(LOG_DEBUG, "rrmdir for (%d,%d): reading %d bytes\n", uid,gid,len);
   /* rmdir() is not for remote users */
   (void)umask(0) ;
   if ( rt ) { 
      status = -1;
      rcode = EACCES ;
      log(LOG_ERR,"Attempt to srrmdir() from %s denied\n",host);
   }
   else {
      if ( (status=chsuser(uid,gid,host,&rcode,"RMDIRTRUST")) < 0 ) {
	 if (status == -1)
	    log(LOG_ERR,"srrmdir(): UID %d not allowed to rmdir()\n",uid);
	 else
	    log(LOG_ERR,"srrmdir(): failed, rcode = %d\n",rcode);
	 status = -1 ;
      }
      if (netread(s, rqstbuf, len) != len) {
#if defined(_WIN32)
	 log(LOG_ERR, "srrmdir(): read(): %s\n", geterr());
#else	 
	 log(LOG_ERR, "srrmdir(): read(): %s\n", sys_errlist[errno]);
#endif	 
	 return -1;
      }
      p = rqstbuf ;
      unmarshall_STRING(p, filename) ;
      log(LOG_INFO,"rrmdir: filename: %s\n", filename) ;
      if (status == 0 ) {
	 if ( (status =  rmdir(filename)) < 0 ) 
	    rcode = errno ;
	 else
	    status = 0 ;
      }
   }
   p = rqstbuf ;
   marshall_LONG(p, status);
   marshall_LONG(p, rcode);
#if defined(SACCT)
   rfioacct(RQST_MKDIR,uid,gid,s,0,0,status,rcode,NULL,filename,NULL);
#endif /* SACCT */
   log(LOG_DEBUG, "srrmdir: sending back status %d rcode %d\n", status,rcode);
   if (netwrite(s, rqstbuf, 2*LONGSIZE) != 2*LONGSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR, "srrmdir(): write(): %s\n", geterr());
#else      
      log(LOG_ERR, "srrmdir(): write(): %s\n", sys_errlist[errno]);
#endif      
      return -1 ; 
   }
   return status ; 
}

int	srrename(s,host,rt)
#if defined(_WIN32)
SOCKET	s;
#else
int     s;
#endif
char 	*host ;
int 	rt ;
{
   char    *p ;
   LONG    status = 0;
   LONG    len ;
   LONG    mode ;
   int     uid,gid ;
   char    filenameo[MAXFILENAMSIZE] ;
   char    filenamen[MAXFILENAMSIZE] ;
   int     rcode = 0 ;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   p = rqstbuf + (2*WORDSIZE) ;
   unmarshall_WORD(p, uid) ;
   unmarshall_WORD(p, gid) ;
   unmarshall_LONG(p, len) ;
   /*
    * Reading rename request.
    */
   log(LOG_DEBUG, "srrename for (%d,%d): reading %d bytes\n", uid,gid,len);
   /* rename() is not for remote users */
   if ( rt ) { 
      status = -1;
      rcode = EACCES ;
      log(LOG_ERR,"Attempt to srrename() from %s denied\n",host);
   }
   else {
      if ( (status=chsuser(uid,gid,host,&rcode,"RENAMETRUST")) < 0 ) {
	 if (status == -1)
	    log(LOG_ERR,"srrename(): UID %d not allowed to rename()\n",uid);
	 else
	    log(LOG_ERR,"srrename(): failed, rcode = %d\n",rcode);
	 status = -1 ;
      }
      if (netread(s, rqstbuf, len) != len) {
#if defined(_WIN32)
	 log(LOG_ERR, "srrename(): read(): %s\n", geterr());
#else	 
	 log(LOG_ERR, "srrename(): read(): %s\n", sys_errlist[errno]);
#endif	 
	 return -1;
      }
      p = rqstbuf ;
      unmarshall_STRING(p, filenameo) ;
      unmarshall_STRING(p, filenamen) ;
      log(LOG_INFO,"srrename: filenameo %s, filenamen %s\n", filenameo, filenamen);
      if (status == 0 ) {
	 if ( (status =  rename(filenameo, filenamen)) < 0 ) 
	    rcode = errno ;
	 else
	    status = 0 ;
      }
   }
   p = rqstbuf ;
   marshall_LONG(p, status);
   marshall_LONG(p, rcode);
#if defined(SACCT)
   rfioacct(RQST_RENAME,uid,gid,s,0,0,status,rcode,NULL,filenameo,filenamen);
#endif /* SACCT */
   log(LOG_DEBUG, "srrename: sending back status %d rcode %d\n", status,rcode);
   if (netwrite(s, rqstbuf, 2*LONGSIZE) != 2*LONGSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR, "srrename(): write(): %s\n", geterr());
#else      
      log(LOG_ERR, "srrename(): write(): %s\n", sys_errlist[errno]);
#endif      
      return -1 ; 
   }
   return status ; 
}

#if !defined(_WIN32)
int srlockf(s,fd)
int     s;
int 	fd;
{
   char    *p ;
   LONG    status = 0;
   LONG    len ;
   LONG    mode ;
   int     uid,gid ;
   int     op;
   long    siz;
   int     rcode = 0 ;

   p = rqstbuf + (2*WORDSIZE) ;
   unmarshall_WORD(p, uid) ;
   unmarshall_WORD(p, gid) ;
   unmarshall_LONG(p, len) ;

   if ( (setgid(gid)<0) || (setuid(uid)<0) )  {
      status= -1 ;
      rcode= errno ;
      log(LOG_ERR,"srlockf(): unable to setuid,gid(%d,%d): %s\n",uid,gid,sys_errlist[errno]) ;
   }

   log(LOG_DEBUG, "srlockf for (%d,%d): reading %d bytes\n", uid,gid,len);

   if (netread(s, rqstbuf, len) != len) {
      log(LOG_ERR, "srlockf(): read(): %s\n", sys_errlist[errno]);
      return -1;
   }
   /*
    * Reading request.
    */
   p = rqstbuf ;
   unmarshall_LONG(p, op) ;
   unmarshall_LONG(p, siz);
   log(LOG_INFO,"srlockf: op %d, siz %ld\n", op, siz);
   if (status == 0 ) {
      if ( (status = lockf(fd, op, siz)) < 0 ) 
	 rcode = errno ;
      else
	 status = 0 ;
   }
   p = rqstbuf ;
   marshall_LONG(p, status);
   marshall_LONG(p, rcode);
#if defined(SACCT)
   rfioacct(RQST_LOCKF,uid,gid,s,op,(int)siz,status,rcode,NULL,NULL,NULL);
#endif /* SACCT */
   log(LOG_DEBUG, "srlockf: sending back status %d rcode %d\n", status,rcode);
   if (netwrite(s, rqstbuf, 2*LONGSIZE) != 2*LONGSIZE)  {
      log(LOG_ERR, "srlockf(): write(): %s\n", sys_errlist[errno]);
      return -1 ; 
   }
   return status ; 
}
#endif	/* !WIN32 */

int   srerrmsg(s)
#if defined(_WIN32)
SOCKET	s;
#else
int     s;
#endif
{
   int   code ; 
   int    len ;
   char * msg ;
   char *   p ;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   p= rqstbuf + 2*WORDSIZE ; 
   unmarshall_LONG(p, code);
   log(LOG_INFO, "rerrmsg: code: %d\n",code) ;
   msg= (code < sys_nerr && code > 0) ? sys_errlist[code] : "Invalid error code" ;
   log(LOG_DEBUG, "rerrmsg: errmsg: %s\n",msg);
   len= strlen(msg)+1 ;
   p = rqstbuf ;
   marshall_LONG(p,len) ;
   marshall_STRING(p,msg) ;
   log(LOG_DEBUG, "rerrmsg: sending back %d bytes\n",len+LONGSIZE);
   if (netwrite(s,rqstbuf,len+LONGSIZE) != len+LONGSIZE) {
#if defined(_WIN32)
      log(LOG_ERR, "rerrmsg: write(): %s\n", geterr());
#else      
      log(LOG_ERR, "rerrmsg: write(): %s\n", sys_errlist[errno]);
#endif      
      return(-1);
   }
   return(0);
}

#if !defined(_WIN32)
int     srlstat(s,rt,host,bet)
int     s;
int	rt; /* Is it a remote site call ?   */
char *host; /* Where the request comes from */
int   bet ; /* Version indicator: 0(old) or 1(new) */
{
   char *   p ;
   int status, rcode ;
   int    len ;
   struct stat statbuf ;
   char user[20];
   int uid,gid;

   p= rqstbuf + 2*WORDSIZE ;
   unmarshall_LONG(p,len) ;
   /*
    * Reading stat request.
    */
   log(LOG_DEBUG,"rlstat: reading %d bytes\n",len);
   if ((status = netread(s,rqstbuf,len)) != len) {
      log(LOG_ERR,"rlstat: read(): %s\n",sys_errlist[errno]);
      return -1;
   }
   p= rqstbuf ;
   uid = gid = 0;
   if (bet) {
     unmarshall_WORD(p,uid);
     unmarshall_WORD(p,gid);
     unmarshall_STRING(p,user);
   }
   unmarshall_STRING(p,filename) ;

   status = 0;
   if ( bet && rt ) {
      char to[100];
      int rcd;
      int to_uid, to_gid ;

      if ( (rcd = get_user(host,user,uid,gid,to,&to_uid,&to_gid)) == -ENOENT ) {
	 log(LOG_ERR,"rlstat: get_user(): Error opening mapping file\n") ;
	 status= -1;
	 errno = EINVAL;
	 rcode = errno ;
      }

      if ( !status && abs(rcd) == 1 ) {
	 log(LOG_ERR,"No entry in mapping file for (%s,%s,%d,%d)\n", host,user,uid,gid);
	 status= -1;
	 errno=EACCES;
	 rcode=errno;
      }
      else {
	 log(LOG_DEBUG,"(%s,%s,%d,%d) mapped to %s(%d,%d)\n",
	     host,user,uid,gid,to,to_uid,to_gid) ;
	 uid = to_uid ;
	 gid = to_gid ;
      }	
   }
   if ( !status ) {
     if (bet && 
	 (status=chsuser(uid,gid,host,&rcode,"OPENTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"STATTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"POPENTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"LINKTRUST")) < 0  &&
	 (status=chsuser(uid,gid,host,&rcode,"CHMODTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"CHOWNTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"MKDIRTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"RMDIRTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"RENAMETRUST")) < 0 ) {
       if (status == -2)
	 log(LOG_ERR,"rlstat(): uid %d not allowed to stat()\n",uid);
       else
	 log(LOG_ERR,"rlstat(): failed at chsuser(), rcode %d\n",rcode);
       memset(&statbuf,'\0',sizeof(statbuf));
       status = rcode ;
     } else {
       status= ( lstat(filename, &statbuf) < 0 ) ? errno : 0 ;
       log(LOG_INFO,"rlstat: file: %s , status %d\n",filename,status) ;
     }
   }
   p = rqstbuf ;
   marshall_WORD(p, statbuf.st_dev);
   marshall_LONG(p, statbuf.st_ino);
   marshall_WORD(p, statbuf.st_mode);
   marshall_WORD(p, statbuf.st_nlink);
   marshall_WORD(p, statbuf.st_uid);
   marshall_WORD(p, statbuf.st_gid);
   marshall_LONG(p, statbuf.st_size);
   marshall_LONG(p, statbuf.st_atime);
   marshall_LONG(p, statbuf.st_mtime);
   marshall_LONG(p, statbuf.st_ctime);
   marshall_LONG(p, status);
   log(LOG_DEBUG, "rlstat: sending back %d\n", status);
   if (netwrite(s,rqstbuf,6*LONGSIZE+5*WORDSIZE) != 6*LONGSIZE+5*WORDSIZE)  {
      log(LOG_ERR, "rlstat: write(): %s\n", sys_errlist[errno]);
      return -1 ;
   }
   return 0 ;
}
#endif 	/* !WIN32 */

int     srstat(s,rt,host,bet)
#if defined(_WIN32)
SOCKET 	s;
#else
int     s;
#endif
int	rt; /* Is it a remote site call ?   */
char *host; /* Where the request comes from */
int   bet ; /* Version indicator: 0(old) or 1(new) */
{
   char *   p ;
   int status, rcode ; 
   int    len ; 
   struct stat statbuf ;
   char user[20];
   int uid,gid;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif
   p= rqstbuf + 2*WORDSIZE ;
   unmarshall_LONG(p,len) ;
   /*
    * Reading stat request.
    */
   log(LOG_DEBUG,"rstat: reading %d bytes\n",len);
   if ((status = netread(s,rqstbuf,len)) != len) {
#if defined(_WIN32)
      log(LOG_ERR,"rstat: read(): %s\n", geterr());
#else      
      log(LOG_ERR,"rstat: read(): %s\n",sys_errlist[errno]);
#endif      
      return -1;
   }
   p= rqstbuf ;
   uid = gid = 0;
   if (bet) {
     unmarshall_WORD(p,uid);
     unmarshall_WORD(p,gid);
     unmarshall_STRING(p,user);
   }
   unmarshall_STRING(p,filename) ;

   status = 0;
   if ( bet && rt ) {
      char to[100];
      int rcd;
      int to_uid, to_gid ;

      if ( (rcd = get_user(host,user,uid,gid,to,&to_uid,&to_gid)) == -ENOENT ) {
	 log(LOG_ERR,"rstat: get_user(): Error opening mapping file\n") ;
	 status= -1;
	 errno = EINVAL;
	 rcode = errno ;
      }

      if ( !status && abs(rcd) == 1 ) {
	 log(LOG_ERR,"No entry in mapping file for (%s,%s,%d,%d)\n", host,user,uid,gid);
	 status= -1;
	 errno=EACCES;
	 rcode=errno;
      }
      else {
	 log(LOG_DEBUG,"(%s,%s,%d,%d) mapped to %s(%d,%d)\n",
	     host,user,uid,gid,to,to_uid,to_gid) ;
	 uid = to_uid ;
	 gid = to_gid ;
      }	
   }
   if ( !status ) {
     /*
      * Trust root for stat() if trusted for any other privileged operation
      */
     rcode = 0;
     if (bet && 
	 (status=chsuser(uid,gid,host,&rcode,"OPENTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"STATTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"POPENTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"LINKTRUST")) < 0  &&
	 (status=chsuser(uid,gid,host,&rcode,"CHMODTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"CHOWNTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"MKDIRTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"RMDIRTRUST")) < 0 &&
	 (status=chsuser(uid,gid,host,&rcode,"RENAMETRUST")) < 0 ) {
       if (status == -2)
	 log(LOG_ERR,"rstat(): uid %d not allowed to stat()\n",uid);
       else
	 log(LOG_ERR,"rstat(): failed at chsuser(), rcode %d\n",rcode);
       memset(&statbuf,'\0',sizeof(statbuf));
       status = rcode ;
     } else  {
       status= ( stat(filename, &statbuf) < 0 ) ? errno : 0 ;
       log(LOG_INFO,"rstat: stat(): file: %s for (%d,%d) status %d\n",filename,uid,gid,status) ;
     }
   }
   p = rqstbuf ;
   marshall_WORD(p, statbuf.st_dev);
   marshall_LONG(p, statbuf.st_ino);
   marshall_WORD(p, statbuf.st_mode);
   marshall_WORD(p, statbuf.st_nlink);
   marshall_WORD(p, statbuf.st_uid);
   marshall_WORD(p, statbuf.st_gid);
   marshall_LONG(p, statbuf.st_size);
   marshall_LONG(p, statbuf.st_atime);
   marshall_LONG(p, statbuf.st_mtime);
   marshall_LONG(p, statbuf.st_ctime);
   marshall_LONG(p, status);
#if !defined(_WIN32)
   marshall_LONG(p, statbuf.st_blksize);
   marshall_LONG(p, statbuf.st_blocks);
#endif
   if (netwrite(s,rqstbuf,8*LONGSIZE+5*WORDSIZE) != 8*LONGSIZE+5*WORDSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR, "rstat: write(): %s\n", geterr());
#else      
      log(LOG_ERR, "rstat: write(): %s\n", sys_errlist[errno]);
#endif      
      return -1 ; 
   }
   return 0 ; 
}

#if !defined(_WIN32)
int     sraccess(s)
int     s;
{
   char 	*p ;
   int 	status = 0; 
   int    	len ,uid, gid; 
   int 	mode ;

   p= rqstbuf + 2*WORDSIZE ;
   unmarshall_LONG(p,len) ;
   /*
    * Reading stat request.
    */
   log(LOG_DEBUG,"raccess: reading %d bytes\n",len);
   if (netread(s,rqstbuf,len) != len) {
      log(LOG_ERR,"raccess: read(): %s\n",sys_errlist[errno]);
      return -1;
   }
   p= rqstbuf ;
   unmarshall_STRING(p,filename) ;
   unmarshall_LONG(p,uid);
   unmarshall_LONG(p,gid);
   unmarshall_LONG(p,mode);

   if ( (setgid(gid)<0) || (setuid(uid)<0) )  {
      status= errno ;
      log(LOG_ERR,"rlink: unable to setuid,gid(%d,%d): %s\n",uid,gid,sys_errlist[errno]) ;
   }

#if ( defined ( _AIX ) && defined(_IBMR2))
   /* 
    * for RS6000, setgid() and setuid() is not enough 
    */
   if ( !status && setgroups( 0 , NULL) <0 ) {
      status = errno ;
      log(LOG_ERR,"Unable to setup the process to group ID\n");
   }
#endif
   if (!status) {
      status= ( access(filename, mode) < 0 ) ? errno : 0 ;
      log(LOG_INFO,"raccess: filen: %s, mode %d for (%d,%d) status %d\n",filename,mode,uid,gid,status) ;
   }
   p = rqstbuf ;
   marshall_LONG(p, status);
#if defined(SACCT)
   rfioacct(RQST_ACCESS,uid,gid,s,0,(int)mode,status,errno,NULL,filename,NULL);
#endif /* SACCT */   
   log(LOG_DEBUG, "raccess: sending back %d\n", status);
   if (netwrite(s,rqstbuf,LONGSIZE) != LONGSIZE)  {
      log(LOG_ERR, "raccess: write(): %s\n", sys_errlist[errno]);
      return -1 ; 
   }
   return 0 ; 
}
#endif	/* !WIN32 */

int  srstatfs(s)
int     s;
{
   int status = 0 ;
   int rcode = 0;
   int len ;
   char *p ;
   char path[MAXFILENAMSIZE] ;
   struct rfstatfs statfsbuf ;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   p= rqstbuf + 2*WORDSIZE ;
   unmarshall_LONG(p,len) ;
   log(LOG_DEBUG,"srstatfs(): reading %d bytes\n",len) ;
   if ((status = netread(s,rqstbuf,len)) != len) {
#if defined(_WIN32)
      log(LOG_ERR,"srstatfs(): read(): %s\n", geterr());
#else      
      log(LOG_ERR,"srstatfs(): read(): %s\n",sys_errlist[errno]);
#endif
      return -1;
   }

   p= rqstbuf ;
   unmarshall_STRING(p,path) ;
   status = rfstatfs(path,&statfsbuf) ;
   log(LOG_INFO,"srrstatfs: path : %s , status %d\n",path,status ) ;
   rcode = errno ;
   /*
    * Shipping the results
    */
   p = rqstbuf ;
   marshall_LONG( p, statfsbuf.bsize ) ;
   marshall_LONG( p, statfsbuf.totblks ) ;
   marshall_LONG( p, statfsbuf.freeblks ) ;
   marshall_LONG( p, statfsbuf.totnods ) ;
   marshall_LONG( p, statfsbuf.freenods ) ;
   marshall_LONG( p, status ) ;
   marshall_LONG( p, rcode ) ;

   log(LOG_DEBUG, "srstatfs: sending back %d\n", status);
   if (netwrite(s,rqstbuf,7*LONGSIZE) != 7*LONGSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR, "srstatfs: write(): %s\n", geterr());
#else      
      log(LOG_ERR, "srstatfs: write(): %s\n", sys_errlist[errno]);
#endif      
      return -1 ;
   }
   return status ;


}
	
int  sropen(s,rt,host,bet)
#if defined(_WIN32)
SOCKET 	s;
#else
int     s;
#endif  
int	rt; /* Is it a remote site call ?   */
char *host; /* Where the request comes from */
int   bet ; /* Version indicator: 0(old) or 1(new) */
{
   int	status;
   int   rcode = 0;
   char       *p;
   int        len;
   int         fd ;
   LONG    flags, mode;
   int     uid, gid;
   WORD    mask, ftype, passwd, mapping;
   char    account[MAXACCTSIZE];           /* account string       */
   char    user[20];			/* User name 		*/
   char 	reqhost[MAXHOSTNAMELEN];
   char 	vmstr[MAXVMSTRING];
#if defined(_WIN32)
   SOCKET  sock;
#else
   int 	sock;
#endif	
#if defined(HPSS)
   extern char *rtuser;
#endif /* HPSS */

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   p = rqstbuf + 2*WORDSIZE ;
   unmarshall_LONG(p, len) ;
   /*
    * Reading open request.
    */
   log(LOG_DEBUG,"ropen: reading %d bytes\n",len) ;
   if ((status = netread(s,rqstbuf,len)) != len) {
#if defined(_WIN32)
      log(LOG_ERR,"ropen: read(): %s\n", geterr());
#else      
      log(LOG_ERR,"ropen: read(): %s\n",sys_errlist[errno]) ;
#endif      
      return -1 ;
   }
   p= rqstbuf ;
   unmarshall_WORD(p, uid);
   unmarshall_WORD(p, gid);
   unmarshall_WORD(p, mask);
   unmarshall_WORD(p, ftype);
   unmarshall_LONG(p, flags);
   unmarshall_LONG(p, mode);
   unmarshall_STRING(p, account);
   unmarshall_STRING(p, filename);
   if (bet) {
      unmarshall_STRING(p, user);
      unmarshall_STRING(p, reqhost);
      unmarshall_LONG(p, passwd);
      unmarshall_WORD(p, mapping);
      unmarshall_STRING(p, vmstr);
   }

   log(LOG_DEBUG,"vms string is %s\n", vmstr) ;
   if (bet) 
      log(LOG_DEBUG,"Opening file %s for remote user: %s\n",filename,user);
   if (rt)
      log(LOG_DEBUG,"Mapping : %s\n",mapping ? "yes" : "no" );
   if (rt && !mapping) {
      log(LOG_DEBUG,"passwd : %d\n",passwd);
      log(LOG_DEBUG,"uid: %d\n",uid );
      log(LOG_DEBUG,"gid: %d\n",gid );
   }

   /*
    * Someone in the site has tried to specify (uid,gid) directly !
    */
   status=0;
   if (bet && !mapping && !rt) {
      log(LOG_INFO,"attempt to make non-mapped I/O and modify uid or gid !\n");
      errno=EACCES ;
      rcode=errno ;
      status= -1 ;
   }
		
   if ( rt ) { 
#if !defined(ultrix)
      openlog("rfio",LOG_PID, LOG_USER) ;
#else
      openlog("rfio",LOG_PID ) ;
#endif
      syslog(LOG_ALERT, "rfio: connection %s mapping by %s(%d,%d) from %s",(mapping ? "with" : "without"),user,uid,gid,host) ;
      closelog() ;
   }

   /*
    * MAPPED mode: user will be mapped to user "to"
    */
   if ( !status && rt && mapping ) {
      char to[100];
      int rcd,to_uid,to_gid;

      log(LOG_DEBUG,"Mapping (%s, %d, %d) \n",user, uid, gid );
      if ( (rcd = get_user(host,user,uid,gid,to,&to_uid,&to_gid)) == -ENOENT ) {
	 log(LOG_ERR,"sropen(): get_user() error opening mapping file\n") ;
	 status = -1;
	 errno = EINVAL;
	 rcode = SEHOSTREFUSED ;
      }

      else if ( abs(rcd) == 1 ) {
	 log(LOG_ERR,"No entry found in mapping file for (%s,%s,%d,%d)\n", host,user,uid,gid);
	 status = -1;
	 errno = EACCES;
	 rcode = SEHOSTREFUSED;
      }
      else {
	 log(LOG_DEBUG,"(%s,%s,%d,%d) mapped to %s(%d,%d)\n",
	     host,user,uid,gid,to,to_uid,to_gid) ;
	 uid = to_uid ;
	 gid = to_gid ;
	 if ( uid < 100 || gid < 100 ) {
	    errno = EACCES;
	    status = -1;
	    rcode = SEHOSTREFUSED;
	 }
      }
   }
   /* 
    * DIRECT access: the user specifies uid & gid by himself 
    */
   if ( !status && rt && !mapping ){
#if defined(HPSS)
      if ( rtuser == NULL || !strcmp(rtuser,"YES") ) {
#else /* HPSS */
      char * rtuser;
      if ( (rtuser=getconfent ("RTUSER","CHECK",0) ) == NULL || ! strcmp (rtuser,"YES") ) {
#endif /* HPSS */
	 /* Port is also passwd */
#if defined(_WIN32)
	 if( (sock = connecttpread(reqhost, passwd)) != INVALID_SOCKET
	     && !checkkey(sock, passwd) )  
#else
	 if( (sock = connecttpread(reqhost, passwd)) >= 0 && !checkkey(sock, passwd) )  
#endif
	 {
	    status= -1 ;
	    errno = EACCES;
	    rcode= errno ;
	    log(LOG_ERR,"ropen: DIRECT mapping : permission denied\n");
	 }
#if defined(_WIN32)
	    if( sock == INVALID_SOCKET )
#else	    
	    if( sock < 0 ) 
#endif
	    {
	      status= -1 ;
	    log(LOG_ERR,"ropen: DIRECT mapping failed: Couldn't connect %s\n", reqhost);
	    rcode = EACCES;
	    }
      }
      else
	 log(LOG_INFO ,"Any DIRECT rfio request from out of site is authorized\n");
   }
   if ( !status ) {
      log(LOG_DEBUG, "ropen: uid %d gid %d mask %o ftype %d flags %d mode %d\n",uid, gid, mask, ftype, flags, mode);
      log(LOG_DEBUG, "ropen: account: %s\n", account);
      log(LOG_DEBUG, "ropen: filename: %s\n", filename);
      log(LOG_INFO, "ropen(%s,0X%X,0X%X) for (%d,%d)\n",filename,flags,mode,uid,gid);
      (void) umask(mask) ;
      if ( (status=chsuser(uid,gid,host,&rcode,"OPENTRUST")) < 0 ) {
	 if (status == -2)
	    log(LOG_ERR,"ropen(): uid %d not allowed to open()\n",uid);
	 else
	    log(LOG_ERR,"ropen(): failed at chsuser(), rcode %d\n",rcode);
	 status = -1 ;
      }
      else
      {
	 fd = open(filename, ntohopnflg(flags), mode) ;
	 log(LOG_DEBUG, "ropen: open(%s,%d,%d) returned %x (hex)\n", filename, flags, mode, fd);
	 if (fd < 0) {
	    char alarmbuf[1024];
	    sprintf(alarmbuf,"sropen(): %s",filename) ;
	    status= -1 ;
	    rcode= errno ;
	    log(LOG_DEBUG,"ropen: open: %s\n",sys_errlist[errno]) ;
	    rfio_alrm(rcode,alarmbuf) ;
	 }
	 else {
	    /*
	     * Getting current offset
	     */
	    status= lseek(fd,0L,SEEK_CUR) ;
	    log(LOG_DEBUG,"ropen: lseek(%d,0,SEEK_CUR) returned %x (hex)\n",fd,status) ; 
	    if ( status < 0 ) rcode= errno ;
	 }
      }
   }

   /*
    * Sending back status.
    */
   p= rqstbuf ;
   marshall_WORD(p,RQST_OPEN) ; 
   marshall_LONG(p,status);
   marshall_LONG(p,rcode) ;
   marshall_LONG(p,0) ;
#if defined(SACCT)
   rfioacct(RQST_OPEN,uid,gid,s,(int)ntohopnflg(flags),(int)mode,status,rcode,NULL,filename,NULL);
#endif /* SACCT */
   log(LOG_DEBUG, "ropen: sending back status(%d) and errno(%d)\n",status,rcode);
   if (netwrite(s,rqstbuf,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR,"ropen: write(): %s\n", geterr());
#else      
      log(LOG_ERR,"ropen: write(): %s\n",sys_errlist[errno]) ;
#endif      
      return -1 ;
   }
   return fd ;
}

int srwrite(s, infop, fd)
#if defined(_WIN32)
SOCKET s;
#else
int     s;
#endif
int     fd;
struct rfiostat * infop ;
{
   int	status;		/* Return code		*/
   int	rcode;		/* To send back errno	*/
   int 	how;		/* lseek mode		*/
   int	offset;		/* lseek offset		*/
   int  size;		/* Requeste write size	*/
   char *p;		/* Pointer to buffer	*/

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   /*
    * Receiving request,
    */
   log(LOG_DEBUG, "rwrite(%d, %d)\n",s, fd);
   p= rqstbuf + 2*WORDSIZE ; 
   unmarshall_LONG(p, size);
   unmarshall_LONG(p,how) ;
   unmarshall_LONG(p,offset) ; 
   log(LOG_DEBUG, "rwrite(%d, %d): size %d, how %d offset %d\n",s,fd,size,how,offset);
   /*
    * lseek() if needed.
    */
   if ( how != -1 ) {
      log(LOG_DEBUG,"rwrite(%d,%d): lseek(%d,%d,%d)\n",s,fd,fd,offset,how) ; 
      infop->seekop++;
      if ( (status= lseek(fd,offset,how)) == -1 ) { 
	 rcode= errno ;
	 p= rqstbuf ; 
	 marshall_WORD(p,RQST_WRITE) ;			
	 marshall_LONG(p,status) ; 
	 marshall_LONG(p,rcode) ; 
	 marshall_LONG(p,0) ; 
	 if ( netwrite(s,rqstbuf,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE ) {
#if defined(_WIN32)
	    log(LOG_ERR, "rread: write(): %s\n", geterr());
#else	    
	    log(LOG_ERR, "rread: write(): %s\n", sys_errlist[errno]);
#endif	    
	    return -1 ;
	 }
	 return -1 ;
      }
   }
   /*
    * Checking if buffer is large enough. 
    */
   if (iobufsiz < size)     {
      int     optval ;	/* setsockopt opt value */

      if (iobufsiz > 0)       {
	 log(LOG_DEBUG, "rwrite(): freeing %x\n",iobuffer);
	 (void) free(iobuffer) ;
      }
      if ((iobuffer = malloc(size)) == NULL)    {
	 status= -1 ; 
	 rcode= errno ;
	 p= rqstbuf ; 
	 marshall_WORD(p,RQST_WRITE) ;			
	 marshall_LONG(p,status) ; 
	 marshall_LONG(p,rcode) ; 
	 marshall_LONG(p,0) ; 
	 log(LOG_ERR, "rwrite: malloc(): %s\n", sys_errlist[errno]) ;
	 if ( netwrite(s,rqstbuf,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE ) {
#if defined(_WIN32)
	    log(LOG_ERR, "rread: write(): %s\n", geterr());
#else	    
	    log(LOG_ERR, "rread: write(): %s\n", sys_errlist[errno]) ;
#endif
	    return -1 ;
	 }
	 return -1 ;
      }
      iobufsiz = size ;
      optval = iobufsiz;
      log(LOG_DEBUG, "rwrite(): allocated %d bytes at %x\n",size,iobuffer) ;
#if defined(_WIN32)
      if( setsockopt(s, SOL_SOCKET, SO_RCVBUF, (char*)&optval, sizeof(optval)) == SOCKET_ERROR ) 
	 log(LOG_ERR, "rwrite(): setsockopt(SO_RCVBUF): %s\n", geterr());
#else
      if (setsockopt(s, SOL_SOCKET, SO_RCVBUF, (char *)&optval, sizeof(optval)) == -1) 
	 log(LOG_ERR, "rwrite(): setsockopt(SO_RCVBUF): %s\n",sys_errlist[errno]);
#endif      
      else
	 log(LOG_DEBUG, "rwrite(): setsockopt(SO_RCVBUF): %d\n",size) ;
   }
   /*
    * Reading data on the network.
    */
   p= iobuffer ;
   if (netread(s,p,size) != size) {
#if defined(_WIN32)
      log(LOG_ERR, "rwrite: read(): %s\n", geterr());
#else      
      log(LOG_ERR, "rwrite: read(): %s\n", sys_errlist[errno]) ;
#endif      
      return -1 ;
   }
   /*
    * Writing data on disk.
    */
   infop->wnbr+= size ;
#if defined(HPSS)
   status = rhpss_write(fd,p,size,s,0,0);
#else /* HPSS */
   status = write(fd,p,size) ;
#endif /* HPSS */
   rcode= ( status < 0 ) ? errno : 0 ;
	
   if ( status < 0 ) {
      char alarmbuf[1024];
      sprintf(alarmbuf,"srwrite(): %s",filename) ;
      rfio_alrm(rcode,alarmbuf) ;
   }
   p = rqstbuf;
   marshall_WORD(p,RQST_WRITE) ;			
   marshall_LONG(p,status) ;
   marshall_LONG(p,rcode) ;
   marshall_LONG(p,0) ;
   log(LOG_DEBUG, "rwrite: status %d, rcode %d\n", status, rcode) ;
   if (netwrite(s,rqstbuf,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR, "rwrite: write(): %s\n", geterr());
#else      
      log(LOG_ERR, "rwrite: write(): %s\n", sys_errlist[errno]) ;
#endif      
      return -1 ; 
   }
   return status ; 
}

int srread(s, infop, fd)
#if defined(_WIN32)
SOCKET 	s;
#else
int     s;
#endif
int     fd;
struct rfiostat * infop ;
{
   int 	status ;	/* Return code		*/
   int      rcode ;	/* To send back errno	*/
   int	   how ;	/* lseek mode 		*/
   int	offset ;	/* lseek offset		*/
   int       size ;	/* Requested read size	*/
   char       *p ;	/* Pointer to buffer	*/
   int	msgsiz ;	/* Message size		*/

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   /*
    * Receiving request.
    */
   log(LOG_DEBUG, "rread(%d, %d)\n",s, fd);
   p= rqstbuf + 2*WORDSIZE ; 
   unmarshall_LONG(p, size) ;
   unmarshall_LONG(p,how) ;
   unmarshall_LONG(p,offset) ; 
   /*
    * lseek() if needed.
    */
   if ( how != -1 ) {
      log(LOG_DEBUG,"rread(%d,%d): lseek(%d,%d,%d)\n",s,fd,fd,offset,how) ; 
      infop->seekop++;
      if ( (status= lseek(fd,offset,how)) == -1 ) { 
	 rcode= errno ;
	 p= rqstbuf ; 
	 marshall_WORD(p,RQST_READ) ;			
	 marshall_LONG(p,status) ; 
	 marshall_LONG(p,rcode) ; 
	 marshall_LONG(p,0) ;
	 if ( netwrite(s,rqstbuf,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE ) {
#if defined(_WIN32)
	    log(LOG_ERR, "rread: write(): %s\n", geterr());
#else
	    log(LOG_ERR, "rread: write(): %s\n", sys_errlist[errno]);
#endif	    
	    return -1 ;
	 }
	 return -1 ;
      }
   }
   /*
    * Allocating buffer if not large enough.
    */
   log(LOG_DEBUG, "rread(%d, %d): checking buffer size %d\n", s, fd, size);
   if (iobufsiz < (size+WORDSIZE+3*LONGSIZE))     {
      int     optval ;	/* setsockopt opt value	*/

      if (iobufsiz > 0)       {
	 log(LOG_DEBUG, "rread(): freeing %x\n",iobuffer);
	 (void) free(iobuffer);
      }
      if ((iobuffer = malloc(size+WORDSIZE+3*LONGSIZE)) == NULL)    {
	 status= -1 ; 
	 rcode= errno ;
	 log(LOG_ERR, "rread: malloc(): %s\n", sys_errlist[errno]) ;
	 p= rqstbuf ; 
	 marshall_WORD(p,RQST_READ) ;			
	 marshall_LONG(p,status) ; 
	 marshall_LONG(p,rcode) ; 
	 marshall_LONG(p,0) ;
	 if ( netwrite(s,rqstbuf,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE ) {
#if defined(_WIN32)
	    log(LOG_ERR, "rread: netwrite(): %s\n", geterr());
#else	    
	    log(LOG_ERR, "rread: write(): %s\n", sys_errlist[errno]) ;
#endif	    
	    return -1 ;
	 }
	 return -1 ; 
      }
      iobufsiz = size + WORDSIZE + 3*LONGSIZE ;
      log(LOG_DEBUG, "rread(): allocated %d bytes at %x\n",size,iobuffer);
      optval = iobufsiz;
#if defined(_WIN32)
      if( setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char*)&optval, sizeof(optval))
	  == SOCKET_ERROR )  
	 log(LOG_ERR, "rread(): setsockopt(SO_SNDBUF): %s\n", geterr());
#else	 
      if( setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char*)&optval, sizeof(optval)) == -1 )  
	 log(LOG_ERR, "rread(): setsockopt(SO_SNDBUF): %s\n",sys_errlist[errno]);
#endif
      log(LOG_DEBUG, "rread(): setsockopt(SO_SNDBUF): %d\n",size);
   }
   p = iobuffer + WORDSIZE + 3*LONGSIZE;
#if defined(HPSS)
   status = rhpss_read(fd,p,size,s,0,0);
#else /* HPSS */
   status = read(fd, p, size) ;
#endif /* HPSS */
   if ( status < 0 ) {
      char alarmbuf[1024];
      sprintf(alarmbuf,"srread(): %s",filename) ;
      rcode= errno ;
      msgsiz= WORDSIZE+3*LONGSIZE ;
      rfio_alrm(rcode,alarmbuf) ;
   }  else  {
      rcode= 0 ; 
      infop->rnbr+= status ;
      msgsiz= status+WORDSIZE+3*LONGSIZE ;
   }
   p= iobuffer ;
   marshall_WORD(p,RQST_READ) ; 
   marshall_LONG(p,status) ;
   marshall_LONG(p,rcode) ;
   marshall_LONG(p,status) ;
   log(LOG_DEBUG, "rread: returning status %d, rcode %d\n", status, rcode) ;
   if (netwrite(s,iobuffer,msgsiz) != msgsiz)  {
#if defined(_WIN32)
      log(LOG_ERR, "rread: write(): %s\n", geterr());
#else      
      log(LOG_ERR, "rread: write(): %s\n", sys_errlist[errno]);
#endif      
      return -1 ;
   }
   return status ;
}

int srreadahead(s, infop, fd)
#if defined(_WIN32)
SOCKET	s;
#else
int     s;
#endif
int     fd;
struct rfiostat *infop ;
{
   int  status;	/* Return code		*/ 
   int	rcode;	/* To send back errno	*/
   int	how;	/* lseek mode		*/
   int	offset;	/* lseek offset		*/
   int	size;	/* Requested read size	*/
   int	first;	/* First block sent	*/
   char *p;	/* Pointer to buffer	*/

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   /*
    * Receiving request.
    */
   log(LOG_DEBUG, "rreadahead(%d, %d)\n",s, fd);
   p= rqstbuf + 2*WORDSIZE ; 
   unmarshall_LONG(p,size);
   unmarshall_LONG(p,how) ;
   unmarshall_LONG(p,offset) ; 
   /*
    * lseek() if needed.
    */
   if ( how != -1 ) {
      log(LOG_DEBUG,"rread(%d,%d): lseek(%d,%d,%d)\n",s,fd,fd,offset,how) ; 
      infop->seekop++;
      if ( (status= lseek(fd,offset,how)) == -1 ) { 
	 rcode= errno ;
	 p= iobuffer ; 
	 marshall_WORD(p,RQST_FIRSTREAD) ;			
	 marshall_LONG(p,status) ; 
	 marshall_LONG(p,rcode) ; 
	 if ( netwrite(s,iobuffer,iobufsiz) != iobufsiz ) {
#if defined(_WIN32)
	    log(LOG_ERR, "rreadahead(): write(): %s\n",geterr());
#else	    
	    log(LOG_ERR, "rreadahead(): write(): %s\n", sys_errlist[errno]);
#endif	    
	    return -1 ;
	 }
	 return status ;
      }
   }
   /*
    * Allocating buffer if not large enough.
    */
   log(LOG_DEBUG, "rreadahead(%d, %d): checking buffer size %d\n", s, fd, size);
   if (iobufsiz < (size+WORDSIZE+3*LONGSIZE))     {
      int     optval ;	/* setsockopt opt value */

      if (iobufsiz > 0)       {
	 log(LOG_DEBUG, "rreadahead(): freeing %x\n",iobuffer);
	 (void) free(iobuffer); 				   
      }
      if ((iobuffer = malloc(size+WORDSIZE+3*LONGSIZE)) == NULL)    {
	 log(LOG_ERR, "rreadahead: malloc(): %s\n", sys_errlist[errno]) ;
#if !defined(HPSS)
	 (void) close(s) ;
#endif /* HPSS */
	 return -1 ; 
      }
      iobufsiz = size+WORDSIZE+3*LONGSIZE ;
      optval = iobufsiz ;
      log(LOG_DEBUG, "rreadahead(): allocated %d bytes at %x\n",iobufsiz,iobuffer);
#if defined(_WIN32)
      if( setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char*)&optval, sizeof(optval)) == SOCKET_ERROR )
	 log(LOG_ERR, "rreadahead(): setsockopt(SO_SNDBUF): %s\n", geterr());
#else      
      if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *)&optval, sizeof(optval)) == -1)
	 log(LOG_ERR, "rreadahead(): setsockopt(SO_SNDBUF): %s\n",sys_errlist[errno]) ;
#endif      
      else
	 log(LOG_DEBUG, "rreadahead(): setsockopt(SO_SNDBUF): %d\n",size) ;
   }
   /*
    * Reading data and sending it. 
    */
   for(first= 1;;first= 0) {
      fd_set fds ;
      struct timeval timeout ;

      /*
       * Has a new request arrived ?
       */
      FD_ZERO(&fds) ; 
      FD_SET(s,&fds) ;
      timeout.tv_sec = 0 ; 
      timeout.tv_usec= 0 ;
#if defined(_WIN32)
      if( select(FD_SETSIZE, &fds, (fd_set*)0, (fd_set*)0, &timeout) == SOCKET_ERROR )  {
	 log(LOG_ERR,"rreadahead(): select(): %s\n", geterr());
	 return -1;
      }
#else      
      if ( select(FD_SETSIZE,&fds,(fd_set *)0,(fd_set *)0,&timeout) == -1 ) {
	 log(LOG_ERR,"rreadahead(): select(): %s\n",sys_errlist[errno]) ;
	 return -1 ; 
      }
#endif      
      if ( FD_ISSET(s,&fds) ) {
	 log(LOG_DEBUG,"rreadahead(): returns because of new request\n") ;
	 return 0 ; 
      }
      /*
       * Reading disk ...
       */
      p= iobuffer + WORDSIZE + 3*LONGSIZE ;
#if defined(HPSS)
      status = rhpss_read(fd,p,size,s,0,0);
#else /* HPSS */
      status = read(fd,p,size);
#endif /* HPSS */
      if (status < 0)        {
	 rcode= errno ;
      }
      else	{
	 rcode= 0 ; 
	 infop->rnbr+= status ;
      }
      log(LOG_DEBUG, "rreadahead: status %d, rcode %d\n", status, rcode);
      /*
       * Sending data.
       */
      p= iobuffer ;
      marshall_WORD(p,(first)?RQST_FIRSTREAD:RQST_READAHEAD) ; 
      marshall_LONG(p,status) ;
      marshall_LONG(p, rcode) ;
      marshall_LONG(p, size) ;
      if ( netwrite(s, iobuffer, iobufsiz) != iobufsiz ) {
#if defined(_WIN32)
	 log(LOG_ERR, "rreadahead(): netwrite(): %s\n", geterr());
#else	     
	 log(LOG_ERR, "rreadahead(): write(): %s\n", sys_errlist[errno]) ;
#endif	     
	 return -1 ;
      }
      /*
       * The end of file has been reached
       * or an error was encountered.
       */
      if ( status != size ) {
	 return 0 ; 
      }
   }
}

int   srclose(s, infop, fd)
#if defined(_WIN32)
SOCKET 	s;
#else
int     s;
#endif
int     fd;
struct rfiostat * infop ;
{
   int status ;
   int  rcode ;
   char   * p ;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   log(LOG_INFO,"%d read, %d readahead, %d write, %d flush, %d stat, %d lseek and %d preseek\n",
       infop->readop, infop->aheadop, infop->writop, infop->flusop, infop->statop,
       infop->seekop, infop->presop) ;
   log(LOG_INFO,"%d bytes read and %d bytes written\n", infop->rnbr,infop->wnbr) ;
   log(LOG_INFO, "rclose(%d, %d)\n",s, fd) ;
#if defined(HPSS)
   status = rhpss_close(fd,s,0,0);
#else /* HPSS */
   status = close(fd);
#endif /* HPSS */
   rcode = ( status < 0 ) ? errno : 0 ;
#if !defined(HPSS)
   if (iobufsiz > 0)       {
      log(LOG_DEBUG,"rclose(): freeing %x\n",iobuffer) ;
      (void) free(iobuffer);
   }
   iobufsiz= 0 ;
#endif /* HPSS */
   p= rqstbuf ; 
   marshall_WORD(p,RQST_CLOSE) ;
   marshall_LONG(p,status) ;
   marshall_LONG(p,rcode) ;
   marshall_LONG(p,0) ;
#if defined(SACCT)
   rfioacct(RQST_CLOSE,0,0,s,0,0,status,rcode,infop,NULL,NULL);
#endif /* SACCT */
   if (netwrite(s,rqstbuf,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR, "rclose: netwrite(): %s\n", geterr());
#else      
      log(LOG_ERR, "rclose: write(): %s\n", sys_errlist[errno]);
#endif
      return -1 ;
   }
   return status ;
}

int 	srpclose(s, fs) 
#if defined(_WIN32)
SOCKET	s;
#else
int 	s;
#endif
FILE 	*fs;
{
   int 	status;
   char *p;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   errno = 0;
#if defined(_WIN32)
   status = _pclose(fs);
#else   
   status = pclose(fs);
#endif
   log(LOG_DEBUG,"rpclose(%x) returns %d\n",fs,status) ;
   /*
    * status returns the command's error code
    */
   p= rqstbuf ;
   marshall_LONG(p,status) ;
   marshall_LONG(p,errno) ;
#if defined(SACCT)
   rfioacct(RQST_PCLOSE,0,0,s,0,0,status,errno,NULL,NULL,NULL);
#endif /* SACCT */
   if (netwrite(s,rqstbuf,2*LONGSIZE) != 2*LONGSIZE)  {
      log(LOG_ERR, "rpclose: write(): %s\n", sys_errlist[errno]);
      return -1 ;
   }
   return status ;
}

FILE 	*srpopen(s, host, rt)
#if defined(_WIN32)
SOCKET 	s;
#else
int 	s;
#endif
char 	*host;
int 	rt;
{
   int 	status = 0;
   int  rcode = 0;
   int	uid, gid;
   char *p;
   int 	len;
   char type[5];
   char command[256];
   char username[10];
   FILE *fs;
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
   struct sigvec   sv;
#endif /* sun || ultrix || _AIX */
   extern char * getconfent() ;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   log(LOG_DEBUG, "srpopen(%d,%s,%d)\n",s,host,rt) ;
   p= rqstbuf + 2*WORDSIZE ;
   unmarshall_LONG(p ,len );
   if (netread(s,rqstbuf,len) != len) {
      log(LOG_ERR,"rpopen: read(): %s\n",sys_errlist[errno]) ;
      return NULL ;
   }
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
#if (defined(sun) && !defined(SOLARIS))
   sv.sv_mask = sigmask(SIGCHLD)|sigmask(SIGALRM);
#else
   sv.sv_mask = sigmask(SIGCHLD);
#endif /* sun && !SOLARIS */
   sv.sv_handler = SIG_DFL;
   sigvec(SIGCHLD, &sv, (struct sigvec *)0);
#endif /* sun || ultrix || _AIX */
#if defined(sgi) || defined (hpux) || defined (SOLARIS) || (defined(__osf__) && defined(__alpha)) || defined(linux)
   signal(SIGCLD, SIG_DFL) ;
#endif /* sgi || hpux || SOLARIS || alpha-osf || linux */
   p= rqstbuf ;
   unmarshall_WORD(p, uid);
   unmarshall_WORD(p, gid);
   unmarshall_STRING(p , type ) ;
   unmarshall_STRING(p,  command ) ;
   unmarshall_STRING(p, username) ;
   log(LOG_DEBUG,"requestor is (%s, %d, %d) \n",username, uid, gid );
   if ( rt ) { 
      char to[100];
      int rcd,to_uid,to_gid;

      log(LOG_DEBUG,"Mapping (%s, %d, %d) \n",username, uid, gid );
      if ( (rcd = get_user(host,username,uid,gid,to,&to_uid,&to_gid)) == -ENOENT ) {
	 log(LOG_ERR,"get_user(): Error opening mapping file\n");
	 status = -1;
	 errno = EINVAL;
	 rcode = errno ;
      }

      if ( abs(rcd) == 1 ) {
	 log(LOG_ERR,"No entry found in mapping file for (%s,%s,%d,%d)\n", host,username,uid,gid);
	 status= -1;
	 errno=EACCES;
	 rcode=errno;
      }
      else {
	 log(LOG_DEBUG,"(%s,%s,%d,%d) mapped to %s(%d,%d)\n", host,username,uid,gid,to,to_uid,to_gid) ;
	 uid = to_uid ;
	 gid = to_gid ;
      }
   }
   if ( status == 0 ) {
      if ( (status=chsuser(uid,gid,host,&rcode,"POPENTRUST")) < 0 ) {
	 if (status == -2)
	    log(LOG_ERR,"rpopen(): uid %d not allowed to popen()\n",uid);
	 else
	    log(LOG_ERR,"rpopen(): failed at chsuser(), rcode %d\n",rcode);
	 status = -1 ;
      }
   }
   if ( status == 0 ) {
#if defined(_WIN32)
      fs = _popen(command, type);
#else      
      fs = popen(command, type);
#endif
      if (fs == NULL) {
	 log(LOG_INFO, "rpopen(%s,%s) failed : %s\n",sys_errlist[errno]);
	 rcode = errno ;
	 status = -1 ;
      }
      else {
	 log(LOG_INFO, "rpopen(%s,%s) for %s successful\n",command,type,username) ;
	 rcode = 0 ;
      }
   }
   p= rqstbuf ;
#if defined(SACCT)
   rfioacct(RQST_POPEN,uid,gid,s,0,0,status,rcode,NULL,command,NULL);
#endif /* SACCT */
   log(LOG_DEBUG, "rpopen: sending back status(%d) and rcode(%d)\n",status, rcode) ;
   marshall_LONG( p, status ) ;
   marshall_WORD( p, rcode ) ;
   if (netwrite(s,rqstbuf,WORDSIZE+LONGSIZE) != WORDSIZE+LONGSIZE) {
#if defined(WIN32)
      log(LOG_ERR,"rpopen(): netwrite(): %s\n", geterr());
#else      
      log(LOG_ERR,"rpopen(): write(): %s\n",sys_errlist[errno]) ;
#endif
      return NULL ;
   }
   return fs ;
}


int srfread(s, fp)
#if defined(_WIN32)
SOCKET 	s;
#else
int     s;
#endif
FILE    *fp;
{
   int	status = 0;
   int	rcode = 0;
   int  size, items;
   char *p;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   p = rqstbuf +2*WORDSIZE ;
   log(LOG_DEBUG, "rfread(%x)\n",fp);
   unmarshall_LONG(p, size);
   unmarshall_LONG(p, items);
   log(LOG_DEBUG,"rfread(%d, %x): size %d items %d\n", s, fp, size, items);
   if (iobufsiz < items*size) {
      if (iobufsiz > 0) {
	 log(LOG_DEBUG, "rfread(): freeing %x\n",iobuffer);
	 (void) free(iobuffer);
      }
      if ((iobuffer = malloc(items*size)) == NULL)    {
	 log(LOG_ERR, "rfread: malloc(): %s\n", sys_errlist[errno]);
	 return(-1);
      }
      iobufsiz = items*size;
      log(LOG_DEBUG, "rfread(): allocated %d bytes at %x\n",items*size,iobuffer);
   }
   errno = 0 ;
   status = fread(iobuffer, size, items, fp) ;
   if ( status == 0 ) {
      rcode= errno ;
   }
   log(LOG_DEBUG, "rfread : status %d, rcode %d\n", status, rcode);
   p = rqstbuf;
   marshall_LONG(p, status);
   marshall_LONG(p, rcode);
   if (netwrite(s, rqstbuf, 2*LONGSIZE) != 2*LONGSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR, "rfread : netwrite(): %s\n", geterr());
#else      
      log(LOG_ERR, "rfread : write(): %s\n", sys_errlist[errno]);
#endif      
      return(-1);
   }
   if ( status > 0 ) {
      if (netwrite(s,iobuffer, status*size) != status*size)  {
#if defined(_WIN32)
	 log(LOG_ERR, "rfread: netwrite(): %s\n", geterr());
#else
	 log(LOG_ERR, "rfread: write(): %s\n",sys_errlist[errno]);
#endif	 
	 return(-1);
      }
   }
   return(status);
}	

int srfwrite(s, fp)
#if defined(_WIN32)
SOCKET	s;
#else
int     s;
#endif
FILE    *fp;
{
   int     status = 0;
   int     rcode = 0;
   int     size, items;
   char    *ptr;
   char    *p = rqstbuf;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   p =  rqstbuf +2*WORDSIZE ;
   log(LOG_DEBUG, "rfwrite(%x)\n",fp);
   unmarshall_LONG(p, size);
   unmarshall_LONG(p, items);
   log(LOG_DEBUG, "rfwrite(%d,%x): size %d items %d\n",s,fp,size,items);
   if (iobufsiz < items*size)     {
      if (iobufsiz > 0)       {
	 log(LOG_DEBUG, "rfwrite(): freeing %x\n",iobuffer);
	 (void) free(iobuffer);
      }
      if ((iobuffer = malloc(items*size)) == NULL)    {
	 log(LOG_ERR, "rfwrite: malloc(): %s\n", sys_errlist[errno]);
	 return(-1);
      }
      iobufsiz = items*size;
      log(LOG_DEBUG, "rfwrite(): allocated %d bytes at %x\n",items*size,iobuffer);
   }
   ptr = iobuffer;
   log(LOG_DEBUG, "rfwrite: reading %d bytes\n",items*size) ;
   if (netread(s, iobuffer, items*size) != items*size)       {
#if defined(_WIN32)
      log(LOG_ERR, "rfwrite: netread(): %s\n", geterr());
#else      
      log(LOG_ERR, "rfwrite: read(): %s\n", sys_errlist[errno]);
#endif
      return(-1);
   }
   if ( (status = fwrite( ptr, size, items, fp)) == 0 ) 
      rcode= errno ;
   log(LOG_DEBUG, "rfwrite: status %d, rcode %d\n", status, rcode);
   p = rqstbuf;
   marshall_LONG(p, status);
   marshall_LONG(p, rcode);
   if (netwrite(s, rqstbuf, 2*LONGSIZE) != 2*LONGSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR, "rfwrite: netwrite(): %s\n", geterr());
#else      
      log(LOG_ERR, "rfwrite: write(): %s\n", sys_errlist[errno]);
#endif
      return(-1);
   }
   return(status);
}

int     srfstat(s, infop, fd)
#if defined(_WIN32)
SOCKET 	s;
#else
int     s;
#endif
int	fd;
struct rfiostat *infop;
{
   int	status;
   int	rcode;
   int	msgsiz;
   int	how;
   int	offset;
   char	*p;
   struct stat 	statbuf;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   log(LOG_DEBUG, "rfstat(%d, %d)\n",s,fd) ;
   p= rqstbuf + 2*WORDSIZE ;
   unmarshall_LONG(p,offset) ;
   unmarshall_LONG(p,how) ;
   /*
    * lseek() if needed.
    */
   if ( how != -1 ) {
      log(LOG_DEBUG,"rread(%d,%d): lseek(%d,%d,%d)\n",s,fd,fd,offset,how) ; 
      if ( (status= lseek(fd,offset,how)) == -1 ) { 
	 rcode= errno ;
	 p= rqstbuf ; 
	 marshall_WORD(p,RQST_FSTAT) ;			
	 marshall_LONG(p,status) ; 
	 marshall_LONG(p,rcode) ; 
	 if ( netwrite(s,rqstbuf,6*LONGSIZE+6*WORDSIZE) != 6*LONGSIZE+6*WORDSIZE ) {
#if defined(WIN32)
	    log(LOG_ERR, "rreadahead(): netwrite(): %s\n", geterr());
#else	    
	    log(LOG_ERR, "rreadahead(): write(): %s\n", sys_errlist[errno]);
#endif
	    return -1 ;
	 }
	 return status ;
      }
   }
   /*
    * Issuing the fstat()
    */	
   status= fstat(fd, &statbuf) ;
   rcode= errno ;
   msgsiz= 5*WORDSIZE + 5*LONGSIZE ;
   p = rqstbuf;
   marshall_WORD(p, RQST_FSTAT) ; 
   marshall_LONG(p, status) ;
   marshall_LONG(p,  rcode) ;
   marshall_LONG(p, msgsiz) ;
   marshall_WORD(p, statbuf.st_dev);
   marshall_LONG(p, statbuf.st_ino);
   marshall_WORD(p, statbuf.st_mode);
   marshall_WORD(p, statbuf.st_nlink);
   marshall_WORD(p, statbuf.st_uid);
   marshall_WORD(p, statbuf.st_gid);
   marshall_LONG(p, statbuf.st_size);
   marshall_LONG(p, statbuf.st_atime);
   marshall_LONG(p, statbuf.st_mtime);
   marshall_LONG(p, statbuf.st_ctime);
   log(LOG_DEBUG, "rfstat: sending back %d\n",status) ;
   if (netwrite(s,rqstbuf,8*LONGSIZE+6*WORDSIZE) != 8*LONGSIZE+6*WORDSIZE)  {
#if defined(WIN32)
      log(LOG_ERR,"rfstat: netwrite(): %s\n", geterr());
#else
      log(LOG_ERR,"rfstat: write(): %s\n",sys_errlist[errno]);
#endif
      return -1 ;
   }
   return 0 ; 
}

int srlseek(s, infop, fd)
#if defined(_WIN32)
SOCKET	s;
#else
int     s;
#endif
int	fd;
struct rfiostat *infop;
{
   int	status;
   int	rcode;
   int  offset;
   int	how;
   char *p;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   p= rqstbuf + 2*WORDSIZE ; 
   unmarshall_LONG(p,offset) ;
   unmarshall_LONG(p,how) ;
   log(LOG_DEBUG,"rlseek(%d, %d): offset %d, how: %x\n",s,fd,offset,how) ;
   status = lseek(fd, offset, how) ;
   rcode= ( status < 0 ) ? errno : 0 ; 
   log(LOG_DEBUG,"rlseek: status %d, rcode %d\n",status,rcode) ;
   p= rqstbuf ;
   marshall_WORD(p,RQST_LSEEK) ;
   marshall_LONG(p,status) ;
   marshall_LONG(p,rcode) ;
   marshall_LONG(p,0) ; 
   if (netwrite(s,rqstbuf,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR,"rlseek: netwrite(): %s\n", geterr()) ;
#else
      log(LOG_ERR,"rlseek: write(): %s\n",sys_errlist[errno]) ;
#endif      
      return -1 ;
   }
   return status ;
}

int srpreseek(s, infop, fd)
#if defined(_WIN32)
SOCKET	s;
#else
int     s;
#endif
int	fd;
struct rfiostat *infop;
{
   int	status;		/* Return code		*/ 
   int  size;		/* Buffer size		*/
   int	nblock; 	/* Nb of blocks to read	*/
   int	first;		/* First block sent	*/
   char *p;		/* Pointer to buffer	*/
   int	reqno;		/* Request number	*/
#if defined(HPSS)
   struct iovec *v = NULL; /* List of requests	*/
#else /* HPSS */
   struct iovec *v;	/* List of requests	*/
#endif /* HPSS */
   char *trp = NULL;	/* Temporary buffer	*/

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   p= rqstbuf + 2*WORDSIZE ; 
   unmarshall_LONG(p,size) ;
   unmarshall_LONG(p,nblock) ; 
   log(LOG_DEBUG,"rpreseek(%d, %d)\n",s,fd) ;

   /*
    * A temporary buffer may need to be created 
    * to receive the request.
    */
   if ( nblock*2*LONGSIZE > BUFSIZ ) {
      if ( (trp= (char *) malloc(nblock*2*LONGSIZE)) == NULL ) {
	 return -1 ;
      }
   }
   p= ( trp ) ? trp : rqstbuf ;
   /*
    * Receiving the request.
    */
   log(LOG_DEBUG,"rpreseek: reading %d bytes\n",nblock*2*LONGSIZE) ; 
   if ( netread(s,p,nblock*2*LONGSIZE) != nblock*2*LONGSIZE ) {
#if defined(_WIN32)
      log(LOG_ERR,"rpreseek: netread(): %s\n", geterr());
#else      
      log(LOG_ERR,"rpreseek: read(): %s\n",sys_errlist[errno]) ;
#endif      
      if ( trp ) (void) free(trp) ;
      return -1 ;
   }	
   /*
    * Allocating space for the list of requests.
    */
   if ( (v= ( struct iovec *) malloc(nblock*sizeof(struct iovec))) == NULL ) {
      log(LOG_ERR, "rpreseek: malloc(): %s\n",sys_errlist[errno]) ;
      if ( trp ) (void) free(trp) ;
#if !defined(HPSS)
      (void) close(s) ;
#endif /* HPSS */
      return -1 ; 
   }
   /*
    * Filling list request.
    */
   for(reqno= 0;reqno<nblock;reqno++) {
#if ( defined(__osf__) && defined(__alpha)) || defined(SOLARIS) || defined(IRIX6) || defined(linux)
      long *c ;
      c = (long *) &(v[reqno].iov_base) ;
      unmarshall_LONG(p,*c);
#else
      unmarshall_LONG(p,v[reqno].iov_base) ;
#endif
      unmarshall_LONG(p,v[reqno].iov_len) ; 
   }
   /*
    * Freeing temporary buffer if needed.
    */ 
   if ( trp ) (void) free(trp) ;
   /*
    * Allocating new data buffer if the 
    * current one is not large enough.
    */
   log(LOG_DEBUG,"rpreseek(%d, %d): checking buffer size %d\n",s,fd,size) ;
   if (iobufsiz < (size+WORDSIZE+3*LONGSIZE))     {
      int     optval ;	/* setsockopt opt value */

      if (iobufsiz > 0)       {
	 log(LOG_DEBUG, "rpreseek(): freeing %x\n",iobuffer);
	 (void) free(iobuffer);
      }
      if ((iobuffer = malloc(size+WORDSIZE+3*LONGSIZE)) == NULL)    {
	 log(LOG_ERR, "rpreseek: malloc(): %s\n", sys_errlist[errno]) ;
#if defined(HPSS)
	 if ( v ) free(v);
#endif /* HPSS */
#if !defined(HPSS)
	 (void) close(s) ;
#endif /* HPSS */
	 return -1 ; 
      }
      iobufsiz = size+WORDSIZE+3*LONGSIZE ;
      optval = iobufsiz ;
      log(LOG_DEBUG, "rpreseek(): allocated %d bytes at %x\n",iobufsiz,iobuffer) ;
#if defined(_WIN32)
      if( setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char*)&optval, sizeof(optval)) == SOCKET_ERROR )
	 log(LOG_ERR, "rpreseek(): setsockopt(SO_SNDBUF): %s\n", geterr());
#else      
      if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *)&optval, sizeof(optval)) == -1)
	 log(LOG_ERR, "rpreseek(): setsockopt(SO_SNDBUF): %s\n",sys_errlist[errno]) ;
#endif
      else
	 log(LOG_DEBUG, "rpreseek(): setsockopt(SO_SNDBUF): %d\n",size) ;
   }
   /*
    * Reading data and sending it. 
    */
   reqno= 0 ; 
   for(first= 1;;first= 0) {
      struct timeval timeout ;
      fd_set fds ;
      int nbfree ;
      int     nb ;

      /*
       * Has a new request arrived ?
       * The preseek is then interrupted.
       */
      FD_ZERO(&fds) ; 
      FD_SET(s,&fds) ;
      timeout.tv_sec = 0 ; 
      timeout.tv_usec= 0 ;
#if defined(_WIN32)
      if( select(FD_SETSIZE, &fds, (fd_set*)0, (fd_set*)0, &timeout) == SOCKET_ERROR ) {
	 log(LOG_ERR,"rpreseek(): select(): %s\n", geterr());
	 return -1;
      }
#else      
      if ( select(FD_SETSIZE,&fds,(fd_set *)0,(fd_set *)0,&timeout) == -1 ) {
	 log(LOG_ERR,"rpreseek(): select(): %s\n",sys_errlist[errno]) ;
#if defined(HPSS)
	 if ( v ) free(v);
#endif /* HPSS */
	 return -1 ; 
      }
#endif 	/* WIN32 */
      if ( FD_ISSET(s,&fds) ) {
	 log(LOG_DEBUG,"rpreseek(): returns because of new request\n") ;
#if defined(HPSS)
	 if ( v ) free(v);
#endif /* HPSS */
	 return 0 ; 
      }
      /*
       * Filling buffer.
       */
      p= iobuffer + WORDSIZE + 3*LONGSIZE ;
      for(nb= 0, nbfree= size; 4*LONGSIZE<nbfree && reqno<nblock; reqno ++, nb ++ ) {
	 nbfree -= 4*LONGSIZE ;
	 status= lseek(fd,(off_t)v[reqno].iov_base,SEEK_SET) ;
	 if ( status == -1 ) {
	    marshall_LONG(p,v[reqno].iov_base) ; 
	    marshall_LONG(p,v[reqno].iov_len) ;
	    marshall_LONG(p,status) ;
	    marshall_LONG(p,errno) ; 
	    continue ;
	 }
	 if ( v[reqno].iov_len <= nbfree ) {
#if defined(HPSS)
	    status = rhpss_read(fd,p+4*LONGSIZE,v[reqno].iov_len,s,0,0);
#else /* HPSS */
	    status= read(fd,p+4*LONGSIZE,v[reqno].iov_len) ; 	
#endif /* HPSS */
	    marshall_LONG(p,v[reqno].iov_base) ; 
	    marshall_LONG(p,v[reqno].iov_len) ;
	    marshall_LONG(p,status) ;
	    marshall_LONG(p,errno) ; 
	    if ( status != -1 ) {
	       infop->rnbr += status ;
	       nbfree -= status ;	
	       p += status ;
	    }
	 }
	 else	{
	    /* 
	     * The record is broken into two pieces.
	     */
#if defined(HPSS)
	   status = rhpss_read(fd,p+4*LONGSIZE,nbfree,s,0,0);
#else /* HPSS */
	    status= read(fd,p+4*LONGSIZE,nbfree) ;
#endif /* HPSS */
	    marshall_LONG(p,v[reqno].iov_base) ; 
	    marshall_LONG(p,nbfree) ;
	    marshall_LONG(p,status) ;
	    marshall_LONG(p,errno) ; 
	    if ( status != -1 ) {
	       infop->rnbr += status ;
	       nbfree -= status ;	
	       p += status ;
#if HPUX1010 || IRIX6
	       v[reqno].iov_base = (caddr_t)v[reqno].iov_base + status ;
#else
	       v[reqno].iov_base += status ;
#endif
	       v[reqno].iov_len -= status ;
	       reqno -- ;
	    }
	 }
		
      }
      p= iobuffer ;
      if ( first ) {
	 marshall_WORD(p,RQST_FIRSTSEEK) ; 
      }
      else	{
	 marshall_WORD(p,(reqno == nblock) ? RQST_LASTSEEK:RQST_PRESEEK) ; 
      }
      marshall_LONG(p,nb) ;
      marshall_LONG(p,0) ;
      marshall_LONG(p,size) ;
      log(LOG_DEBUG,"rpreseek(): sending %d bytes\n",iobufsiz) ;
      if ( netwrite(s,iobuffer,iobufsiz) != iobufsiz ) {
#if defined(_WIN32)
	 log(LOG_ERR, "rpreseek(): netwrite(): %s\n", geterr());
#else	 
	 log(LOG_ERR, "rpreseek(): write(): %s\n", sys_errlist[errno]) ;
#endif	 
#if defined(HPSS)
	 if ( v ) free(v);
#endif /* HPSS */
	 return -1 ;
      }
      /*
       * All the data needed has been
       * sent over the network.
       */
#if defined(HPSS)
      if ( reqno == nblock ) {
	 if ( v ) free(v);
	 return 0 ; 
      }
#else /* HPSS */
      if ( reqno == nblock ) 
	 return 0 ; 
#endif /* HPSS */
   }
}

#if !defined(_WIN32)
DIR *sropendir(s,rt,host,bet)
int s;
int rt;
char *host;
int bet;
{
   int status;
   int rcode = 0;
   char *p;
   int len;
   int fd;
   int uid, gid;
   WORD mask,passwd,mapping;
   char account[MAXACCTSIZE];
   char user[20];
   char reqhost[MAXHOSTNAMELEN];
   char 	vmstr[MAXVMSTRING];
   int sock;
   DIR *dirp;
#if defined(HPSS)
   extern char *rtuser;
#endif /* HPSS */

   dirp = NULL;
   p = rqstbuf + 2*WORDSIZE ;
   unmarshall_LONG(p,len);
   /*
    * Read opendir request
    */
   log(LOG_DEBUG,"ropendir: reading %d bytes\n",len);
   if ( (status = netread(s,rqstbuf,len)) != len ) {
      log(LOG_ERR,"ropendir: read(): %s\n",sys_errlist[errno]);
      return(NULL);
   }
   p = rqstbuf;
   unmarshall_WORD(p,uid);
   unmarshall_WORD(p,gid);
   unmarshall_STRING(p, account);
   unmarshall_STRING(p, filename);
   unmarshall_STRING(p, user);
   unmarshall_STRING(p, reqhost);
   unmarshall_LONG(p, passwd);
   unmarshall_WORD(p, mapping);
   unmarshall_STRING(p, vmstr);
   log(LOG_DEBUG,"vms string is %s\n", vmstr) ;
   if (bet) 
      log(LOG_DEBUG,"Opening directory %s for remote user: %s\n",filename,user);
   if (rt)
      log(LOG_DEBUG,"Mapping : %s\n",mapping ? "yes" : "no" );
   if (rt && !mapping) {
      log(LOG_DEBUG,"passwd : %d\n",passwd);
      log(LOG_DEBUG,"uid: %d\n",uid );
      log(LOG_DEBUG,"gid: %d\n",gid );
   }
  
   /*
    * Someone in the site has tried to specify (uid,gid) directly !
    */
   status=0;
   if (bet && !mapping && !rt) {
      log(LOG_INFO,"attempt to make non-mapped I/O and modify uid or gid !\n");
      errno=EACCES ;
      rcode=errno ;
      status= -1 ;
   }
  
   if ( rt ) { 
#if !defined(ultrix)
      openlog("rfio",LOG_PID, LOG_USER) ;
#else
      openlog("rfio",LOG_PID ) ;
#endif
      syslog(LOG_ALERT, "rfio: connection %s mapping by %s(%d,%d) from %s",(mapping ? "with" : "without"),user,uid,gid,host) ;
      closelog() ;
   }
  
   /*
    * MAPPED mode: user will be mapped to user "to"
    */
   if ( !status && rt && mapping ) {
      char to[100];
      int rcd,to_uid,to_gid;
    
      log(LOG_DEBUG,"Mapping (%s, %d, %d) \n",user, uid, gid );
      if ( (rcd = get_user(host,user,uid,gid,to,&to_uid,&to_gid)) == -ENOENT ) {
	 log(LOG_ERR,"sropendir(): get_user() error opening mapping file\n") ;
	 status = -1;
	 errno = EINVAL;
	 rcode = SEHOSTREFUSED ;
      }
    
      else if ( abs(rcd) == 1 ) {
	 log(LOG_ERR,"No entry found in mapping file for (%s,%s,%d,%d)\n", host,user,uid,gid);
	 status = -1;
	 errno = EACCES;
	 rcode = SEHOSTREFUSED;
      }
      else {
	 log(LOG_DEBUG,"(%s,%s,%d,%d) mapped to %s(%d,%d)\n",
	     host,user,uid,gid,to,to_uid,to_gid) ;
	 uid = to_uid ;
	 gid = to_gid ;
	 if ( uid < 100 || gid < 100 ) {
	    errno = EACCES;
	    status = -1;
	    rcode = SEHOSTREFUSED;
	 }
      }
   }
   /* 
    * DIRECT access: the user specifies uid & gid by himself 
    */
   if ( !status && rt && !mapping ) {
#if defined(HPSS)
      if ( rtuser == NULL || !strcmp(rtuser,"YES") ) {
#else /* HPSS */
      char * rtuser;
      if ( (rtuser=getconfent ("RTUSER","CHECK",0) ) == NULL || ! strcmp (rtuser,"YES") ) {
#endif /* HPSS */
	 /* Port is also passwd */
	 if  ((sock=connecttpread(reqhost,passwd))>=0 && !checkkey(sock,passwd)) {
	    status= -1 ;
	    errno = EACCES;
	    rcode= errno ;
	    log(LOG_ERR,"ropendir: DIRECT mapping : permission denied\n");
	 }
	 if (sock < 0) {
	    status= -1 ;
	    log(LOG_ERR,"ropendir: DIRECT mapping failed: Couldn't connect %s\n",reqhost);
	    rcode = EACCES;
	 }
      } 
      else log(LOG_INFO ,"Any DIRECT rfio request from out of site is authorized\n");
   }
   if ( !status ) {
      log(LOG_DEBUG, "ropendir: uid %d gid %d\n",uid, gid);
      log(LOG_DEBUG, "ropendir: account: %s\n", account);
      log(LOG_DEBUG, "ropendir: dirname: %s\n", filename);
      log(LOG_INFO, "ropendir(%s) for (%d,%d)\n",filename,uid,gid);
      if ( (status=chsuser(uid,gid,host,&rcode,"OPENTRUST")) < 0 ) {
	 if (status == -2)
	    log(LOG_ERR,"ropendir(): uid %d not allowed to open()\n",uid);
	 else
	    log(LOG_ERR,"ropendir(): failed at chsuser(), rcode %d\n",rcode);
	 status = -1 ;
      }
      else {
	 dirp= opendir(filename) ;
	 if ( dirp == NULL ) {
	    char alarmbuf[1024];
	    status= -1 ;
	    rcode= errno ;
	    sprintf(alarmbuf,"sropendir(): %s",filename) ;
	    log(LOG_ERR,"ropendir: opendir: %s\n",sys_errlist[rcode]) ;
	    rfio_alrm(rcode,alarmbuf) ;
	 }
	 log(LOG_DEBUG,"ropendir: opendir(%s) returned %x (hex)\n",filename,dirp) ;
      }
   }
   /*
    * Sending back status.
    */
   p = rqstbuf;
   marshall_WORD(p,RQST_OPENDIR) ; 
   marshall_LONG(p,status);
   marshall_LONG(p,rcode) ;
   marshall_LONG(p,0) ;
#if defined(SACCT)
   rfioacct(RQST_OPENDIR,uid,gid,s,0,0,status,rcode,NULL,filename,NULL);
#endif /* SACCT */
   log(LOG_DEBUG, "ropendir: sending back status(%d) and errno(%d)\n",status,rcode);
   if (netwrite(s,rqstbuf,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE)  {
      log(LOG_ERR,"ropendir: write(): %s\n",sys_errlist[errno]) ;
      return NULL ;
   }
   return(dirp);
}

int srreaddir(s, infop, dirp)
int s;
struct rfiostat * infop;
DIR *dirp;
{
   int 	status ;	/* Return code		*/
   int   rcode=0 ;	/* To send back errno	*/
   int     namlen ;      /* length of filename */
   char       * p ;	/* Pointer to buffer	*/
   char  direntmsg[MAXFILENAMSIZE+WORDSIZE+3*LONGSIZE];  /* Reply msg */
   int	msgsiz ;	/* Message size		*/
   struct dirent *dp = NULL;

   /*
    * Receiving request.
    */
   log(LOG_DEBUG, "rreaddir(%d, 0x%x)\n",s, dirp);
   p= rqstbuf + 2*WORDSIZE ; 

   msgsiz = 0;
   status = 0;

   dp = readdir(dirp);
   if ( dp == NULL ) {
      rcode = errno;
      status = -1;
   }

   p= direntmsg;
   if ( dp != NULL && *dp->d_name != '\0' ) {
      namlen = strlen(dp->d_name);
   } else {
      namlen = 0;
   }
   marshall_WORD(p,RQST_READDIR);
   marshall_LONG(p,status);
   marshall_LONG(p,rcode);
   marshall_LONG(p,namlen);
   infop->rnbr+=namlen + WORDSIZE + 3*LONGSIZE;
   log(LOG_DEBUG, "rreaddir: status %d, rcode %d\n", status, rcode) ;
   if (netwrite(s,direntmsg,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE)  {
      log(LOG_ERR, "rreaddir: write(): %s\n", sys_errlist[errno]) ;
      return -1 ; 
   }
   if ( namlen > 0 ) {
      marshall_STRING(p,dp->d_name);
      if (netwrite(s,&direntmsg[WORDSIZE+3*LONGSIZE],namlen) != namlen)  {
	 log(LOG_ERR, "rreaddir: write(): %s\n", sys_errlist[errno]) ;
	 return -1 ; 
      }
   }
   return status ; 
}

int srrewinddir(s, infop, dirp)
int s;
struct rfiostat * infop;
DIR *dirp;
{
   int status = 0;
   int rcode = 0;
   char *p;

   log(LOG_DEBUG,"rrewinddir(%d,0x%x)\n",s,dirp);
   if ( dirp != NULL ) {
#if defined(HPSS)
     /*
      * rewinddir is alread a macro on some systems so we cannot override it...
      */
     status = rhpss_rewinddir(dirp,s,0,0);
#else /* HPSS */
      (void)rewinddir(dirp);
      status = 0;
#endif /* HPSS */
   } else {
     status = -1;
     rcode = EBADF;
   }

   p = rqstbuf;
   marshall_WORD(p,RQST_REWINDDIR);
   marshall_LONG(p,status);
   marshall_LONG(p,rcode);
   marshall_LONG(p,0);
#if defined(SACCT)
   rfioacct(RQST_REWINDDIR,0,0,s,0,0,status,rcode,infop,NULL,NULL);
#endif /* SACCT */
   if (netwrite(s,rqstbuf,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE)  {
      log(LOG_ERR, "rrewinddir: write(): %s\n", sys_errlist[errno]);
      return -1 ;
   }
   return status ;
}

int srclosedir(s,infop,dirp)
int s;
struct rfiostat * infop;
DIR *dirp;
{
   int status = 0;
   int rcode = 0;
   char *p;

   log(LOG_DEBUG,"rclosedir(%d,0x%x)\n",s,dirp);
   if ( dirp != NULL ) {
      status = closedir(dirp);
   }
   rcode = (status < 0) ? errno : 0;
   p = rqstbuf;
   marshall_WORD(p,RQST_CLOSEDIR);
   marshall_LONG(p,status);
   marshall_LONG(p,rcode);
   marshall_LONG(p,0);
#if defined(SACCT)
   rfioacct(RQST_CLOSEDIR,0,0,s,0,0,status,rcode,infop,NULL,NULL);
#endif /* SACCT */
   if (netwrite(s,rqstbuf,WORDSIZE+3*LONGSIZE) != WORDSIZE+3*LONGSIZE)  {
      log(LOG_ERR, "rclosedir: write(): %s\n", sys_errlist[errno]);
      return -1 ;
   }
   return status ;
}
#endif /* WIN32 */

/*
 * makes the setgid() and setuid(). Returns -1 if error , -2 if unauthorized.
 */
static int chsuser(uid,gid,hostname,ptrcode,permstr)
int uid; 		/* uid of caller */
int gid;		/* gid of caller */
char *hostname ;	/* caller's host name */
int *ptrcode ;		/* Return code */
char *permstr;		/* permission string for the request */
{
	
   char ptr[BUFSIZ] ;
#if defined(HPSS)
   struct passwd pw_result;
   char pwbuf[1024];
#endif /* HPSS */    
   struct passwd *pw ;
   int found = 0 ;
   char *cp , *p;
   char hostname1[MAXHOSTNAMELEN];

   if ( uid < 100  ) {
      if ( permstr != NULL && hostname != NULL && (p=getconfent("RFIOD", permstr, 1)) != NULL ) {
	 strcpy(ptr,p) ;
	 for (cp=strtok(ptr,"\t ");cp!=NULL;cp=strtok(NULL,"\t ")) {
	    if ( !strcmp(hostname,cp) ) {
	       found ++ ;
	       break ;
	    }
	    sprintf(hostname1,"%s.%s",cp,DOMAINNAME);
	    if ( !strcmp(hostname1,hostname) ) {
	       found ++ ;
	       break ;
	    }
	 }
      }
      if (!found) {
	 *ptrcode = EACCES ;
	 log(LOG_ERR,"chsuser():uid < 100: No %s.\n",permstr) ;
	 return -2 ;
      }
      else
	 log(LOG_INFO, "chsuser():root authorized from %s\n",hostname);
   }
#if defined(HPSS)
   pw = &pw_result;
   if ( uid >=100 && ( 
#if defined(__osf__) && defined(__alpha)
        getpwuid_r((uid_t)uid,&pw_result,pwbuf,sizeof(pwbuf),&pw) || pw == NULL
#else /* __osf__ && __alpha */
        getpwuid_r((uid_t)uid,&pw_result,pwbuf,sizeof(pwbuf))
#endif /* __osf__ && __alpha */ 
        || chsgroup(pw,gid) ) ) 
#else /* HPSS */
   if ( uid >=100 && ( (pw = getpwuid((uid_t)uid)) == NULL
#if defined(_WIN32)
	))
#else      
	|| chsgroup(pw,gid)) )
#endif
#endif /* HPSS */
   {
      *ptrcode = EACCES ;
      log(LOG_ERR,"chsuser(): user (%d,%d) does not exist at local host\n",uid,gid);
      return -2 ;
   }
   if ( setgid((gid_t)gid)<0 || setuid((uid_t)uid)<0 )  {
      *ptrcode = errno ;
      log(LOG_ERR,"chsuser(): unable to setuid,gid(%d,%d): %s\n",uid,gid,sys_errlist[errno]) ;
      return -2 ;
   }
#if ( defined ( _AIX ) && defined(_IBMR2))
   /*
    * for RS6000, setgid() and setuid() is not enough
    */
   if ( setgroups(0 , NULL) <0 ) {
      *ptrcode = errno ;
      log(LOG_ERR,"chsuser():Unable to setup the process to group ID\n");
      return -1 ;
   }
#endif
   return 0 ;
}

#if !defined(_WIN32)
static int chk_newacct(pwd,gid)
struct passwd *pwd ;
gid_t gid ;
{
  char buf[BUFSIZ] ;
  char acct[7];
  char * def_acct ;
#if defined(HPSS)
  struct group gr_result;
  char grbuf[1024];
#endif /* HPSS */
  struct group * gr ;
  char * getacctent() ;
  
#if defined(HPSS)
  gr = &gr_result;
#endif /* HPSS */
  /* get default account */
  if ( getacctent(pwd,NULL,buf,sizeof(buf)) == NULL )
    return -1 ;
  if ( strtok(buf,":") == NULL || (def_acct= strtok(NULL,":")) == NULL )
    return -1;
  if ( strlen(def_acct) == 6 && *(def_acct+3) == '$' &&   /* uuu$gg */
#if defined(HPSS)
#if defined(__osf__) && defined(__alpha)
       (getgrgid_r(gid,&gr_result,grbuf,sizeof(grbuf),&gr))
#else /* __osf__ && __alpha */
       (getgrgid_r(gid,gr,grbuf,sizeof(grbuf)))
#endif /* __osf__ && __alpha */ 
#else /* HPSS */
       (gr= getgrgid(gid))
#endif /* HPSS */
       ) {
    strncpy(acct,def_acct,4) ;
    strcpy(acct+4,gr->gr_name) ;    /* new uuu$gg */
    if ( getacctent(pwd,acct,buf,sizeof(buf)) )
      return 0 ;      /* newacct was executed */
  }
  acct[0]= '\0' ;
  return -1 ;
}

int chsgroup(pw,gid)
struct passwd *pw;
int gid;
{
  struct group *gr;
  char **membername;
#if defined(HPSS)
  struct group gr_result;
  char grbuf[1024];
  FILE *Grf;
#endif /* HPSS */
  int rc,found;

  if ( pw != NULL && pw->pw_gid != (gid_t)gid ) {
    found = 0;
#if defined(HPSS)
    rc = setgrent_r(&Grf);
    if ( rc ) return(rc);
    gr = &gr_result;
    Grf = NULL;
    while ( !( rc = getgrent_r(gr,grbuf,sizeof(grbuf),&Grf) ) ) {
#else
    (void) setgrent();
    while (gr = getgrent()) {
#endif /* HPSS */
      if ( gr->gr_gid != (gid_t)gid ) continue;
      for ( membername = gr->gr_mem; membername && *membername; membername++ )
	if ( !strcmp(*membername,pw->pw_name) ) {
	  found = 1;
	  break;
	}
      if ( found ) break;
    }
#if defined(HPSS)
    endgrent_r(&Grf);
#else /* HPSS */
    endgrent();
#endif /* hpss */
    if ( !found && chk_newacct(pw,(gid_t)gid) ) return(-1);
  } else if ( pw == NULL ) return(-1);
  return(0);
}
#endif /* WIN32 */

  
#if !defined(HPSS)
/* Warning : the new sequential transfer mode cannot be used with 
several files open at a time (because of those global variables)*/
#if !defined(_WIN32)    /* moved to global structure */
static int data_sock;   /* Data socket */
static int ctrl_sock;  /* the control socket */
static int first_write;
static int first_read;
static int byte_read_from_network;
static struct rfiostat myinfo;
#endif	/* WIN32 */
#endif /* HPSS */

int  sropen_v3(s, rt, host, bet)
#if defined(_WIN32)
SOCKET 	s;
#else
int     s;
#endif
int	rt; 	/* Is it a remote site call ?   */
char 	*host; 	/* Where the request comes from */
int   	bet;  	/* Version indicator: 0(old) or 1(new) */
{
   int	status;
   int  rcode = 0;
   char  *p;
   int  len;
   int  fd;
   LONG flags, mode;
   int uid, gid;
   WORD mask, ftype, passwd, mapping;
   char account[MAXACCTSIZE];           /* account string       */
   char user[20];			/* User name 		*/
   char reqhost[MAXHOSTNAMELEN];
   char vmstr[MAXVMSTRING];
#if defined(HPSS)
   extern char *rtuser;
   int sock;
#else /* HPSS */
#if defined(_WIN32)
    SOCKET sock;
#else
   int sock, data_s;
#endif   
#endif /* HPSS */
   int fromlen, port;
   struct sockaddr_in sin, from;
   int size_sin;
   extern int max_rcvbuf;
   extern int max_sndbuf;
   int yes;
   int optlen, maxseg;
#if defined(_WIN32)
   struct thData *td;
#endif
   
#if !defined(HPSS)
#ifdef DUXV4
#ifdef RFIODaemonRealTime
   struct sched_param param;
   int mypid = 0;

   if (getconfent("RFIOD","NORT",0) == NULL)
   {
      param.sched_priority = SCHED_PRIO_RT_MIN;
      if (sched_setscheduler(mypid,SCHED_RR,&param) < 0)
	 log(LOG_DEBUG,"ropen_v3: sched_setscheduler error : %s\n",sys_errlist[errno]);
      else
	 log(LOG_DEBUG,"ropen_v3: changing to real time class\n");
   }
#endif
#endif
#endif /* HPSS */

#if defined(_WIN32)
   td = (struct thData*)TlsGetValue(tls_i);
#endif

   /* Initialization of global variables */
   ctrl_sock = s;
   first_write = 1;
   first_read = 1;
   /* Init myinfo to zeros */
   myinfo.readop = myinfo.writop = myinfo.flusop = myinfo.statop = myinfo.seekop
      = myinfo.presop = 0;
   myinfo.rnbr = myinfo.wnbr = 0;
   /* Will remain at this value (indicates that the new sequential transfer mode has been used) */
   myinfo.aheadop = 1;
   byte_read_from_network = 0;

   p= rqstbuf + 2*WORDSIZE ;
   unmarshall_LONG(p, len) ;
   /*
    * Reading open request.
    */
   log(LOG_DEBUG,"ropen_v3: reading %d bytes\n",len) ;
   if ((status = netread(s,rqstbuf,len)) != len) {
#if defined(_WIN32)
      log(LOG_ERR,"ropen_v3: read(): %s\n", geterr());
#else      
      log(LOG_ERR,"ropen_v3: read(): %s\n",sys_errlist[errno]) ;
#endif
      return -1 ;
   }
   p= rqstbuf ;
   unmarshall_WORD(p, uid);
   unmarshall_WORD(p, gid);
   unmarshall_WORD(p, mask);
   unmarshall_WORD(p, ftype);
   unmarshall_LONG(p, flags);
   unmarshall_LONG(p, mode);
   unmarshall_STRING(p, account);
   unmarshall_STRING(p, filename);
   if (bet) {
      unmarshall_STRING(p, user);
      unmarshall_STRING(p, reqhost);
      unmarshall_LONG(p, passwd);
      unmarshall_WORD(p, mapping);
      unmarshall_STRING(p, vmstr);
   }

   log(LOG_DEBUG,"vms string is %s\n", vmstr) ;
   if (bet) 
      log(LOG_DEBUG,"Opening file %s for remote user: %s\n",filename,user);
   if (rt)
      log(LOG_DEBUG,"Mapping : %s\n",mapping ? "yes" : "no" );
   if (rt && !mapping) {
      log(LOG_DEBUG,"passwd : %d\n",passwd);
      log(LOG_DEBUG,"uid: %d\n",uid );
      log(LOG_DEBUG,"gid: %d\n",gid );
   }

   /*
    * Someone in the site has tried to specify (uid,gid) directly !
    */
   status=0;
   if (bet && !mapping && !rt) {
      log(LOG_INFO,"attempt to make non-mapped I/O and modify uid or gid !\n");
      errno=EACCES ;
      rcode=errno ;
      status= -1 ;
   }
		
   if ( rt ) { 
#if !defined(ultrix)
      openlog("rfio",LOG_PID, LOG_USER) ;
#else
      openlog("rfio",LOG_PID ) ;
#endif
      syslog(LOG_ALERT, "rfio: connection %s mapping by %s(%d,%d) from %s",(mapping ? "with" : "without"),user,uid,gid,host) ;
#if !defined(_WIN32)
      closelog();
#endif      
   }

   /*
    * MAPPED mode: user will be mapped to user "to"
    */
   if ( !status && rt && mapping ) {
      char to[100];
      int rcd,to_uid,to_gid;

      log(LOG_DEBUG,"Mapping (%s, %d, %d) \n",user, uid, gid );
      if ( (rcd = get_user(host,user,uid,gid,to,&to_uid,&to_gid)) == -ENOENT ) {
	 log(LOG_ERR,"sropen_v3(): get_user() error opening mapping file\n") ;
	 status = -1;
	 errno = EINVAL;
	 rcode = SEHOSTREFUSED ;
      }

      else if ( abs(rcd) == 1 ) {
	 log(LOG_ERR,"No entry found in mapping file for (%s,%s,%d,%d)\n", host,user,uid,gid);
	 status = -1;
	 errno = EACCES;
	 rcode = SEHOSTREFUSED;
      }
      else {
	 log(LOG_DEBUG,"(%s,%s,%d,%d) mapped to %s(%d,%d)\n",
	     host,user,uid,gid,to,to_uid,to_gid) ;
	 uid = to_uid ;
	 gid = to_gid ;
	 if ( uid < 100 || gid < 100 ) {
	    errno = EACCES;
	    status = -1;
	    rcode = SEHOSTREFUSED;
	 }
      }
   }
   /* 
    * DIRECT access: the user specifies uid & gid by himself 
    */
   if( !status && rt && !mapping ) {
#if defined(HPSS)
      if ( rtuser == NULL || strcmp(rtuser,"YES") ) {
#else /* HPSS */
      char *rtuser;
      if( (rtuser = getconfent("RTUSER","CHECK",0) ) == NULL || ! strcmp (rtuser,"YES") ) {
#endif /* HPSS */
	 /* Port is also passwd */
	 sock = connecttpread(reqhost, passwd);
#if defined(_WIN32)
	 if( (sock != INVALID_SOCKET) && !checkkey(sock, passwd) )  
#else	    
	 if( (sock >= 0) && !checkkey(sock, passwd) )  
#endif
	 {
	    status= -1 ;
	    errno = EACCES;
	    rcode= errno ;
	    log(LOG_ERR,"ropen_v3: DIRECT mapping : permission denied\n");
	 }
#if defined(_WIN32)
	 if( sock == INVALID_SOCKET )  
#else	    
	 if (sock < 0) 
#endif
	 {
	    status= -1 ;
	    log(LOG_ERR,"ropen_v3: DIRECT mapping failed: Couldn't connect %s\n",reqhost);
	    rcode = EACCES;
	 }
      }
      else
	 log(LOG_INFO ,"Any DIRECT rfio request from out of site is authorized\n");
   }
   if ( !status ) {

      log(LOG_DEBUG, "ropen_v3: uid %d gid %d mask %o ftype %d flags %d mode %d\n",uid, gid, mask, ftype, flags, mode);
      log(LOG_DEBUG, "ropen_v3: account: %s\n", account);
      log(LOG_DEBUG, "ropen_v3: filename: %s\n", filename);
      log(LOG_INFO, "ropen_v3(%s,0X%X,0X%X) for (%d,%d)\n",filename,flags,mode,uid,gid);
      (void) umask(mask) ;
#if !defined(_WIN32)  
      if ( (status=chsuser(uid,gid,host,&rcode,"OPENTRUST")) < 0 ) {
	 if (status == -2)
	    log(LOG_ERR,"ropen_v3: uid %d not allowed to open()\n",uid);
	 else
	    log(LOG_ERR,"ropen_v3: failed at chsuser(), rcode %d\n",rcode);
	 status = -1 ;
      }  else
#endif
      {
	 fd = open(filename, ntohopnflg(flags), mode);
#if defined(_WIN32)
	 _setmode( fd, _O_BINARY );	/* default is text mode  */
#endif	
	 log(LOG_DEBUG,"ropen_v3: open(%s,%d,%d) returned %x (hex)\n",filename,flags,mode,fd) ;
	 if (fd < 0)  {
	    char alarmbuf[1024];
	    sprintf(alarmbuf,"sropen_v3: %s",filename) ;
	    status= -1 ;
	    rcode= errno ;
	    log(LOG_DEBUG,"ropen_v3: open: %s\n",sys_errlist[errno]) ;
	    /* rfio_alrm(rcode,alarmbuf) ; */
	 }
	 else  {
	    /*
	     * Getting current offset
	     */
	    status= lseek(fd,0L,SEEK_CUR) ;
	    log(LOG_DEBUG,"ropen_v3: lseek(%d,0,SEEK_CUR) returned %x (hex)\n",fd,status) ; 
	    if ( status < 0 ) rcode= errno ;
	 }
      }
   }

   if (fd >= 0)  {
      data_s = socket(AF_INET, SOCK_STREAM, 0);
#if defined(_WIN32)
      if( data_s == INVALID_SOCKET )  {
	 log( LOG_ERR, "datasocket(): %s\n", geterr());
	 return(-1);
      }
#else      
      if( data_s < 0 )  {
	 log(LOG_ERR, "datasocket(): %s\n", sys_errlist[errno]);
#if defined(HPSS)
	 return(-1);
#endif /* HPSS */
	 exit(1);
      }
#endif	    
      log(LOG_DEBUG, "data socket created fd=%d\n", data_s);
      memset(&sin,0,sizeof(sin));
      port = 0;
      sin.sin_port = htons(port);
      sin.sin_addr.s_addr = htonl(INADDR_ANY);
      sin.sin_family = AF_INET;
	    
#if defined(_WIN32)	    
      if( bind(data_s, (struct sockaddr*)&sin, sizeof(sin)) == SOCKET_ERROR) 
      {
	 log(LOG_ERR, "bind: %s\n", geterr());
	 return(-1);
      }
#else
      if( bind(data_s, (struct sockaddr*)&sin, sizeof(sin)) < 0 )
      {
	 log(LOG_ERR, "bind: %s\n",sys_errlist[errno]);
#if defined(HPSS)
	 return(-1);
#endif /* HPSS */
	 exit(1);
      }
#endif
      
      size_sin = sizeof(sin);
#if defined(_WIN32)      
      if( getsockname(data_s, (struct sockaddr*)&sin, &size_sin) == SOCKET_ERROR )  {
	 log(LOG_ERR, "getsockname: %s\n", geterr());
	 return(-1);
      }
#else
      if( getsockname(data_s, (struct sockaddr*)&sin, &size_sin) < 0 )  {
	 log(LOG_ERR, "getsockname: %s\n",sys_errlist[errno]);
#if defined(HPSS)
	 return(-1);
#endif /* HPSS */
	 exit(1);
      }
#endif	    
      log(LOG_DEBUG, "ropen_v3: assigning data port %d\n",htons(sin.sin_port));
#if defined(_WIN32)	    
      if( listen(data_s, 5) == INVALID_SOCKET )   {
	 log(LOG_ERR, "listen: %s\n", geterr());
	 return(-1);
      }
#else
      if( listen(data_s, 5) < 0 )   {
	 log(LOG_ERR, "listen: %s\n",sys_errlist[errno]);
#if defined(HPSS)
	 return(-1);
#endif /* HPSS */
	 exit(1);
      }
#endif
   }
	   
   /*
    * Sending back status to the client
    */
   p= rqstbuf ;
   marshall_WORD(p,RQST_OPEN_V3) ; 
   marshall_LONG(p,status);
   marshall_LONG(p,rcode) ;
   marshall_LONG(p,ntohs(sin.sin_port)) ;
   log(LOG_DEBUG, "ropen_v3: sending back status(%d) and errno(%d)\n",status,rcode);
   errno = ECONNRESET;
   if (netwrite(s,rqstbuf,RQSTSIZE) != RQSTSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR,"ropen_v3: write(): %s\n", geterr());
#else      
      log(LOG_ERR,"ropen_v3: write(): %s\n",sys_errlist[errno]) ;
#endif
      return -1 ;
   }

   if (fd >= 0)
   {
#if defined(sgi)
      /* On SGIs, setting the rcv and snd socket buffer size to 256 KB with FDDI gives
	 bad performance so we restrict this size to 128 KB only
	 Tuning done for reading NTPs with FDDI between AIX 4 client with 1 MB send socket buffer
	 size and IRIX 6.2 server with 256 KB rcv socket buffer size */

      optlen = sizeof(maxseg);
      if (getsockopt(data_sock,IPPROTO_TCP,TCP_MAXSEG,(char *)&maxseg,&optlen) < 0) {
	 log(LOG_ERR,"rread_v3: getsockopt maxseg: ERROR occured (errno=%d)",errno); 
      }

      /* MTU for FDDI */
      if ((maxseg > 4000) && (maxseg < 5000))
	 max_rcvbuf = max_sndbuf = 128 * 1024;
#endif

      /*
       * The rcvbuf on the data socket must be set _before_
       * the connection is accepted! Otherwise the receiver will
       * only offer the default window, which for large MTU devices
       * (such as HIPPI) is far too small and performance goes down
       * the drain.
       *
       * The sndbuf must be set on the socket returned by accept()
       * as it is not inherited (at least not on SGI).
       * 98/08/05 - Jes
       */
      log(LOG_DEBUG, "doing setsockopt rcv\n");
#if defined(_WIN32)
      if( setsockopt(data_s, SOL_SOCKET, SO_RCVBUF, (char*)&max_rcvbuf,
		     sizeof(max_rcvbuf)) == SOCKET_ERROR )  {
	 log(LOG_ERR, "setsockopt open rcvbuf(%d bytes): %s\n", max_rcvbuf, geterr());
      }
#else      
      if (setsockopt(data_s,SOL_SOCKET,SO_RCVBUF,(char *)&max_rcvbuf,
		     sizeof(max_rcvbuf)) < 0) {
	 log(LOG_ERR, "setsockopt open rcvbuf(%d bytes): %s\n",
	     max_rcvbuf, sys_errlist[errno]);
      }
#endif	/* WIN32 */
      log(LOG_DEBUG, "setsockopt rcvbuf on data socket (%d bytes)\n",
	  max_rcvbuf);
      for (;;) 
      {
	 fromlen = sizeof(from);
	 log(LOG_DEBUG, "ropen_v3: wait for accept to complete\n");
	 data_sock = accept(data_s, (struct sockaddr*)&from, &fromlen);
#if defined(_WIN32)
	 if( data_sock == INVALID_SOCKET )  {
	    if( WSAGetLastError() != WSAEINTR )  {
	       log(LOG_ERR, "data accept(): %s\n", geterr());
	       return(-1);
	    }  else  {
	       log(LOG_DEBUG, "data accept(): %s\n", geterr());
	       continue;
	    }
	 }
#else	    
	 if( data_sock < 0 )  {
	    if (errno != EINTR)   {
	       log(LOG_ERR, "data accept(): %s\n",sys_errlist[errno]);
#if defined(HPSS)
	       return(-1);
#endif /* HPSS */
	       exit(1);
	    }  else   {
	       log(LOG_DEBUG, "data accept(): %s\n",sys_errlist[errno]);
	       continue;
	    }
	 }
#endif 	/* WIN32 */	 
	 else
	    break;
      }
      log(LOG_DEBUG, "data accept is ok, fildesc=%d\n",data_sock);

      /*
       * Set the send socket buffer on the data socket (see comment
       * above before accept())
       */
      log(LOG_DEBUG, "doing setsockopt snd\n");
#if defined(_WIN32)
      if( setsockopt(data_sock, SOL_SOCKET, SO_SNDBUF, (char*)&max_sndbuf,
		     sizeof(max_sndbuf)) == SOCKET_ERROR)  {
	 log(LOG_ERR, "setsockopt open sndbuf(%d bytes): %s\n",
	     max_sndbuf, geterr());
      }
#else       
      if (setsockopt(data_sock,SOL_SOCKET,SO_SNDBUF,(char *)&max_sndbuf,
		     sizeof(max_sndbuf)) < 0) {
	 log(LOG_ERR, "setsockopt open sndbuf(%d bytes): %s\n",
	     max_sndbuf, sys_errlist[errno]);
      }
#endif 	/* WIN32 */
      log(LOG_DEBUG, "setsockopt sndbuf on data socket (%d bytes)\n",
	  max_sndbuf);

      /* Set the keepalive option on both sockets */
      yes = 1;
#if defined(_WIN32)
      if( setsockopt(data_sock, SOL_SOCKET, SO_KEEPALIVE, (char*)&yes,
		     sizeof(yes)) == SOCKET_ERROR) {
	 log(LOG_ERR, "setsockopt keepalive on data: %s\n", geterr());
      } 
#else      
      if (setsockopt(data_sock,SOL_SOCKET,SO_KEEPALIVE,(char *)&yes, sizeof(yes)) < 0) {
	 log(LOG_ERR, "setsockopt keepalive on data: %s\n",sys_errlist[errno]);
      }
#endif	/* WIN32 */      
      log(LOG_DEBUG, "setsockopt keepalive on data done\n");
	    
      yes = 1;
#if defined(_WIN32)
      if( setsockopt(ctrl_sock, SOL_SOCKET, SO_KEEPALIVE, (char*)&yes,
		     sizeof(yes)) == SOCKET_ERROR )  {
	 log(LOG_ERR, "setsockopt keepalive on ctrl: %s\n", geterr());
      }      
#else
      if (setsockopt(ctrl_sock,SOL_SOCKET,SO_KEEPALIVE,(char *)&yes, sizeof(yes)) < 0) {
	 log(LOG_ERR, "setsockopt keepalive on ctrl: %s\n",sys_errlist[errno]);
      }
#endif	/* WIN32 */
      log(LOG_DEBUG, "setsockopt keepalive on ctrl done\n");

#if (defined(__osf__) && defined(__alpha) && defined(DUXV4))    
      /* Set the keepalive interval to 20 mns instead of the default 2 hours */
      yes = 20 * 60;
      if (setsockopt(data_sock,IPPROTO_TCP,TCP_KEEPIDLE,(char *)&yes,sizeof(yes)) < 0) {
	 log(LOG_ERR, "setsockopt keepidle on data: %s\n",sys_errlist[errno]);
      }
      log(LOG_DEBUG, "setsockopt keepidle on data done (%d s)\n",yes);
	    
      yes = 20 * 60;
      if (setsockopt(ctrl_sock,IPPROTO_TCP,TCP_KEEPIDLE,(char *)&yes,sizeof(yes)) < 0) {
	 log(LOG_ERR, "setsockopt keepidle on ctrl: %s\n",sys_errlist[errno]);
      }
      log(LOG_DEBUG, "setsockopt keepidle on ctrl done (%d s)\n",yes);
#endif
#if !(defined(__osf__) && defined(__alpha) && defined(DUXV4))    
      /*
       * TCP_NODELAY seems to cause small Hippi packets on Digital UNIX 4.x
       */
      yes = 1;
#if defined(_WIN32)
      if( setsockopt(data_sock, IPPROTO_TCP, TCP_NODELAY, (char*)&yes,
		     sizeof(yes))  == SOCKET_ERROR )  {
	 log(LOG_ERR, "setsockopt nodelay on data: %s\n", geterr());
      }
#else      
      if (setsockopt(data_sock,IPPROTO_TCP,TCP_NODELAY,(char *)&yes,sizeof(yes)) < 0) {
	 log(LOG_ERR, "setsockopt nodelay on data: %s\n",sys_errlist[errno]);
      }
#endif	/* WIN32 */      
      log(LOG_DEBUG,"setsockopt nodelay option set on data socket\n");
#endif /* !(defined(__osf__) && defined(__alpha) && defined(DUXV4)) */
      
      yes = 1;
#if defined(_WIN32)
      if( setsockopt(ctrl_sock, IPPROTO_TCP, TCP_NODELAY, (char*)&yes,
		     sizeof(yes)) == SOCKET_ERROR )  {
	 log(LOG_ERR, "setsockopt nodelay on ctrl: %s\n", geterr());
      } 
#else      
      if (setsockopt(ctrl_sock,IPPROTO_TCP,TCP_NODELAY,(char *)&yes,sizeof(yes)) < 0) {
	 log(LOG_ERR, "setsockopt nodelay on ctrl: %s\n",sys_errlist[errno]);
      }
#endif  /* WIN32 */
      log(LOG_DEBUG,"setsockopt nodelay option set on ctrl socket\n");
   }
#if defined(SACCT)
   rfioacct(RQST_OPEN_V3,uid,gid,s,(int)ntohopnflg(flags),(int)mode,status,rcode,NULL,filename,NULL);
#endif /* SACCT */
   return fd ;
}


int   srclose_v3(s, infop, fd)
#if defined(_WIN32)
SOCKET 	s;
#else
int	s;
#endif   
int     fd;
struct rfiostat *infop;
{
   int 	status;
   int  rcode;
   char *p;

#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif
   
   log(LOG_INFO,"%d read, %d readahead, %d write, %d flush, %d stat, %d lseek and %d preseek\n",
       myinfo.readop, myinfo.aheadop, myinfo.writop, myinfo.flusop, myinfo.statop,
       myinfo.seekop, myinfo.presop);
   log(LOG_INFO,"%d bytes read and %d bytes written\n", myinfo.rnbr,myinfo.wnbr) ;
   log(LOG_INFO, "rclose_v3(%d, %d)\n",s, fd) ;
#if defined(HPSS)
   status = rhpss_close(fd,s,0,0);
#else /* HPSS */
   status = close(fd) ;
#endif /* HPSS */
   rcode = ( status < 0 ) ? errno : 0 ;

#if !defined(HPSS)
   /* Close data socket */
#if defined(_WIN32)
   if( closesocket(data_sock) == SOCKET_ERROR )
     log(LOG_DEBUG, "rclose_v3: Error closing data socket fildesc=%d, errno=%d\n",
	  data_sock, WSAGetLastError()); 
#else      
   if( close(data_sock) < 0 )
      log(LOG_DEBUG, "rclose_v3 : Error closing data socket fildesc=%d,errno=%d\n",
	  data_sock, errno);
#endif	/* WIN32 */   
   else
      log(LOG_DEBUG, "rclose_v3 : closing data socket fildesc=%d\n", data_sock) ;
#endif /* HPSS */
   p= rqstbuf; 
   marshall_WORD(p, RQST_CLOSE_V3);
   marshall_LONG(p, status);
   marshall_LONG(p, rcode);
#if defined(SACCT)
   rfioacct(RQST_CLOSE_V3,0,0,s,0,0,status,rcode,&myinfo,NULL,NULL);
#endif /* SACCT */
   
   errno = ECONNRESET;
   if (netwrite(s, rqstbuf, RQSTSIZE) != RQSTSIZE)  {
#if defined(_WIN32)
      log(LOG_ERR, "rclose_v3: netwrite(): %s\n", geterr());
#else      
      log(LOG_ERR, "rclose_v3: write(): %s\n", sys_errlist[errno]);
#endif  /* WIN32 */
      return -1 ;
   }
#if !defined(HPSS)
#if defined(_WIN32)
   if( closesocket(s) == SOCKET_ERROR )
      log(LOG_DEBUG, "rclose_v3: Error closing control socket fildesc=%d, errno=%d\n",
	  s, WSAGetLastError());
#else
   if( close(s) < 0 )
      log(LOG_DEBUG, "rclose_v3 : Error closing control socket fildesc=%d,errno=%d\n",
	  s, errno);
#endif  /* WIN32 */
   else
      log(LOG_DEBUG, "rclose_v3 : closing ctrl socket fildesc=%d\n", s);
#endif /* HPSS */

   return status ;
}

#if defined(_WIN32)
int srread_v3(s, infop, fd)
SOCKET 	s;
#else
#if defined(HPSS)
int srread_v3(s, infop, fd)
int s;
#else /* HPSS */
int srread_v3(ctrl_sock, infop, fd)
int     ctrl_sock;
#endif /* HPSS */
#endif
int     fd;
struct 	rfiostat* infop;
{
   int	status; 	/* Return code		*/
   int	rcode;		/* To send back errno	*/
   int 	how;		/* lseek mode		*/
   int	offset;		/* lseek offset		*/
   int  size;		/* Requeste write size	*/
   char *p;		/* Pointer to buffer	*/
#if !defined(_WIN32) && !defined(HPSS)
   char *iobuffer;
#endif
   fd_set fdvar, fdvar2;
   extern int max_sndbuf;
   int optlen, maxseg;
   struct stat st;
   char rfio_buf[BUFSIZ];
   int eof_met;
#if defined(HPSS)
   extern int DISKBUFSIZE_READ;
#else /* HPSS */
   int DISKBUFSIZE_READ = (2 * 1024 * 1024); 
#endif /* HPSS */
   int n;
 
#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);

   ctrl_sock = s;
#endif 
#if defined(HPSS)
   ctrl_sock = s;
#endif /* HPSS */
   /*
    * Receiving request,
    */
   log(LOG_DEBUG, "rread_v3(%d, %d)\n",ctrl_sock, fd);
  
   if (first_read)
   {
      char *p;
      first_read = 0;
      eof_met = 0;
      
#if !defined(HPSS)
      if( (p = getconfent("RFIO", "DAEMONV3_RDSIZE", 0)) != NULL )
      {
	 if (atoi(p) > 0)
	    DISKBUFSIZE_READ = atoi(p);
      }
#endif /* HPSS */    
#if defined(HPSS)
      /*
       * For HPSS we reuse the buffer defined in the global structure
       * for this thread rather than reserving a new local buffer.
       */
      if ( iobufsiz>0 && iobufsiz<DISKBUFSIZE_READ) {
	 free(iobuffer);
	 iobufsiz = 0;
      }
      if ( iobufsiz <= 0 ) {
#endif /* HPSS */
	 log(LOG_DEBUG, "rread_v3 allocating malloc buffer : %d bytes\n",DISKBUFSIZE_READ);
	 if ((iobuffer = (char *)malloc(DISKBUFSIZE_READ)) == NULL)  {
#if defined(_WIN32)
	    log(LOG_ERR, "rread_v3: malloc: ERROR occured (errno=%d)", errno);
#else	 
	    TRACE(2,"rfio","rread_v3: malloc: ERROR occured (errno=%d)",errno) ;
	    END_TRACE() ;
#endif	/* WIN32 */
	    return -1 ;
	 }
	 log(LOG_DEBUG, "rread_v3 malloc buffer allocated : 0X%X\n",iobuffer);      
#if defined(HPSS)
	 iobufsiz = DISKBUFSIZE_READ;
      }
#endif /* HPSS */
      if (fstat(fd,&st) < 0) {
#if defined(_WIN32)
	 log(LOG_ERR, "rread_v3: fstat(): ERROR occured (errno=%d)", errno);
#else	 
	 TRACE(2,"rfio","rread_v3: fstat(): ERROR occured (errno=%d)",errno) ;
	 END_TRACE() ;
#endif	/* WIN32 */
	 return -1 ;
      }
      
      log(LOG_DEBUG, "rread_v3 filesize : %d bytes\n",st.st_size);
      p = rfio_buf;
      marshall_WORD(p,RQST_READ_V3);
      marshall_LONG(p,st.st_size);

#if defined(_WIN32)
      log(LOG_DEBUG, "rread_v3: sending %d bytes", RQSTSIZE);
#else      
      TRACE(2, "rfio", "rread_v3: sending %d bytes",RQSTSIZE) ;
#endif	/* WIN32 */
      errno = ECONNRESET;
      if ((n = netwrite(ctrl_sock, rfio_buf, RQSTSIZE)) != RQSTSIZE) {
#if defined(_WIN32)
	 log(LOG_ERR, "rread_v3: netwrite(): %s\n", geterr());
#else	 
	 TRACE(2,"rfio","rread_v3: write(): ERROR occured (errno=%d)",errno) ;
	 END_TRACE() ;
#endif	/* WIN32 */
	 return -1 ;
      }

#if !defined (_WIN32)     
      optlen = sizeof(maxseg);
      if (getsockopt(data_sock,IPPROTO_TCP,TCP_MAXSEG,(char *)&maxseg,&optlen) < 0) {
	 log(LOG_ERR,"rread_v3: getsockopt maxseg: ERROR occured (errno=%d)",errno); 
      }
      log(LOG_DEBUG,"rread_v3: max TCP segment: %d\n",maxseg);
#endif   /* TCP_MAXSEG option not supported by WinSock */      

#ifdef CS2
      if (ioctl(fd,NFSIOCACHE,CLIENTNOCACHE) < 0)
	 TRACE(2,"rfio","rread_v3: ioctl client nocache error occured (errno=%d)",errno);
      
      if (ioctl(fd,NFSIOCACHE,SERVERNOCACHE) < 0) 
	 TRACE(2,"rfio","rread_v3: ioctl server nocache error occured (errno=%d)",errno);
      log(LOG_DEBUG,"rread_v3: CS2: clientnocache, servernocache\n");
#endif
   }
  
   /*
    * Reading data from the network.
    */
   while (1) 
   {
      struct timeval t;
      fd_set *write_fdset;
      
      FD_ZERO(&fdvar);
      FD_SET(ctrl_sock,&fdvar);
      
      FD_ZERO(&fdvar2);
      FD_SET(data_sock,&fdvar2);
      
      t.tv_sec = 10;
      t.tv_usec = 0;
      
      if (eof_met)
	 write_fdset = NULL;
      else
	 write_fdset = &fdvar2;
      
      log(LOG_DEBUG,"srread: doing select\n") ;
#if defined(_WIN32)
      if( select(FD_SETSIZE, &fdvar, write_fdset, NULL, &t) == SOCKET_ERROR )  {
	 log(LOG_ERR, "srread_v3: select failed: %s\n", geterr());
	 return -1;
      }
#else      
      if( select(FD_SETSIZE, &fdvar, write_fdset, NULL, &t) < 0 )  {
	 TRACE(2,"rfio","srread_v3: select failed (errno=%d)",errno) ;
	 END_TRACE() ;
	 return -1 ;
      }
#endif      
      if( FD_ISSET(ctrl_sock, &fdvar) )  {
	 int n, magic, code;
	  
	 /* Something received on the control socket */
	 log(LOG_DEBUG, "ctrl socket: reading %d bytes\n", RQSTSIZE) ;
	 errno = ECONNRESET;
	 if ((n = netread(ctrl_sock,rqstbuf,RQSTSIZE)) != RQSTSIZE) {
#if defined(_WIN32)
	    log(LOG_ERR, "read ctrl socket: netread(): %s\n", geterr());
#else	    
	    log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif
	    return -1 ;
	 }
	 p = rqstbuf ; 
	 unmarshall_WORD(p,magic) ;
	 unmarshall_WORD(p,code) ;
	  
	 /* what to do ? */
	 if (code == RQST_CLOSE_V3)  {
	    log(LOG_DEBUG,"close request: magic: %x code: %x\n", magic, code);
#if !defined(HPSS)
	    log(LOG_DEBUG,"freeing iobuffer at 0X%X\n",iobuffer) ;
	    free(iobuffer);
#endif /* HPSS */
	    srclose_v3(ctrl_sock,&myinfo,fd);
	    return 0;
	 }  else  {
	    log(LOG_ERR,"unknown request:  magic: %x code: %x\n",magic,code) ;
	    return(-1);
	 }
      }
      
      /*
       * Reading data on disk.
       */
      
      if( !eof_met && (FD_ISSET(data_sock, &fdvar2)) )  {
#if defined(HPSS)
	 status = rhpss_read(fd,iobuffer,DISKBUFSIZE_READ,s,0,0);
#else /* HPSS */
	 status = read(fd,iobuffer,DISKBUFSIZE_READ);
#endif /* HPSS */

	 /* To simulate a read I/O error 
	    status = -1;
	    errno = 5; */

	 rcode = (status < 0) ? errno:0;
	 log(LOG_DEBUG, "%d bytes have been read on disk\n",status) ;

	 if (status == 0)  {
	    eof_met = 1;
	    p = rqstbuf;
	    marshall_WORD(p,REP_EOF) ;			
	    log(LOG_DEBUG, "rread_v3: eof\n") ;
	    errno = ECONNRESET;
	    if ((n = netwrite(ctrl_sock, rqstbuf, RQSTSIZE)) != RQSTSIZE)  {
#if defined(_WIN32)
	       log(LOG_ERR,"rread_v3: netwrite(): %s\n", geterr());   
#else	       
	       log(LOG_ERR,"rread_v3: netwrite(): %s\n", sys_errlist[errno]) ;
#endif 	/* WIN32 */	       
	       return -1 ; 
	    }
	 } /*  status == 0 */
	 else
	    if (status < 0)  {
	       p = rqstbuf;
	       marshall_WORD(p, REP_ERROR);			
	       marshall_LONG(p, status);
	       marshall_LONG(p, rcode);
	       log(LOG_DEBUG, "rread_v3: status %d, rcode %d\n", status, rcode) ;
	       errno = ECONNRESET;
	       if ((n = netwrite(ctrl_sock, rqstbuf, RQSTSIZE)) != RQSTSIZE)  {
#if defined(_WIN32)
		  log(LOG_ERR, "rread_v3: netwrite(): %s\n", geterr()); 
#else		  
		  log(LOG_ERR, "rread_v3: netwrite(): %s\n", sys_errlist[errno]) ;
#endif  /* WIN32 */
		  return -1 ; 
	       }
	       log(LOG_DEBUG, "read_v3: waiting ack for error\n");
	       if ((n = netread(ctrl_sock,rqstbuf,RQSTSIZE)) != RQSTSIZE) {
		  if (n == 0)  {
#if defined(_WIN32)
		     WSASetLastError(WSAECONNRESET);
		     log(LOG_ERR, "read ctrl socket: read(): %s\n", geterr());
#else		     
		     errno = ECONNRESET;
		     log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif	/* WIN32 */
		     return -1;
		  }  else  {
#if defined(_WIN32)
		     log(LOG_ERR, "read ctrl socket: read(): %s\n", geterr()); 
#else		     
		     log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif
		     return -1 ;
		  }
	       }
	       return(-1);
	    }  else  {
	       log(LOG_DEBUG, "rread_v3: writing %d bytes to data socket %d\n",status, data_sock) ;
#if defined(_WIN32)
	       WSASetLastError(WSAECONNRESET);
	       if( (n = send(data_sock, iobuffer, status, 0)) != status )  {
		  log(LOG_ERR, "rread_v3: send() (to data sock): %s", geterr() );
		  log(LOG_ERR, "rread_v3: freeing iobuffer after error in send: 0X%X\n", iobuffer);
		  free(iobuffer);
		  return -1;
	       }
#else
	       errno = ECONNRESET;  
	       if( (n = write(data_sock, iobuffer, status)) != status ) {
		  log(LOG_ERR, "rread_v3: write(): %s\n", sys_errlist[errno]);
		  return -1 ; 
	       }
#endif
	       myinfo.rnbr += status;
	       myinfo.readop++;
	    }
      }
   }
}

int srwrite_v3(s, infop, fd)
#if defined(_WIN32)
SOCKET 	s;   
#else
int     s;
#endif
int	fd;
struct rfiostat *infop;
{
   int	status; 	/* Return code		*/
   int	rcode;		/* To send back errno	*/
   int 	how;		/* lseek mode		*/
   int	offset;		/* lseek offset		*/
   int  size;		/* Requested write size	*/
   char *p;		/* Pointer to buffer	*/
#if !defined(_WIN32) && !defined(HPSS)
   char *iobuffer;
#endif   
   fd_set fdvar, fdvar2;
   int byte_written_by_client;
   extern int max_rcvbuf;
   int optlen, maxseg;
   int byte_in_diskbuffer = 0;
   char *iobuffer_p;
   int max_rcv_wat;
   struct timeval t;
#if defined(HPSS)
   int sizeofdummy;
   /*
    * Put dummy on heap to avoid large arrays in thread stack
    */
   unsigned char *dummy;
   extern int DISKBUFSIZE_WRITE;
#else /* HPSS */
   int DISKBUFSIZE_WRITE = (2*1024*1024); 
#endif /* HPSS */
#if defined(_WIN32)
   struct thData *td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif
  
   /*
    * Receiving request,
    */
   log(LOG_DEBUG, "rwrite_v3(%d, %d)\n",s, fd);
   if( first_write )  {
      char *p;
      
      first_write = 0;

#if !defined(HPSS)
      if ((p = getconfent("RFIO","DAEMONV3_WRSIZE",0)) != NULL)  {
	 if (atoi(p) > 0)
	    DISKBUFSIZE_WRITE = atoi(p);
      }
#endif /* HPSS */
      
#if defined(HPSS)
      /*
       * For HPSS we reuse the buffer defined in the global structure
       * for this thread rather than reserving a new local buffer.
       */
      if ( iobufsiz>0 && iobufsiz<DISKBUFSIZE_WRITE) {
	free(iobuffer);
	iobufsiz = 0;
      }
      if ( iobufsiz <= 0 ) {
#endif /* HPSS */
      log(LOG_DEBUG, "rwrite_v3 allocating malloc buffer : %d bytes\n",DISKBUFSIZE_WRITE);
      if ((iobuffer = (char *)malloc(DISKBUFSIZE_WRITE)) == NULL) {
#if defined(_WIN32)
	 log(LOG_ERR, "rwrite_v3: malloc: ERROR occured (errno=%d)", errno);
#endif	 
	 TRACE(2,"rfio","rwrite_v3: malloc: ERROR occured (errno=%d)",errno) ;
	 END_TRACE() ;
	 return -1 ;
      }
#if defined(HPSS)
      iobufsiz = DISKBUFSIZE_WRITE;
      }
#endif /* HPSS */
      
      byte_in_diskbuffer = 0;
      iobuffer_p = iobuffer;
#if !defined(_WIN32)
      optlen = sizeof(maxseg);
      if (getsockopt(data_sock,IPPROTO_TCP,TCP_MAXSEG,(char *)&maxseg,&optlen) < 0) {
	 TRACE(2,"rfio","rwrite_v3: getsockopt: ERROR occured (errno=%d)",errno) ;
	 END_TRACE() ;
	 return -1 ;
      }
      log(LOG_DEBUG,"rwrite_v3: max TCP segment: %d\n",maxseg);
#endif	/* WIN32 */       
#ifdef CS2
      log(LOG_DEBUG,"rwrite_v3: CS2: clientnocache, servercache\n");
      if (ioctl(fd,NFSIOCACHE,CLIENTNOCACHE) < 0)
	 TRACE(2,"rfio","rwrite_v3: ioctl client nocache error occured (errno=%d)",errno);
      
      if (ioctl(fd,NFSIOCACHE,SERVERCACHE) < 0) 
	 TRACE(2,"rfio","rwrite_v3: ioctl server cache error occured (errno=%d)",errno);
#endif
   }
  
   /*
    * Reading data from the network.
    */
  
   while (1)  {
      FD_ZERO(&fdvar);
      FD_SET(ctrl_sock, &fdvar);
      FD_SET(data_sock, &fdvar);
      
      t.tv_sec = 10;
      t.tv_usec = 0;
      
      log(LOG_DEBUG,"rwrite: doing select\n") ;
#if defined(_WIN32)
      if( select(FD_SETSIZE, &fdvar, NULL, NULL, &t) == SOCKET_ERROR ) {
	 log(LOG_ERR, "rwrite_v3: select: %s", geterr());
	 return -1;
      }
#else      
      if( select(FD_SETSIZE, &fdvar, NULL, NULL, &t) < 0 )  {
	 TRACE(2, "rfio", "rwrite_v3: select failed (errno=%d)", errno) ;
	 END_TRACE() ;
	 return -1 ;
      }
#endif	/* WIN32 */
      
      if( FD_ISSET(ctrl_sock, &fdvar) )  {
	 int n, magic, code;
	  
	 /* Something received on the control socket */
	 log(LOG_DEBUG, "ctrl socket: reading %d bytes\n",RQSTSIZE) ;
	 if( (n = netread(ctrl_sock, rqstbuf, RQSTSIZE)) != RQSTSIZE )  {
	    if (n == 0)  {
	       errno = ECONNRESET;
#if defined(_WIN32)
	       log(LOG_ERR, "read ctrl socket: netread(): %s\n", ws_strerr(errno));
#else
	       log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif	/* WIN32 */
	       return -1;
	    }
	    else
	    {
#if defined(_WIN32)
	       log(LOG_ERR, "read ctrl socket: netread(): %s\n", geterr());
#else	              
	       log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif	/* WIN32 */
	       return -1 ;
	    }
	 }
	 p = rqstbuf ; 
	 unmarshall_WORD(p,magic) ;
	 unmarshall_WORD(p,code) ;
	 unmarshall_LONG(p,byte_written_by_client);
	  
	 if (code == RQST_CLOSE_V3)
	    log(LOG_DEBUG,"close request:  magic: %x code: %x\n",magic,code) ;
	 else
	    log(LOG_DEBUG,"unknown request:  magic: %x code: %x\n",magic,code) ;
	  
	 log(LOG_DEBUG, "data socket: read_from_net=%d, written_by_client=%d\n",
	     byte_read_from_network, byte_written_by_client);
	 
	 if( byte_read_from_network == byte_written_by_client )  {
	    /*
	     * Writing last buffered data on disk if necessary  
	     */
	      
	    if( byte_in_diskbuffer )  {
	       log(LOG_DEBUG, "writing last %d bytes on disk\n",byte_in_diskbuffer) ;
#if defined(HPSS)
	       status = rhpss_write(fd,iobuffer,byte_in_diskbuffer,s,0,0);
#else /* HPSS */
	       status = write(fd,iobuffer,byte_in_diskbuffer);
#endif /* HPSS */
	       rcode = (status < 0) ? errno:0;
	      
	       if (status < 0)  {
		  p = rqstbuf;
		  marshall_WORD(p,REP_ERROR) ;			
		  marshall_LONG(p,status) ;
		  marshall_LONG(p,rcode) ;
		  log(LOG_ERR, "rwrite_v3: status %d (%s), rcode %d\n", status,
		      sys_errlist[errno], rcode);
		  errno = ECONNRESET;
		  if( (n = netwrite(s, rqstbuf, RQSTSIZE)) != RQSTSIZE )  {
#if defined(_WIN32)
		     log(LOG_ERR, "rwrite_v3: netwrite(): %s\n", ws_strerr(errno));
#else		     
		     log(LOG_ERR, "rwrite_v3: write(): %s\n", sys_errlist[errno]);
#endif		     
		     return -1; 
		  }

		  /* No deadlock here since the client has already sent a CLOSE request 
		     (thus no data is still in transit) */
		  log(LOG_DEBUG, "rwrite_v3: waiting ack for error\n");
		  if ((n = netread(ctrl_sock,rqstbuf,RQSTSIZE)) != RQSTSIZE) {
		     if (n == 0)  {
			errno = ECONNRESET;
#if defined(_WIN32)
			log(LOG_ERR, "read ctrl socket: netread(): %s\n", ws_strerr(errno));
#else
			log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif 	/* WIN32 */
			return -1;
		     }  else    {
#if defined(_WIN32)
			log(LOG_ERR, "read ctrl socket: netread(): %s\n", geterr());
#else			
			log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif	/* WIN32 */
			return -1 ;
		     }
		  }
	       }  else   {
		  myinfo.wnbr += byte_in_diskbuffer;
		  myinfo.writop++;
		  byte_in_diskbuffer = 0;
		  iobuffer_p = iobuffer;
	       }
	    }
#if !defined(HPSS)
	    log(LOG_DEBUG,"freeing iobuffer at 0X%X\n",iobuffer) ;
	    free(iobuffer);
#endif /* HPSS */
	    srclose_v3(ctrl_sock, &myinfo, fd);
	    return 0;
	 } /*  if( byte_read_from_network == byte_written_by_client ) */
	 else  {
	    int diff;
	      
	    diff = byte_written_by_client - byte_read_from_network;
#if defined(HPSS)
	    if (byte_in_diskbuffer + diff > iobufsiz)  {
#else /* HPSS */
	    if (byte_in_diskbuffer + diff > DISKBUFSIZE_WRITE)  {
#endif /* HPSS */
	       iobuffer = (char*)realloc(iobuffer, byte_in_diskbuffer + diff);
		  
	       log(LOG_DEBUG, "data socket: realloc done to get %d additional bytes, buffer 0X%X\n", diff, iobuffer);
	       if (iobuffer == NULL)  {
		  log(LOG_ERR, "realloc failed: %s\n", sys_errlist[errno]);
		  return -1 ;
	       }
	       iobuffer_p = iobuffer + byte_in_diskbuffer;
#if defined(HPSS)
	       iobufsiz = byte_in_diskbuffer + diff;
#endif /* HPSS */
	    } /* buffer reallocation was necessary */
	      
	    log(LOG_DEBUG, "data socket: reading residu %d bytes\n", diff) ;
	    if( (n = netread(data_sock, iobuffer_p, diff)) != diff )  {
	       if (n == 0)   {
		  errno = ECONNRESET;
#if defined(_WIN32)
		  log(LOG_ERR, "read ctrl socket: netread(): %s\n", ws_strerr(errno));
#else		 
		  log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif	/* WIN32 */
		  return -1;
	       }  else  {
#if defined(_WIN32)
		  log(LOG_ERR, "read data residu socket: netread(): %s\n", geterr());
#else		  
		  log(LOG_ERR, "read data residu socket: read(): %s\n", sys_errlist[errno]);
#endif
		  return -1 ;
	       }
	    }
	    byte_read_from_network += diff;
	    byte_in_diskbuffer += diff;
	    /*
	     * Writing data on disk.
	     */
	      
	    log(LOG_DEBUG, "writing %d bytes on disk\n",byte_in_diskbuffer) ;
#if defined(HPSS)
	    status = rhpss_write(fd, iobuffer, byte_in_diskbuffer, s, 0,0);
#else /* HPSS */
	    status = write(fd, iobuffer, byte_in_diskbuffer);
#endif /* HPSS */
	    rcode = (status<0) ? errno:0;
	      
	    if (status < 0)  {
	       p = rqstbuf;
	       marshall_WORD(p, REP_ERROR);			
	       marshall_LONG(p, status);
	       marshall_LONG(p, rcode);
	       log(LOG_DEBUG, "rwrite_v3: status %d, rcode %d\n", status, rcode);
	       errno = ECONNRESET;
	       if( (n = netwrite(s, rqstbuf, RQSTSIZE)) != RQSTSIZE )  {
#if defined(_WIN32)
		  log(LOG_ERR, "rwrite_v3: write(): %s\n", ws_strerr(errno));
#else		  
		  log(LOG_ERR, "rwrite_v3: write(): %s\n", sys_errlist[errno]) ;
#endif
		  return -1 ; 
	       }
	       /* No deadlock possible here since all the data sent by the client
		  using the data socket has been read at this point */

	       log(LOG_DEBUG, "rwrite_v3: waiting ack for error\n");
	       if ((n = netread(ctrl_sock,rqstbuf,RQSTSIZE)) != RQSTSIZE) {
		  if (n == 0)  {
		     errno = ECONNRESET;
#if defined(_WIN32)
		     log(LOG_ERR, "read ctrl socket: read(): %s\n", ws_strerr(errno));
#else
		     log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif	/* WIN32 */		     
		     return -1;
		  }  else  {
#if defined(_WIN32)
		     log(LOG_ERR, "read ctrl socket: read(): %s\n", geterr());
#else		     
		     log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif	/* WIN32 */	
		     return -1 ;
		  }
	       }
	    }  else   {
	       myinfo.wnbr += byte_in_diskbuffer;
	       myinfo.writop++;
	       byte_in_diskbuffer = 0;
	       iobuffer_p = iobuffer;
	    }
#if !defined(HPSS)
	    log(LOG_DEBUG,"freeing iobuffer at 0X%X\n", iobuffer) ;
	    free(iobuffer);
#endif /* HPSS */
	    srclose_v3(ctrl_sock, &myinfo, fd);
	    return 0;
	 }
      }
      
      
      if (FD_ISSET(data_sock,&fdvar))
      {
	 int n,can_be_read;
	 
	 log(LOG_DEBUG,"iobuffer_p = %X\n",iobuffer_p);
#if defined(_WIN32)
	 n = recv(data_sock, iobuffer_p, DISKBUFSIZE_WRITE-byte_in_diskbuffer, 0);
	 if( (n == 0) || n == SOCKET_ERROR )
#else	    
	 if( (n = read(data_sock, iobuffer_p, DISKBUFSIZE_WRITE-byte_in_diskbuffer)) <= 0 )
#endif
	 {
	    if (n == 0)  {
	       errno = ECONNRESET;
#if defined(_WIN32)
	       log(LOG_ERR, "read ctrl socket: recv(): %s\n", ws_strerr(errno));
#else
	       log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif 	/* WIN32 */	       
	       return -1;
	    }  else  {
#if defined(_WIN32)
	       log(LOG_DEBUG, "read data socket: recv(): %s\n", geterr());
#else	       
	       log(LOG_DEBUG, "read data socket: read(): %s\n", sys_errlist[errno]);
#endif
	       return -1 ;
	    }
	 }  else  { 
	    can_be_read = n;
	    log(LOG_DEBUG, "read data socket : %d bytes\n", can_be_read);
	 }
	  
	 byte_read_from_network += can_be_read;
	 byte_in_diskbuffer += can_be_read;
	 iobuffer_p += can_be_read;
 
	 /*
	  * Writing data on disk.
	  */
	  
	 if (byte_in_diskbuffer == DISKBUFSIZE_WRITE)  {
	    log(LOG_DEBUG, "writing %d bytes on disk\n", byte_in_diskbuffer);
#if defined(HPSS)
	    status = rhpss_write(fd, iobuffer, byte_in_diskbuffer, s, 0,0);
#else /* HPSS */
	    status = write(fd, iobuffer, byte_in_diskbuffer);
#endif /* HPSS */
	    rcode = (status < 0) ? errno:0;
	      
	    if (status < 0)  {
	       p = rqstbuf;
	       marshall_WORD(p, REP_ERROR);			
	       marshall_LONG(p, status);
	       marshall_LONG(p, rcode);
	       log(LOG_ERR, "rwrite_v3: status %d (%s), rcode %d\n", status,sys_errlist[errno], rcode) ;
	       errno = ECONNRESET;
	       if ((n = netwrite(s,rqstbuf,RQSTSIZE)) != RQSTSIZE)  {
#if defined(_WIN32)
		  log(LOG_ERR, "rwrite_v3: write(): %s\n", ws_strerr(errno));
#else		  
		  log(LOG_ERR, "rwrite_v3: write(): %s\n", sys_errlist[errno]) ;
#endif
		  return -1 ; 
	       }

	       /* 
		  There is a potential deadlock here since the client may be stuck
		  in netwrite (cf rfio_write_v3), trying to write data on the data 
		  socket while both socket buffers (client + server) are full.
		  To avoid this problem, we empty the data socket while waiting
		  for the ack to be received on the control socket
		  */

	       while (1)  {
		  FD_ZERO(&fdvar2);
		  FD_SET(ctrl_sock,&fdvar2);
		  FD_SET(data_sock,&fdvar2);
		      
		  t.tv_sec = 1;
		  t.tv_usec = 0;
		      
		  log(LOG_DEBUG,"rwrite_v3: doing select after error writing on disk\n") ;
#if defined(_WIN32)
		  if( select(FD_SETSIZE, &fdvar2, NULL, NULL, &t) == SOCKET_ERROR ) 
#else
		  if( select(FD_SETSIZE, &fdvar2, NULL, NULL, &t) < 0 )
#endif
		  {
#if defined(_WIN32)
		     errno = WSAGetLastError();
#endif
		     TRACE(2,"rfio","rwrite_v3: select fdvar2 failed (errno=%d)",errno) ;
		     END_TRACE();
		     return -1 ;
		  }
		      
		  if( FD_ISSET(ctrl_sock, &fdvar2) )  {
		     /* The ack has been received on the control socket */
			  
		     log(LOG_DEBUG, "rwrite_v3: waiting ack for error\n");
		     if ((n = netread(ctrl_sock, rqstbuf, RQSTSIZE)) != RQSTSIZE)  {
			if (n == 0)  {
			   errno = ECONNRESET;
#if defined(_WIN32)
			   log(LOG_ERR, "read ctrl socket: read(): %s\n", ws_strerr(errno));  
#else			   
			   log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif			   
			   return -1;
			}  else  {
#if defined(_WIN32)
			   log(LOG_ERR, "read ctrl socket: read(): %s\n", geterr()); 
#else	
			   log(LOG_ERR, "read ctrl socket: read(): %s\n", sys_errlist[errno]);
#endif			   
			   return -1 ;
			}
		     }  else  {
#if !defined(HPSS)
			log(LOG_DEBUG,"freeing iobuffer at 0X%X\n",iobuffer) ;
			free(iobuffer);
#endif /* HPSS */
			/* srclose_v3(ctrl_sock,&myinfo,fd); */
			return 0;
		     }
		  }

		  if (FD_ISSET(data_sock,&fdvar2))  {
#if defined(HPSS)
		    /*
		     * To avoid overflowing the local thread stack we must
		     * put dummy on heap
		     */
		     sizeofdummy = 256 * 1024;
		     dummy = (unsigned char *)malloc(sizeof(unsigned char) * sizeofdummy);
#else /* HPSS */
		     unsigned char dummy[256 * 1024];
#endif /* HPSS */
		     /* Read as much data as possible from the data socket */
			  
		     log(LOG_DEBUG, "rwrite_v3: emptying data socket (last disk write)\n");
#if defined(_WIN32)
		     n = recv(data_sock, dummy, sizeof(dummy), 0);
		     if( (n == 0) || (n == SOCKET_ERROR) ) 
#else
#if defined(HPSS)
		     n = read(data_sock, dummy, sizeofdummy);
		     if ( n <= 0 )
#else /* HPSS */
		     n = read(data_sock, dummy, sizeof(dummy));
		     if( n <= 0 )
#endif /* HPSS */
#endif  /* WIN32 */
		     {
#if defined(HPSS)
		        (void) free(dummy);
#endif /* HPSS */
			if (n == 0)  {
			   errno = ECONNRESET;
#if defined(_WIN32)
			   log(LOG_ERR, "read emptying data socket: recv(): %s\n", ws_strerr(errno));
#else			   
			   log(LOG_ERR, "read emptying data socket: read(): %s\n", sys_errlist[errno]);
#endif	/* WIN32 */
			   return -1;
			}  else	{
#if defined(_WIN32)
			   log(LOG_ERR, "read emptying data socket: recv(): %s\n", geterr());
#else			   
			   log(LOG_ERR, "read emptying data socket: read(): %s\n", sys_errlist[errno]);
#endif
			   return -1 ;
			}
		     }
#if defined(HPSS)
		     (void) free(dummy);
#endif /* HPSS */
		  }
	       }
	    }  else  {
	       myinfo.wnbr += byte_in_diskbuffer;
	       myinfo.writop++;
	       byte_in_diskbuffer = 0;
	       iobuffer_p = iobuffer;
	    }
	 }
      }
   }
}

