/*
 * Copyright (C) 1990-1999 by CERN/IT/PDP/IP
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)rfio_serv.c	3.60 09/06/99 CERN IT-PDP/IP Frederic Hemmer";
#endif /* not lint */

/* rfio_serv.c  SHIFT remote file access super server                   */

#define RFIO_KERNEL     1               /* KERNEL part of the programs  */

#include "rfio.h"                       /* Remote file I/O              */
#include <signal.h>			/* Signal handling		*/
#if defined(_WIN32)
#include "syslog.h"
#include "log.h"
#else
#include <syslog.h>			/* System logger		*/
#include <log.h>                        /* Genralized error logger      */
#endif

#if defined(SACCT)
#include <sacct.h>                      /* SHIFT accounting             */
#endif /* SACCT */

#if !defined(_WIN32)
#include <sys/param.h>                  /* System parameters            */
#endif
#if defined(sun) || defined(ultrix) || defined(_AIX)
#include <sys/wait.h>			/* wait, wait3, wait4 (BSD)	*/
#include <sgtty.h>			/* Terminal ioctl's		*/
#include <sys/time.h>                   /* time definitions             */
#include <sys/resource.h>               /* resources usage definitions  */
#ifndef sun
#include <sys/termio.h>                 /* tty ioctl()'s                */
#endif
#endif /* sun || ultrix || _AIX */
#if ( defined(__osf__) && defined(__alpha) )
#include <sys/ioctl.h>
#endif
#if defined(sgi)
#include <sys/types.h>                  /* System Types and Macros      */
#include <sys/termio.h>                 /* tty ioctl()'s                */
#include <sys/prctl.h>                  /* Process data area defs.      */
#include <sys/schedctl.h>               /* Scheduling definitions       */
#endif /* sgi */

#if defined(_WIN32)
#include <winsock2.h>
#else
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#if ( defined(__osf__) && defined(__alpha) ) || defined(linux)
#include <sys/types.h>
#include <sys/wait.h>                   /* wait, wait3, wait4 (BSD)     */
#endif /* __alpha ** __osf__ || linux */

#if defined(HPSS)
#include <dirent.h>
#include <dce/pthread.h>
#include <rfio_hpss.h>
/*
 * some globals set by getconfent and therefore must go to main thread
 */
char *rtuser = NULL;
char *keepalive = NULL;
int DISKBUFSIZE_READ =  262144;
int DISKBUFSIZE_WRITE = 262144;
struct global_defs global[FD_SETSIZE];
/*
 * important constants
 */
const char PrincipalName[] = RFIO_PRINCIPAL;
const char KeyTabFile[] = RFIO_KEYTAB;
#endif /* HPSS */

#if !defined(_WIN32)
extern char     *malloc();		/* Some systems forget this	*/
#endif

#ifndef linux
extern char     *sys_errlist[];         /* External error list          */
#endif

#define SO_BUFSIZE      20*1024         /* Default socket buffer size   */

extern FILE 	*srpopen();		/* server remote popen() 	*/
extern int      sropen();               /* server remote open()         */
extern int      srclose();              /* server remote close()        */
extern int      srwrite();              /* server remote write()        */
extern int      srread();               /* server remote read()         */
extern int	srreadahead();		/* server remote read() ahead	*/
extern int	srlseek();		/* server remote lseek()	*/
extern int	srpreseek();		/* server remote preseek()	*/
extern int      srstat();               /* server remote stat()         */
extern int      srfstat();              /* server remote fstat()        */
extern int 	srlstat() ;		/* server remote lstat()	*/
extern void     serrmsg();              /* server remote errmsg()       */
extern int      srrequest();            /* server read request          */
extern int	srmkdir();              /* server remote mkdir()        */
extern int      srrmdir();              /* server remote rmdir()        */
extern int	srrename();		/* server remote rename()	*/
extern int	srlockf();		/* server remote lockf()	*/
extern int      srchmod();              /* server remote chmod()        */
#if !defined(_WIN32)
extern int      srchown();              /* server remote chown()        */
extern DIR     *sropendir();            /* server remote opendir()      */
extern int      srreaddir();            /* server remote readdir()      */
extern int      srrewinddir();          /* server remote rewinddir()    */
extern int      srclosedir();           /* server remote closedir()     */
#endif
#if defined(FORTRAN)
extern int      srxyopen();             /* server remote xyopen()       */
extern int      srxyclos();             /* server remote xyclos()       */
extern int      srxywrit();             /* server remote xywrit()       */
extern int      srxyread();             /* server remote xyread()       */
#endif /* FORTRAN */
extern int      setnetio();             /* set network characteristics  */

#if defined(HPSS)
extern int      srreadlist();
extern int      srwritelist();
extern int      srsetcos();
#endif /* HPSS */

#if defined(_WIN32)
extern int	standalone;
extern char	logfile[128]; 
extern char 	*argv0;
#else
static int      standalone=0;   /* standalone flag                      */
static char     logfile[128];   /* log file name buffer                 */
#endif

FILE 	*streamf ;	/* FILE pointer for popen() calls	*/

int     doit();                 /* doit() forward reference             */
#if defined(sun) || defined(ultrix) || defined(_AIX) || ( defined(__alpha) && defined(__osf__)) || defined(linux)
void    reaper();               /* reaper() forward reference           */
#endif /* sun || ultrix || AIX || __alpha && __osf__ || linux */

#ifndef WTERMSIG
#define WTERMSIG(x)     (((union wait *)&(x))->w_termsig)
#endif /* WTERMSIG */
#ifndef WSTOPSIG
#define WSTOPSIG(x)     (((union wait *)&(x))->w_stopsig)
#endif /* WSTOPSIG */

static int setsock_ceiling = 256 * 1024;
int max_rcvbuf;
int max_sndbuf;


#if defined(_WIN32) 	/* WIN32 version with multithread support */
#define MAX_THREADS	64	/*  */

struct thData  {	
  SOCKET ns;    	/* control socket */
  struct sockaddr_in from;
  int mode;
  int _is_remote;

  int fd;
/* all globals, which have to be local for thread */
  char *rqstbuf;        /* Request buffer		*/
  char *filename;        /* file name            	*/  
  char *iobuffer; 		/* Data communication buffer    */
  int  iobufsiz;		/* Current io buffer size       */
  SOCKET data_s;     	/* Data listen socket (v3) */
  SOCKET data_sock;  	/* Data accept socket (v3) */
  SOCKET ctrl_sock;  	/* the control socket (v3) */
  int first_write;
  int first_read;
  int byte_read_from_network;
  struct rfiostat myinfo;
  char	from_host[MAXHOSTNAMELEN];
} *td;

DWORD 	tls_i;			 	/* Thread local storage index 	*/
int mt_doit(void **); 
int mt_cleanup(struct thData *, int *, int); 
extern void rfiod_stop();		/* Stops the service rfiod	*/
#endif	/* WIN32 */

#if defined(_WIN32)
rfiod()
#else
main (argc,argv)
int     argc;
char    **argv;
#endif
{
   extern int      opterr, optind;         /* required by getopt(3)*/
   extern char     *optarg;                /* required by getopt(3)*/
#if !defined(_WIN32)
   register int    option;
#endif
   int  loglevel = LOG_INFO; 	  /* Default log level    */
   int	debug = 0;                /* Debug flag           */
   int 	port = 0;                 /* Non-standard port    */
   int 	logging = 0;              /* Default not to log   */
   int 	singlethread = 0;         /* Single threaded      */
   int 	lfname = 0;               /* log file given       */   
#if defined(_WIN32)
   register SOCKET      s, ns;
#else
   register int		s, ns;
#endif
   int    i, pid;
   struct servent  *sp;
   struct sockaddr_in sin, from;
   int             fromlen;
   char     localhost[MAXHOSTNAMELEN];     /* Local host name      */
   int             mode;
   register int    maxfds=0;               /* max. # of file descr.*/
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
   struct sigvec   sv;
#endif
#if (defined(__osf__) && defined(__alpha)) || defined (SOLARIS) || defined(linux)
   struct sigaction sa;
#endif
#if defined(_WIN32)
   WSADATA 	wsadata;
   int 	rcode;
   struct thData *td;
   struct hostent *hp;
/*   char *p; */
#endif
#if defined(HPSS)
   char privhosts[MAX_PRIVHOST_LEN];
   int nb_threads = 0;
   struct rfio_threadData *threadData;
   extern char *rtuser;
   extern char *keepalive;
   extern int DISKBUFSIZE_READ;
   extern int DISKBUFSIZE_WRITE;
#endif

   strcpy(logfile, "syslog"); /* default logfile */
   opterr++;

#if defined(_WIN32)
   openlog("rfiod", loglevel, LOG_DAEMON);
   rcode = WSAStartup(MAKEWORD(2, 0), &wsadata);	/* initialization of WinSock DLL */
   if( rcode )  {	
      log(LOG_ERR, "WSAStartup: %s\n", ws_strerr(rcode));
      rfiod_stop();
   }
   tls_i = TlsAlloc(); 				/* allocation of thread local storage */
   if( tls_i == 0xFFFFFFFF )  {			/* TLS allocation error		*/
      log(LOG_ERR, "TlsAlloc() failed, errno=%d", GetLastError());
      WSACleanup();
      rfiod_stop();
   }
#endif /* if WIN32 */
#if !defined(_WIN32)
   while ((option = getopt(argc,argv,"sdltf:p:")) != EOF)        {
      switch (option) {
       case 'd': debug++;
	  break;
       case 's': standalone++;
	  break;
       case 'f':
	  lfname++;
	  strcpy(logfile,optarg);
	  break;
       case 'l':
	  logging++;
	  break;
       case 't':
	  singlethread++;
	  break;
       case 'p':
	  port=atoi(optarg);
	  break;
      }
   }
#endif	/* WIN32 */   
   if (debug)      {
      loglevel = LOG_DEBUG;
   }
   if (logging && !lfname)  {
      strcpy(logfile, LOGFILE);
   }
   if (!(strcmp(logfile,"stderr")))       {
      strcpy(logfile,"");
   }
   max_rcvbuf = setsock_ceiling;
   max_sndbuf = setsock_ceiling;

   if (standalone) {
/*
 * Trap SIGCLD, SIGCHLD
 */
#if ( defined(__osf__) && defined(__alpha) ) || defined (SOLARIS) || defined(linux)
      sa.sa_handler = reaper;
      sa.sa_flags = SA_RESTART;
      sigaction (SIGCHLD, &sa, NULL);
#if ( defined(__osf__) && defined(__alpha) ) || defined (SOLARIS)
      sigignore(SIGHUP);
#endif
#endif /* __osf__ && __alpha  || SOLARIS || linux */
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
      sv.sv_mask = sigmask(SIGCHLD)|sigmask(SIGHUP)|sigmask(SIGALRM);
      sv.sv_handler = reaper;
      sigvec(SIGCHLD, &sv, (struct sigvec *)0);
#endif /* sun || ultrix || AIX */
#if defined(CRAY) || defined(sgi) || defined(hpux)
/* FH */ /* Should trap SIGCLD for kid status */
      if (signal(SIGCLD, SIG_IGN) == SIG_ERR) {
	 perror("signal (SIGCLD)");
	 exit(1);
      }
#endif /* CRAY || sgi || hpux */

#if !( defined(CRAY) || defined(sgi) || defined(hpux) || defined(SOLARIS) || defined(_WIN32))
      maxfds=getdtablesize();
#else 
      maxfds=_NFILE;
#endif 

/*
 * disassociate controlling terminal
 */
#if !defined(_WIN32)      
      if (!debug)     {
	 for (i=0; i< maxfds; i++) (void) close(i);

#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX) || defined(sgi) ||  ( defined(__osf__) && defined(__alpha) )
	 (void) open("/dev/null", O_RDONLY);
	 dup2(0,1);
	 dup2(0,2);
	 i = open("/dev/tty", O_RDWR);
	 if (i>0)        {
	    ioctl(i, TIOCNOTTY, 0);
	    close(i);
	 }
#endif /* sun || ultrix || _AIX || sgi */

/*
 * Finally fork ourselves
 */
	 pid = fork();
	 if (pid == -1)   {
	    perror("main fork");
	    exit(1);
	 }
	 if (pid > 0) exit(0);
#if HPUX10
	 setpgrp3();
#else
#if __Lynx__
	 setpgrp(0, getpid());
#else
	 setpgrp();
#endif
#endif
      } /* if( !debug */
#endif  /* not WIN32 */

      (void) initlog("rfiod", loglevel, logfile);
#if defined(__DATE__) && defined (__TIME__)
#if defined(_WIN32)
      log(LOG_ERR, "%s generated on %s %s\n", argv0, __DATE__, __TIME__);
#else
      log(LOG_ERR, "%s generated on %s %s\n",argv[0],__DATE__,__TIME__);
#endif	/* WIN32 */      
#else
      log(LOG_ERR, "%s\n", argv[0]);
#endif /* __DATE__ && __TIME__ */

#if defined(SACCT)
          rfioacct(RFIODSTART,0,0,-1,0,0,0,0,NULL,NULL,NULL);
#endif /* SACCT */

      
      if( gethostname(localhost, sizeof(localhost)) )   {
#if defined(_WIN32)
	 log(LOG_ERR, "gethostname(): %s\n", geterr());
	 rfiod_stop();
#else	 
	 log(LOG_ERR, "gethostname(): %s\n",sys_errlist[errno]);
	 exit(1);
#endif
      }
      log(LOG_ERR, "starting on %s\n", localhost);

#if defined(HPSS)
      /*
       * Initialize HPSS.
       */
      rhpss_init(PrincipalName,KeyTabFile,privhosts,&threadData,&nb_threads);
      log(LOG_ERR, "HPSS initialized: principal=%s, keytabfile=%s, threadpool=%d\n",
	  PrincipalName,KeyTabFile,nb_threads);
#endif /* HPSS */
      
#if defined(_WIN32)
      if( (s = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET )  {
	 log(LOG_ERR, "socket(): %s\n", geterr());
	 WSACleanup();
	 TlsFree(tls_i);
	 rfiod_stop();
      }
#else      
      if( (s = socket(AF_INET, SOCK_STREAM, 0)) < 0)  {
	 log(LOG_ERR, "socket(): %s\n",sys_errlist[errno]);
	 exit(1);
      }
#endif	/* WIN32 */
      if (!port)       {
	 sp = getservbyname("rfio", "tcp");
	 if (sp == NULL) {
	    log(LOG_ERR, "rfio/tcp: no such service\n");
	    serrno = SENOSSERV;
	    log(LOG_ERR, "rfio/tcp: %s\n", sys_serrlist[SERRNO]);
#if defined(_WIN32)
	    rfiod_stop();
#else	    
	    exit(1);
#endif	/* WIN32 */	    
	 }
	 sin.sin_port = sp->s_port;
      }
      else    {
	 sin.sin_port = htons(port);
      }
      sin.sin_addr.s_addr = htonl(INADDR_ANY);
      sin.sin_family = AF_INET;
      { int bool = 1; setsockopt (s, SOL_SOCKET, SO_REUSEADDR,
				  (char *)&bool, sizeof(bool)); }	/* Re-usable port */
#if defined(_WIN32)
      if( bind(s, (struct sockaddr*)&sin, sizeof(sin)) == SOCKET_ERROR )  {
	 log(LOG_ERR, "bind(): %s\n", geterr());
	 WSACleanup();
	 TlsFree(tls_i);
	 rfiod_stop();
      }
#else	 
      if( bind(s, (struct sockaddr*)&sin, sizeof(sin)) < 0 )  {
	 log(LOG_ERR, "bind(): %s\n",sys_errlist[errno]);
	 exit(1);
      }
#endif
      listen(s, 5);

      max_rcvbuf = setsock_ceiling;
      max_sndbuf = setsock_ceiling;

      for (i = setsock_ceiling ; i >= 16 * 1024 ; i >>= 1)  {
	 if (set_rcv_sockparam(s, i) == i)  {
	    max_rcvbuf = i;
	    break;
	 }
      }
      for (i = setsock_ceiling ; i >= 16 * 1024 ; i >>= 1)  {
	 if (set_snd_sockparam(s,i) == i)  {
	    max_sndbuf = i;
	    break;
	 }
      } 
		    
      log(LOG_DEBUG,"setsockopt maxsnd=%d, maxrcv=%d\n", max_sndbuf, max_rcvbuf);

      for (;;) {
	 fromlen = sizeof(from);
	 ns = accept(s, (struct sockaddr *)&from, &fromlen);
#if defined(_WIN32)
	 if( ns == INVALID_SOCKET )  {
	    if (errno != EINTR) {
	       log(LOG_ERR, "accept(): %s\n", geterr());
	       WSACleanup();
	       TlsFree(tls_i);
	       rfiod_stop();
	    }
	    log(LOG_DEBUG, "accept(): %s\n", geterr());
	    continue;
	 }
#else	 
	 if( ns < 0 )   {
	    if (errno != EINTR) {
	       log(LOG_ERR, "accept(): %s\n", sys_errlist[errno]);
	       exit(1);
	    }
	    log(LOG_DEBUG, "accept(): %s\n",sys_errlist[errno]);
	    continue;
	 }
#endif	/* WIN32 */
	 log(LOG_DEBUG, "accepting requests\n");
#if defined(_WIN32)
	 if( getpeername(ns, (struct sockaddr*)&from, &fromlen) == SOCKET_ERROR )  {
	    log(LOG_ERR, "getpeername: %s\n", geterr());
	    (void) closesocket(ns);
	    continue;
	 }
#else	 
	 if( getpeername(ns, (struct sockaddr*)&from, &fromlen) < 0 )  {
	    log(LOG_ERR, "getpeername: %s\n",sys_errlist[errno]);
	    (void) close(ns);
	    continue;
	 }
#endif
	 if (!singlethread)      {
#if defined(HPSS)
	    if ( rhpss_startreq(ns,&from,fromlen,privhosts,threadData,nb_threads) ) {
	      shutdown(ns,2);
	      close(ns);
	    }
	    continue;
#endif /* HPSS */
#if defined(_WIN32)
	    td = (struct thData*)malloc(sizeof(struct thData));
	    if( td == NULL )  {
		  log(LOG_ERR, "Error allocating thread data pointer, errno=%d", errno);
		  closesocket(ns);
		  closesocket(s);
		  TlsFree(tls_i);
		  WSACleanup();
		  rfiod_stop();
	       }
	       td->ns = ns;
	       memcpy(&(td->from), (void*)&from, sizeof(from)); 
	       td->mode = 1; 	
	       td->_is_remote = 0;
	       if( (hp = gethostbyaddr((char*)(&(from.sin_addr)), sizeof(struct in_addr),
				       from.sin_family)) == NULL )  {
		  strcpy(td->from_host, (char*)inet_ntoa(from.sin_addr));
		  log(LOG_INFO, "connection from %s\n", inet_ntoa(from.sin_addr));
	       } else  {
		  strcpy(td->from_host, hp->h_name);
		  log(LOG_INFO, "connection from %s\n", hp->h_name);
	       }
   /*
    * Detect whether client is in or out of site
    */
	       if( isremote(from.sin_addr, td->from_host) ) 
		  td->_is_remote++;
	       pid = _beginthread(mt_doit, 0, (void*)td ); 
	       if( pid == -1 )	{
		  log(LOG_ERR, "_beginthread: %s\n", sys_errlist[errno]);
		  closesocket(ns);
	       }
#else
	       pid = fork();
	       switch (pid)    {
		case -1:
		   log(LOG_ERR,"fork(): %s \n",sys_errlist[errno]);
		   close(ns);
		   exit(1);
		case 0:                         /* Child                */
		   close(s);
		   mode = 0;
		   doit(ns, &from, mode);
		   break;
	       }
	       close(ns);                      /* Parent */
#endif	/* WIN32 */  
	 }   else    {	/* singlethread */
	    mode = 1;
	    doit(ns, &from, mode);
	 }
      }
   }
   else    {       /* !standalone */

#if defined(_WIN32)
      openlog("rfiod", loglevel, LOG_DAEMON);
#endif      
      (void) initlog("rfiod", loglevel, logfile);
      fromlen = sizeof(from);
      log(LOG_DEBUG, "accepting requests\n");
#if defined(_WIN32)
      if( getpeername(0, (struct sockaddr*)&from, &fromlen) == INVALID_SOCKET)  {
	 log(LOG_ERR, "getpeername: %s\n", geterr());
	 WSACleanup();
	 TlsFree(tls_i);
	 rfiod_stop();
      }
#else      
      if (getpeername(0,(struct sockaddr *)&from, &fromlen)<0)        {
	 log(LOG_ERR, "getpeername: %s\n",sys_errlist[errno]);
	 exit(1);
      }
#endif      
#if defined(_AIX) && defined(_IBMESA)
      if ( setluid (0) == -1 ) {
	 log(LOG_ERR, "setluid: %s\n",sys_errlist[errno]);
	 exit(1);
      }
#endif
      mode = 0;
      doit(0, &from, mode);
   }
#if defined(_WIN32)
   WSACleanup();
   TlsFree(tls_i);
#endif
   exit(0);
}


#if  ( defined(__osf__) && defined(__alpha) ) || defined(SOLARIS) || defined(linux)
void reaper(dummy)
int dummy;
{
   int status ;
   pid_t pid ;
   while ( (pid=waitpid(-1,&status,WNOHANG)) > 0) 
      log(LOG_ERR,"Waiting for end of child %d\n",pid);
}
#endif /* __osf__ && __alpha || SOLARIS || linux */


#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
void reaper()
{
#if !defined(_AIX)
   union wait      status;
#else
   int             status;
#endif /* _AIX */
   int             pid;
   for (;;)        {
      pid = wait3(&status, WNOHANG, (struct rusage *)0);
      if (pid <=0)    break;
      log(LOG_DEBUG," %d reaped\n", pid);
      if (WIFSIGNALED(status))        {
	 log(LOG_ERR, "%d signaled by signal %d\n",pid, WTERMSIG(status));
      }
      if (WIFSTOPPED(status))        {
	 log(LOG_ERR, "%d stopped by signal %d\n",pid, WSTOPSIG(status));
      }
   }
}
#endif /* sun || ultrix || _AIX */
#if defined(sgi) || defined(hpux)
void reaper()
{
   int status;

   wait (&status);
}
#endif  /* sgi || hpux */

#if defined(_WIN32)
mt_doit( void **ptr )  	/* Wrapper for doit() */
{
   int rcode;   
   struct thData *td = (struct thData*)ptr;

   td->rqstbuf = (char*)malloc(BUFSIZ);
     if( td->rqstbuf == NULL ) {
     log(LOG_ERR, "Error allocating td->rqstbuf, errno=%d", errno);
     rfiod_stop();
   }
   td->filename = (char*)malloc(MAXFILENAMSIZE);
   if( td->filename == NULL ) {
      log(LOG_ERR, "Error allocating td->filename, errno=%d", errno);
      rfiod_stop();
   }
   rcode = TlsSetValue(tls_i, (LPVOID)td);
   if( rcode == 0 )  {
      log(LOG_ERR, "TlsSetValue: errno=%d", GetLastError() );
      rfiod_stop();
   }
   
   rcode = doit( td->ns, td->from, td->mode );
   return (rcode);
}

int mt_cleanup(struct thData *td, int *fd, int rcode)
{  
   if( *fd >= 0 )
      close(*fd);
   *fd = -1;

   if( rcode > 0 ) {
      log(LOG_INFO, "mt_cleanup: closing control socket %d", td->ns);
      shutdown(td->ns, SD_BOTH);
      closesocket(td->ns);
   }
   free(td->rqstbuf);
   free(td->filename);
   log(LOG_INFO, "mt_cleanup: freeing thread data pointer at 0X%X", td);
   free(td);

   return rcode;
}
#endif

doit(s, fromp, mode)
#if defined(_WIN32) 
SOCKET  s;
#else
int 	s;
#endif
struct sockaddr_in *fromp;
{
   int     request, status;
   int     fd;
#if !defined(_WIN32)
   DIR     *dirp = NULL;
   struct  hostent *hp;
#endif	
   int     lun;
   int     access;
   struct rfiostat info;
#if !defined(HPSS)
   int 	is_remote = 0;	/* Is requestor in another site ? */
   char 	from_host[MAXHOSTNAMELEN]; /* Where the request comes from   */
#endif /* HPSS */
   char    * p1 ;
#if defined(sgi)
   register int    ndpri;
#endif /* sgi */

#if defined(HPSS)
   extern char *keepalive;
   extern struct global_defs global[FD_SETSIZE];
#endif /* HPSS */
   
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
   struct sigvec   sv;
#endif
#if (defined(__osf__) && defined(__alpha)) || defined(linux)
   struct sigaction sa;
#endif

#if defined(_WIN32)
   struct thData 	*td;
   td = (struct thData*)TlsGetValue(tls_i);
#endif 	/* WIN32 */  
   
   /*
    * Initializing the info data structure.
    */
   info.readop= 0 ; 
   info.writop= 0 ; 
   info.flusop= 0 ; 
   info.statop= 0 ; 
   info.seekop= 0 ; 
   info.presop= 0 ; 
   info.aheadop=0 ; 
   info.mkdiop= 0 ; 
   info.renaop= 0 ;
   info.lockop= 0 ;
   info.rnbr= 0 ; 
   info.wnbr= 0 ; 
   /*
    * Use to solve an UltraNet bug
    */
#if !defined(_WIN32) && !defined(HPSS)
   if (setnetio(s) <0)     {
      shutdown(s, 2);
      close(s);
      exit(1);
   }
#endif /* _WIN32 && HPSS */
   
#if defined(HPSS)
   if ( keepalive != NULL && !strcmp(keepalive,"YES") ) {
#else /* HPSS */
   if ( (p1 = getconfent("RFIOD","KEEPALIVE",0)) != NULL && !strcmp(p1,"YES") )   {
#endif /* HPSS */
      if (setsockopt(s, SOL_SOCKET, SO_KEEPALIVE,(char *)&access, sizeof (int) ) == -1) {
	 log(LOG_ERR,"setsockopt(SO_KEEPALIVE) failed");
      }
      /*
       * Trap SIGPIPE
       */
#if defined(CRAY) || defined(sgi) || defined(hpux) || defined(SOLARIS)
      (void) signal(SIGPIPE,reaper) ;
#endif /* CRAY || sgi || hpux || SOLARIS */
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_AIX)
      sv.sv_mask = sigmask(SIGCHLD)|sigmask(SIGHUP)|sigmask(SIGALRM);
      sv.sv_handler = reaper;
      sigvec(SIGPIPE, &sv, (struct sigvec *)0);
#endif /* sun || ultrix || AIX */
#if ( defined(__osf__) && defined(__alpha) ) || defined(linux)
      sa.sa_handler = reaper;
      sa.sa_flags = SA_RESTART;
      sigaction (SIGPIPE, &sa, NULL);
#endif /* __osf__ && __alpha || linux */

   }
#if !defined(_WIN32)
   else {
      /*
       * Ignoring SIGPIPE signal.
       */	   
      (void) signal(SIGPIPE,SIG_IGN) ;
   }
#endif
   /*
    * Getting the client host name.
    */
#if !defined(HPSS)
#if !defined(_WIN32)   
   if ((hp =  gethostbyaddr((char *)(&fromp->sin_addr), sizeof(struct in_addr),
			    fromp->sin_family)) == NULL)  {
      strcpy(from_host,(char *)inet_ntoa(fromp->sin_addr));
      log(LOG_INFO, "connection from %s\n", inet_ntoa(fromp->sin_addr));
   }
   else    {
      strcpy(from_host,hp->h_name);
      log(LOG_INFO, "connection from %s\n", hp->h_name);
   }
   /*
    * Detect wether client is in or out of site
    */
   if ( isremote(fromp->sin_addr,from_host) ) 
      is_remote++;
#else
   strcpy(from_host, td->from_host);
   is_remote = td->_is_remote;
#endif /* WIN32 */   
#endif /* HPSS */
   /*
    * Setting read timeout to 2 hours.
    * Disabled for now
    */
   /* (void) setrtimo(60*60*2) ;	*/
   /*
    * Locking program in memory and setting a non degrading
    * priority if specified in the configuration file.
    */
#if defined(sgi)
   if ((p1 = getconfent("RFIO","RESIDENT",0)) != NULL)     {
      if ( !strcmp(p1,"1") ) {
	 /* 
	  * Lock program in memory
	  */
	 if ( prctl(PR_RESIDENT) < 0) 
	    log(LOG_INFO,"prctl(PR_RESIDENT): %s\n",sys_errlist[errno]) ;
	 else 
	    log(LOG_INFO,"Daemon locked\n");
      }
   }
   if ((p1 = getconfent("RFIO","NDPRIORITY",0)) != NULL) {
      ndpri= atoi(p1) ;
      if ((ndpri < NDPHIMAX) || (ndpri > NDPLOMIN)) 
	 log(LOG_INFO,"Invalid non-degrading priority: %d\n",ndpri) ;
      else if (schedctl(NDPRI, 0, ndpri) < 0)   
	 log(LOG_INFO,"schedctl(%d,%d,%d): %s\n",NDPRI,0,ndpri,sys_errlist[errno]) ;
      else    
	 log(LOG_INFO,"schedctl(%d,%d,%d) done\n",NDPRI,0,ndpri) ;
   }
#endif /* sgi */
   /*
    * Loop on request.
    */
   for (;;)        {
      int bet ;
      request = srrequest(s,&bet);
      if ( (request==RQST_OPEN || request==RQST_OPENDIR || 
	    request==RQST_XYOPEN) && !bet && is_remote ) {
	 log(LOG_ERR,"Attempt to call daemon with expired magic from outside site\n");
#if defined(HPSS)
	 return(rhpss_cleanup(s,&fd,dirp,1));
#endif /* HPSS */
#if defined(_WIN32)
	 return(mt_cleanup(td, &fd, 1));
#else	/* WIN32 */
	 shutdown(s, 2);
	 close(s);
	 exit(1);
#endif
      }
      if (request < 0)   {
	 log(LOG_INFO,"%d read, %d readahead, %d write, %d flush, %d stat, %d lseek and %d preseek\n",
	     info.readop, info.aheadop, info.writop, info.flusop, info.statop, info.seekop, info.presop); 
	 log(LOG_INFO,"%d bytes read and %d bytes written\n",info.rnbr,info.wnbr) ; 
	 log(LOG_ERR, "fatal: %s\n", sys_errlist[errno]);
#if defined(HPSS)
	 return(rhpss_cleanup(s,&fd,dirp,1));
#endif /* HPSS */

#if defined(_WIN32)
	 return(mt_cleanup(td, &fd, 1));
#else
	 shutdown(s, 2);
	 close(s);
#endif
      }
      switch (request)    {
       case 0:
	  log(LOG_INFO,"%d read, %d readahead, %d write, %d flush, %d stat, %d lseek and %d preseek\n",
	      info.readop, info.aheadop, info.writop, info.flusop, info.statop, info.seekop, info.presop); 
	  log(LOG_INFO,"%d bytes read and %d bytes written\n",info.rnbr,info.wnbr) ; 
	  log(LOG_ERR, "connection dropped by remote end\n");
#if defined(SACCT)
	  rfioacct(RFIOCONNDROP,0,0,s,0,0,status,errno,&info,NULL,NULL);
#endif /* SACCT */
	  
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,1));
#endif /* HPSS */
#if defined(_WIN32)
	  return(mt_cleanup(td, &fd, 1));
#endif
	  shutdown(s, 2); 
	  if( close(s) < 0 )
	     log(LOG_ERR, "Error closing socket fildesc=%d, errno=%d\n", s, errno);
	  else
	     log(LOG_INFO, "Closing socket fildesc=%d\n", s);
	  if( mode ) return(1); else  exit(1);
       case RQST_CHKCON :
	  log(LOG_DEBUG, "request type : check connect\n");
	  srchk(s) ;
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	  return(mt_cleanup(td, &fd, 0));
#endif
	  shutdown(s, 2); close(s);
	  if (mode) return(0); else  exit(0);
       case RQST_OPEN  :
	  log(LOG_DEBUG, "request type <open()>\n");
	  fd = sropen(s,(bet?is_remote:0),(bet?from_host:(char *)NULL), bet);
	  log(LOG_DEBUG, "ropen() returned: %x\n",fd);
	  break;
#if !defined(_WIN32)
       case RQST_OPENDIR :
	  log(LOG_DEBUG, "request type <opendir()>\n");
	  dirp = sropendir(s,is_remote,from_host,bet);
	  log(LOG_DEBUG, "ropendir() returned %x\n",dirp);
	  break;
#endif /* WIN32 */		
       case RQST_CLOSE  :
	  log(LOG_DEBUG, "request type <close()>\n");
	  status = srclose(s, &info, fd);
	  log(LOG_DEBUG,"close() returned %d\n",status);
	  fd = -1;
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)
	  return(mt_cleanup(td, &fd, 0));     
#endif
	  shutdown(s, 2); close(s);
	  if (mode) return(0); else exit(0);
#if !defined(_WIN32)
       case RQST_CLOSEDIR  :
	  log(LOG_DEBUG, "request type <closedir()>\n");
	  status = srclosedir(s,&info,dirp);
	  log(LOG_DEBUG,"close() returned %d\n",status);
	  dirp = NULL;
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
#endif /* WIN32 */
       case RQST_READ  :
	  info.readop ++ ;
	  log(LOG_DEBUG, "request type <read()>\n");
	  status = srread(s, &info, fd);
	  log(LOG_DEBUG, "rread() returned: %x\n",status);
	  break;
       case RQST_READAHEAD  :
	  info.aheadop ++ ;
	  log(LOG_DEBUG, "request type <readahead()>\n");
	  status = srreadahead(s, &info, fd);
	  log(LOG_DEBUG, "rreadahead() returned: %x\n",status);
	  break;
#if !defined(_WIN32)
       case RQST_READDIR :
	  info.readop++;
	  log(LOG_DEBUG, "request type <readdir()>\n");
	  status = srreaddir(s,&info,dirp);
	  log(LOG_DEBUG, "rreaddir() returned: %x\n",status);
	  break;
#endif	/* WIN32 */	  
       case RQST_WRITE  :
	  info.writop ++ ;
	  log(LOG_DEBUG, "request type <write()>\n");
	  status = srwrite(s, &info, fd);
	  log(LOG_DEBUG, "rwrite() returned: %x\n",status);
	  break;
       case RQST_FSTAT :
	  info.statop ++ ;
	  log(LOG_DEBUG, "request type <fstat()>\n");
	  status = srfstat(s, &info, fd);
	  log(LOG_DEBUG, "fstat() returned %d\n",status);
	  break;
       case RQST_MSTAT_SEC:
       case RQST_STAT_SEC:
       case RQST_MSTAT:
       case RQST_STAT :
	  log(LOG_DEBUG, "request type <stat()>\n");
	  status = srstat(s,(bet?is_remote:0),(bet?from_host:(char *)NULL),bet);
	  log(LOG_DEBUG, "stat() returned %d\n",status);
	  if (request==RQST_STAT || request==RQST_STAT_SEC) {
#if defined(HPSS)
	     return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	     return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */
	     shutdown(s, 2); close(s);
	     if(mode) return(0); else exit(0);
	  }  /* if request == RQST_STAT  */
	  break ;
#if !defined(_WIN32) 
       case RQST_LSTAT_SEC:
       case RQST_LSTAT :
	  log(LOG_DEBUG, "request type <lstat()>\n");
	  status = srlstat(s,(bet?is_remote:0),(bet?from_host:(char *)NULL),bet);
	  log(LOG_DEBUG, "lstat() returned %d\n",status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
#endif	/* WIN32 */
       case RQST_LSEEK :
	  info.seekop ++ ;
	  log(LOG_DEBUG, "request type <lseek()>\n");
	  status = srlseek(s, &info, fd);
	  log(LOG_DEBUG, "lseek() returned %d\n",status);
	  break;
       case RQST_PRESEEK :
	  info.presop ++ ;
	  log(LOG_DEBUG, "request type <preseek()>\n");
	  status = srpreseek(s, &info, fd);
	  log(LOG_DEBUG, "preseek() returned %d\n",status);
	  break;
       case RQST_ERRMSG :
	  log(LOG_DEBUG, "request type <errmsg()>\n");
	  srerrmsg(s);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	  return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
#if !defined(_WIN32)
       case RQST_SYMLINK :
	  log(LOG_DEBUG, "request type <symlink()>\n");
	  status = srsymlink(s,(bet?is_remote:0),(bet?from_host:(char *)NULL)) ; 
#if defined(HPSS)
	  log(LOG_DEBUG, "srsymlink() returned %d\n", status) ;
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
	  shutdown(s,2); close(s);
	  log(LOG_DEBUG, "srsymlink() returned %d\n", status) ;
	  if (mode) return(0); else exit(0);
       case RQST_READLINK:
	  log(LOG_DEBUG, "request type <readlink()>\n");
	  status = srreadlink(s) ;
#if defined(HPSS)
	  log(LOG_DEBUG, "srreadlink() returned %d\n", status) ;
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
	  shutdown(s,2); close(s);
	  log(LOG_DEBUG, "srreadlink() returned %d\n", status) ;
	  if (mode) return(0); else exit(0);
       case RQST_REWINDDIR:
	  info.seekop ++;
	  log(LOG_DEBUG, "request type <rewinddir()>\n");
	  status = srrewinddir(s,&info,dirp);
	  log(LOG_DEBUG, "srrewinddir() returned %d\n",status);
	  break;
#endif	/* WIN32 */
       case RQST_STATFS :
	  log(LOG_DEBUG, "request type <statfs()>\n");
	  status = srstatfs(s) ;
	  log(LOG_DEBUG, "statfs() returned %d\n",status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	  return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
       case RQST_POPEN :
	  log(LOG_DEBUG, "request type <popen()>\n");
	  streamf = srpopen(s, from_host, (bet?is_remote:0) ) ;
	  log(LOG_DEBUG, "srpopen() returned %x\n", streamf ) ;
	  break ;
       case RQST_FREAD :
	  log(LOG_DEBUG,"request type <fread()>\n");
	  status = srfread(s,streamf) ;
	  log(LOG_DEBUG, "rfread() returned %d\n",status);
	  break ;
       case RQST_FWRITE :
	  log(LOG_DEBUG,"request type <fwrite()\n");
	  status = srfwrite(s,streamf);
	  log(LOG_DEBUG, "rfwrite() returned %d\n",status);
	  break ;
       case RQST_PCLOSE :
	  log(LOG_DEBUG,"request type <pclose()>\n");
	  status = srpclose(s,streamf) ;
	  log(LOG_DEBUG,"pclose() returned %d\n",status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	  return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */	  
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
#if !defined(_WIN32)
       case RQST_ACCESS :
	  log(LOG_DEBUG,"request type <access()>\n");
	  status = sraccess(s) ;
	  log(LOG_DEBUG,"raccess returned %d\n",status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
#endif	/* WIN32 */  
       case RQST_MKDIR :
	  log(LOG_DEBUG,"request type <mkdir()>\n");
	  status = srmkdir(s,from_host,is_remote) ;
	  log(LOG_DEBUG,"rmkdir returned %d\n", status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	   return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
       case RQST_RMDIR :
	  log(LOG_DEBUG,"request type <rmdir()>\n");
	  status = srrmdir(s,from_host,is_remote) ;
	  log(LOG_DEBUG,"rrmdir returned %d\n", status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	   return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */  
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
       case RQST_CHMOD:
	  log(LOG_DEBUG,"request type <chmod()>\n");
	  status = srchmod(s,from_host,is_remote) ;
	  log(LOG_DEBUG,"rchmod returned %d\n", status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	   return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */  
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
#if !defined(_WIN32)
       case RQST_CHOWN:
	  log(LOG_DEBUG,"request type <chown()>\n");
	  status = srchown(s,from_host,is_remote) ;
	  log(LOG_DEBUG,"rchown returned %d\n", status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
#endif	/* WIN32 */  
       case RQST_RENAME:
	  log(LOG_DEBUG,"request type <rename()>\n");
	  status = srrename(s,from_host,is_remote) ;
	  log(LOG_DEBUG,"rrename returned %d\n", status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	   return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */  
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
#if !defined(_WIN32)	  
       case RQST_LOCKF:
	  log(LOG_DEBUG,"request type <lockf()>\n");
	  status = srlockf(s,fd) ;
	  log(LOG_DEBUG,"rlockf returned %d\n", status);
	  break;
#endif	 /* WIN32 */
       case RQST_END :
	  log(LOG_DEBUG,"request type : end rfiod\n") ;
#if defined(SACCT)
	  rfioacct(RQST_END,0,0,s,0,0,status,errno,&info,NULL,NULL);
#endif /* SACCT */
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	   return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */  
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
	  break ;
       case RQST_OPEN_V3:
	  log(LOG_DEBUG,"request type : open_v3\n");
	  fd = sropen_v3(s,(bet?is_remote:0),(bet?from_host:(char *)NULL), bet);
	  log(LOG_DEBUG,"ropen_v3 returned %d\n",fd);
	  break;
       case RQST_CLOSE_V3: /* Should not be received here but inside read_v3 and write_v3 functions */
	  log(LOG_DEBUG,"request type : close_v3\n");
	  status = srclose_v3(s,&info,fd);
	  log(LOG_DEBUG,"rclose_v3 returned %d\n", status);
	  fd = -1;
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)
	  return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */	  
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
	  break;
       case RQST_READ_V3:
	  log(LOG_DEBUG,"request type : read_v3\n");
	  status = srread_v3(s,&info,fd);
	  log(LOG_DEBUG,"rread_v3 returned %d\n",status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)
	  return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */	  	  
	  fd = -1;
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
	  break;
       case RQST_WRITE_V3:
	  log(LOG_DEBUG,"request type : write_v3\n");
	  status = srwrite_v3(s,&info,fd);
	  log(LOG_DEBUG,"rwrite_v3 returned %d\n",status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	   return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */  	  
	  fd = -1;
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
	  break;
#if defined(FORTRAN)
       case RQST_XYOPEN  :
	  log(LOG_DEBUG, "request type <xyopen()>\n");
	  status = srxyopen(s, &lun, &access,(bet?is_remote:0),(bet?from_host:NULL),bet);
	  log(LOG_DEBUG, "xyopen(%d,%d) returned: %d\n",lun,access,status);
	  break;
       case RQST_XYCLOS  :
	  log(LOG_DEBUG, "request type <xyclos(%d)>\n",lun);
	  status = srxyclos(s, &info, lun);
	  log(LOG_DEBUG,"xyclos() returned %d\n",status);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
	  shutdown(s,2); close(s);
	  if (mode) return(0); else exit(0);
       case RQST_XYREAD  :
	  info.readop ++ ;
	  log(LOG_DEBUG, "request type <xyread()>\n");
	  status = srxyread(s, &info, lun, access);
	  log(LOG_DEBUG, "xyread() returned: %x\n",status);
	  break;
       case RQST_XYWRIT  :
	  info.writop ++ ;
	  log(LOG_DEBUG, "request type <xywrit(%d, %d)>\n", lun, access);
	  status = srxywrit(s, &info, lun, access);
	  log(LOG_DEBUG, "xywrit() returned: %x\n",status);
	  break;
#endif /* FORTRAN */
#if defined(HPSS)
       case RQST_READLIST  :
	  info.readop ++ ;
	  log(LOG_DEBUG, "request type <hpss_readlist()>\n");
	  status = srreadlist(s, &info, fd, fromp);
	  log(LOG_DEBUG, "rreadlist() returned: %x\n",status);
	  break;
       case RQST_WRITELIST  :
	  info.writop ++ ;
	  log(LOG_DEBUG, "request type <hpss_writelist()>\n");
	  status = srwritelist(s, &info, fd, fromp);
	  log(LOG_DEBUG, "rwritelist() returned: %x\n",status);
	  break;
       case RQST_SETCOS  :
	  log(LOG_DEBUG, "request type <hpss_setcos()>\n");
	  status = srsetcos(s, fd);
	  log(LOG_DEBUG, "rsetcos() returned: %x\n",status);
	  break;
#endif /* HPSS */
       default :
	  log(LOG_ERR, "unknown request type %x(hex)\n", request);
#if defined(HPSS)
	  return(rhpss_cleanup(s,&fd,dirp,0));
#endif /* HPSS */
#if defined(_WIN32)	     
	   return(mt_cleanup(td, &fd, 0));
#endif	/* WIN32 */  	  
	  if (mode) return(0); else exit(0);
      }
   }
}

   
#if defined(_WIN32)
int set_rcv_sockparam(s, value)
SOCKET 	s;
int   	value;
{
   if( setsockopt( s, SOL_SOCKET, SO_RCVBUF, (char*)&value, sizeof(value)) == SOCKET_ERROR)  {
      if( WSAGetLastError() != WSAENOBUFS )  {
	 log(LOG_ERR, "setsockopt rcvbuf(): %s\n", geterr());
	 WSACleanup();
	 rfiod_stop();
      } else
	 return(-1);
   } else
      return(value);
}

int set_snd_sockparam(s, value)
SOCKET	s;
int 	value;
{
   if(setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char*)&value, sizeof(value)) == SOCKET_ERROR)  {
      if( WSAGetLastError() != WSAENOBUFS )  {
	 log(LOG_ERR, "setsockopt sndbuf(): %s\n", geterr());
	 WSACleanup();
	 rfiod_stop();
      }
      else
	 return(-1);
   }
   else
      return(value);
}
#else
int set_rcv_sockparam(s,value)
int s,value;
{
   if (setsockopt(s,SOL_SOCKET,SO_RCVBUF,(char *)&value, sizeof(value)) < 0) {
      if (errno != ENOBUFS)
      {
	 log(LOG_ERR, "setsockopt rcvbuf(): %s\n",sys_errlist[errno]);
	 exit(1);
      }
      else
	 return(-1);
   }
   else
      return(value);
}

int set_snd_sockparam(s,value)
int s,value;
{
   if (setsockopt(s,SOL_SOCKET,SO_SNDBUF,(char *)&value, sizeof(value)) < 0) {
      if (errno != ENOBUFS)
      {
	 log(LOG_ERR, "setsockopt sndbuf(): %s\n",sys_errlist[errno]);
	 exit(1);
      }
      else
	 return(-1);
   }
   else
      return(value);
}
#endif
