
/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tpsinfo.c	1.1 03/11/94  CERN CN-SW/DC F. Hassine";
#endif /* not lint */

#include "tpsinfo.h"
#include <syslog.h>

static 		char buf[256];
extern char     *getenv();      /* get environmental variable value     */
static char     last_host[256]; /* to hold last connect host name       */
/*
 * returns -2 if an error occured  or -1 if no information is available at the 
 * daemon's host. 0 otherwise.
 */
static int info_connect() ;

int rqst_info(hostname , ptr, size, site , device)
char  *hostname ;
char *ptr 	;
int size 	;
char * site 	; /* request info for which site ? */
char * device	; /* Which device type info ? */

{ 
	int status ;
	int msglen , ans_req;
	int s ;
	char *p;
	char info[256];
	
	INIT_TRACE("INFO_TRACE");
	TRACE( 1, "tpsinfo", " rqst_info (%s, %x, %d, %s, %s)",hostname, ptr, size, site , device );
        s = info_connect(hostname);
        if (s < 0)      {
                END_TRACE();
                return(-2);
        }
	p = buf ;
        marshall_WORD(p, INFO_MAGIC);
        marshall_WORD(p, RQST_TPSERV);
	if (netwrite(s,buf,RQSTSIZE) != RQSTSIZE) {
                TRACE(2, "tpsinfo", "rqst_info() : write(): ERROR occured (errno=%d)",errno);
                (void) close(s);
                END_TRACE();
                return(-2);
        }

	if (site == NULL || device == NULL ) {
		TRACE(1, "tpsinfo", "rqst_info() : Error : bad argument passed to rqst_info");
		return -2;
	}
	p = buf ;
	marshall_STRING(p,site);
	marshall_STRING(p,device);
	if (netwrite(s,buf,RQSTSIZE) != RQSTSIZE) {
                TRACE(2, "tpsinfo", "rqst_info() : write(): ERROR occured (errno=%d)", errno);
                (void) close(s);
                END_TRACE();
                return(-2);
        }

	p = buf;
	TRACE(2, "tpsinfo", "rqst_info(): reading %d bytes", 3*LONGSIZE);
        if (netread(s, buf, 3*LONGSIZE) != 3*LONGSIZE)  {
                TRACE(2, "tpsinfo", "rqst_info(): read(): ERROR occured (errno=%d)", errno);
                (void) close(s);
                END_TRACE();
                return(-2);
        }

	unmarshall_LONG( p, ans_req );
	unmarshall_LONG( p, status ) ;
	unmarshall_LONG( p, msglen ) ;

	if ( ans_req != RQST_TPSERV ) {
		TRACE(1,"tpsinfo","rqst_info(): ERROR: answer does not correspond to request !");
		(void) close(s);
                END_TRACE();
                return(-2);
        }
	if ( status < 0 ) {
		TRACE(1,"tpsinfo","rqst_info():Server didn't find any info to send");
		(void) close(s);
                END_TRACE();
                return(-1);
	}
	TRACE(1,"tpsinfo","rqst_info(): Got msglen = %d",msglen);
	p = buf ;
        if (netread(s, buf, msglen ) != msglen )  {
                TRACE(2, "tpsinfo", "rqst_info(): read(): ERROR occured (errno=%d)", errno);
                (void) close(s);
                END_TRACE();
                return(-2);
        }
	unmarshall_STRING(p,info );
	TRACE(2,"tpsinfo", "rqst_info(): got info : %s",info);
	strncpy(ptr, info,size);
	END_TRACE();
	return 0 ;
}

static int     info_connect(node)      /* Connect <node>'s info server         */
char    *node;
{
	register int    s;      /* A socket descriptor                  */
	struct servent  *sp;    /* A service entry pointer              */
	struct hostent  *hp;    /* A host entry pointer                 */
	struct sockaddr_in sin; /* A socket address (internet) struct   */
	char    *host;          /* Host name chararcter string          */
	char    *p;             /* A character string pointer           */
	register int    rtycnt = 0; /* connect retry count              */
	register int    rtyint = 0; /* connect retry interval           */

	INIT_TRACE("INFO_TRACE");
/*
 * Should we use an alternate name ?
 */

/*
 * Under some circumstances (heavy load, use of inetd) the server fails
 * to accept a connection. A simple retry mechanism is therefore
 * implemented here.
 */
	if ((p = getconfent("TPSINFO", "CONRETRY", 0)) != NULL)        {
		if ((rtycnt = atoi(p)) <= 0)     {
			rtycnt = 0;
		}
	}
	if ((p = getconfent("TPSINFO", "CONRETRYINT", 0)) != NULL)        {
		if ((rtyint = atoi(p)) <= 0)     {
			rtyint = 0;
		}
	}

	if ((host = getconfent("NET",node,0)) == NULL)  {       /* No   */
		host = node;
	}

	serrno = 0; /* reset the errno could be SEENTRYNFND */

	TRACE(1, "tpsinfo", "info_connect: connecting(%s)",host);

	if ( (p= getenv("TPS_PORT")) == NULL ) {
		TRACE(2, "tpsinfo", "info_connect: getservbyname(%s, %s)","tpsinfo", "tcp");
        	if ((sp = getservbyname("tpsinfo","tcp")) == NULL) {
                	TRACE(2, "tpsinfo", "info_connect: info/tcp no such service");
                	serrno = SENOSSERV;     /* No such service              */
                	END_TRACE();
                	return(-1);
		}
		sin.sin_family = AF_INET;
		sin.sin_port = sp->s_port;
	}
	else {
		TRACE(2, "tpsinfo", "info_connect: *** Warning: using port %s", p);
		sin.sin_port = htons(atoi(p));
		sin.sin_family = AF_INET;
	}

	TRACE(2, "tpsinfo", "info_connect: gethostbyname(%s)", host);

	hp = gethostbyname(host);
	if (hp == NULL) {
		if (strchr(host,'.') != NULL) { /* Dotted notation */
			TRACE(2, "tpsinfo", "info_connect: using %s", host);
			sin.sin_addr.s_addr = htonl(inet_addr(host));
		}
		else    {
			TRACE(2, "tpsinfo", "info_connect: %s: no such host",host);
			serrno = SENOSHOST;     /* No such host                 */
			END_TRACE();
			return(-1);
		}
	}
	else    {
		sin.sin_addr.s_addr = ((struct in_addr *)(hp->h_addr))->s_addr;
	}

retry:
	TRACE(2, "tpsinfo", "info_connect: socket(%d, %d, %d)",
				sin.sin_family, SOCK_STREAM, 0);
	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)  {
		TRACE(2, "tpsinfo", "info_connect: socket(): ERROR occured (errno=%d)", errno);
		END_TRACE();
		return(-1);
	}
	TRACE(2, "tpsinfo", "info_connect: connect(%d, %x, %d)", s, &sin, sizeof(struct sockaddr_in));
	if (connect(s, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) < 0)   {
		TRACE(2, "tpsinfo", "info_connect: connect(): ERROR occured (errno=%d)", errno);
		if (errno == ECONNREFUSED)      {
			syslog(LOG_ALERT, "tpsinfo: %d failed to connect %s", getpid(), host);
			if (rtycnt-- > 0)       {
				if (rtyint) sleep(rtyint);
				syslog(LOG_ALERT, "tpsinfo: %d retrying to connect %s", getpid(), host);
/*
 * connect() returns "Invalid argument when called twice,
 * so socket needs to be closed and recreated first
 */

				(void) close(s);
				goto retry;
			}
		}
		(void) close(s);
		END_TRACE();
		return(-1);
	}
	strcpy(last_host,host); /* remember to fetch back remote errs     */
	TRACE(2, "tpsinfo", "info_connect: connected");
	TRACE(2, "tpsinfo", "info_connect: calling setnetio(%d)", s);
	if (setnetio(s) < 0)    {
		close(s);
		END_TRACE();
		return(-1);
	}

	TRACE(1, "tpsinfo", "info_connect: return socket %d", s);
	END_TRACE();
	return(s);
}

