
/*
 * @(#)tpsinfo.h	1.1 03/11/94  CERN CN-SW/DC Felix Hassine
 */

/*
 * Copyright (C) 1990-1993 by CERN/CN/SW/DC
 * All rights reserved
 */

/* tpsinfo.h       Remote File Access routines header                      */

#ifndef _TPSINFO_H_INCLUDED_
#define _TPSINFO_H_INCLUDED_

/*
 * Include files
 */
#include <stdio.h>              /* standard Input/Output                */
#if !defined(apollo)
#include <unistd.h>             /* Standardized definitions             */
#endif  /* !apollo */
#include <sys/types.h>          /* standard data types                  */
#include <sys/socket.h>         /* socket interface                     */
#include <netinet/in.h>         /* internet types                       */
#include <netdb.h>              /* network database                     */
#include <errno.h>              /* standard error numbers               */
#if !defined(apollo)
#include <string.h>             /* string handling routines             */
#else
#include <strings.h>            /* strings operations                   */
#endif  /* ! apollo     */
#include <sys/file.h>           /* define L_XTND, L_INCR and L_SET      */
#include <sys/stat.h>           /* file status definitions              */
#include <sys/time.h>           /* for time declarations                */
#include <marshall.h>           /* marshalling macros and definitions   */
#include <serrno.h>             /* special error numbers                */
#include <trace.h>              /* tracing definitions                  */

#if defined(_AIX) && defined(_IBMR2)
#include <sys/select.h>         /*some of the defs are in this file     */
#endif /* AIX */

extern int (*recvfunc)();       /* Network receive function             */
#define netread    (*recvfunc)
extern int (*sendfunc)();       /* Network send function                */
#define netwrite   (*sendfunc)

#define INFO_MAGIC 	0X1100       /* Info daemon magic number   */
#define RQST_TPSERV     0x1001       	/* request for tpsinfo        */
#define RQSTSIZE	3*(LONGSIZE+WORDSIZE)

extern char *getconfent();      /* get configuration file entry         */

#endif /* _RFIO_H_INCLUDED_ */
