.\" @(#)stageout.man	1.9 09/08/98 CERN CN-PDP/DH Jean-Philippe Baud
.\" Copyright (C) 1994-1998 by CERN/CN/PDP/DH
.\" All rights reserved
.\"
.TH STAGEOUT l "09/08/98"
.SH NAME
stageout \- allocate space and store the option values in the stgdaemon catalog
for use by stageput later.
.SH SYNOPSIS
.B stageout 
[
.BI -b " max_block_size"
] [
.BI -C " charconv"
] [
.BI -d " density"
] [ 
.BI -F " record_format" 
] [
.BI -f " file_id"
] [
.BI -G 
] [ 
.BI -g " device_group_name"
] [
.BI -h " host"
] [
.BI -I " external_filename"
] [ 
.BI -K
] [
.BI -L " record_length"
] [ 
.BI -l " label_type"
] [
.BI -M " hsmfile"
] [
.BI -N " nread"
] [
.BI -n
] [
.BI -o
] [
.BI -p " pool"
] [
.BI -q " file_sequence_number"
] [
.BI -S " tape_server"
] [
.BI -s " size"
] [
.BI -t " retention_period_in_days"
] [
.BI -U " fun"
] [
.BI -u " user"
] [
.BI -V " visual_identifier(s)"
] [ 
.BI -v " volume_serial_number(s)"
] [
.BI -X " xparm"
] [ 
.I files
]
.SH DESCRIPTION
This command sends a request to a stage daemon which allocates space in a pool
and stores the option values in its catalog.
Then the daemon creates an empty file and sets the ownership and permissions.
If the request gives tape parameters and 
.B -q
option is not
.B "-q n" ,
the internal file name is in the form
.BR "vid.fseq.label" ;
if
.B -q n
is specified, the internal file name is in the form
.B vid.fseq.label.reqid
while if an external file name is specified with the option -I (disk stageing),
the internal file name is in the form
.BR xfile_basename.reqid .
If
.I file
is specified, a symbolic link pointing at the actual file is created with that
name.
.LP
.I file
may be a local path, the combination
.I machine:fullpath
(NFS syntax), a full path starting with the NFS_ROOT, i.e. /shift,
or absent.
.SH OPTIONS
.TP
.BI \-b " blocksize"
Specifies the maximum block size.
If not given and the input tape is labelled and -o is also specified, the
block size is taken from the header label when the field is not zero;
otherwise: for all drive types except Redwoods the default is 32760 if
.I lrecl
is not specified,
.I lrecl
otherwise. On Redwoods, the default is 262144 if
.I lrecl
is not specified or the largest multiple of
.I lrecl
below 262144.
.TP
.BI \-C " charconv"
The data will be converted to this character set when
.B stageput
is executed.
.I charconv
may be
.B ascii
(no conversion is done) or
.BR ebcdic .
The option value may also be
.BR block .
In this case, the new line will be removed from each record and padding with
blanks will be done if necessary.
Option values may be combined; they are separated by comma in this case.
.br
For example:
.br
	-C ebcdic,block
.TP
.BI \-d " density"
.B 1600
or
.B 6250
for round (IBM 3420) tapes,
.B 38000
for standard IBM 3480 cartridges,
.B 38KC
for 3480 cartridges with compaction (IDRC),
.B 38KD
for double density IBM 3490 cartridges,
.B 38KDC
for 3490 cartridges with compaction (IDRC),
.BR 8200 ,
.B 8500
or
.B 8500C
for Exabytes,
.B DDS
or
.B DDSC
for DAT cartridges,
.BR 2G ,
.BR 6G ,
.BR 10G ,
.BR 10GC ,
.BR 20G ,
.BR 20GC ,
.B 35G
or
.B 35GC
for DLT cartridges,
.B 10G
or
.B 10GC
for IBM 3590 cartridges,
.BR 10G ,
.BR 10GC ,
.BR 25G ,
.BR 25GC ,
.B 50G
or
.B 50GC
for Redwood cartridges.
It must match the device group specified in TMS (if installed).
If this parameter is missing, the value is taken from TMS.
.TP
.BI \-F " recfm"
Specifies the record format of the data on the tape. It may be one of the 
following:
.RS
.TP
.B U,\|f77
Blocks may be of unknown length. A single logical record on disk corresponds
to one tape block. The disk file must be formatted according to the convention
for sequential 
.SM FORTRAN 
unformatted I/O.
.TP
.B U
is an alias for
.BR U,\|f77 .
.TP
.B U,\|bin
Each tape block created will be exactly
.IR blocksize
bytes long (See the \-b option) with the exception of the last block
which may be shorter.
This format is suitable for use with direct access Fortran unformatted I/O
or C I/O.
.TP
.B F
Each tape block created will be exactly
.IR blocksize
bytes long (See the \-b option) with the exception of the last block
which may be shorter.
.I lrecl
must be specified (-L option) and if both
.I blocksize
and
.I lrecl
are provided, they should be equal.
.br
This format is suitable for use with direct access Fortran unformatted I/O
or C I/O.
.TP
.B FB
This allows to group several records of
.I lrecl
bytes into tape blocks of
.I blksize
bytes.
.I blksize
must be a multiple of
.IR lrecl .
.LP
The default record format is
.BR U .
.RE
.TP
.BI \-f " fid"
Specifies the fileid in HDR1. If more than 17 characters long,
only the last 17 are taken. It is then converted to upper case.
If the -f parameter is absent, the internal
.B rtcopy
tape pathname is used instead.
In the case of multiple files, a series of file identifiers may be given,
separated by ":"s. These apply to the tape files in the specified order.
If there are more files than identifiers, the last one will be used for all
remaining files. Thus,
a single file identifier may be given which applies to all files on the tape.
.TP
.B \-G
Specifies that the tape copy operations should be issued on the tape server by
the 'group user'. A 'group user' may be defined for each group in 
.B /etc/shift.conf.
.br
For example: 
.br
	GRPUSER ws	opalprod
.TP 
.BI \-g " dgn"
Requests a device from an installation defined set of "device groups".
It must match the device group specified in TMS (if installed).
If this parameter is missing, the value is taken from TMS or
defaults to CART.
.TP
.BI \-h " host"
Sends the request to the stager on
.IR host .
This may also be specified thru the environment variable STAGE_HOST.
.TP
.BI \-I " external_filename"
Gives the name of an external disk file. In this case,
.B rfcp
will be used to copy the file from the staging pool to that external file.
.TP
.BI \-K
Keeps file on disk.
If this option is absent, the disk file is removed as soon as the
.B stageput
operation is successful.
.TP
.BI \-L " lrecl"
Specifies the logical record length for fixed length record format files.
.TP
.BI \-l " lab_type"
Specifies the type of label which should be checked or generated. The following
label types are supported:
.RS
.TP
.B al
.SM ANSI 
label
.TP
.B nl
no label
.TP
.B sl
standard 
.SM IBM
label
.LP
It must match the label type specified in TMS (if installed).
If this parameter is missing, the value is taken from TMS or
defaults to
.BR sl .
.RE
.TP
.BI \-M " hsmfile"
Gives the name of a Hierarchical Storage Manager (HSM) file. In this case,
.B rfcp
will be used to copy the file from the staging pool to that HSM file.
.TP
.BI \-N " nread"
If specified, only 
.I nread 
records will be copied.
In the case of multiple files, a series of nread values may be given,
separated by ":"s. These apply to the tape files in the specified order.
If there are more files than nread values, the last one will be used for all
remaining files. Thus,
a single nread value may be given which applies to all files on the tape.
.TP
.BI \-n
Implies new fileid. The existing fileid is not checked but if the new file would
overwrite an existing one, the old file expiry date is checked.
.TP
.BI \-o
Implies old fileid. The existing fileid is checked if the option
.B -f
is also specified.
If the new file would overwrite an existing one, the old file expiry date is
checked.
.TP
.BI \-p " poolname"
Allocates the file in the pool
.IR poolname .
This may also be specified thru the environment variable STAGE_POOL.
.TP
.BI \-q " fseq"
Specifies the file sequence number(s) of the tape file(s) to be created.
Default is 1.
Multiple files may be specified using the following syntax:
.RS 
.TP 1.5i 
.I f1\-f2 
Files 
.I f1
to 
.I f2 
inclusive.
.TP
.B n 
Append one file to the tape.
.TP 
.BI n x 
Append 
.I x 
files to the tape.
.TP
.B u
Position the tape by fid.
.RE
.TP
.BI \-S " server"
Specifies that the tape copy operation has to be issued on the tape server 
.IR server. 
.TP
.BI \-s " size"
If specified, only 
.I size 
Mbytes will be copied.
The value must be smaller than 2048 (2 Gbytes).
In the case of multiple files, a series of size values may be given,
separated by ":"s. These apply to the tape files in the specified order.
If there are more files than size values, the last one will be used for all
remaining files. Thus,
a single size value may be given which applies to all files on the tape.
.TP
.BI \-t " days"
Retention period of the file on tape in days. A file may be overwritten only if
it is expired.
Default is 0, which means that the file may be overwritten immediately.
.TP
.BI \-U " fun"
Fortran unit number.
This is internally converted to a local path
.BI ftn fun
(HP-UX) or
.BI fort. fun
(all other platforms).
The
.B \-U
option and the
.I file
parameter may be both specified for single file allocation only.
.TP
.BI \-u " user"
A file allocated in a pool will be stored in a subdirectory
.IR user .
This may also be specified thru the environment variable STAGE_USER.
The default subdirectory name is
.BR stage .
.I user
must be a valid user name and belong to the same group as the requestor.
.TP
.BI \-V " vid"
Specifies the tape 
.SM VID
if different from the 
.SM VSN .
In the case of multi\-volume files a series of 
.IR vid s
may be given, separated by ":"s, in the order in which the tapes are to be used.
.TP
.BI \-v " vsn"
Specifies the volume serial number of the tape. In the case of a multi-volume
file a series of 
.IR vsn s
may be given, separated by ":"s, in the order in which the tapes are to be used.
When \-v and \-V are both used, each
.IR vsn
must be matched by a
.IR vid
in the same order.
.SH EXAMPLES
.LP
To allocate disk space for the output,
generate the data and write them on a tape:
.RS
stageout -v CUT222 out
.br
a.out out
.br
stageput out
.RE
.LP
.SH RETURN CODES
\
.br
0	Ok.
.br
1	Bad parameter.
.br
2	System error.
.br
4	Configuration error.
.br
28	ENOSPC: unable to find enough disk space.
.br
192	Request cancelled by stageclr.
