/*
 * Copyright (C) 1990-1998 by CERN/CN/SW/CU
 * All rights reserved
 */

/*
 * @(#)tape.h	1.66 03/19/98 CERN CN-SW/CU   Jean-Philippe Baud
 */

			/* tape daemon constants and macros */

#define	DEFDGN	"CART"	/* default device group name */
#define MAXDGP	4	/* maximum number of device groups */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN  64
#endif
#ifdef MAXPATH
#undef MAXPATH
#endif
#define MAXPATH	80	/* maximum path length */
#define MAXUNIT 32	/* maximum number of units */
#define MAXUSER 24	/* maximum number of simultaneous tape users */
#define MAXVSN	64	/* maximum number of vsns on a tpmnt */
#define LBLBUFSZ  128   /* size of buffers to read labels */
#define OPRMSGSZ  257	/* maximum operator message/reply length */
#define PRTBUFSZ  180
#define REPBUFSZ 2800	/* must be >= max tape daemon reply size */
#define REQBUFSZ 1240	/* must be >= max tape daemon request size */
#define CHECKI	10	/* max interval to check for work to be done */
#define	RBTFASTRI 60	/* fast retry interval for robotic operations */
#define UCHECKI	10	/* max interval to check for unit ready or oper cancel */
#define	VOLBSYRI 300	/* retry interval if volume busy */
#define CLNREQI 180	/* interval to check for jobs that have died */
#define SMSGI	30	/* retry interval when sending operator messages */
#define AL	1
#define NL	2
#define SL	3
#define BLP	4
#define OUT	0
#define IN	1
#define	D800	0x1
#define	D1600	0x2
#define	D6250	0x3
#define	D38000	0x4
#define	D8200	0x5
#define	D8500	0x6
#define	D38KD	0x7
#define D2G	0x8
#define D6G	0x9
#define D10G	0xA
#define SFMT	0xB
#define SRAW	0xC
#define DDS	0xD
#define D20G	0xE
#define D25G	0xF
#define D35G	0x10
#define D50G	0x11
#define IDRC	0x100
#define	D38KC	(D38000 | IDRC)
#define	D38KDC	(D38KD | IDRC)
#define	D8200C	(D8200 | IDRC)
#define	D8500C	(D8500 | IDRC)
#define D10GC	(D10G | IDRC)
#define DDSC	(DDS | IDRC)
#define D20GC	(D20G | IDRC)
#define D25GC	(D25G | IDRC)
#define D35GC	(D35G | IDRC)
#define D50GC	(D50G | IDRC)

#ifdef NOTRACE
#ifdef __STDC__
#define ENTRY(x) \
	{ \
	strcpy (func, #x); \
	}
#else
#define ENTRY(x) \
	{ \
	strcpy (func, "x"); \
	}
#endif
#define RETURN(x) \
	{ \
	return ((x)); \
	}
#else
#ifdef __STDC__
#define ENTRY(x) \
	{ \
	strcpy (func, #x); \
	tplogit (func, "function entered"); \
	}
#else
#define ENTRY(x) \
	{ \
	strcpy (func, "x"); \
	tplogit (func, "function entered"); \
	}
#endif
#define RETURN(x) \
	{ \
	tplogit (func, "returns %d", (x)); \
	return ((x)); \
	}
#endif
#ifdef ultrix
#define READ(x,y,z) recv(x,y,z,0)
#define WRITE(x,y,z) send(x,y,z,0)
#else
#define READ(x,y,z) read(x,y,z)
#define WRITE(x,y,z) write(x,y,z)
#endif
#define UPPER(s) \
	{ \
	char * q; \
	for (q = s; *q; q++) \
		if (*q >= 'a' && *q <= 'z') *q = *q + ('A' - 'a'); \
	}

			/* tape daemon request types */

#define TPRSV 	0	/* reserve tape units */
#define TPMOUNT	1	/* assign unit, ask for the tape to be mounted, check VOL1 */
#define TPSTAT	2	/* get tape status display */
#define TPRSTAT	3	/* get unit reservation status display */
#define TPCONF	4	/* configure tape unit up/down */
#define TPRLS	5	/* unload tape and release reservation */
#define UPDVSN	6	/* update vid, vsn and mount flag in tape unit table */
#define	OVLEND	7	/* overlay ended execution */
#define	KILLMNT	8	/* mount killed by user */
#define	FREEUNT	9	/* free unit */
#define NEXTVOL 10	/* switch to next volume */
#define RSLT	11	/* switch to new unit */
#define UPDFIL	12	/* update blksize, cfseq, fid, lrecl, recfm in tpfil */
#define TPINFO	13	/* get info for a given mounted tape */

			/* tape daemon return codes */

#define ETDNP	200	/* daemon not available */
#define ETSYS	201	/* system error */
#define ETTMO	202	/* time out */
#define	ETPRM	203	/* bad parameter */
#define	ETRSV	204	/* reserv already issued */
#define	ETMUSR	205	/* too many tape users */
#define	ETNDV	206	/* too many units requested */
#define	ETIDG	207	/* invalid device group name */
#define	ETNRS	208	/* reserv not done */
#define	ETIDN	209	/* no unit with requested characteristics */
#define	ETLBL	210	/* bad label structure */
#define	ETFSQ	211	/* bad file sequence number */
#define	ETINTR	212	/* interrupted by user */
#define ETEOV	213	/* EOV found in multivolume set */
#define ETEOL	214	/* list of tapes in multivolume set is exhausted */
#define ETRLSP	215	/* release pending */
#include "taperr.h"
#define	ETRSLT	222	/* reselect server */
#define	ETVBSY	223	/* volume busy or inaccessible */
#define	ETDCA	224	/* drive currently assigned */

			/* rbtsubr return codes */

#define	RBT_OK		0	/* Ok or error should be ignored */
#define	RBT_NORETRY	1	/* Unrecoverable error (just log it) */
#define	RBT_SLOW_RETRY	2	/* Should release drive & retry in 600 seconds */
#define	RBT_FAST_RETRY	3	/* Should retry in 60 seconds */
#define	RBT_DMNT_FORCE	4	/* Should do first a demount force */
#define	RBT_CONF_DRV_DN	5	/* Should configure the drive down */
#define	RBT_OMSG_NORTRY	6	/* Should send a msg to operator and exit */
#define	RBT_OMSG_SLOW_R 7	/* Ops msg (nowait) + release drive + slow retry */
#define	RBT_OMSGR	8	/* Should send a msg to operator and wait */
#define	RBT_UNLD_DMNT	9	/* Should unload the tape and retry demount */

			/* tape daemon messages */

#define TP000	"TP000 - tape daemon not available"
#define TP001	"TP001 - no response from tape daemon"
#define TP002	"TP002 - %s : %s error : %d"
#define TP003   "TP003 - illegal function %d"
#define TP004   "TP004 - error reading request header, read = %d"
#define TP005	"TP005 - cannot get memory"
#define TP006	"TP006 - invalid value for option %s\n"
#define TP007	"TP007 - duplicate option %s\n"
#define TP008	"TP008 - %s not accessible"
#define TP009	"TP009 - could not configure %s, rc = %d\n"
#define TP010	"TP010 - units already reserved for this job\n"
#define TP011	"TP011 - too many tape users\n"
#define TP012	"TP012 - too many units requested\n"
#define TP013	"TP013 - invalid device group name\n"
#define TP014	"TP014 - reserve not done\n"
#define TP015	"TP015 - unit with specified characteristics does not exist\n"
#define TP016	"TP016 - options -%c and -%c are mutually exclusive\n"
#define TP017	"TP017 - cannot use blp in write mode\n"
#define TP019	"TP019 - too many vsns specified\n"
#define TP020	"TP020 - mount tape %s(%s) %s on unit %s@%s for %s %d, %s (%s) or reply cancel | unit name"
#define TP021	"TP021 - label type mismatch: request %s, tape is %s"
#define TP022	"TP022 - path exists already"
#define TP023	"TP023 - mount cancelled by operator: %s"
#define TP024	"TP024 - file %s does not exist"
#define TP025	"TP025 - bad label structure"
#define TP026	"TP026 - system error"
#define TP027	"TP027 - you are not registered in account file\n"
#define TP028	"TP028 - file not expired"
#define	TP029	"TP029 - pathname is mandatory\n"
#define	TP030	"TP030 - I/O error"
#define	TP031	"TP031 - no vsn specified\n"
#define	TP032	"TP032 - %s: unit name too long"
#define	TP033	"TP033 - unit %s@%s not operational"
#define	TP034	"TP034 - all entries for a given device group must be grouped together"
#define TP035	"TP035 - configuring %s %s"
#define TP036	"TP036 - parameter -p or -d is mandatory with -k\n"
#define TP037	"TP037 - path %s does not exist"
#define TP038	"TP038 - pathname %s too long\n"
#define TP039	"TP039 - vsn mismatch: request %s, tape vsn is %s"
#define TP040	"TP040 - release pending"
#define	TP041	"TP041 - %s of %s on %s failed : %s"
#define	TP042	"TP042 - %s : %s error : %s"
#define	TP043	"TP043 - configuration line too long: %s"
#define TP044	"TP044 - fid mismatch: request %s, tape fid for file %d is %s"
#define TP045	"TP045 - cannot write file %d (only %d files are on tape)"
#define	TP047	"TP047 - reselect server requested by operator"
#define	TP048	"TP048 - config postponed: %s currently assigned"
#define	TP049	"TP049 - option -E ignoreeoi is not valid for label type al or sl\n"
#define	TP050	"TP050 - vid mismatch: %s on request, %s on drive\n"

			/* tape daemon internal tables */

#if defined(_WIN32)
typedef long gid_t;
typedef long uid_t;
#endif

struct tpdev {		/* tape device description */
	char	dvn[32];	/* device name */
	int	den;		/* density */
	dev_t	majmin;		/* major/minor device number */
};
struct tpdgpu {		/* units per device group table (pointers in tptab */
	char	name[9];	/* device group name */
	struct tptab *first;	/* pointer to first unit in device group */
	struct tptab *last;	/* pointer to last unit in device group */
	struct tptab *next;	/* pointer to next unit in device group to be alloc. */
};
struct tpfil {		/* tape file description */
	int	blksize;	/* maximum block size */
	int	den;		/* density */
	int	cfseq;		/* current file number */
	char	fid[18];	/* file id */
	char	filstat;	/* file status: new = 'n', old = 'o' */
	int	fsec;		/* file section number */
	int	fseq;		/* file sequence number requested by user */
	int	lbl;		/* label type: al, nl, sl, blp */
	int	lrecl;		/* record length */
	int	numvid;		/* # of vsn/vid in list */
	char	path[MAXPATH];	/* pathname specified by user */
	int	Qfirst;		/* fseq of first file of a mapped volume */
	int	Qlast;		/* fseq of last file of a mapped volume */
	char	recfm[4];	/* record format: F, FB or U */
	int	retentd;	/* retention period in days */
	int	ring;		/* ring option: out = 0, in = 1 */
	char	ignoreeoi;	/* allow to position beyond double tape marks */
	char	Nflag;		/* do not check/change physical tape position */
	char	Tflag;		/* do not check trailer labels */
	int	vseq;		/* volume sequence number */
	char	vid[MAXVSN][7];
	char	vsn[MAXVSN][7];
};
struct tptab {		/* tape unit table */
	char	unm[9];		/* unit name */
	char	dgn[9];		/* TAPE, CART, 8MM */
	char	devtype[9];	/* device type */
	char	dvrname[7];	/* driver name */
	char	loader[14];	/* manual, robot, fhs, acs or lmcp */
	int	ux;		/* index in unit table tptab */
	int	devnum;		/* number of devices defined for this unit */
	struct tpdev *devp;	/* pointer to tape device descriptions */

	int	up;		/* unit status: down = 0, up = 1 */

	int	asn;		/* assign flag: assigned = 1 */
	time_t	asn_time;	/* timestamp of drive assignment */
	struct tpdev *cdevp;	/* pointer to tape device description in use */
	struct tpfil *filp;	/* pointer to tape file description */
	uid_t	uid;
	gid_t	gid;
	char	acctname[7];	/* uuu$gg */
	int	jid;		/* process-group-id */
	char	nqsid[16];	/* QSUB_REQID */

	int	mntovly_pid;	/* pid of mounttape overlay */

	char	vid[7];
	char	vsn[7];
	int	tobemounted;	/* 1 means tape to be mounted */
	int	lbl;		/* label type: al, nl, sl, blp */
	int	ring;		/* ring option: out = 0, in = 1 */
};
struct tpurt {		/* unit reservation table: one entry per jid */
	struct tpurt *prev;
	struct tpurt *next;
	uid_t	uid;
	int	jid;		/* process-group-id */
	int	unldcnt;	/* count of unload in progress for this jid */
	int	totrsvd;	/* total number of reserved units */
	struct	{
		char	name[9];	/* device group name */
		int	rsvd;		/* number reserved */
		int	used;		/* number used */
		int	wait;		/* 1 if waiting for a free unit */
	}	dg[MAXDGP];
};
struct rlsq {		/* rls queue */
	struct rlsq *next;
	struct rlsq *prev;
	char rpn[MAXPATH];
	int unldcnt;	/* count of unload in progress for this rls request */
};
struct waitq {		/* wait queue */
	struct waitq *next;
	struct waitq *prev;
	struct tpmount *reqp;
	int *wfp;
};

			/* tape daemon request structures */

struct tpdrqhdr {	/* tape daemon request header */
	int size;
	int code;
	char rpn[MAXPATH];
};
struct freeunt {		/* free unit request (after unload) */
	struct	tpdrqhdr rh;
	int	jid;		/* process-group-id */
	int	keeprsv;	/* keep reservation */
	char	rpn[MAXPATH];	/* user reply pipe name */
	int	ux;		/* index in unit table tptab */
};
struct killmnt {		/* kill mount request */
	struct	tpdrqhdr rh;
	int	jid;		/* process-group-id */
	char	path[MAXPATH];
};
struct nextvol {		/* next volume request */
	struct	tpdrqhdr rh;
	int	jid;		/* process-group-id */
	char	path[MAXPATH];
};
struct ovlend {		/* overlay ended execution */
	struct	tpdrqhdr rh;
	int	ux;		/* index in unit table tptab */
	int	mntovly_pid;	/* pid of mounttape overlay */
};
struct rslt {		/* reselect request, i.e. switch to new unit */
	struct	tpdrqhdr rh;
	int	jid;		/* process-group-id */
	char	olddvn[9];	/* previous device name */
	char	newdvn[9];	/* new device name */
};
struct tpconf {		/* tpconfig request */
	struct	tpdrqhdr rh;
	int	status;		/* unit status: down = 0, up = 1 */
	int	count;		/* # of units to be configured up/down */
	char	unm[MAXUNIT][9];/* unit names */
};
struct tpinfo {		/* tpinfo request */
	struct	tpdrqhdr rh;
	char	path[MAXPATH];
};
struct tpmount {	/* mount request */
	struct	tpdrqhdr rh;
	uid_t	uid;
	gid_t	gid;
	int	jid;		/* process-group-id */
	char	acctname[7];	/* uuu$gg */
	char	nqsid[16];	/* QSUB_REQID */
	int	blksize;	/* maximum block size */
	int	den;		/* density */
	char	dgn[9];		/* TAPE, CART, 8MM */
	char	dvn[9];		/* device name */
	char	fid[18];	/* file id */
	char	filstat;	/* file status: new = 'n', old = 'o' */
	int	fseq;		/* file sequence number */
	int	lbl;		/* label type: al, nl, sl, blp */
	int	lrecl;		/* record length */
	int	numvid;		/* # of vsn/vid in list */
	char	path[MAXPATH];
	int 	prelabel;	/* called from tplabel -> 1 */
	int	Qfirst;		/* fseq of first file of a mapped volume */
	int	Qlast;		/* fseq of last file of a mapped volume */
	char	recfm[4];	/* record format: F, FB or U */
	int	retentd;	/* retention period in days */
	int	ring;		/* ring option: out = 0, in = 1 */
	char	ignoreeoi;	/* allow to position beyond double tape marks */
	char	Nflag;		/* do not check/change physical tape position */
	char	Tflag;		/* do not check trailer labels */
	char	vid[MAXVSN][7];
	char	vsn[MAXVSN][7];
	int	nretry;
};
struct tprls {		/* rls request */
	struct	tpdrqhdr rh;
	int	jid;		/* process-group-id */
	char	dvn[9];		/* device name */
	char	path[MAXPATH];
	int	keeprsv;	/* keep reservation */
};
struct tprsv {		/* reserv request */
	struct	tpdrqhdr rh;
	uid_t	uid;
	int	jid;		/* process-group-id */
	int	count;		/* # of different device groups requested */
	struct	{
		char	name[9];	/* device group name */
		int	num;		/* number requested */
	}	dg[MAXDGP];
};
struct tpst {		/* tape status request */
	struct	tpdrqhdr rh;
	uid_t	uid;
};
struct updfil {		/* update blksize, cfseq, fid, lrecl, recfm */
	struct	tpdrqhdr rh;
	int	ux;		/* index in unit table tptab */
	int	blksize;	/* maximum block size */
	int	cfseq;		/* current file sequence */
	char	fid[18];	/* file id */
	int	lrecl;		/* record length */
	char	recfm[4];	/* record format: F, FB or U */
};
struct updvsn {		/* update vsn and mount flag */
	struct	tpdrqhdr rh;
	int	ux;		/* index in unit table tptab */
	char	vid[7];
	char	vsn[7];
	int	tobemounted;	/* 1 means tape to be mounted */
	int	lbl;		/* label type: al, nl, sl, blp */
	int	ring;		/* ring option: out = 0, in = 1 */
	int	cfseq;		/* current file sequence */
};
struct tpdreq {		/* tape daemon request */
        struct tpdrqhdr rh;
        char	data[REQBUFSZ];
};

			/* tape daemon reply structures */

struct tpdrphdr {	/* tape daemon reply header */
        int size;
        int rc;
};
struct rsltr {		/* reselect reply, i.e. switch to new unit */
	int	ux;
	char	loader[9];
	char	dvn[32];
};
struct tpinfor {	/* tpinfo reply entry */
	int	blksize;	/* maximum block size */
	int	cfseq;		/* current file sequence */
	int	den;		/* density */
	char	devtype[9];	/* device type */
	char	fid[18];	/* file id */
	int	lrecl;		/* record length */
	char	recfm[4];	/* record format: F, FB or U */
	char	unm[9];		/* unit name */
};
struct tprstr {		/* unit reservation status reply entry */
	uid_t	uid;
	int	jid;		/* process-group-id */
	int	count;		/* # of different device groups */
	struct	{
		char	name[9];	/* device group name */
		int	rsvd;		/* number reserved */
		int	used;		/* number used */
		int	wait;		/* 1 if waiting for a free unit */
	}	dg[MAXDGP];
};
struct tpstr {		/* tape status reply entry */
	uid_t	uid;
	int	jid;		/* process-group-id */
	char	dgn[9];		/* TAPE, CART, 8MM */
	int	status;		/* unit status: down = 0, up = 1 */
	int	asn;		/* assign flag: assigned = 1 */
	time_t	asn_time;	/* timestamp of drive assignment */
	char	unm[9];		/* unit name */
	int	ring;		/* ring option: out = 0, in = 1 */
	int	lbl;		/* label type: al, nl, sl, blp */
	int	tobemounted;	/* 1 means tape to be mounted */
	char	vid[7];
	char	vsn[7];
};
struct tpdrep {		/* tape daemon reply */
        struct tpdrphdr rh;
	char	data[REPBUFSZ];
};

			/* interface to TMS */
struct vsn_req {
	int	num;				/* number of vsns in list */
	uid_t	uid;
	gid_t	gid;
	int	mode;
#define VSN_READ	1
#define VSN_WRITE	2
	char	vsn[MAXVSN][7];
	char	vid[MAXVSN][7];
	char	acctname[7];
	int	jid;
	char	nqsid[16];
	char	dvn[9];
	int	nounload;
	char	path[MAXPATH];
	char	dgn[9];
	char	lbl[4];
};

			/* interface for user label writing */
struct labelinfo {
	char	path[MAXPATH];	/* pathname */
	char	labeltype[2];	/* label type: al, nl or sl */
	char	Tflag;		/* do not check trailer labels */
	char	fseq[4];	/* file sequence number */
	char	vol1[80];	/* VOL1 label */
	char	hdr1[80];	/* HDR1 label */
	char	hdr2[80];	/* HDR2 label */
	char	lf;		/* line feed */
};
