/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tpconfig.c	1.4 10/12/93 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	tpconfig - configure tape units up/down */
#include <stdio.h>
#include <sys/types.h>
#include "tape.h"
int jid;
struct tpconf req;

main(argc, argv)
int	argc;
char	**argv;
{
	char repbuf[1];
	int c, n;

	if (argc != 3) {
		usage (argv[0]);
		exit (ETPRM);
	}
	jid = findpgrp();
	req.rh.size = sizeof(struct tpconf);
	req.rh.code = TPCONF;
	if (strcmp (argv[2], "up") == 0)
		req.status = 1;
	else if (strcmp (argv[2], "down") == 0)
		req.status = 0;
	else {
		usage (argv[0]);
		exit (ETPRM);
	}
	strcpy (req.unm[0], argv[1]);
	req.count = 1;
	c = send2tpd (&req, repbuf, &n);
	switch (c) {
	case 0:
		break;
	case ETDNP:
		fprintf (stderr, "%s\n", TP000);
		break;
	case ETSYS:
		fprintf (stderr, "%s\n", TP026);
		break;
	case ETTMO:
		fprintf (stderr, "%s\n", TP001);
		break;
	default:
		fprintf (stderr, TP009, req.unm[0], c);
	}
	exit (c);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "unit_name status\n");
}

