/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tpdaemon.c	1.82 05/09/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <malloc.h>
#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#if defined(_AIX) && (defined(_IBMESA) || defined(RS6000PCTA))
#include <sys/ioctl.h>
#include <sys/mtio.h>
#endif
#if defined(ADSTAR)
#include <sys/Atape.h>
#endif
#if sgi || sun || ultrix
#include <sys/termio.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
#include <sys/socket.h>
#include <sys/un.h>
#endif
#if defined(_AIX) && defined(_IBMR2)
#include <sys/select.h>
#endif
#include <sys/wait.h>
#include "tape.h"
#if SACCT
#include "../h/sacct.h"
#endif
int jid;
int nbdgp;		/* number of device groups */
int nbtpunit;		/* number of tape units */
struct tpdgpu dgpu[MAXDGP];
fd_set readfd, readmask;
struct tpdrep rep;
struct waitq *retryqp;	/* pointer to retry queue */
struct rlsq *rlsqp;	/* pointer to rls queue */
int rqfd;
struct tpurt tpdurt;	/* global unit reservation table */
struct tptab *tptabp;	/* pointer to tape unit table */
struct waitq *wfuqp;	/* pointer to waiting for free unit queue */
#if (defined(_AIX) && defined(_IBMR2)) || defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha)) || defined(linux)
struct sigaction sa;
#endif
char func[16];
time_t time();

main()
{
	int c, l;
	int maxfds;
	char *p;
	struct waitq *rtryp;
	struct timeval timeval;
	struct tpdrqhdr tpdrqhdr;
	time_t lasttime, tm;
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	struct sockaddr_un sname, fromunix;
	int fromlen = sizeof(fromunix);
	int s;
#endif
	void wait4child();

#if defined(ultrix) || (defined(sun) && !defined(SOLARIS)) || defined(linux)
	maxfds = getdtablesize();
#else
	maxfds = _NFILE;
#endif
#ifndef TEST
	/* Background */
	if ((c = fork()) < 0) {
		fprintf (stderr, "tpdaemon: cannot fork\n");
		exit (ETSYS);
	} else
		if (c > 0) exit (0);
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_IBMESA)
        c = setpgrp(0, getpid());
#else
#if (defined(__osf__) && defined(__alpha)) || defined(linux)
        c = setsid();
#else
#if HPUX10
	c = setpgrp3();
#else
        c = setpgrp();
#endif
#endif
#endif
	for (c = 0; c < maxfds; c++)
		close (c);
#if ultrix || sun || sgi
	c = open ("/dev/tty", O_RDWR);
	if (c >= 0) {
		ioctl (c, TIOCNOTTY, 0);
		(void) close(c);
	}
#endif
#endif
#if defined(ultrix) || (defined(sun) && !defined(SOLARIS)) || (defined(_AIX) && defined(_IBMESA))
	signal (SIGCHLD, wait4child);
#else
#if (defined(sgi) && !defined(IRIX5)) || defined(hpux)
	signal (SIGCLD, wait4child);
#else
#if (defined(_AIX) && defined(_IBMR2)) || defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha)) || defined(linux)
	sa.sa_handler = wait4child;
	sa.sa_flags = SA_RESTART;
	sigaction (SIGCHLD, &sa, NULL);
#endif
#endif
#endif
	sleep (1);	/* the original process could be still running */
	strcpy (func, "tpdaemon");
	jid = findpgrp();
	tplogit (func, "started");
#if SACCT
	tapeacct (TPDSTART, 0, 0, jid, ".", "", "", "", 0, "");
#endif

	/* initialize tape units table */
	inittut();

	/* initialize global unit reservation table */
	initurt();

	lasttime = time(0);
	FD_ZERO (&readmask);
	FD_ZERO (&readfd);
	signal (SIGPIPE,SIG_IGN);

	/* Open command pipe */
	unlink (REQPIPE);
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	if ((s = socket (AF_UNIX, SOCK_STREAM, 0)) < 0) {
		tplogit (func, TP002, REQPIPE, "socket", errno);
		exit (ETSYS);
	}
	sname.sun_family = AF_UNIX;
	strcpy (sname.sun_path, REQPIPE);
	if (bind (s, (struct sockaddr *) &sname, sizeof(sname)) < 0) {
		tplogit (func, TP002, REQPIPE, "bind", errno);
		exit (ETSYS);
	}
	listen (s, 5);
	FD_SET (s, &readmask);
#else
	if (mknod (REQPIPE, 0010700, 0) < 0) {
		tplogit (func, TP002, REQPIPE, "mknod", errno);
		exit (ETSYS);
	}
	if ((rqfd = open (REQPIPE, O_RDONLY | O_NDELAY)) < 0) {
		tplogit (func, TP002, REQPIPE, "open", errno);
		exit (ETSYS);
	}
	FD_SET (rqfd, &readmask);
#endif

	while (1) {
		/* scan the retry queue first */
		while (retryqp) {
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
		        rqfd = atoi (retryqp->reqp->rh.rpn);
#endif
			p = (char *) retryqp->reqp;
			rtryp = retryqp;
			retryqp = retryqp->next;
			if (retryqp) retryqp->prev = NULL;
			free (rtryp);
			procmountreq (p, 1);
		}
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
		if (FD_ISSET (s, &readfd)) {
			rqfd = accept (s, (struct sockaddr *) &fromunix, &fromlen);
#else
		if (FD_ISSET (rqfd, &readfd)) {
#endif
			l = READ (rqfd, (char *) &tpdrqhdr, sizeof(tpdrqhdr));
			if (l == sizeof(tpdrqhdr)) {
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
				sprintf (tpdrqhdr.rpn, "%d", rqfd);
#endif
				if ((p = (char *) malloc (tpdrqhdr.size)) == NULL) {
					tplogit (func, TP005);
					exit (ETSYS);
				}
				l = tpdrqhdr.size - sizeof(tpdrqhdr);
				READ (rqfd, p + sizeof(tpdrqhdr), l);
				memcpy (p, &tpdrqhdr, sizeof(tpdrqhdr));
				procreq (p);
			} else if (l > 0)
				tplogit (func, TP004, l);
			else if (l < 0)
				tplogit (func, TP002, REQPIPE, "read", errno);
			FD_CLR (rqfd, &readfd);
		}
		if (((tm = time (0)) - lasttime) >= CLNREQI) {
			clean4jobdied();  /* look for jobs that died */
			lasttime = tm;
		}
		memcpy (&readfd, &readmask, sizeof(readmask));
		timeval.tv_sec = CHECKI;	/* must set each time for linux */
		timeval.tv_usec = 0;
		if (select (maxfds, &readfd, (fd_set *)0, (fd_set *)0, &timeval) < 0) {
			FD_ZERO (&readfd);
		}
	}
}

procreq(p)
struct tpdreq *p;
{
	switch (p->rh.code) {
	case TPRSV:
		procrsvreq (p);
		break;
	case TPMOUNT:
		procmountreq (p, 0);
		break;
	case TPRSTAT:
		procrstatreq (p);
		break;
	case TPSTAT:
		procstatreq (p);
		break;
	case TPCONF:
		procconfreq (p);
		break;
	case TPRLS:
		procrlsreq (p);
		break;
	case UPDVSN:
		procuvsnreq (p);
		break;
	case OVLEND:
		procovlendreq (p);
		break;
	case KILLMNT:
		procklmntreq (p);
		break;
	case FREEUNT:
		procfruntreq (p);
		break;
	case NEXTVOL:
		procnextvol (p);
		break;
	case RSLT:
		procrsltreq (p);
		break;
	case UPDFIL:
		procufilreq (p);
		break;
	case TPINFO:
		procinforeq (p);
		break;
	default:
		tplogit (func, TP003, p->rh.code);
		rep.rh.rc = ETSYS;
		sendrep (p->rh.rpn, &rep);
	}
}

procrsvreq(reqp)
struct tprsv *reqp;
{
	int c, i, j, n;
	struct tpurt *prev, *urtp;

	tplogit (func, "reserv request");
	c = 0;
	n = 0;
	urtp = &tpdurt;
	while (urtp) {
		if (reqp->jid == urtp->jid) {
			c = ETRSV;	/* units already reserved for this job */
			goto reply;
		}
		n++;
		prev = urtp;
		urtp = urtp->next;
	}
	if (n >= MAXUSER) {
		c = ETMUSR;	/* too many tape users */
		goto reply;
	}
	urtp = (struct tpurt *) calloc (1, sizeof(struct tpurt));
	urtp->uid = reqp->uid;
	urtp->jid = reqp->jid;
	for (j = 0; j < nbdgp; j++) {
		strcpy (urtp->dg[j].name, tpdurt.dg[j].name);
	}
	for (i = 0; i < reqp->count; i++) {
		for (j = 0; j < nbdgp; j++) {
			if (strcmp (urtp->dg[j].name, reqp->dg[i].name) == 0) {
				if (reqp->dg[i].num <= tpdurt.dg[j].rsvd)
					break;
				else {
					c = ETNDV;	/* too many units requested */
					free (urtp);
					goto reply;
				}
			}
		}
		if (j == nbdgp) {
				c = ETIDG;	/* invalid device group name */
				free (urtp);
				goto reply;
		}
		urtp->dg[j].rsvd = reqp->dg[i].num;
		urtp->totrsvd += reqp->dg[i].num;	/* total user reservation */
	}
	prev->next = urtp;
	urtp->prev = prev;
reply:
	rep.rh.rc = c;
	rep.rh.size = sizeof(struct tpdrphdr);
	sendrep (reqp->rh.rpn, &rep);
	free (reqp);
}

procmountreq(reqp, inwq)
struct tpmount *reqp;
int inwq;
{
	int c, i, j;
	struct tpdev *cdevp;
	int found;
	struct tpfil *filp;
	struct tptab *tunp;
	struct tpurt *urtp;

	tplogit (func, "mount request %s", reqp->vid[0]);
	c = 0;
	rep.data[0] = '\0';
	filp = NULL;

	/* check if reserv done */

	urtp = tpdurt.next;
	while (urtp) {
		if (reqp->jid == urtp->jid) break;
		urtp = urtp->next;
	}
	if (urtp == 0) {
		c = ETNRS;	/* reserve not done */
		goto reply;
	}

	/* check device group name validity */

	for (j = 0; j < nbdgp; j++)
		if (strcmp (urtp->dg[j].name, reqp->dgn) == 0) break;
	if (j == nbdgp) {
		c = ETIDG;	/* invalid device group name */
		goto reply;
	}

	if (reqp->dvn[0] != 0) {	/* request is for a specific unit */
		tunp = tptabp;
		for (i = 0; i < nbtpunit; i++) {
			if (strcmp (tunp->unm, reqp->dvn) == 0) break;
			tunp++;
		}
		if (i == nbtpunit) {
			c = ETIDN;	/* non existing unit */
			goto reply;
		}
		if (strcmp (tunp->dgn, reqp->dgn) != 0) {
			c = ETIDG;	/* device group name does not match */
			goto reply;
		}
		/* check if the tape is already mounted for the same job */
		if (tunp->asn == 1 && 
			tunp->jid == reqp->jid &&
			strcmp (tunp->filp->vid[0], reqp->vid[0]) == 0) {
			unlink (tunp->filp->path);	/* delete previous path */
			filp = tunp->filp;
			goto bldtfd;
		}
		if (urtp->dg[j].used >= urtp->dg[j].rsvd) {
			c = ETNDV;	/* request would exceed # of units rsvd */
			goto reply;
		}
		if (chk_den (tunp, reqp->den, &cdevp) != 0) {
			c = ETIDN;	/* unit does not have requested density */
			goto reply;
		}
		if (tunp->asn != 0 || tunp->up != 1) {
			add2wfuq (urtp, reqp, j, inwq);	/* add to wait for free unit queue */
			return (0);
		}

	} else {	/* non specific unit request */

		/* check if the tape is already mounted for the same job */

		found = 0;
		for (tunp = dgpu[j].first; tunp <= dgpu[j].last; tunp++) {
			if (tunp->asn == 1 && 
				tunp->jid == reqp->jid &&
				strcmp (tunp->filp->vid[0], reqp->vid[0]) == 0) {
				found = 1;
				break;
			}
		}
		if (found) {	/* tape already mounted */
			unlink (tunp->filp->path);	/* delete previous path */
			filp = tunp->filp;
			goto bldtfd;
		}
		if (urtp->dg[j].used >= urtp->dg[j].rsvd) {
			c = ETNDV;	/* request would exceed # of units rsvd */
			goto reply;
		}

		/* check if there exists one unit not assigned, not down
		 * with the requested options in this device group.
		 * allocate units in a circular way.
		 */

		found = 0;
		tunp = dgpu[j].next;
		do {
			if (tunp->asn == 0 && tunp->up == 1 &&
			    chk_den (tunp, reqp->den, &cdevp) == 0) {
				found = 1;
				break;
			}
			tunp = (tunp == dgpu[j].last) ? dgpu[j].first : tunp + 1;
		} while (tunp != dgpu[j].next);
		if (! found) {
			for (tunp = dgpu[j].first; tunp <= dgpu[j].last; tunp++) {
				if (chk_den (tunp, reqp->den, &cdevp) == 0) {
					found = 1;
					break;
				}
			}
			if (! found) {
				c = ETIDN;	/* no unit with requested density */
				goto reply;
			}
			add2wfuq (urtp, reqp, j, inwq);	/* add to wait for free unit queue */
			return (0);
		}
		dgpu[j].next = (tunp == dgpu[j].last) ? dgpu[j].first : tunp + 1;
	}

	urtp->dg[j].used++;	/* increment usage count in user reservation table */
	tpdurt.dg[j].used++;	/* increment usage count in global reservation table */
	tunp->asn = 1;
	tunp->asn_time = time (0);
	tunp->cdevp = cdevp;
	tunp->uid = reqp->uid;
	tunp->gid = reqp->gid;
	strcpy (tunp->acctname, reqp->acctname);
	tunp->jid = reqp->jid;
	strcpy (tunp->nqsid, reqp->nqsid);

#if SACCT
	tapeacct (TPASSIGN, tunp->uid, tunp->gid, tunp->jid, tunp->nqsid,
		tunp->dgn, tunp->unm, "", 0, "");
#endif

	/* build tape file description */

	filp = (struct tpfil *) calloc (1, sizeof(struct tpfil));
	tunp->filp = filp;
bldtfd:
	filp->blksize = reqp->blksize;
	filp->den = tunp->cdevp->den;
	strcpy (filp->fid, reqp->fid);
	filp->filstat = reqp->filstat;
	filp->fsec = 1;
	filp->fseq = reqp->fseq;
	filp->lbl = reqp->lbl;
	filp->lrecl = reqp->lrecl;
	filp->numvid = reqp->numvid;
	strcpy (filp->path, reqp->path);
	filp->Qfirst = reqp->Qfirst;
	filp->Qlast = reqp->Qlast;
	strcpy (filp->recfm, reqp->recfm);
	filp->retentd = reqp->retentd;
	filp->ring = reqp->ring;
	filp->ignoreeoi = reqp->ignoreeoi;
	filp->Nflag = reqp->Nflag;
	filp->Tflag = reqp->Tflag;
	filp->vseq = 1;
	for (i = 0; i < reqp->numvid; i++) {
		strcpy (filp->vid[i], reqp->vid[i]);
		strcpy (filp->vsn[i], reqp->vsn[i]);
	};

	/* create special device */

	if (mknod (filp->path, 0020700, tunp->cdevp->majmin) < 0) {
		if (errno == EEXIST)
			strcpy (rep.data, TP022);
		else
			sprintf (rep.data, TP002, filp->path, "mknod", errno);
		c = errno;
		goto reply;
	}
	if (chown (filp->path, tunp->uid, tunp->gid) < 0) {
		tplogit (func, TP002, filp->path, "chown", errno);
		c = ETSYS;
		goto reply;
	}
	c = fork_exec_mount (tunp, filp, reqp->prelabel, reqp->rh.rpn);

reply:
	if (c) {
		rep.rh.rc = c;
		rep.rh.size = sizeof(struct tpdrphdr) + strlen (rep.data);
		sendrep (reqp->rh.rpn, &rep);
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	} else {
		close (rqfd);
#endif
	}
	free (reqp);
	return (0);
}

procrstatreq(reqp)
struct tpst *reqp;
{
	int j, n;
	struct tpurt *urtp;
	struct tprstr *trstp;

	tplogit (func, "unit reservation status request");
	trstp = (struct tprstr *) rep.data;
	n = 0;
	urtp = &tpdurt;
	while (urtp) {
		trstp->uid = urtp->uid;
		trstp->jid = urtp->jid;
		trstp->count = nbdgp;
		for (j = 0; j < nbdgp; j++) {
			strcpy (trstp->dg[j].name, urtp->dg[j].name);
			trstp->dg[j].rsvd = urtp->dg[j].rsvd;
			trstp->dg[j].used = urtp->dg[j].used;
			trstp->dg[j].wait = urtp->dg[j].wait;
		}
		n++;
		trstp++;
		urtp = urtp->next;
	}
	rep.rh.rc = 0;
	rep.rh.size = sizeof(struct tpdrphdr) + (n * sizeof(struct tprstr));
	sendrep (reqp->rh.rpn, &rep);
	free (reqp);
}

procstatreq(reqp)
struct tpst *reqp;
{
	int j;
	struct tptab *tunp;
	struct tpstr *tstp;

	tplogit (func, "status request");
	tstp = (struct tpstr *) rep.data;
	tunp = tptabp;
	for (j = 0; j < nbtpunit; j++) {
		strcpy (tstp->unm, tunp->unm);
		strcpy (tstp->dgn, tunp->dgn);
		tstp->status = tunp->up;
		tstp->asn = tunp->asn;
		tstp->asn_time = tunp->asn_time;
		tstp->uid = tunp->uid;
		tstp->jid = tunp->jid;
		tstp->ring = tunp->ring;
		tstp->lbl = tunp->lbl;
		tstp->tobemounted = tunp->tobemounted;
		strcpy (tstp->vid, tunp->vid);
		strcpy (tstp->vsn, tunp->vsn);
		tstp++;
		tunp++;
	}
	rep.rh.rc = 0;
	rep.rh.size = sizeof(struct tpdrphdr) + (nbtpunit * sizeof(struct tpstr));
	sendrep (reqp->rh.rpn, &rep);
	free (reqp);
}

procconfreq(reqp)
struct tpconf *reqp;
{
	int c, i, j;
	struct tptab *tunp;

	tplogit (func, "config request");
	c = 0;
	for (i = 0; i < reqp->count; i++) {
		tunp = tptabp;
		for (j = 0; j < nbtpunit; j++) {
			if (strcmp (reqp->unm[i], tunp->unm) == 0) break;
			tunp++;
		}
		if (j == nbtpunit) {	/* unknown unit name */
			c = ETIDN;
			break;
		} else {
			if (tunp->up == reqp->status) continue;
			tunp->up = reqp->status;
			for (j = 0; j < nbdgp; j++) {
				if (strcmp (tunp->dgn, tpdurt.dg[j].name) == 0) break;
			}
			c = confunit (tunp, reqp->status);
			if (reqp->status) {	/* tpconfig up */
				if (c == 0) {
					tpdurt.dg[j].rsvd++;
					resched_wdevreq();	/* resched waiting for free unit req */
				}
				if (c == ETDCA)	/* drive currently assigned */
					tpdurt.dg[j].rsvd++;
			} else {
				tpdurt.dg[j].rsvd--;
			}
		}
	}
	rep.rh.rc = c;
	rep.rh.size = sizeof(struct tpdrphdr);
	sendrep (reqp->rh.rpn, &rep);
	free (reqp);
}

procrlsreq(reqp)
struct tprls *reqp;
{
	int c, i, n;
	struct tpurt *urtp;
	struct tptab *tunp;

	tplogit (func, "rls request %s %s", reqp->path[0] ? reqp->path :
		reqp->dvn[0] ? reqp->dvn : "-a", reqp->keeprsv ? "-k" : "");
	c = 0;

	/* check if reserv done */

	urtp = tpdurt.next;
	while (urtp) {
		if (reqp->jid == urtp->jid) break;
		urtp = urtp->next;
	}
	if (urtp == 0) goto reply;
	if (reqp->path[0] != '\0') {	/* release a specific path */
		tunp = tptabp;
		for (i = 0; i < nbtpunit; i++) {
			if (tunp->jid == reqp->jid && tunp->asn != 0 &&
				strcmp (tunp->filp->path, reqp->path) == 0) {
				if (tunp->asn == 1) {
					c = relunit (tunp, reqp->rh.rpn, reqp->keeprsv);
					if (c == 0) urtp->unldcnt++;
				} else {	/* rls in progress */
					if (! reqp->keeprsv)
						tunp->asn = -2;
					c = ETRLSP;
				}
				break;
			}
			tunp++;
		}
	} else if (reqp->dvn[0] != '\0') {	/* release a specific unit */
		tunp = tptabp;
		for (i = 0; i < nbtpunit; i++) {
			if (tunp->jid == reqp->jid && tunp->asn != 0 &&
				strcmp (tunp->unm, reqp->dvn) == 0) {
				if (tunp->asn == 1) {
					c = relunit (tunp, reqp->rh.rpn, reqp->keeprsv);
					if (c == 0) urtp->unldcnt++;
				} else {	/* rls in progress */
					if (! reqp->keeprsv)
						tunp->asn = -2;
					c = ETRLSP;
				}
				break;
			}
			tunp++;
		}
	} else {			/* release everything */
		tunp = tptabp;
		for (i = 0; i < nbtpunit; i++) {
			if (tunp->jid == reqp->jid && tunp->asn != 0) {
				if (tunp->asn == 1) {
					n = relunit (tunp, reqp->rh.rpn, reqp->keeprsv);
					if (n == 0) urtp->unldcnt++;
					else c = n;
				} else {	/* rls in progress */
					tunp->asn = -2;
					c = ETRLSP;
				}
			}
			tunp++;
		}
		if (urtp->unldcnt == 0) {	/* no unit assigned, free only rsv */
			(urtp->prev)->next = urtp->next;
			if (urtp->next) (urtp->next)->prev = urtp->prev;
			free (urtp);
			urtp = 0;
		}
	}
reply:
	if (c || urtp == 0 || urtp->unldcnt == 0) {
		rep.rh.rc = c;
		rep.rh.size = sizeof(struct tpdrphdr);
		sendrep (reqp->rh.rpn, &rep);
	}
	free (reqp);
}

procuvsnreq(reqp)
struct updvsn *reqp;
{
	struct tptab *tunp;

	tplogit (func, "update vsn request");
	tunp = tptabp + reqp->ux;
	strcpy (tunp->vid, reqp->vid);
	strcpy (tunp->vsn, reqp->vsn);
	tunp->tobemounted = reqp->tobemounted;
	tunp->lbl = reqp->lbl;
	tunp->ring = reqp->ring;
	tunp->filp->cfseq = reqp->cfseq;
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	close (rqfd);
#endif
	free (reqp);
}

procovlendreq(reqp)
struct ovlend *reqp;
{
	struct tptab *tunp;

	tplogit (func, "overlay end request");
	tunp = tptabp + reqp->ux;
	if (reqp->mntovly_pid == tunp->mntovly_pid)
		tunp->mntovly_pid = 0;
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	close (rqfd);
#endif
	free (reqp);
}

procklmntreq(reqp)
struct killmnt *reqp;
{
	int c, i;
	struct tpurt *urtp;
	struct tptab *tunp;
	struct waitq *wqp;

	tplogit (func, "kill mount request");
	c = 0;

	/* check if reserv done */

	urtp = tpdurt.next;
	while (urtp) {
		if (reqp->jid == urtp->jid) break;
		urtp = urtp->next;
	}
	if (urtp != 0) {
		tunp = tptabp;
		for (i = 0; i < nbtpunit; i++) {
			if (tunp->jid == reqp->jid && tunp->asn == 1 &&
				strcmp (tunp->filp->path, reqp->path) == 0) {
				if (tunp->mntovly_pid) {
					tplogit (func, "killing process %d",
						tunp->mntovly_pid);
					kill (tunp->mntovly_pid, SIGINT);
					tunp->mntovly_pid = 0;
				}
				break;
			}
			tunp++;
		}
		if (i == nbtpunit && wfuqp) {	/* not assigned to unit */
			wqp = wfuqp;	/* probably waiting for free unit */
			while (wqp) {
				if (wqp->reqp->jid == reqp->jid &&
				    strcmp (wqp->reqp->path, reqp->path) == 0) {
					rmfromwfuq (wqp);	/* remove it */
					break;
				}
				wqp = wqp->next;
			}
		}
	}
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	close (rqfd);
#endif
	free (reqp);
}

procfruntreq(reqp)
struct freeunt *reqp;
{
	int found;
	int j;
	struct rlsq *rqp;
	struct tptab *tunp;
	struct tpurt *urtp;

	tplogit (func, "free unit request");
	tunp = tptabp + reqp->ux;
	urtp = tpdurt.next;
	while (urtp) {
		if (reqp->jid == urtp->jid) break;
		urtp = urtp->next;
	}

	for (j = 0; j < nbdgp; j++) {
		if (strcmp (urtp->dg[j].name, tunp->dgn) == 0) break;
	}
	urtp->dg[j].used--;	/* decrement usage count */
	tpdurt.dg[j].used--;	/* decrement global usage count */
	if (! reqp->keeprsv || tunp->asn == -2) {
		urtp->dg[j].rsvd--;	/* decrement user reservation for dev group */
		urtp->totrsvd--;	/* decrement global user reservation */
	}
	urtp->unldcnt--;		/* decrement number of unloads in progress */
	tunp->asn = 0;		/* unassign unit */
	tunp->asn_time = 0;
	free (tunp->filp);	/* release tape file description */
	tunp->filp = 0;
	tunp->vid[0] = '\0';
	tunp->vsn[0] = '\0';
	tunp->tobemounted = 0;

#if SACCT
	tapeacct (TPFREE, tunp->uid, tunp->gid, tunp->jid, tunp->nqsid,
		tunp->dgn, tunp->unm, "", 0, "");
	if (tpdurt.dg[j].wait)
		tapeacct (TPDGQ, tunp->uid, tunp->gid, tunp->jid, tunp->nqsid,
			tunp->dgn, "", "", tpdurt.dg[j].wait-1, "");
#endif

	if (tunp->up)
		resched_wdevreq();	/* resched waiting for free unit requests */
	else
		confunit (tunp, 0);

	if (urtp->totrsvd <= 0) {	/* no more reserved devices, free entry */
		(urtp->prev)->next = urtp->next;
		if (urtp->next) (urtp->next)->prev = urtp->prev;
		free (urtp);
	}
	found = 0;
	rqp = rlsqp;
	while (rqp) {
		if (strcmp (rqp->rpn, reqp->rpn) == 0) {
			found = 1;
			break;
		}
		rqp = rqp->next;
	}
	if (found && --rqp->unldcnt <= 0) {	/* all unloads are terminated for this rls req */
		if (rqp->prev) (rqp->prev)->next = rqp->next;
		else rlsqp = rqp->next;
		if (rqp->next) (rqp->next)->prev = rqp->prev;
		free (rqp);
		rep.rh.rc = 0;
		rep.rh.size = sizeof(struct tpdrphdr);
		sendrep (reqp->rpn, &rep);
	}
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	close (rqfd);
#endif
	free (reqp);
}

procnextvol(reqp)
struct nextvol *reqp;
{
	int c, i;
	struct tpurt *urtp;
	struct tptab *tunp;

	tplogit (func, "nextvol request");
	c = 0;
	rep.data[0] = '\0';

	/* check if reserv done */

	urtp = tpdurt.next;
	while (urtp) {
		if (reqp->jid == urtp->jid) break;
		urtp = urtp->next;
	}
	if (urtp == 0) {
		c = ETNRS;	/* reserve not done */
		goto reply;
	}
	tunp = tptabp;
	for (i = 0; i < nbtpunit; i++) {
		if (tunp->jid == reqp->jid && tunp->asn == 1 &&
			strcmp (tunp->filp->path, reqp->path) == 0) {
			break;
		}
		tunp++;
	}
	if (i < nbtpunit)
		if (++tunp->filp->vseq > tunp->filp->numvid)
			c = ETEOL;
		else {
			++tunp->filp->fsec;
			c = fork_exec_mount (tunp, tunp->filp, 0, reqp->rh.rpn);
		}
	else {
		sprintf (rep.data, TP037, reqp->path);
		c = ENOENT;
	}
reply:
	if (c) {
		rep.rh.rc = c;
		rep.rh.size = sizeof(struct tpdrphdr) + strlen (rep.data);
		sendrep (reqp->rh.rpn, &rep);
	}
	free (reqp);
}

procrsltreq(reqp)
struct rslt *reqp;
{
	int c, i;
	struct tpdev *cdevp;
	struct tptab *oldtunp, *tunp;
	struct tpurt *urtp;
	struct rsltr *rslp;

	tplogit (func, "reselect request");
	c = 0;

	/* check if reserv done */

	urtp = tpdurt.next;
	while (urtp) {
		if (reqp->jid == urtp->jid) break;
		urtp = urtp->next;
	}
	if (urtp == 0) {
		c = ETNRS;	/* reserve not done */
		goto reply;
	}

	/* Look for unit previously assigned */

	oldtunp = tptabp;
	for (i = 0; i < nbtpunit; i++) {
		if (oldtunp->jid == reqp->jid && oldtunp->asn == 1 &&
			strcmp (oldtunp->unm, reqp->olddvn) == 0) break;
		oldtunp++;
	}

	/* Look for requested unit */

	tunp = tptabp;
	for (i = 0; i < nbtpunit; i++) {
		if (strcmp (tunp->unm, reqp->newdvn) == 0) break;
		tunp++;
	}
	if (i == nbtpunit) {
		c = ETIDN;	/* non existing unit */
		goto reply;
	}
	if (strcmp (tunp->dgn, oldtunp->dgn) != 0) {
		c = ETIDG;	/* device group name does not match */
		goto reply;
	}
	if (chk_den (tunp, oldtunp->cdevp->den, &cdevp) != 0) {
		c = ETIDN;	/* unit does not have requested density */
		goto reply;
	}
	if (tunp->asn != 0 || tunp->up != 1) {
		c = EBUSY;
		goto reply;
	}

	tunp->asn = 1;		/* assign new unit */
	tunp->asn_time = time (0);
	tunp->cdevp = cdevp;
	tunp->filp = oldtunp->filp;
	tunp->uid = oldtunp->uid;
	tunp->gid = oldtunp->gid;
	strcpy (tunp->acctname, oldtunp->acctname);
	tunp->jid = oldtunp->jid;
	strcpy (tunp->nqsid, oldtunp->nqsid);
	tunp->mntovly_pid = oldtunp->mntovly_pid;

	oldtunp->asn = 0;          /* unassign previous unit */
	oldtunp->asn_time = 0;
	oldtunp->filp = 0;
	oldtunp->vid[0] = '\0';
	oldtunp->vsn[0] = '\0';
	oldtunp->tobemounted = 0;

	unlink (tunp->filp->path);	/* delete previous path */

#if SACCT
	tapeacct (TPFREE, tunp->uid, tunp->gid, tunp->jid, tunp->nqsid,
		oldtunp->dgn, oldtunp->unm, "", 0, "");
	tapeacct (TPASSIGN, tunp->uid, tunp->gid, tunp->jid, tunp->nqsid,
		tunp->dgn, tunp->unm, "", 0, "");
#endif
	if (! oldtunp->up)
		confunit (tunp, 0);

	/* create special device */

	if (mknod (tunp->filp->path, 0020700, tunp->cdevp->majmin) < 0) {
		sprintf (rep.data, TP002, tunp->filp->path, "mknod", errno);
		c = errno;
		goto reply;
	}
	if (chown (tunp->filp->path, tunp->uid, tunp->gid) < 0) {
		tplogit (func, TP002, tunp->filp->path, "chown", errno);
		c = ETSYS;
		goto reply;
	}

	rslp = (struct rsltr *) rep.data;
	rslp->ux = tunp->ux;
	strcpy (rslp->loader, tunp->loader);
	strcpy (rslp->dvn, tunp->cdevp->dvn);
reply:
	rep.rh.rc = c;
	rep.rh.size = sizeof(struct tpdrphdr) + (c == 0 ? sizeof(struct rsltr):0);
	sendrep (reqp->rh.rpn, &rep);
	free (reqp);
}

procufilreq(reqp)
struct updfil *reqp;
{
	struct tptab *tunp;

	tplogit (func, "update file info request");
	tunp = tptabp + reqp->ux;
	tunp->filp->blksize = reqp->blksize;
	tunp->filp->cfseq = reqp->cfseq;
	strcpy (tunp->filp->fid, reqp->fid);
	tunp->filp->lrecl = reqp->lrecl;
	strcpy (tunp->filp->recfm, reqp->recfm);
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	close (rqfd);
#endif
	free (reqp);
}

procinforeq(reqp)
struct tpinfo *reqp;
{
	int found;
	int i;
	struct tptab *tunp;
	struct tpinfor *tinfp;

	tplogit (func, "tpinfo request");
	found = 0;
	tinfp = (struct tpinfor *) rep.data;
	tunp = tptabp;
	for (i = 0; i < nbtpunit; i++) {
		if (tunp->asn != 0 &&
		    strcmp (tunp->filp->path, reqp->path) == 0) {
			found = 1;
			break;
		}
		tunp++;
	}
	if (! found) {
		sprintf (rep.data, TP037, reqp->path);
		rep.rh.rc = ENOENT;
		rep.rh.size = sizeof(struct tpdrphdr) + strlen (rep.data);
	} else {
		tinfp->blksize = tunp->filp->blksize;
		tinfp->cfseq = tunp->filp->cfseq;
		if (tunp->filp->Qfirst) tinfp->cfseq -= tunp->filp->Qfirst - 1;
		tinfp->den = tunp->filp->den;
		strcpy (tinfp->devtype, tunp->devtype);
		strcpy (tinfp->fid, tunp->filp->fid);
		tinfp->lrecl = tunp->filp->lrecl;
		strcpy (tinfp->recfm, tunp->filp->recfm);
		strcpy (tinfp->unm, tunp->unm);
		rep.rh.rc = 0;
		rep.rh.size = sizeof(struct tpdrphdr) + sizeof(struct tpinfor);
	}
	sendrep (reqp->rh.rpn, &rep);
	free (reqp);
}

add2wfuq(urtp, reqp, j, inwq)
struct tpurt *urtp;
struct tpmount *reqp;
int j;
int inwq;
{
	/* add request to the wait for free unit queue */
	struct waitq *next, *prev, *wqp;

	prev = 0;
	urtp->dg[j].wait = 1;
	tpdurt.dg[j].wait++;
#if SACCT
	if (! inwq)
		tapeacct (TPDGQ, reqp->uid, reqp->gid, reqp->jid, reqp->nqsid,
			reqp->dgn, "", "", tpdurt.dg[j].wait, "");
#endif
	wqp = wfuqp;
	while (wqp) {
		if (wqp->reqp->nretry < reqp->nretry) break;
		prev = wqp;
		wqp = wqp->next;
	}
	next = wqp;
	wqp = (struct waitq *) calloc (1, sizeof(struct waitq));
	if (prev) {
		prev->next = wqp;
		wqp->prev = prev;
	} else
		wfuqp = wqp;
	if (next) {
		wqp->next = next;
		next->prev = wqp;
	}
	wqp->reqp = reqp;
	wqp->wfp = &(urtp->dg[j].wait);
}

chk_den(tunp, den, cdevp)
struct tptab *tunp;
int den;
struct tpdev **cdevp;
{
	/* check if the device supports the requested density */

	int i;

	*cdevp = tunp->devp;
	for (i = 0; i < tunp->devnum; i++, (*cdevp)++) {
		if (den == 0) 	/* density was not specified */
			return (0);
		if ((*cdevp)->den == 0) 	/* unit density = any or N/A */
			return (0);
		if ((*cdevp)->den == den)
			return (0);
	}
	return (1);
}

clean4jobdied()
{
	int c, i, j, n;
	int jids[MAXUSER+1];
	int nb_unit_asn;
	struct tptab *tunp;
	struct tpurt *urtp;
	struct waitq *wqp;

	j = 0;
	urtp = tpdurt.next;
	if (! urtp) return;
	while (urtp) {
		jids[j++] = urtp->jid;
		urtp = urtp->next;
	}
	jids[j] = 0;

	if ((n = checkjobdied (jids)) == 0) return;

	for (j = 0; j < n; j++) {
		tplogit (func, "cleaning up: job %d has died", jids[j]);
		urtp = tpdurt.next;
		while (urtp) {
			if (urtp->jid == jids[j]) break;
			urtp = urtp->next;
		}
		nb_unit_asn = 0;
		tunp = tptabp;
		for (i = 0; i < nbtpunit; i++) {
			if (tunp->jid == jids[j] && tunp->asn != 0) {
				nb_unit_asn++;
				if (tunp->asn == 1) {
					if (tunp->mntovly_pid) {
						tplogit (func, "killing process %d",
							tunp->mntovly_pid);
						kill (tunp->mntovly_pid, SIGINT);
						tunp->mntovly_pid = 0;
					} else {
						c = relunit (tunp, "", 0);
						if (c == 0) urtp->unldcnt++;
					}
				}
			}
			tunp++;
		}
		if (wfuqp) {	/* may be also one request waiting for free unit */
			wqp = wfuqp;
			while (wqp) {
				if (wqp->reqp->jid == jids[j]) {
					rmfromwfuq (wqp);	/* remove it */
					break;
				}
				wqp = wqp->next;
			}
		}
		if (nb_unit_asn == 0) {	/* no unit assigned, free only rsv */
			(urtp->prev)->next = urtp->next;
			if (urtp->next) (urtp->next)->prev = urtp->prev;
			free (urtp);
		}
	}
}

confunit(tunp, status)
struct tptab *tunp;
int status;
{
	int c, i;
	struct stat sbuf;
	int tapefd;
	struct tpdev *tdp;

	c = 0;
	if (tunp->asn != 0) {
		tplogit (func, TP048, tunp->unm);
		return (ETDCA);	/* drive currently assigned */
	}
	if (status) {	/* tpconfig up */
		tplogit (func, TP035, tunp->unm, "up");
		for (i = 0, tdp = tunp->devp; i < tunp->devnum; i++, tdp++)
			if (stat (tdp->dvn, &sbuf) < 0)
				tplogit (func, TP002, tdp->dvn, "stat", errno);
			else
				tdp->majmin = sbuf.st_rdev;
		strcpy (tunp->dvrname, "tape");
#if defined(_IBMR2)
		getdvrnam (tunp->devp->dvn, tunp->dvrname);
#endif
		tapefd = open (tunp->devp->dvn, O_RDONLY|O_NDELAY);
		if (tapefd < 0 &&
		    (errno == ENOENT || errno == ENXIO || errno == EBUSY ||
		    (strcmp (tunp->dvrname, "Atape") == 0 && errno == EIO))) {
			c = errno;
		} else {
			if (tapefd >= 0) {
#if defined(_AIX) && (defined(_IBMESA) || defined(RS6000PCTA))
#if defined(_IBMR2)
				if (strncmp (tunp->dvrname, "mtdd", 4) == 0)
#endif
					if (ioctl (tapefd, MTASSIGN, 0) < 0)
						c = errno;
#endif
#if defined(ADSTAR)
				if (strcmp (tunp->dvrname, "Atape") == 0)
					if (ioctl (tapefd, SIOC_RESERVE, 0) < 0)
						c = errno;
#endif
				close (tapefd);
			}
		}
		if (c)
			tunp->up = 0;	/* still not operational */
#if SACCT
		else
			tapeacct (TPCONFUP, 0, 0, jid, ".", tunp->dgn, tunp->unm,
			    "", 0, "");
#endif
	} else {
		tplogit (func, TP035, tunp->unm, "down");
#if defined(_IBMR2)
		getdvrnam (tunp->devp->dvn, tunp->dvrname);
#endif
#if defined(_AIX) && (defined(_IBMESA) || defined(RS6000PCTA))
#if defined(_IBMR2)
		if (strncmp (tunp->dvrname, "mtdd", 4) == 0)
#endif
			if ((tapefd = open (tunp->devp->dvn, O_RDONLY|O_NDELAY)) >= 0) {
				ioctl (tapefd, MTUNASSIGN, 0);
				close (tapefd);
			}
#endif
#if defined(ADSTAR)
		if (strcmp (tunp->dvrname, "Atape") == 0)
			if ((tapefd = open (tunp->devp->dvn, O_RDONLY|O_NDELAY)) >= 0) {
				ioctl (tapefd, SIOC_RELEASE, 0);
				close (tapefd);
			}
#endif
#if SACCT
		tapeacct (TPCONFDN, 0, 0, jid, ".", tunp->dgn, tunp->unm, "", 0, "");
#endif
	}
	return (c);
}

fork_exec_mount(tunp, filp, prelabel, rpn)
struct tptab *tunp;
struct tpfil *filp;
int prelabel;
char *rpn;
{
	int c;
	int pid;

	/* fork and exec the overlay to process tape mount and VOL1 checking */

	c = 0;
	tplogit (func, "forking a mounttape process");
	pid = fork ();
	if (pid < 0) {
		tplogit (func, TP002, "", "fork", errno);
		c = ETSYS;
	} else if (pid == 0) {	/* we are in the child */

		/* set up the parameters for the overlay mounttape */

		char arg_gid[5], arg_jid[7], arg_lbl[2];
		char arg_ring[2], arg_uid[6], arg_ux[3];
		char arg_cfseq[7], arg_filstat[2], arg_fsec[5], arg_fseq[7];
		char arg_Qfirst[7], arg_Qlast[7], arg_retentd[5];
		char arg_blksize[7], arg_lrecl[7], arg_den[6];
		char arg_ignoreeoi[2], arg_Nflag[2], arg_Tflag[2], arg_prelabel[2];
		char progfullpath[MAXPATH];

		sprintf (progfullpath, "%s/mounttape", BIN);
		sprintf (arg_uid, "%d", tunp->uid);
		sprintf (arg_gid, "%d", tunp->gid);
		sprintf (arg_jid, "%d", tunp->jid);
		sprintf (arg_ux, "%d", tunp->ux);
		sprintf (arg_ring, "%d", filp->ring);
		sprintf (arg_lbl, "%d", filp->lbl);
		sprintf (arg_cfseq, "%d", filp->cfseq);
		sprintf (arg_filstat, "%c", filp->filstat);
		sprintf (arg_fsec, "%d", filp->fsec);
		sprintf (arg_fseq, "%d", filp->fseq);
		sprintf (arg_Qfirst, "%d", filp->Qfirst);
		sprintf (arg_Qlast, "%d", filp->Qlast);
		sprintf (arg_retentd, "%d", filp->retentd);
		sprintf (arg_blksize, "%d", filp->blksize);
		sprintf (arg_lrecl, "%d", filp->lrecl);
		sprintf (arg_den, "%d", filp->den);
		sprintf (arg_ignoreeoi, "%c", filp->ignoreeoi);
		sprintf (arg_Nflag, "%c", filp->Nflag);
		sprintf (arg_Tflag, "%c", filp->Tflag);
		sprintf (arg_prelabel, "%d", prelabel);

		tplogit (func, "execing mounttape, pid=%d", getpid());
		execlp (progfullpath, "mounttape", tunp->unm, filp->vid[filp->vseq-1], 
			tunp->cdevp->dvn, rpn, arg_uid, arg_gid, tunp->acctname,
			arg_jid, tunp->nqsid[0] ? tunp->nqsid : ".",
			arg_ux, tunp->dgn, tunp->devtype, tunp->dvrname,
			tunp->loader, arg_ring, arg_lbl, filp->vsn[filp->vseq-1],
			arg_cfseq, filp->fid, arg_filstat, arg_fsec, arg_fseq,
			filp->path, arg_Qfirst, arg_Qlast, arg_retentd,
			filp->recfm, arg_blksize, arg_lrecl, arg_den,
			arg_ignoreeoi, arg_Nflag, arg_Tflag, arg_prelabel,
			(filp->vseq > 1) ? filp->vid[filp->vseq-2] : ".", 0);
		tplogit (func, TP002, "mounttape", "execlp", errno);
		exit (errno);
	} else
		tunp->mntovly_pid = pid;
	return (c);
}

inittut()
{
	char buf[82];
	int c;
	char *fgets();
	char den[9];
	int errflag;
	FILE *fopen(), *s;
	int i, j;
	char instat[5];
	char *p;
	char prevunit[9];
	char *strchr();
	struct tpdev *tdp;
	struct tptab *tunp;
	char unitname[9];

	if ((s = fopen (TPCONFIG, "r")) == NULL) {
		tplogit (func, TP008, TPCONFIG);
		exit (ETSYS);
	}
	/* 1st pass: count number of tape units defined */
	errflag = 0;
	nbtpunit = 0;
	prevunit[0] = '\0';
	while (fgets (buf, sizeof(buf), s) != NULL) {
		if (buf[0] == '#') continue;	/* comment line */
		if (buf[strlen (buf)-1] != '\n') {
			tplogit (func, TP043, buf);
			errflag++;
		}
		if (strspn (buf, " \t") == (strlen (buf) - 1)) continue; /* blank line */
		p = strchr (buf, ' ');
		if (p == NULL) p = strchr (buf, '\t');
		if (p != NULL) *p = '\0';
		if (strlen (buf) < sizeof(unitname)) {
			if (strcmp (buf, prevunit)) {
				nbtpunit++;
				strcpy (prevunit, buf);
			}
		} else {
			tplogit (func, TP032, buf);
			errflag++;
		}
	}
	if (errflag) exit (ETSYS);

	/* allocate space for tape unit table */
	tptabp = (struct tptab *) calloc (nbtpunit, sizeof(struct tptab));

	/* 2nd pass: count number of devices defined for each unit */
	rewind (s);
	tunp = tptabp;
	nbtpunit = 0;
	prevunit[0] = '\0';
	while (fgets (buf, sizeof(buf), s) != NULL) {
		if (buf[0] == '#') continue;	/* comment line */
		if (strspn (buf, " \t") == (strlen (buf) - 1)) continue; /* blank line */
		sscanf (buf, "%s", unitname);
		if (strcmp (unitname, prevunit)) {
			if (nbtpunit != 0) tunp++;
			nbtpunit++;
			strcpy (prevunit, unitname);
		}
		tunp->devnum++;
	}
	/* 3rd pass: store information */
	rewind (s);
	tunp = tptabp;
	for (i = 0; i< nbtpunit; i++) {
		tunp->ux = i;
		tdp = (struct tpdev *) calloc (tunp->devnum, sizeof(struct tpdev));
		tunp->devp = tdp;
		j = 0;
		while (j < tunp->devnum) {
			fgets (buf, sizeof(buf), s);
			if (buf[0] == '#') continue;	/* comment line */
			if (strspn (buf, " \t") == (strlen (buf) - 1)) continue;
			sscanf (buf, "%s%s%s%s%s%s%s%s", 
				tunp->unm, tunp->dgn, tdp->dvn, den,
				instat, tunp->loader, tunp->devtype);
			tdp->den = cvtden (den);
			if (instat[0] == 'u') tunp->up = 1;
			tdp++;
			j++;
		}
		c = confunit (tunp, tunp->up);
		tunp++;
	}
	fclose (s);
}

initurt()
{
	int errflag;
	int i, j;
	int prevgrp;
	struct tptab *tunp;

	tunp = tptabp;
	errflag = 0;
	nbdgp = 0;
	tpdurt.jid = jid;
	for (i = 0; i < nbtpunit; i++) {
		for (j = 0; j < nbdgp; j++) {
			if (strcmp (tunp->dgn, tpdurt.dg[j].name) == 0) break;
		}
		if (tpdurt.dg[j].name[0] == '\0') {
			strcpy (tpdurt.dg[j].name, tunp->dgn);
			strcpy (dgpu[j].name, tunp->dgn);
			dgpu[j].first = tunp;
			dgpu[j].next = tunp;
			nbdgp++;
			prevgrp = j;
		} else {
			if (j != prevgrp) {
				tplogit (func, TP034);
				errflag++;
			}
		}
		if (tunp->up) tpdurt.dg[j].rsvd++;
		dgpu[j].last = tunp;
		tunp++;
	}
	if (errflag) exit (ETSYS);
}

relunit(tunp, rpn, keeprsv)
struct tptab *tunp;
char *rpn;
int keeprsv;
{
	int c;
	int found;
	int pid;
	struct rlsq *prev, *rqp;

	c = 0;
	unlink (tunp->filp->path);	/* delete user path to the unit */
	tunp->asn = -1;			/* unit is unloading */

	/* fork and exec the overlay to process tape unload */

	tplogit (func, "forking an unloadtps process");
	pid = fork ();
	if (pid < 0) {
		tplogit (func, TP002, "", "fork", errno);
		c = ETSYS;
	} else if (pid == 0) {	/* we are in the child */

		/* set up the parameters for the overlay unloadtps */

		char arg_den[6], arg_gid[5], arg_jid[7], arg_keeprsv[2];
		char arg_uid[6], arg_ux[3];
		char progfullpath[MAXPATH];

		sprintf (progfullpath, "%s/unloadtps", BIN);
		sprintf (arg_uid, "%d", tunp->uid);
		sprintf (arg_gid, "%d", tunp->gid);
		sprintf (arg_jid, "%d", tunp->jid);
		sprintf (arg_ux, "%d", tunp->ux);
		sprintf (arg_keeprsv, "%d", keeprsv);
		sprintf (arg_den, "%d", tunp->filp->den);

		tplogit (func, "execing unloadtps, pid=%d", getpid());
		execlp (progfullpath, "unloadtps", tunp->unm, tunp->vid,
			tunp->cdevp->dvn, rpn, arg_uid, arg_gid, tunp->acctname,
			arg_jid, tunp->nqsid, arg_ux, arg_keeprsv, tunp->dgn,
			tunp->devtype, tunp->dvrname, tunp->loader, arg_den, 0);
		tplogit (func, TP002, "unloadtps", "execlp", errno);
		c = errno;
		exit (c);
	}
	if (c == 0 && rpn[0]) {		/* increment count of unload request */
					/* if not called from clean4jobdied */
		found = 0;
		prev = 0;
		rqp = rlsqp;
		while (rqp) {
			if (strcmp (rqp->rpn, rpn) == 0) {
				found = 1;	/* other unloads for same req */
				break;
			}
			prev = rqp;
			rqp = rqp->next;
		}
		if (! found) {
			rqp = (struct rlsq *) calloc (1, sizeof(struct rlsq));
			if (prev) {
				prev->next = rqp;
				rqp->prev = prev;
			} else
				rlsqp = rqp;
			strcpy (rqp->rpn, rpn);
		}
		rqp->unldcnt++;
	}
	return (c);
}

resched_wdevreq()
	/* resched waiting for free unit requests if there are any
	 * i.e. reset the wait flag and
	 * move all requests from wait for free unit queue to retry queue
	 */
{
	int j;
	struct waitq *prev, *rtryp, *wqp;

	if (wfuqp) {
		wqp = wfuqp;
		while (wqp) {
			*(wqp->wfp) = 0;
			wqp = wqp->next;
		}
		if (!retryqp) {	/* queue is empty */
			retryqp = wfuqp;
		} else {
			rtryp = retryqp;
			while (rtryp) {
				prev = rtryp;
				rtryp = rtryp->next;
			}
			prev->next = wfuqp;
			wfuqp->prev = prev;
		}
		wfuqp = NULL;
		for (j = 0; j < nbdgp; j++)
			tpdurt.dg[j].wait = 0;	/* reset global wait counts */
	}
}

rmfromwfuq(wqp)
struct waitq *wqp;
{
	int j;

	if (wqp->prev) (wqp->prev)->next = wqp->next;
	else wfuqp = wqp->next;
	if (wqp->next) (wqp->next)->prev = wqp->prev;

	*(wqp->wfp) = 0;	/* reset wait count in urt */
	for (j = 0; j < nbdgp; j++)
		if (strcmp (tpdurt.dg[j].name, wqp->reqp->dgn) == 0) break;
	tpdurt.dg[j].wait--;	/* decr. global wait count for this device group */
#if SACCT
	tapeacct (TPDGQ, wqp->reqp->uid, wqp->reqp->gid, wqp->reqp->jid,
		wqp->reqp->nqsid, wqp->reqp->dgn, "", "", tpdurt.dg[j].wait, "");
#endif
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	close (atoi(wqp->reqp->rh.rpn));
#else
	unlink (wqp->reqp->rh.rpn);
#endif
	free (wqp->reqp);	/* free mount request */
	free (wqp);
}

#if defined(ultrix) || (defined(sun) && !defined(SOLARIS))
void wait4child()
{
	int pid;
	union wait status;

	while ((pid = wait3 (&status, WNOHANG, (struct rusage *) 0)) > 0)
		tplogit (func, "process %d exiting with status %x", pid,
			status.w_status);
}
#else
void wait4child()
{
	int pid;
	int status;

#if defined(_IBMR2) || defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha)) || defined(linux)
	while ((pid = waitpid (-1, &status, WNOHANG)) > 0)
		tplogit (func, "process %d exiting with status %x", pid, status);
#else
	pid = wait (&status);
	tplogit (func, "process %d exiting with status %x", pid, status);
#if _IBMESA
	signal (SIGCHLD, wait4child);
#else
	signal (SIGCLD, wait4child);
#endif
#endif
}
#endif
