/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)send2tmsd.c	1.12 05/08/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	send2tmsd - send request to tms daemon and get reply */

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/un.h>
#if defined(SOLARIS)
#include <sys/filio.h>
#endif
#endif
#include "tms.h"
send2tmsd(treqp, trepp, repsize)
struct tmsreq *treqp;
char *trepp;
int *repsize;
{
	int c, i;
	char func[16];
	struct tmrphdr tmrphdr;
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	int s;
	struct sockaddr_un sname;
#else
	int rpfd, rqfd;
	char *tempnam();
#endif

	strcpy (func, "send2tmsd");

#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	/* create socket to communicate with tmsdaemon */

	if ((s = socket (AF_UNIX, SOCK_STREAM, 0)) < 0) {
		tmslogit (func, TMS19, REQPIPE, "socket", errno);
		return (ETMSS);
	}
	sname.sun_family = AF_UNIX;
	strcpy (sname.sun_path, REQPIPE);
	if (connect (s, (struct sockaddr *) &sname, sizeof(sname)) < 0) {
		if (errno == ECONNREFUSED) {
			tmslogit (func, TMS00);
			close (s);
			return (ETMSS);
		} else {
			tmslogit (func, TMS19, REQPIPE, "connect", errno);
			close (s);
			return (ETMSS);
		}
	}

	/* send request to tmsdaemon */

	if (WRITE (s, (char *) treqp, treqp->rh.size) < 0) {
		tmslogit (func, TMS19, REQPIPE, "send", errno);
		close (s);
		return (ETMSS);
	}

	/* get reply */

	ioctl (s, FIONBIO, 1);
	for (i = 0; i <= TMTIMEOUT; i++) {
		c = READ (s, (char *) &tmrphdr, sizeof(struct tmrphdr));
		if (c > 0 || (c < 0 && errno != EWOULDBLOCK)) break;
		sleep (TMGETREPI);
	}

	if (i > TMTIMEOUT) {
		tmslogit (func, TMS01);
		close (s);
		return (ETMSS);
	}
	if (c != sizeof(struct tmrphdr)) {
		tmslogit (func, TMS19, REQPIPE, "recv", errno);
		close (s);
		return (ETMSS);
	}
	if ((*repsize = tmrphdr.size - sizeof(struct tmrphdr)) != 0)
		if (READ (s, trepp, *repsize) != *repsize) {
			tmslogit (func, TMS19, REQPIPE, "recv", errno);
			close (s);
			return (ETMSS);
		}
	close (s);
#else
	/* make reply pipe */

	strcpy (treqp->rh.rpn, tempnam(NULL, "tms"));
	if (mknod (treqp->rh.rpn, 0010700, 0) < 0) {
		tmslogit (func, TMS19, treqp->rh.rpn, "mknod", errno);
		return (ETMSS);
	}
	if ((rpfd = open (treqp->rh.rpn, O_RDONLY | O_NDELAY)) < 0) {
		tmslogit (func, TMS19, treqp->rh.rpn, "open", errno);
		return (ETMSS);
	}

	/* open request pipe to tmsdaemon */

	while ((rqfd = open (REQPIPE, O_WRONLY | O_NDELAY)) < 0) {
		switch (errno) {
			case ENFILE:
				sleep (1);
				continue;
			case ENOENT:
			case ENXIO:
				tmslogit (func, TMS00);
				close (rpfd);
				unlink (treqp->rh.rpn);
				return (ETMSS);
			default:
				tmslogit (func, TMS19, REQPIPE, "open", errno);
				close (rpfd);
				unlink (treqp->rh.rpn);
				return (ETMSS);
		}
	}

	/* send request to tmsdaemon */

	if (write (rqfd, (char *) treqp, treqp->rh.size) != treqp->rh.size) {
		tmslogit (func, TMS19, REQPIPE, "write", errno);
		close (rqfd);
		close (rpfd);
		unlink (treqp->rh.rpn);
		return (ETMSS);
	}
	close (rqfd);

	/* get reply */

	for (i = 0; i <= TMTIMEOUT; i++) {
		c = READ (rpfd, (char *) &tmrphdr, sizeof(struct tmrphdr));
#if sun
		if (c > 0 || (c < 0 && errno != EWOULDBLOCK)) break;
#else
		if (c != 0) break;
#endif
		sleep (TMGETREPI);
	}

	if (i > TMTIMEOUT) {
		tmslogit (func, TMS01);
		close (rpfd);
		unlink (treqp->rh.rpn);
		return (ETMSS);
	}
	if (c != sizeof(struct tmrphdr)) {
		tmslogit (func, TMS19, treqp->rh.rpn, "read", errno);
		close (rpfd);
		unlink (treqp->rh.rpn);
		return (ETMSS);
	}
	if ((*repsize = tmrphdr.size - sizeof(struct tmrphdr)) != 0)
		if (read (rpfd, trepp, *repsize) != *repsize) {
			tmslogit (func, TMS19, treqp->rh.rpn, "read", errno);
			close (rpfd);
			unlink (treqp->rh.rpn);
			return (ETMSS);
		}
	close (rpfd);
	unlink (treqp->rh.rpn);
#endif
	return (tmrphdr.rc);
}
