/*
 * Copyright (C) 1990-1999 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tmsdaemon.c	1.36 08/19/99 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/time.h>
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
#include <sys/socket.h>
#include <sys/un.h>
#endif
#if _AIX && _IBMR2
#include <sys/select.h>
#endif
#include "tms.h"
#define NOPMSG 4
extern int sys_nerr;
#if !defined(linux)
extern char *sys_errlist[];
#endif
int omsgcnt = 0;
int omsgids[NOPMSG] = {0, 0, 0, 0};
#if cray
char orpn[MAXPATH];
#else
int orport;
#endif
fd_set readfd, readmask;
struct tmsrep rep;
struct tmsmreq *tmre;	/* end of savearea for TMS requests */
struct tmsmreq *tmrs;	/* start of savearea for TMS requests */
char func[16];
int nreq;
int orfd;
int reqbufsz;
int rqfd;
extern int serrno;
time_t time();

main()
{
	int c, l;
	int maxfds;
	struct tmsmreq *p;
	struct stat st;
	struct timeval timeval;
	struct tmrqhdr tmrqhdr;
	char *tempnam();
	int trfd;
	time_t lasttime, tm;
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	struct sockaddr_un sname, fromunix;
	int fromlen = sizeof(fromunix);
	int s;
#endif

#if defined(ultrix) || (defined(sun) && !defined(SOLARIS)) || defined(linux)
	maxfds = getdtablesize();
#else
	maxfds = _NFILE;
#endif
#ifndef TEST
	/* Background */
	if ((c = fork()) < 0) {
		fprintf (stderr, "tmsdaemon: cannot fork\n");
		exit (1);
	} else
		if (c > 0) exit (0);
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_IBMESA)
	c = setpgrp(0, getpid());
#else
#if (defined(__osf__) && defined(__alpha)) || defined(linux)
	c = setsid();
#else
#if HPUX10
	c = setpgrp3();
#else
	c = setpgrp();
#endif
#endif
#endif
	for (c = 0; c < maxfds; c++)
		close (c);
#endif
	strcpy (func, "tmsdaemon");

	lasttime = time(0);
	FD_ZERO (&readmask);
	FD_ZERO (&readfd);
	signal (SIGPIPE,SIG_IGN);

	/* Open command pipe */
	unlink (REQPIPE);
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
	if ((s = socket (AF_UNIX, SOCK_STREAM, 0)) < 0) {
		tmslogit (func, TMS19, REQPIPE, "socket", errno);
		exit (47);
	}
	sname.sun_family = AF_UNIX;
	strcpy (sname.sun_path, REQPIPE);
	if (bind (s, (struct sockaddr *) &sname, sizeof(sname)) < 0) {
		tmslogit (func, TMS19, REQPIPE, "bind", errno);
		exit (47);
	}
	listen (s, 5);
	FD_SET (s, &readmask);
#else
	if (mknod (REQPIPE, 0010700, 0) < 0) {
		tmslogit (func, TMS19, REQPIPE, "mknod", errno);
		exit (47);
	}
	if ((rqfd = open (REQPIPE, O_RDONLY | O_NDELAY)) < 0) {
		tmslogit (func, TMS19, REQPIPE, "open", errno);
		exit (47);
	}
	FD_SET (rqfd, &readmask);
#endif

	/* open operator reply pipe */
#if cray
	if ((orfd = opnmsgr (orpn)) < 0) {
#else
	orport = 0;
	if ((orfd = opnmsgr (&orport)) < 0) {
#endif
		tmslogit (func, TMS19, "", "opnmsgr", serrno ? serrno : errno);
		exit (47);
	}
	FD_SET (orfd, &readmask);

	/* Scan file containing pending TMS requests */
	trfd = open (REQFILE, O_RDWR | O_CREAT, 0664);
	fstat (trfd, &st);
	if (st.st_size == 0) {
		reqbufsz = BUFSIZ;
		tmrs = (struct tmsmreq *) calloc (1, reqbufsz);
		tmre = tmrs + (reqbufsz/sizeof(struct tmsmreq));
		nreq = 0;
		close (trfd);
	} else {
		reqbufsz = (st.st_size + BUFSIZ -1) / BUFSIZ * BUFSIZ;
		tmrs = (struct tmsmreq *) calloc (1, reqbufsz);
		tmre = tmrs + (reqbufsz/sizeof(struct tmsmreq));
		nreq = st.st_size / sizeof(struct tmsmreq);
		read (trfd, (char *) tmrs, st.st_size);
		close (trfd);

	/* Send TMS MOUNT CANCEL for all TMS requests successfully transmitted */
	/* to SYSREQ/TMS before the shutdown/crash but still in the TMS daemon table */
		for (p = tmrs; p < tmre; ) {
			if (p->jid == 0) break;
			if (p->type == TMVERIFY) {
				delreq (p);
				continue;
			}
			if (p->type != TMUNLOCKV) {
				p->req_time = time(0);
				p->type = TMUNLOCKV;
				savereqs ();
			}
			while ((c = sendtmsmount (p)) == ETMNRSP) sleep (TMSVNRSRI);
			if (c != ETMNACT) delreq (p);
			else break;
		}
	}

	while (1) {
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
		if (FD_ISSET (s, &readfd)) {
			rqfd = accept (s, (struct sockaddr *) &fromunix, &fromlen);
#else
		if (FD_ISSET (rqfd, &readfd)) {
#endif
			l = READ (rqfd, (char *) &tmrqhdr, sizeof(tmrqhdr));
			if (l == sizeof(tmrqhdr)) {
#if ultrix || hpux || apollo || _AIX || (__alpha && __osf__) || SOLARIS || IRIX5 || linux
				sprintf (tmrqhdr.rpn, "%d", rqfd);
#endif
				l = tmrqhdr.size - sizeof(tmrqhdr);
				switch (tmrqhdr.code) {
				case TMSMOUNT:
					c = procmountreq (l);
					break;
				case TMSQVOL:
					c = procqvolreq (l);
					break;
				default:
					tmslogit (func, TMS06, tmrqhdr.code);
					c = ETMSS;
				}
				rep.rh.rc = c;
				sendrep (tmrqhdr.rpn, &rep);
			} else if (l != 0)
				tmslogit (func, TMS07, l);
			FD_CLR (rqfd, &readfd);
		}
		if (FD_ISSET (orfd, &readfd)) {
			checkorep();	/* check for pending ops replies */
			FD_CLR (orfd, &readfd);
		}
		if (((tm = time (0)) - lasttime) >= TMCLNREQI) {
			if (nreq) clean4jobdied();  /* look for jobs that died */
			lasttime = tm;
		}
		memcpy (&readfd, &readmask, sizeof(readmask));
		timeval.tv_sec = TMCLNREQI;	/* must set each time for linux */
		timeval.tv_usec = 0;
		if (select (maxfds, &readfd, (fd_set *)0, (fd_set *)0, &timeval) < 0) {
			FD_ZERO (&readfd);
		}
	}
}

procmountreq(size)
int size;
{
	struct tmsmreq tmsmreq;
	struct tmsmreq *p, *findreq();
	int c;
	time_t sav_tm;

	read (rqfd, (char *) &tmsmreq, size);
	c = 0;
	rep.rh.size = sizeof(struct tmrphdr);
	switch (tmsmreq.type) {
	case TMVERIFY:
		p = findreq (&tmsmreq);
		if (p->jid != 0 && p->type == TMMOUNTED) {	/* tpmnt -u */
			p->nounload = tmsmreq.nounload;
			savereqs ();
		} else {
			memcpy ((char *)p, &tmsmreq, sizeof(struct tmsmreq));
			savereqs ();
			c = sendtmsmount (p);
			if (c == EACCDEN) delreq (p);
			if (c == EVOLBSY) c = 0;
		}
		break;
	case TMLOCK:
		p = findreq (&tmsmreq);
		if (p->type == TMLOCK && ! *p->unit)	/* if req. already waiting */
			sav_tm = p->req_time;		/* keep timestamp */
		else
			sav_tm = 0;
		memcpy ((char *)p, &tmsmreq, sizeof(struct tmsmreq));
		if (sav_tm)
			p->req_time = sav_tm;
		savereqs ();
		c = sendtmsmount (p);
		if (c == EACCDEN) delreq (p);
		if (c == 0) {
			strncpy (p->library, rep.data+7, 8);
			strncpy (p->rackslot, rep.data+16, 8);
		}
		if (c == 0 || c == ETMNACT || c == EVOLUNK) {
			p->type = TMLOCKED;
			p->req_time = time(0);
			savereqs ();
		}
		break;
	case TMMOUNTED:
		p = findreq (&tmsmreq);
		if (p->jid) {
			p->req_time = tmsmreq.req_time;
			p->type = TMMOUNTED;
			strcpy (p->unit, tmsmreq.unit);
			strcpy (p->system, tmsmreq.system);
		} else
			memcpy ((char *)p, &tmsmreq, sizeof(struct tmsmreq));
		savereqs ();
		c = sendtmsmount (p);
		break;
	case TMUNLOCKV:
		for (p = tmrs; p < tmre; ) {
			if (p->jid == 0) break;
			if (strcmp (p->vid, tmsmreq.vid) == 0 &&
			    strcmp (p->unit, tmsmreq.unit) == 0) {
				if (p->type == TMVERIFY) {
					delreq (p);
					continue;
				}
				p->req_time = tmsmreq.req_time;
				p->type = TMUNLOCKV;
				savereqs ();
				c = sendtmsmount (p);
				if (c != ETMNRSP && c != ETMNACT) delreq (p);
				else p++;
			}
			else p++;
		}
		break;
	case TMUNLOCKD:
		for (p = tmrs; p < tmre; ) {
			if (p->jid == 0) break;
			if (p->jid == tmsmreq.jid &&
			    strcmp (p->uniqueid, tmsmreq.uniqueid) == 0 &&
			    strcmp (p->logonid, tmsmreq.logonid) == 0 &&
			    strcmp (p->unit, tmsmreq.unit) == 0) {
				p->req_time = tmsmreq.req_time;
				p->type = TMUNLOCKV;
				savereqs ();
				c = sendtmsmount (p);
				if (c != ETMNRSP && c != ETMNACT) delreq (p);
				break;
			}
			else p++;
		}
		break;
	case TMUNLOCKP:
		for (p = tmrs; p < tmre; ) {
			if (p->jid == 0) break;
			if (p->jid == tmsmreq.jid &&
			    strcmp (p->uniqueid, tmsmreq.uniqueid) == 0 &&
			    strcmp (p->logonid, tmsmreq.logonid) == 0 &&
			    strcmp (p->path, tmsmreq.path) == 0 &&
			    p->nounload != '+') {
				if (p->type == TMVERIFY) {
					delreq (p);
					continue;
				}
				p->req_time = tmsmreq.req_time;
				p->type = TMUNLOCKV;
				savereqs ();
				c = sendtmsmount (p);
				if (c != ETMNRSP && c != ETMNACT) delreq (p);
				else p++;
			}
			else p++;
		}
		break;
	case TMUNLOCKA:
		for (p = tmrs; p < tmre; ) {
			if (p->jid == 0) break;
			if (p->jid == tmsmreq.jid &&
			    strcmp (p->uniqueid, tmsmreq.uniqueid) == 0 &&
			    strcmp (p->logonid, tmsmreq.logonid) == 0 &&
			    p->nounload != '+') {
				if (p->type == TMVERIFY) {
					delreq (p);
					continue;
				}
				p->req_time = tmsmreq.req_time;
				p->type = TMUNLOCKV;
				savereqs ();
				c = sendtmsmount (p);
				if (c != ETMNRSP && c != ETMNACT) delreq (p);
				else p++;
			}
			else p++;
		}
		break;
	case TMUNLOCKB:
		p = findreq (&tmsmreq);
		if (p->jid == 0)
			memcpy ((char *)p, &tmsmreq, sizeof(struct tmsmreq));
		p->type = TMUNLOCKV;
		c = sendtmsmount (p);
		p->type = TMLOCK; 	/* mark req as waiting */
		memset (p->unit, 0, sizeof(p->unit));	/* but no drive allocated */
		savereqs ();
		break;
	default:
		tmslogit (func, TMS06, tmsmreq.type);
		c = ETMSS;
	}
	return (c);
}

procqvolreq(size)
int size;
{
	struct tmsqreq tmsqreq;
	int rc;
	int repl;

	read (rqfd, (char *) &tmsqreq, size);
	repl = TMREPBUFSZ;
	rc = send2tms (tmsqreq.logonid, tmsqreq.acctname, tmsqreq.buf,
		strlen(tmsqreq.buf), rep.data, &repl);
	rep.rh.size = sizeof(struct tmrphdr) + repl;
	return (rc);
}

sendtmsmount(treqp)
struct tmsmreq *treqp;
{
	static char tmsmtyp[4][3] = {"PE", "PE", "CO", "CA"};
	char acctname[7];
	char reqbuf[85];
	int repl;
	int c, rc;

	sprintf (reqbuf,
		"MOUNT %c %s V %s US %s UNIQUE %s LOGON %s ACC %s",
		treqp->mode, tmsmtyp[treqp->type], treqp->vid, treqp->userid,
		treqp->uniqueid, treqp->logonid, treqp->account);
	if (treqp->unit[0] != '\0')
		sprintf (reqbuf+strlen(reqbuf), " UN %s", treqp->unit);
	if (treqp->system[0] != '\0')
		sprintf (reqbuf+strlen(reqbuf), " SYS %s", treqp->system);
	sprintf (acctname, "%s$%s", treqp->userid, treqp->account);
	repl = TMREPBUFSZ;
	c = send2tms ("root", acctname, reqbuf, strlen(reqbuf), rep.data, &repl);
	switch (c) {
		case 0:
		case 191:		/* probably after a sequence notms/tmsactive */
		case 192:
			rc = 0;		/* ok */
			break;
		case 12:
		case 182:
		case 184:
		case 185:
		case 186:
		case 187:
		case 189:
		case 2193:
			rc = EACCDEN;	/* access denied or volume inactive */
			break;
		case 190:
		case 2190:
			rc = EVOLBSY;	/* volume busy */
			break;
		case 188:
			rc = EVOLUNK;	/* volume unknown */
			break;
		case ETMNACT:	/* TMS not working for a long period of time */
			rc = c;
			break;
		default:
			rc = ETMNRSP;	/* no answer from SYSREQ/TMS */
	}
	rep.rh.size = sizeof(struct tmrphdr) + repl;
	return (rc);
}

send2tms(requester, acctname, reqp, reql, repp, repl)
char *requester;
char *acctname;
char *reqp;
int reql;
char *repp;
int *repl;
{
	int c, n, s;
	struct stat st;
	int rl;

	tmslogit (func, TMS11, reqp);
	n = 0;
	while ((s = stat (NOTMS, &st)) < 0 && n < TMMAXRETRY) {
		rl = *repl;
		c = _sysreq (requester, acctname, "TMS", reqp, reql, repp, &rl, 0);
		if (c != -ETIMEDOUT && c != -ECONNREFUSED && c != -1021) break;
		sleep (TMSVBSYRI);
		n++;
	}
	if (s < 0) {		/* TMS "active" */
		switch (c) {
		case 3:		/* service unavailable */
			omsgr (TMS13, 0);
			break;
		case -ECONNREFUSED:	/* sysreqd not active */
		case -1016:	/* Connection closed by remote end */
			omsgr (TMS14, 1);
			rl = 0;
			break;
		case -1021:	/* SYSREQ/TMS communication error */
			omsgr (TMS20, 3);
			rl = 0;
			break;
		case -1001:	/* no such host in /etc/hosts */
		case -1002:	/* service not in /etc/services */
		case -1009:	/* /etc/sysreqrc does not exist */
		case -1010:	/* version id mismatch */
		case -1019:	/* wrong port number in /etc/services */
			tmslogit (func, TMS05, c);
			exit (1);
		default:
			if (c >= 0) {	/* TCP/IP and TMS are running fine */
					/* cancel pending oper messages */
				for (n = 0; omsgcnt && n < NOPMSG; n++)
					if (omsgids[n] > 0) omsgdel (n);
			} else {
				n = -c;
				if (n < sys_nerr)
					sprintf (repp, "%s: %s", TMS03, sys_errlist[n]);
				else
					strcpy (repp, TMS03);
				omsgr (repp, 2);
				rl = 0;
			}
		}
		*repl = rl < *repl ? rl : *repl;
	} else {
		c = ETMNACT;	/* TMS not working for a long period of time */
		*repl = 0;
	}
	tmslogit (func, TMS12, c);
	return (c);
}

savereqs()
{
	int c, n;
	int trfd;

	if ((trfd = open (REQFILE, O_WRONLY)) < 0) {
		tmslogit (func, TMS19, REQFILE, "open", errno);
		return (-1);
	}
	n = nreq * sizeof(struct tmsmreq);
	if (nreq != 0) {
		if ((c = write (trfd, tmrs, n)) != n) {
			tmslogit (func, TMS19, REQFILE, "write", errno);
			close (trfd);
			return (-1);
		}
	}
#if cray
	trunc (trfd);
#else
	ftruncate (trfd, n);
#endif
	close (trfd);
}

struct tmsmreq *
findreq(treqp)
struct tmsmreq *treqp;
{
	int found = 0;
	struct tmsmreq *p;
	for (p = tmrs; p < tmre; p++) {
		if (p->jid == 0) break;
		if (p->jid != treqp->jid) continue;
		if (strcmp (p->uniqueid, treqp->uniqueid) != 0) continue;
		if (strcmp (p->logonid, treqp->logonid) != 0) continue;
		if (strcmp (p->vid, treqp->vid) != 0) continue;
		found = 1;
		break;
	}
	if (! found) {
		nreq++;
		if (nreq > reqbufsz/sizeof(struct tmsmreq)) {
			tmrs = (struct tmsmreq *) realloc (tmrs, reqbufsz+BUFSIZ);
			memset ((char *)tmrs+reqbufsz, 0, BUFSIZ);
			reqbufsz += BUFSIZ;
			tmre = tmrs + (reqbufsz/sizeof(struct tmsmreq));
			for (p = tmrs; p->jid != 0; p++) ;
		}
	}
	return (p);
}

delreq(treqp)
struct tmsmreq *treqp;
{
	int n;
	char *p1, *p2;
	nreq--;
	p2 = (char *)tmrs + (nreq * sizeof(struct tmsmreq));
	if ((char *)treqp != p2) {	/* not last request in the list */
		p1 = (char *)treqp + sizeof(struct tmsmreq);
		n = p2 + sizeof(struct tmsmreq) - p1;
		memcpy ((char *)treqp, p1, n);
	}
	memset (p2, 0, sizeof(struct tmsmreq));
	savereqs ();
}

clean4jobdied()
{
	int c, i, j, n, s;
	int *jids;
	struct tmsmreq *p;
	struct stat st;

	s = stat (NOTMS, &st);
	j = 0;
	jids = (int *) calloc (nreq + 1, sizeof(int));
	for (p = tmrs; p < tmre; p++) {
		if (p->jid == 0) break;
		for (i = 0; i < j; i++)
			if (p->jid == *(jids + i)) break;
		if (i == j) *(jids + j++) = p->jid;
	}

	n = checkjobdied (jids);

	for (p = tmrs; p < tmre; ) {
		if (p->jid == 0) break;
		for (j = 0; j < n; j++) {
			if (*(jids + j) == p->jid) break;
		}
		if (j != n ||		/* job has died */
		    p->type == TMUNLOCKV) {	/* pending unlock */
			if (p->type == TMVERIFY || p->type == TMLOCK) {
				delreq (p);
				continue;
			}
			if (p->type != TMUNLOCKV) {
				p++;	/* request will be cleaned from tpdaemon */
				continue;
			}
			if (s < 0) {		/* TMS active */
				c = sendtmsmount (p);
				if (c != ETMNRSP && c != ETMNACT) delreq (p);
				else p++;
			}
			else p++;
		}
		else p++;
	}
	free (jids);
}

omsgr(p, myindex)
char *p;
int myindex;
{
	int c;

	if (omsgids[myindex]) return;	/* don't repeat message */
	tmslogit (func, "%s", p);
#if cray
	c = sndmsgr (p, orpn, myindex);
#else
	c = sndmsgr (p, orport, myindex);
#endif
	if (c < 0) return (-1);
	omsgcnt++;
	omsgids[myindex] = -1;
	return (0);
}

checkorep()
{
	char rep[80];
	int c, i;
	int msg_number;
	int myindex;
	int reply_type;

	c = rcvmsgr (orfd, &reply_type, &myindex, &msg_number, rep, sizeof(rep));
	if (c < 0) return (-1);
	switch (reply_type) {
	case 0x2001:	/* msgid returned */
		omsgids[myindex] = msg_number;
		break;
	case 0x1007:	/* oper replied */
		for (i = 0; i < NOPMSG; i++) {
			if (omsgids[i] == msg_number) break;
		}
		if (i == NOPMSG) return (0);
		if (c == 0) rep[0] = '\0';
		tmslogit (func, TMS15, rep);
		omsgcnt--;
		omsgids[i] = 0;
	}
	return (0);
}

omsgdel(msgindx)
int msgindx;
{
	int c;

#if cray
	c = canmsgr (omsgids[msgindx], orpn);
#else
	c = canmsgr (omsgids[msgindx], orport);
#endif
	if (c < 0) return (-1);
	omsgcnt--;
	omsgids[msgindx] = 0;
}
