/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tmsreq.c	1.7 06/26/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	tmsreq - send request to tmsdaemon */
 
#include <pwd.h>
#include <stdio.h>
#include <sys/param.h>
#include <string.h>
#include <sys/types.h>
#include "tms.h"
int repsize;
struct tmsreq req;
 
main(argc, argv)
int     argc;
char    **argv;
{
	char func[16];
	char hostname[MAXHOSTNAMELEN];
	char *p;
	char tmrepbuf[TMREPBUFSZ];
#if cray
	char *acid2nam();
#else
	char *getacct();
#endif
	struct passwd *pwd;
	struct tmsqreq *tmrp;
	uid_t uid;
	int c, i;

	if (argc == 1) {
		usage (argv[0]);
		exit(1);
	}

	strcpy (func, "tmsreq");
	memset ((char *)&req, 0, sizeof(struct tmsreq));
	req.rh.size = sizeof(struct tmrqhdr) + sizeof(struct tmsqreq);
	req.rh.code = TMSQVOL;
	tmrp = (struct tmsqreq *) req.data;
	uid = getuid();
	pwd = getpwuid (uid);
	strcpy (tmrp->logonid, pwd->pw_name);
#if cray
	if (uid >= 100)
		p = acid2nam (acctid (0, -1));
	else
		p = "xmp$cy";
#else
	p = getacct();
	if (p == NULL) {
		fprintf (stderr, TMS21);
		exit (1);
	}
#endif
	strcpy (tmrp->acctname, p);

	strcpy(tmrp->buf, argv[1]);
	for (i = 2; i < argc; i++)  {
		strcat(tmrp->buf, " ");
		strcat(tmrp->buf,argv[i]);
	}

	while (1) {
		tmslogit (func, "TMSREQ - %s", tmrp->buf);
		c = send2tmsd (&req, tmrepbuf, &repsize);
		switch (c) {
		case 0: /* ok */
			if (repsize) printf ("%s\n", tmrepbuf);
			break;
		case 4:	/* continuation of reply necessary but no space for cmd*/
			printf ("%s\n", tmrepbuf);
			break;
		case 2:	/* continuation of reply necessary */
			p = strrchr (tmrepbuf, '\n');
			*p++ = '\0';
			printf ("%s\n", tmrepbuf);
			strcpy (tmrp->buf, p);
			continue;
		case ETMNACT:
			gethostname (hostname, MAXHOSTNAMELEN);
			fprintf (stderr, "TMS disabled on %s(%s)\n", SYSTEM, hostname);
			break;
		default: /* error */
			if (repsize)
				fprintf (stderr, "%s\n", tmrepbuf);
			else
				if (c == ETMSS)
					fprintf (stderr, TMS22);
				else
					fprintf (stderr, "%s\n", TMS03);
			if (c < 0) c = -c;
		}
		break;
	}
	exit (c);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "[command] [arguments]\n");
}
