/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.filter.DestinationFilter;

public class CompositeDestinationFilter
extends DestinationFilter {
    private DestinationFilter[] filters;

    public CompositeDestinationFilter(ActiveMQDestination destination) {
        ActiveMQDestination[] destinations = destination.getCompositeDestinations();
        this.filters = new DestinationFilter[destinations.length];
        for (int i2 = 0; i2 < destinations.length; ++i2) {
            ActiveMQDestination childDestination = destinations[i2];
            this.filters[i2] = DestinationFilter.parseFilter(childDestination);
        }
    }

    @Override
    public boolean matches(ActiveMQDestination destination) {
        for (int i2 = 0; i2 < this.filters.length; ++i2) {
            if (!this.filters[i2].matches(destination)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWildcard() {
        for (DestinationFilter filter : this.filters) {
            if (!filter.isWildcard()) continue;
            return true;
        }
        return false;
    }
}

