/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jetty.util.Utf8StringBuilder;

public interface CharsetStringBuilder {
    public void append(byte var1);

    public void append(char var1);

    default public void append(byte[] bytes) {
        this.append(bytes, 0, bytes.length);
    }

    default public void append(byte[] b, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.append(b[i]);
        }
    }

    default public void append(CharSequence chars, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.append(chars.charAt(i));
        }
    }

    default public void append(ByteBuffer buf) {
        int end = buf.position() + buf.remaining();
        while (buf.position() < end) {
            this.append(buf.get());
        }
    }

    default public String build() throws CharacterCodingException {
        return this.build(false);
    }

    public String build(boolean var1) throws CharacterCodingException;

    default public boolean hasCodingErrors() {
        return false;
    }

    default public boolean replaceIncomplete() {
        return false;
    }

    public int length();

    public void reset();

    public static CharsetStringBuilder forCharset(Charset charset) {
        return CharsetStringBuilder.forCharset(charset, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
    }

    public static CharsetStringBuilder forCharset(Charset charset, CodingErrorAction onMalformedInput, CodingErrorAction onUnmappableCharacter) {
        Objects.requireNonNull(charset);
        if (charset == StandardCharsets.UTF_8) {
            return new Utf8StringBuilder(onMalformedInput, onUnmappableCharacter);
        }
        if (charset == StandardCharsets.ISO_8859_1) {
            return new Iso88591StringBuilder();
        }
        if (charset == StandardCharsets.US_ASCII) {
            return new UsAsciiStringBuilder();
        }
        return new DecoderStringBuilder(charset.newDecoder(), onMalformedInput, onUnmappableCharacter);
    }

    public static class Iso88591StringBuilder
    implements CharsetStringBuilder {
        private final StringBuilder _builder = new StringBuilder();

        @Override
        public void append(byte b) {
            this._builder.append((char)(0xFF & b));
        }

        @Override
        public void append(char c) {
            this._builder.append(c);
        }

        @Override
        public void append(CharSequence chars, int offset, int length) {
            this._builder.append(chars, offset, offset + length);
        }

        @Override
        public String build() {
            String s = this._builder.toString();
            this._builder.setLength(0);
            return s;
        }

        @Override
        public String build(boolean ignored) {
            return this.build();
        }

        @Override
        public int length() {
            return this._builder.length();
        }

        @Override
        public void reset() {
            this._builder.setLength(0);
        }
    }

    public static class UsAsciiStringBuilder
    implements CharsetStringBuilder {
        private final StringBuilder _builder = new StringBuilder();

        @Override
        public void append(byte b) {
            if (b < 0) {
                throw new IllegalArgumentException();
            }
            this._builder.append((char)b);
        }

        @Override
        public void append(char c) {
            this._builder.append(c);
        }

        @Override
        public void append(CharSequence chars, int offset, int length) {
            this._builder.append(chars, offset, offset + length);
        }

        @Override
        public String build() {
            String s = this._builder.toString();
            this._builder.setLength(0);
            return s;
        }

        @Override
        public String build(boolean ignored) {
            return this.build();
        }

        @Override
        public int length() {
            return this._builder.length();
        }

        @Override
        public void reset() {
            this._builder.setLength(0);
        }
    }

    public static class DecoderStringBuilder
    implements CharsetStringBuilder {
        private final CharsetDecoder _decoder;
        private final StringBuilder _stringBuilder = new StringBuilder(32);
        private ByteBuffer _buffer;

        public DecoderStringBuilder(CharsetDecoder charsetDecoder, CodingErrorAction onMalformedInput, CodingErrorAction onUnmappableCharacter) {
            this._decoder = charsetDecoder;
            this._decoder.onMalformedInput(onMalformedInput);
            this._decoder.onUnmappableCharacter(onUnmappableCharacter);
        }

        private void ensureSpace(int needed) {
            if (this._buffer == null) {
                this._buffer = ByteBuffer.allocate(needed + 32);
            } else {
                int space = this._buffer.remaining();
                if (space < needed) {
                    int position = this._buffer.position();
                    this._buffer = ByteBuffer.wrap(Arrays.copyOf(this._buffer.array(), this._buffer.capacity() + needed - space + 32)).position(position);
                }
            }
        }

        @Override
        public void append(byte b) {
            this.ensureSpace(1);
            this._buffer.put(b);
        }

        @Override
        public void append(char c) {
            if (this._buffer != null && this._buffer.position() > 0) {
                if (c > '\u00ff') {
                    try {
                        CharBuffer decoded = this._decoder.decode(this._buffer.flip());
                        this._buffer.clear();
                        this._stringBuilder.append(decoded);
                        this._stringBuilder.append(c);
                    }
                    catch (CharacterCodingException e) {
                        if (this._decoder.malformedInputAction() == CodingErrorAction.IGNORE) {
                            return;
                        }
                        if (this._decoder.malformedInputAction() == CodingErrorAction.REPLACE) {
                            this._buffer.clear();
                            this._stringBuilder.append(this._decoder.replacement());
                            return;
                        }
                        throw new IllegalArgumentException("Invalid character " + Integer.toHexString(c), e);
                    }
                } else {
                    this.ensureSpace(1);
                    this._buffer.put((byte)c);
                }
            } else {
                this._stringBuilder.append(c);
            }
        }

        @Override
        public void append(CharSequence chars, int offset, int length) {
            for (int idx = offset; idx < offset + length; ++idx) {
                this.append(chars.charAt(idx));
            }
        }

        @Override
        public void append(byte[] b, int offset, int length) {
            this.ensureSpace(length);
            this._buffer.put(b, offset, length);
        }

        @Override
        public void append(ByteBuffer buf) {
            this.ensureSpace(buf.remaining());
            this._buffer.put(buf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String build(boolean ignore) throws CharacterCodingException {
            try {
                if (this._buffer != null && this._buffer.position() > 0) {
                    CharBuffer decoded = this._decoder.decode(this._buffer.flip());
                    this._buffer.clear();
                    if (this._stringBuilder.isEmpty()) {
                        String string = decoded.toString();
                        return string;
                    }
                    this._stringBuilder.append(decoded);
                }
                String string = this._stringBuilder.toString();
                return string;
            }
            finally {
                this._stringBuilder.setLength(0);
            }
        }

        @Override
        public int length() {
            return this._stringBuilder.length();
        }

        @Override
        public void reset() {
            this._stringBuilder.setLength(0);
            if (this._buffer != null) {
                this._buffer.clear();
            }
        }
    }
}

