/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.commons.cli.OptionValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class OptionValidatorTest {
    private static final String LETTERS = "a\u00d1";
    private static final String DIGITS = "1\u0661\u06f2\u0968\uff14";
    private static final String CURRENCY = "\u20ac$";
    private static final String PUNCTUATION = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
    private static final String COMBINING_MARK = "\u0303";
    private static final String NON_SPACING_MARK = "\u0cbf";
    private static final String IDENTIFIER_IGNORABLE = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b";
    private static String acceptablePunctuation;
    private static String notAcceptablePunctuation;
    private static String additionalOptonChars;
    private static String additionalLongChars;
    private static String firstChars;
    private static String notFirstChars;
    private static String restChars;
    private static String notRestChars;

    OptionValidatorTest() {
    }

    private static Stream<Arguments> optionParameters() {
        String s;
        ArrayList<Arguments> args = new ArrayList<Arguments>();
        args.add(Arguments.of((Object[])new Object[]{"CamelCase", true, "Camel case error"}));
        args.add(Arguments.of((Object[])new Object[]{"Snake_case", true, "Snake case error"}));
        args.add(Arguments.of((Object[])new Object[]{"_leadingUnderscore", true, "Leading underscore error"}));
        args.add(Arguments.of((Object[])new Object[]{"kabob-case", true, "Kabob case error"}));
        args.add(Arguments.of((Object[])new Object[]{"-leadingDash", false, "Leading dash error"}));
        args.add(Arguments.of((Object[])new Object[]{"lowercase", true, "Lower case error"}));
        args.add(Arguments.of((Object[])new Object[]{"UPPERCASE", true, "Upper case error"}));
        for (char c : firstChars.toCharArray()) {
            s = String.format("%sMoreText", Character.valueOf(c));
            args.add(Arguments.of((Object[])new Object[]{s, true, String.format("testing: First character '%s'", Character.valueOf(c))}));
        }
        for (char c : restChars.toCharArray()) {
            s = String.format("Some%sText", Character.valueOf(c));
            args.add(Arguments.of((Object[])new Object[]{s, true, String.format("testing: Middle character '%s'", Character.valueOf(c))}));
        }
        for (char c : notFirstChars.toCharArray()) {
            s = String.format("%sMoreText", Character.valueOf(c));
            args.add(Arguments.of((Object[])new Object[]{s, false, String.format("testing: Bad first character '%s'", Character.valueOf(c))}));
        }
        for (char c : notRestChars.toCharArray()) {
            s = String.format("Some%sText", Character.valueOf(c));
            args.add(Arguments.of((Object[])new Object[]{s, false, String.format("testing: Bad middle character '%s'", Character.valueOf(c))}));
        }
        return args.stream();
    }

    @BeforeAll
    public static void setup() {
        int idx;
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (char c : PUNCTUATION.toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb2.append(c);
        }
        acceptablePunctuation = sb.toString();
        notAcceptablePunctuation = sb2.toString();
        sb = new StringBuilder();
        for (char c : OptionValidator.ADDITIONAL_LONG_CHARS) {
            sb.append(c);
        }
        additionalLongChars = sb.toString();
        sb = new StringBuilder();
        for (char c : OptionValidator.ADDITIONAL_OPTION_CHARS) {
            sb.append(c);
        }
        additionalOptonChars = sb.toString();
        String javaIdentifierPart = "a\u00d11\u0661\u06f2\u0968\uff14\u20ac$" + acceptablePunctuation + COMBINING_MARK + NON_SPACING_MARK + IDENTIFIER_IGNORABLE;
        firstChars = additionalOptonChars + javaIdentifierPart;
        sb = new StringBuilder(notAcceptablePunctuation).append(additionalLongChars);
        for (char c : OptionValidator.ADDITIONAL_OPTION_CHARS) {
            while ((idx = sb.indexOf(Character.toString(c))) > -1) {
                sb.deleteCharAt(idx);
            }
        }
        notFirstChars = sb.toString();
        restChars = additionalLongChars + javaIdentifierPart;
        sb = new StringBuilder(notAcceptablePunctuation).append(additionalOptonChars);
        for (char c : OptionValidator.ADDITIONAL_LONG_CHARS) {
            while ((idx = sb.indexOf(Character.toString(c))) > -1) {
                sb.deleteCharAt(idx);
            }
        }
        notRestChars = sb.toString();
    }

    @Test
    void testExclusivity() {
        for (char c : OptionValidator.ADDITIONAL_LONG_CHARS) {
            Assertions.assertFalse((boolean)Character.isJavaIdentifierPart(c), () -> String.format("'%s' should not be in 'ADDITIONAL_LONG_CHARS", Character.valueOf(c)));
        }
        for (char c : OptionValidator.ADDITIONAL_OPTION_CHARS) {
            Assertions.assertFalse((boolean)Character.isJavaIdentifierPart(c), () -> String.format("'%s' should not be in 'ADDITIONAL_OPTION_CHARS", Character.valueOf(c)));
        }
    }

    @ParameterizedTest(name="{2}")
    @MethodSource(value={"optionParameters"})
    void testValidate(String str, boolean expected, String name) {
        if (expected) {
            Assertions.assertEquals((Object)str, (Object)OptionValidator.validate((String)str));
        } else {
            Assertions.assertThrows(IllegalArgumentException.class, () -> OptionValidator.validate((String)str));
        }
    }
}

