/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.Optional;
import java.util.function.Function;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.vintage.engine.descriptor.DescriptionUtils;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.discovery.UniqueIdFilter;

class MethodSelectorResolver
implements SelectorResolver {
    MethodSelectorResolver() {
    }

    @Override
    public SelectorResolver.Resolution resolve(MethodSelector selector, SelectorResolver.Context context) {
        Class<?> testClass = selector.getJavaClass();
        return this.resolveParentAndAddFilter(context, DiscoverySelectors.selectClass(testClass), parent -> this.toMethodFilter(selector));
    }

    @Override
    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId current = selector.getUniqueId();
        while (!current.getSegments().isEmpty()) {
            if ("runner".equals(current.getLastSegment().getType())) {
                return this.resolveParentAndAddFilter(context, DiscoverySelectors.selectUniqueId(current), parent -> this.toUniqueIdFilter((RunnerTestDescriptor)parent, selector.getUniqueId()));
            }
            current = current.removeLastSegment();
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private SelectorResolver.Resolution resolveParentAndAddFilter(SelectorResolver.Context context, DiscoverySelector selector, Function<RunnerTestDescriptor, Filter> filterCreator) {
        return context.resolve(selector).flatMap(parent -> this.addFilter((TestDescriptor)parent, filterCreator)).map(this::toResolution).orElse(SelectorResolver.Resolution.unresolved());
    }

    private Optional<RunnerTestDescriptor> addFilter(TestDescriptor parent, Function<RunnerTestDescriptor, Filter> filterCreator) {
        if (parent instanceof RunnerTestDescriptor) {
            RunnerTestDescriptor runnerTestDescriptor = (RunnerTestDescriptor)parent;
            runnerTestDescriptor.getFilters().ifPresent(filters -> filters.add((Filter)filterCreator.apply(runnerTestDescriptor)));
            return Optional.of(runnerTestDescriptor);
        }
        return Optional.empty();
    }

    private SelectorResolver.Resolution toResolution(RunnerTestDescriptor parent) {
        return SelectorResolver.Resolution.match(SelectorResolver.Match.partial(parent));
    }

    private Filter toMethodFilter(MethodSelector methodSelector) {
        Class<?> testClass = methodSelector.getJavaClass();
        String methodName = methodSelector.getMethodName();
        return MethodSelectorResolver.matchMethodDescription(Description.createTestDescription(testClass, methodName));
    }

    private Filter toUniqueIdFilter(RunnerTestDescriptor runnerTestDescriptor, UniqueId uniqueId) {
        return new UniqueIdFilter(runnerTestDescriptor, uniqueId);
    }

    private static Filter matchMethodDescription(final Description desiredDescription) {
        final String desiredMethodName = DescriptionUtils.getMethodName(desiredDescription);
        return new Filter(){

            @Override
            public boolean shouldRun(Description description) {
                if (description.isTest()) {
                    return desiredDescription.equals(description) || this.isParameterizedMethod(description);
                }
                for (Description each : description.getChildren()) {
                    if (!this.shouldRun(each)) continue;
                    return true;
                }
                return false;
            }

            private boolean isParameterizedMethod(Description description) {
                String methodName = DescriptionUtils.getMethodName(description);
                return methodName.startsWith(desiredMethodName + "[");
            }

            @Override
            public String describe() {
                return String.format("Method %s", desiredDescription.getDisplayName());
            }
        };
    }
}

