/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api;

import lombok.Generated;
import org.apache.dolphinscheduler.api.metrics.ApiServerMetrics;
import org.apache.dolphinscheduler.common.CommonConfiguration;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.DefaultUncaughtExceptionHandler;
import org.apache.dolphinscheduler.dao.DaoConfiguration;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceProcessorProvider;
import org.apache.dolphinscheduler.plugin.storage.api.StorageConfiguration;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.registry.api.RegistryConfiguration;
import org.apache.dolphinscheduler.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.EventListener;

@Import(value={DaoConfiguration.class, CommonConfiguration.class, ServiceConfiguration.class, StorageConfiguration.class, RegistryConfiguration.class})
@ServletComponentScan
@SpringBootApplication
public class ApiApplicationServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiApplicationServer.class);
    @Autowired
    private PluginDao pluginDao;

    public static void main(String[] args) {
        ApiServerMetrics.registerUncachedException(DefaultUncaughtExceptionHandler::getUncaughtExceptionCount);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultUncaughtExceptionHandler.getInstance());
        SpringApplication.run(ApiApplicationServer.class, (String[])new String[0]);
    }

    @EventListener
    public void run(ApplicationReadyEvent readyEvent) {
        ServerLifeCycleManager.toRunning();
        log.info("Received spring application context ready event will load taskPlugin and write to DB");
        DataSourceProcessorProvider.initialize();
        TaskPluginManager.loadTaskPlugin();
    }
}

