/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.api;

import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperatorFactory;
import org.apache.dolphinscheduler.plugin.storage.api.StorageType;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class StorageConfiguration {
    @Bean
    public StorageOperator storageOperate() {
        Optional<StorageType> storageTypeOptional = StorageType.getStorageType(PropertyUtils.getUpperCaseString((String)"resource.storage.type"));
        Optional<StorageOperator> storageOperate = storageTypeOptional.map(storageType -> {
            ServiceLoader<StorageOperatorFactory> storageOperateFactories = ServiceLoader.load(StorageOperatorFactory.class);
            for (StorageOperatorFactory storageOperateFactory : storageOperateFactories) {
                if (storageOperateFactory.getStorageOperate() != storageType) continue;
                return storageOperateFactory.createStorageOperate();
            }
            return null;
        });
        return storageOperate.orElse(null);
    }
}

