/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.security;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;

public class AccessTokenContextRelay {
    private OAuth2ClientContext context;

    public AccessTokenContextRelay(OAuth2ClientContext context) {
        this.context = context;
    }

    public boolean copyToken() {
        Object details;
        Authentication authentication;
        if (this.context.getAccessToken() == null && (authentication = SecurityContextHolder.getContext().getAuthentication()) != null && (details = authentication.getDetails()) instanceof OAuth2AuthenticationDetails) {
            OAuth2AuthenticationDetails holder = (OAuth2AuthenticationDetails)details;
            String token = holder.getTokenValue();
            DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken(token);
            String tokenType = holder.getTokenType();
            if (tokenType != null) {
                accessToken.setTokenType(tokenType);
            }
            this.context.setAccessToken((OAuth2AccessToken)accessToken);
            return true;
        }
        return false;
    }
}

