/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster.loadbalancer;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.server.master.cluster.IClusters;
import org.apache.dolphinscheduler.server.master.cluster.WorkerClusters;
import org.apache.dolphinscheduler.server.master.cluster.WorkerServerMetadata;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.IWorkerLoadBalancer;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.WeightedServer;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.WorkerLoadBalancerType;
import org.jetbrains.annotations.NotNull;

public class FixedWeightedRoundRobinWorkerLoadBalancer
implements IWorkerLoadBalancer {
    private final WorkerClusters workerClusters;
    private final AtomicInteger robinIndex = new AtomicInteger(0);
    private final Map<String, WeightedServer<WorkerServerMetadata>> weightedServerMap = new ConcurrentHashMap<String, WeightedServer<WorkerServerMetadata>>();

    public FixedWeightedRoundRobinWorkerLoadBalancer(WorkerClusters workerClusters) {
        this.workerClusters = workerClusters;
        this.workerClusters.registerListener(new IClusters.IClustersChangeListener<WorkerServerMetadata>(){

            @Override
            public void onServerAdded(WorkerServerMetadata server) {
                FixedWeightedRoundRobinWorkerLoadBalancer.this.weightedServerMap.put(server.getAddress(), new WeightedServer<WorkerServerMetadata>(server, server.getWorkerWeight()));
            }

            @Override
            public void onServerRemove(WorkerServerMetadata server) {
                FixedWeightedRoundRobinWorkerLoadBalancer.this.weightedServerMap.remove(server.getAddress(), new WeightedServer<WorkerServerMetadata>(server, server.getWorkerWeight()));
            }

            @Override
            public void onServerUpdate(WorkerServerMetadata server) {
            }
        });
    }

    @Override
    public Optional<String> select(@NotNull String workerGroup) {
        List weightedServers = this.workerClusters.getNormalWorkerServerAddressByGroup(workerGroup).stream().map(this.weightedServerMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(weightedServers)) {
            return Optional.empty();
        }
        double totalWeight = weightedServers.stream().mapToDouble(WeightedServer::getWeight).sum();
        WeightedServer selectedWorker = null;
        while (selectedWorker == null) {
            WeightedServer tmpWorker = (WeightedServer)weightedServers.get(this.robinIndex.incrementAndGet() % weightedServers.size());
            tmpWorker.setCurrentWeight(tmpWorker.getCurrentWeight() + tmpWorker.getWeight());
            if (!(tmpWorker.getCurrentWeight() >= totalWeight)) continue;
            tmpWorker.setCurrentWeight(tmpWorker.getCurrentWeight() - totalWeight);
            selectedWorker = tmpWorker;
        }
        return Optional.of(((WorkerServerMetadata)selectedWorker.getServer()).getAddress());
    }

    @Override
    public WorkerLoadBalancerType getType() {
        return WorkerLoadBalancerType.FIXED_WEIGHTED_ROUND_ROBIN;
    }
}

