/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import lombok.Generated;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.ConnectionState;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterConnectionStateListener
implements ConnectionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterConnectionStateListener.class);
    private final RegistryClient registryClient;

    public MasterConnectionStateListener(RegistryClient registryClient) {
        this.registryClient = registryClient;
    }

    public void onUpdate(ConnectionState state) {
        log.info("Master received a {} event from registry, the current server state is {}", (Object)state, (Object)ServerLifeCycleManager.getServerStatus());
        switch (state) {
            case CONNECTED: {
                break;
            }
            case SUSPENDED: {
                break;
            }
            case RECONNECTED: {
                log.warn("Master reconnect to registry");
                break;
            }
            case DISCONNECTED: {
                this.registryClient.getStoppable().stop("Master disconnected from registry, will stop myself");
                break;
            }
            default: {
                log.warn("Unknown connection state: {}", (Object)state);
            }
        }
    }
}

