/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyReleasePolicy;
import com.azure.security.keyvault.keys.models.KeyType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public class KeyVaultKey {
    @JsonProperty(value="key")
    private JsonWebKey key;
    final KeyProperties properties;

    KeyVaultKey() {
        this.properties = new KeyProperties();
    }

    KeyVaultKey(KeyProperties keyProperties, JsonWebKey jsonWebKey) {
        this.properties = keyProperties;
        this.key = jsonWebKey;
    }

    public JsonWebKey getKey() {
        return this.key;
    }

    public KeyProperties getProperties() {
        return this.properties;
    }

    public String getId() {
        return this.properties.getId();
    }

    public String getName() {
        return this.properties.getName();
    }

    public KeyType getKeyType() {
        return this.key.getKeyType();
    }

    public List<KeyOperation> getKeyOperations() {
        return this.key.getKeyOps();
    }

    @JsonProperty(value="key")
    private void unpackKeyMaterial(Map<String, Object> key) {
        this.key = this.properties.createKeyMaterialFromJson(key);
    }

    @JsonProperty(value="attributes")
    private void unpackAttributes(Map<String, Object> attributes) {
        this.properties.unpackAttributes(attributes);
    }

    @JsonProperty(value="tags")
    private void setTags(Map<String, String> tags) {
        this.properties.setTags(tags);
    }

    @JsonProperty(value="managed")
    private void setManaged(boolean managed) {
        this.properties.setManaged(managed);
    }

    @JsonProperty(value="release_policy")
    private void setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.properties.setReleasePolicy(releasePolicy);
    }
}

