/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.options;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.models.ShareRequestConditions;
import java.util.Map;

public final class ShareFileRenameOptions {
    private static final ClientLogger LOGGER = new ClientLogger(ShareFileRenameOptions.class);
    private final String destinationPath;
    private Boolean replaceIfExists;
    private Boolean ignoreReadOnly;
    private ShareRequestConditions sourceRequestConditions;
    private ShareRequestConditions destinationRequestConditions;
    private String filePermission;
    private FileSmbProperties smbProperties;
    private Map<String, String> metadata;
    private String contentType;

    public ShareFileRenameOptions(String destinationPath) {
        StorageImplUtils.assertNotNull((String)"destinationPath", (Object)destinationPath);
        this.destinationPath = destinationPath;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public Boolean getReplaceIfExists() {
        return this.replaceIfExists;
    }

    public ShareFileRenameOptions setReplaceIfExists(Boolean replaceIfExists) {
        this.replaceIfExists = replaceIfExists;
        return this;
    }

    public Boolean isIgnoreReadOnly() {
        return this.ignoreReadOnly;
    }

    public ShareFileRenameOptions setIgnoreReadOnly(Boolean ignoreReadOnly) {
        this.ignoreReadOnly = ignoreReadOnly;
        return this;
    }

    public ShareRequestConditions getSourceRequestConditions() {
        return this.sourceRequestConditions;
    }

    public ShareFileRenameOptions setSourceRequestConditions(ShareRequestConditions sourceRequestConditions) {
        this.sourceRequestConditions = sourceRequestConditions;
        return this;
    }

    public ShareRequestConditions getDestinationRequestConditions() {
        return this.destinationRequestConditions;
    }

    public ShareFileRenameOptions setDestinationRequestConditions(ShareRequestConditions destinationRequestConditions) {
        this.destinationRequestConditions = destinationRequestConditions;
        return this;
    }

    public String getFilePermission() {
        return this.filePermission;
    }

    public ShareFileRenameOptions setFilePermission(String filePermission) {
        this.filePermission = filePermission;
        return this;
    }

    public FileSmbProperties getSmbProperties() {
        return this.smbProperties;
    }

    public ShareFileRenameOptions setSmbProperties(FileSmbProperties smbProperties) {
        this.smbProperties = smbProperties;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ShareFileRenameOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ShareFileRenameOptions setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }
}

