/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannelFactory;

public final class TaskMetrics {
    private static final Map<String, Counter> taskTypeExecutionCounter = new HashMap<String, Counter>();
    private static final Counter taskUnknownTypeExecutionCounter = Counter.builder((String)"ds.task.execution.count.by.type").tag("task_type", "unknown").description("task execution counter by type").register((MeterRegistry)Metrics.globalRegistry);

    public static void incrTaskTypeExecuteCount(String taskType) {
        taskTypeExecutionCounter.getOrDefault(taskType, taskUnknownTypeExecutionCounter).increment();
    }

    @Generated
    private TaskMetrics() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (TaskChannelFactory taskChannelFactory : ServiceLoader.load(TaskChannelFactory.class)) {
            taskTypeExecutionCounter.put(taskChannelFactory.getName(), Counter.builder((String)"ds.task.execution.count.by.type").tag("task_type", taskChannelFactory.getName()).description("task execution counter by type").register((MeterRegistry)Metrics.globalRegistry));
        }
    }
}

