/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.cdn.CdnManager;
import com.azure.resourcemanager.cdn.fluent.CdnManagementClient;
import com.azure.resourcemanager.cdn.fluent.ProfilesClient;
import com.azure.resourcemanager.cdn.fluent.models.ProfileInner;
import com.azure.resourcemanager.cdn.fluent.models.SsoUriInner;
import com.azure.resourcemanager.cdn.implementation.CdnProfileImpl;
import com.azure.resourcemanager.cdn.models.CdnProfile;
import com.azure.resourcemanager.cdn.models.CdnProfiles;
import com.azure.resourcemanager.cdn.models.CheckNameAvailabilityInput;
import com.azure.resourcemanager.cdn.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.cdn.models.EdgeNode;
import com.azure.resourcemanager.cdn.models.LoadParameters;
import com.azure.resourcemanager.cdn.models.Operation;
import com.azure.resourcemanager.cdn.models.PurgeParameters;
import com.azure.resourcemanager.cdn.models.ResourceType;
import com.azure.resourcemanager.cdn.models.ResourceUsage;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.List;
import reactor.core.publisher.Mono;

public final class CdnProfilesImpl
extends TopLevelModifiableResourcesImpl<CdnProfile, CdnProfileImpl, ProfileInner, ProfilesClient, CdnManager>
implements CdnProfiles {
    public CdnProfilesImpl(CdnManager cdnManager) {
        super((InnerSupportsListing)((CdnManagementClient)cdnManager.serviceClient()).getProfiles(), (Manager)cdnManager);
    }

    protected CdnProfileImpl wrapModel(String name) {
        return new CdnProfileImpl(name, new ProfileInner(), (CdnManager)this.manager());
    }

    protected CdnProfileImpl wrapModel(ProfileInner inner) {
        if (inner == null) {
            return null;
        }
        return new CdnProfileImpl(inner.name(), inner, (CdnManager)this.manager());
    }

    public CdnProfileImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public String generateSsoUri(String resourceGroupName, String profileName) {
        SsoUriInner ssoUri = ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getProfiles().generateSsoUri(resourceGroupName, profileName);
        if (ssoUri != null) {
            return ssoUri.ssoUriValue();
        }
        return null;
    }

    @Override
    public CheckNameAvailabilityResult checkEndpointNameAvailability(String name) {
        return (CheckNameAvailabilityResult)this.checkEndpointNameAvailabilityAsync(name).block();
    }

    @Override
    public Mono<CheckNameAvailabilityResult> checkEndpointNameAvailabilityAsync(String name) {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).checkNameAvailabilityAsync(new CheckNameAvailabilityInput().withName(name).withType(ResourceType.MICROSOFT_CDN_PROFILES_ENDPOINTS)).map(CheckNameAvailabilityResult::new);
    }

    @Override
    public PagedIterable<Operation> listOperations() {
        return PagedConverter.mapPage(((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getOperations().list(), Operation::new);
    }

    @Override
    public PagedIterable<ResourceUsage> listResourceUsage() {
        return PagedConverter.mapPage(((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getResourceUsages().list(), ResourceUsage::new);
    }

    @Override
    public PagedIterable<EdgeNode> listEdgeNodes() {
        return PagedConverter.mapPage(((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEdgeNodes().list(), EdgeNode::new);
    }

    @Override
    public void startEndpoint(String resourceGroupName, String profileName, String endpointName) {
        ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().start(resourceGroupName, profileName, endpointName);
    }

    @Override
    public void stopEndpoint(String resourceGroupName, String profileName, String endpointName) {
        ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().stop(resourceGroupName, profileName, endpointName);
    }

    @Override
    public void purgeEndpointContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().purgeContent(resourceGroupName, profileName, endpointName, new PurgeParameters().withContentPaths(contentPaths));
    }

    @Override
    public void loadEndpointContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().loadContent(resourceGroupName, profileName, endpointName, new LoadParameters().withContentPaths(contentPaths));
    }
}

