/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyReleasePolicy;
import com.azure.security.keyvault.keys.models.KeyType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class KeyProperties {
    Boolean enabled;
    Boolean exportable;
    OffsetDateTime notBefore;
    String version;
    OffsetDateTime expiresOn;
    private OffsetDateTime createdOn;
    private OffsetDateTime updatedOn;
    private String recoveryLevel;
    String name;
    @JsonProperty(value="kid")
    String id;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="managed", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean managed;
    @JsonProperty(value="recoverableDays", access=JsonProperty.Access.WRITE_ONLY)
    private Integer recoverableDays;
    @JsonProperty(value="release_policy")
    private KeyReleasePolicy releasePolicy;

    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    public KeyProperties setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    public String getRecoveryLevel() {
        return this.recoveryLevel;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public KeyProperties setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean isExportable() {
        return this.exportable;
    }

    public KeyProperties setExportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    public OffsetDateTime getNotBefore() {
        return this.notBefore;
    }

    public KeyProperties setNotBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public KeyProperties setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public KeyProperties setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="attributes")
    void unpackAttributes(Map<String, Object> attributes) {
        this.enabled = (Boolean)attributes.get("enabled");
        this.exportable = (Boolean)attributes.get("exportable");
        this.notBefore = this.epochToOffsetDateTime(attributes.get("nbf"));
        this.expiresOn = this.epochToOffsetDateTime(attributes.get("exp"));
        this.createdOn = this.epochToOffsetDateTime(attributes.get("created"));
        this.updatedOn = this.epochToOffsetDateTime(attributes.get("updated"));
        this.recoveryLevel = (String)attributes.get("recoveryLevel");
        this.recoverableDays = (Integer)attributes.get("recoverableDays");
    }

    private OffsetDateTime epochToOffsetDateTime(Object epochValue) {
        if (epochValue != null) {
            Instant instant = Instant.ofEpochMilli(((Number)epochValue).longValue() * 1000L);
            return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        return null;
    }

    Object lazyValueSelection(Object input1, Object input2) {
        if (input1 == null) {
            return input2;
        }
        return input1;
    }

    @JsonProperty(value="kid")
    void unpackId(String keyId) {
        if (keyId != null && keyId.length() > 0) {
            this.id = keyId;
            try {
                URL url = new URL(keyId);
                String[] tokens = url.getPath().split("/");
                this.name = tokens.length >= 3 ? tokens[2] : null;
                this.version = tokens.length >= 4 ? tokens[3] : null;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    List<KeyOperation> getKeyOperations(List<String> jsonWebKeyOps) {
        ArrayList<KeyOperation> output = new ArrayList<KeyOperation>();
        for (String keyOp : jsonWebKeyOps) {
            output.add(KeyOperation.fromString(keyOp));
        }
        return output;
    }

    JsonWebKey createKeyMaterialFromJson(Map<String, Object> key) {
        JsonWebKey outputKey = new JsonWebKey().setY(this.decode((String)key.get("y"))).setX(this.decode((String)key.get("x"))).setCurveName(KeyCurveName.fromString((String)key.get("crv"))).setKeyOps(this.getKeyOperations((List)key.get("key_ops"))).setT(this.decode((String)key.get("key_hsm"))).setK(this.decode((String)key.get("k"))).setQ(this.decode((String)key.get("q"))).setP(this.decode((String)key.get("p"))).setQi(this.decode((String)key.get("qi"))).setDq(this.decode((String)key.get("dq"))).setDp(this.decode((String)key.get("dp"))).setD(this.decode((String)key.get("d"))).setE(this.decode((String)key.get("e"))).setN(this.decode((String)key.get("n"))).setKeyType(KeyType.fromString((String)key.get("kty"))).setId((String)key.get("kid"));
        this.unpackId((String)key.get("kid"));
        return outputKey;
    }

    void setManaged(boolean managed) {
        this.managed = managed;
    }

    private byte[] decode(String in) {
        if (in != null) {
            return Base64.getUrlDecoder().decode(in);
        }
        return null;
    }
}

