/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VerifyMode {
    POINT_IN_TIME_CONSISTENT("POINT_IN_TIME_CONSISTENT"),
    ONLY_FILES_TRANSFERRED("ONLY_FILES_TRANSFERRED"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VerifyMode> VALUE_MAP;
    private final String value;

    private VerifyMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VerifyMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VerifyMode> knownValues() {
        EnumSet<VerifyMode> knownValues = EnumSet.allOf(VerifyMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VerifyMode.class, VerifyMode::toString);
    }
}

