/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.CopyActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.LogSettings;
import com.azure.resourcemanager.datafactory.models.LogStorageSettings;
import com.azure.resourcemanager.datafactory.models.RedirectIncompatibleRowSettings;
import com.azure.resourcemanager.datafactory.models.SkipErrorFile;
import com.azure.resourcemanager.datafactory.models.StagingSettings;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Copy")
public final class CopyActivity
extends ExecutionActivity {
    @JsonProperty(value="typeProperties", required=true)
    private CopyActivityTypeProperties innerTypeProperties = new CopyActivityTypeProperties();
    @JsonProperty(value="inputs")
    private List<DatasetReference> inputs;
    @JsonProperty(value="outputs")
    private List<DatasetReference> outputs;
    private static final ClientLogger LOGGER = new ClientLogger(CopyActivity.class);

    private CopyActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public List<DatasetReference> inputs() {
        return this.inputs;
    }

    public CopyActivity withInputs(List<DatasetReference> inputs) {
        this.inputs = inputs;
        return this;
    }

    public List<DatasetReference> outputs() {
        return this.outputs;
    }

    public CopyActivity withOutputs(List<DatasetReference> outputs) {
        this.outputs = outputs;
        return this;
    }

    @Override
    public CopyActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public CopyActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public CopyActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public CopyActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public CopyActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public CopyActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public CopySource source() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().source();
    }

    public CopyActivity withSource(CopySource source) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withSource(source);
        return this;
    }

    public CopySink sink() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sink();
    }

    public CopyActivity withSink(CopySink sink) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withSink(sink);
        return this;
    }

    public Object translator() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().translator();
    }

    public CopyActivity withTranslator(Object translator) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withTranslator(translator);
        return this;
    }

    public Object enableStaging() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableStaging();
    }

    public CopyActivity withEnableStaging(Object enableStaging) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withEnableStaging(enableStaging);
        return this;
    }

    public StagingSettings stagingSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().stagingSettings();
    }

    public CopyActivity withStagingSettings(StagingSettings stagingSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withStagingSettings(stagingSettings);
        return this;
    }

    public Object parallelCopies() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().parallelCopies();
    }

    public CopyActivity withParallelCopies(Object parallelCopies) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withParallelCopies(parallelCopies);
        return this;
    }

    public Object dataIntegrationUnits() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataIntegrationUnits();
    }

    public CopyActivity withDataIntegrationUnits(Object dataIntegrationUnits) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withDataIntegrationUnits(dataIntegrationUnits);
        return this;
    }

    public Object enableSkipIncompatibleRow() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableSkipIncompatibleRow();
    }

    public CopyActivity withEnableSkipIncompatibleRow(Object enableSkipIncompatibleRow) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withEnableSkipIncompatibleRow(enableSkipIncompatibleRow);
        return this;
    }

    public RedirectIncompatibleRowSettings redirectIncompatibleRowSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().redirectIncompatibleRowSettings();
    }

    public CopyActivity withRedirectIncompatibleRowSettings(RedirectIncompatibleRowSettings redirectIncompatibleRowSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withRedirectIncompatibleRowSettings(redirectIncompatibleRowSettings);
        return this;
    }

    public LogStorageSettings logStorageSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logStorageSettings();
    }

    public CopyActivity withLogStorageSettings(LogStorageSettings logStorageSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withLogStorageSettings(logStorageSettings);
        return this;
    }

    public LogSettings logSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logSettings();
    }

    public CopyActivity withLogSettings(LogSettings logSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withLogSettings(logSettings);
        return this;
    }

    public List<Object> preserveRules() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().preserveRules();
    }

    public CopyActivity withPreserveRules(List<Object> preserveRules) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withPreserveRules(preserveRules);
        return this;
    }

    public List<Object> preserve() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().preserve();
    }

    public CopyActivity withPreserve(List<Object> preserve) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withPreserve(preserve);
        return this;
    }

    public Object validateDataConsistency() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().validateDataConsistency();
    }

    public CopyActivity withValidateDataConsistency(Object validateDataConsistency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withValidateDataConsistency(validateDataConsistency);
        return this;
    }

    public SkipErrorFile skipErrorFile() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().skipErrorFile();
    }

    public CopyActivity withSkipErrorFile(SkipErrorFile skipErrorFile) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withSkipErrorFile(skipErrorFile);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model CopyActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.inputs() != null) {
            this.inputs().forEach(e -> e.validate());
        }
        if (this.outputs() != null) {
            this.outputs().forEach(e -> e.validate());
        }
    }
}

