/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.monitor.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.monitor.fluent.models.PrivateLinkResourceListResultInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import reactor.core.publisher.Mono;

public final class PrivateLinkResourcesClientImpl
implements PrivateLinkResourcesClient {
    private final PrivateLinkResourcesService service;
    private final MonitorClientImpl client;

    PrivateLinkResourcesClientImpl(MonitorClientImpl client) {
        this.service = (PrivateLinkResourcesService)RestProxy.create(PrivateLinkResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PrivateLinkResourceListResultInner>> listByPrivateLinkScopeWithResponseAsync(String resourceGroupName, String scopeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (scopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeName is required and cannot be null."));
        }
        String apiVersion = "2021-07-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByPrivateLinkScope(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2021-07-01-preview", scopeName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourceListResultInner>> listByPrivateLinkScopeWithResponseAsync(String resourceGroupName, String scopeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (scopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeName is required and cannot be null."));
        }
        String apiVersion = "2021-07-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByPrivateLinkScope(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2021-07-01-preview", scopeName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PrivateLinkResourceListResultInner> listByPrivateLinkScopeAsync(String resourceGroupName, String scopeName) {
        return this.listByPrivateLinkScopeWithResponseAsync(resourceGroupName, scopeName).flatMap(res -> Mono.justOrEmpty((Object)((PrivateLinkResourceListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateLinkResourceListResultInner listByPrivateLinkScope(String resourceGroupName, String scopeName) {
        return (PrivateLinkResourceListResultInner)this.listByPrivateLinkScopeAsync(resourceGroupName, scopeName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateLinkResourceListResultInner> listByPrivateLinkScopeWithResponse(String resourceGroupName, String scopeName, Context context) {
        return (Response)this.listByPrivateLinkScopeWithResponseAsync(resourceGroupName, scopeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PrivateLinkResourceInner>> getWithResponseAsync(String resourceGroupName, String scopeName, String groupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (scopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeName is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        String apiVersion = "2021-07-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2021-07-01-preview", scopeName, groupName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourceInner>> getWithResponseAsync(String resourceGroupName, String scopeName, String groupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (scopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeName is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        String apiVersion = "2021-07-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2021-07-01-preview", scopeName, groupName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PrivateLinkResourceInner> getAsync(String resourceGroupName, String scopeName, String groupName) {
        return this.getWithResponseAsync(resourceGroupName, scopeName, groupName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PrivateLinkResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateLinkResourceInner get(String resourceGroupName, String scopeName, String groupName) {
        return (PrivateLinkResourceInner)((Object)this.getAsync(resourceGroupName, scopeName, groupName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateLinkResourceInner> getWithResponse(String resourceGroupName, String scopeName, String groupName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, scopeName, groupName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientPrivate")
    private static interface PrivateLinkResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/privateLinkScopes/{scopeName}/privateLinkResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateLinkResourceListResultInner>> listByPrivateLinkScope(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="scopeName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/privateLinkScopes/{scopeName}/privateLinkResources/{groupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateLinkResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="scopeName") String var5, @PathParam(value="groupName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

