/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.trafficmanager.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.trafficmanager.fluent.HeatMapsClient;
import com.azure.resourcemanager.trafficmanager.fluent.models.HeatMapModelInner;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerManagementClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class HeatMapsClientImpl
implements HeatMapsClient {
    private final HeatMapsService service;
    private final TrafficManagerManagementClientImpl client;

    HeatMapsClientImpl(TrafficManagerManagementClientImpl client) {
        this.service = (HeatMapsService)RestProxy.create(HeatMapsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HeatMapModelInner>> getWithResponseAsync(String resourceGroupName, String profileName, List<Double> topLeft, List<Double> botRight) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        String heatMapType = "default";
        String accept = "application/json";
        String topLeftConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(topLeft, CollectionFormat.CSV);
        String botRightConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(botRight, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, profileName, "default", topLeftConverted, botRightConverted, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HeatMapModelInner>> getWithResponseAsync(String resourceGroupName, String profileName, List<Double> topLeft, List<Double> botRight, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        String heatMapType = "default";
        String accept = "application/json";
        String topLeftConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(topLeft, CollectionFormat.CSV);
        String botRightConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(botRight, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, profileName, "default", topLeftConverted, botRightConverted, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HeatMapModelInner> getAsync(String resourceGroupName, String profileName) {
        List<Double> topLeft = null;
        List<Double> botRight = null;
        return this.getWithResponseAsync(resourceGroupName, profileName, topLeft, botRight).flatMap(res -> Mono.justOrEmpty((Object)((Object)((HeatMapModelInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HeatMapModelInner> getWithResponse(String resourceGroupName, String profileName, List<Double> topLeft, List<Double> botRight, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, profileName, topLeft, botRight, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HeatMapModelInner get(String resourceGroupName, String profileName) {
        List<Double> topLeft = null;
        List<Double> botRight = null;
        return (HeatMapModelInner)((Object)this.getWithResponse(resourceGroupName, profileName, topLeft, botRight, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="TrafficManagerManage")
    private static interface HeatMapsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/heatMaps/{heatMapType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<HeatMapModelInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="profileName") String var4, @PathParam(value="heatMapType") String var5, @QueryParam(value="topLeft") String var6, @QueryParam(value="botRight") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

