/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.resourcemanager.network.fluent.models.LoadBalancingRuleInner;
import com.azure.resourcemanager.network.models.HasBackendPort;
import com.azure.resourcemanager.network.models.HasFloatingIP;
import com.azure.resourcemanager.network.models.HasFrontend;
import com.azure.resourcemanager.network.models.HasFrontendPort;
import com.azure.resourcemanager.network.models.HasNetworkInterfaces;
import com.azure.resourcemanager.network.models.HasProtocol;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerBackend;
import com.azure.resourcemanager.network.models.LoadBalancerProbe;
import com.azure.resourcemanager.network.models.LoadDistribution;
import com.azure.resourcemanager.network.models.TransportProtocol;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ChildResource;
import com.azure.resourcemanager.resources.fluentcore.model.Attachable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Settable;
import java.util.Collection;

public interface LoadBalancingRule
extends HasInnerModel<LoadBalancingRuleInner>,
ChildResource<LoadBalancer>,
HasBackendPort,
HasFrontend,
HasFloatingIP,
HasProtocol<TransportProtocol>,
HasFrontendPort {
    public LoadDistribution loadDistribution();

    public int idleTimeoutInMinutes();

    public LoadBalancerBackend backend();

    public LoadBalancerProbe probe();

    public static interface UpdateDefinition<ReturnT>
    extends UpdateDefinitionStages.Blank<ReturnT>,
    UpdateDefinitionStages.WithAttach<ReturnT>,
    UpdateDefinitionStages.WithProtocol<ReturnT>,
    UpdateDefinitionStages.WithFrontendPort<ReturnT>,
    UpdateDefinitionStages.WithFrontend<ReturnT>,
    UpdateDefinitionStages.WithBackend<ReturnT>,
    UpdateDefinitionStages.WithBackendPort<ReturnT> {
    }

    public static interface UpdateDefinitionStages {

        public static interface WithAttach<ReturnT>
        extends Attachable.InUpdate<ReturnT>,
        WithFloatingIP<ReturnT>,
        WithIdleTimeoutInMinutes<ReturnT>,
        WithLoadDistribution<ReturnT>,
        WithProbe<ReturnT> {
        }

        public static interface WithLoadDistribution<ReturnT> {
            public WithAttach<ReturnT> withLoadDistribution(LoadDistribution var1);
        }

        public static interface WithIdleTimeoutInMinutes<ReturnT> {
            public WithAttach<ReturnT> withIdleTimeoutInMinutes(int var1);
        }

        public static interface WithFloatingIP<ReturnT>
        extends HasFloatingIP.UpdateDefinitionStages.WithFloatingIP<WithAttach<ReturnT>> {
        }

        public static interface WithBackendPort<ReturnT>
        extends HasBackendPort.UpdateDefinitionStages.WithBackendPort<WithAttach<ReturnT>>,
        WithAttach<ReturnT> {
        }

        public static interface WithVirtualMachine<ReturnT> {
            public WithBackendPort<ReturnT> toExistingVirtualMachines(HasNetworkInterfaces ... var1);

            public WithBackendPort<ReturnT> toExistingVirtualMachines(Collection<HasNetworkInterfaces> var1);
        }

        public static interface WithBackend<ReturnT>
        extends WithVirtualMachine<ReturnT> {
            public WithBackendPort<ReturnT> toBackend(String var1);
        }

        public static interface WithProbe<ReturnT> {
            public WithAttach<ReturnT> withProbe(String var1);
        }

        public static interface WithFrontend<ReturnT>
        extends HasFrontend.UpdateDefinitionStages.WithFrontend<WithFrontendPort<ReturnT>> {
        }

        public static interface WithFrontendPort<ReturnT>
        extends HasFrontendPort.UpdateDefinitionStages.WithFrontendPort<WithBackend<ReturnT>> {
        }

        public static interface WithProtocol<ReturnT>
        extends HasProtocol.UpdateDefinitionStages.WithProtocol<WithFrontend<ReturnT>, TransportProtocol> {
        }

        public static interface Blank<ReturnT>
        extends WithProtocol<ReturnT> {
        }
    }

    public static interface Update
    extends Settable<LoadBalancer.Update>,
    UpdateStages.WithFrontendPort,
    UpdateStages.WithFrontend,
    UpdateStages.WithProtocol,
    UpdateStages.WithBackendPort,
    UpdateStages.WithFloatingIP,
    UpdateStages.WithIdleTimeoutInMinutes,
    UpdateStages.WithLoadDistribution,
    UpdateStages.WithProbe {
    }

    public static interface UpdateStages {

        public static interface WithLoadDistribution {
            public Update withLoadDistribution(LoadDistribution var1);
        }

        public static interface WithProbe {
            public Update withProbe(String var1);

            public Update withoutProbe();
        }

        public static interface WithIdleTimeoutInMinutes {
            public Update withIdleTimeoutInMinutes(int var1);
        }

        public static interface WithFloatingIP
        extends HasFloatingIP.UpdateStages.WithFloatingIP<Update> {
        }

        public static interface WithBackendPort
        extends HasBackendPort.UpdateStages.WithBackendPort<Update> {
        }

        public static interface WithFrontend
        extends HasFrontend.UpdateStages.WithFrontend<Update> {
        }

        public static interface WithFrontendPort
        extends HasFrontendPort.UpdateStages.WithFrontendPort<Update> {
        }

        public static interface WithProtocol
        extends HasProtocol.UpdateStages.WithProtocol<Update, TransportProtocol> {
        }
    }

    public static interface Definition<ReturnT>
    extends DefinitionStages.Blank<ReturnT>,
    DefinitionStages.WithAttach<ReturnT>,
    DefinitionStages.WithProtocol<ReturnT>,
    DefinitionStages.WithFrontendPort<ReturnT>,
    DefinitionStages.WithFrontend<ReturnT>,
    DefinitionStages.WithBackend<ReturnT>,
    DefinitionStages.WithBackendPort<ReturnT> {
    }

    public static interface DefinitionStages {

        public static interface WithLoadDistribution<ReturnT> {
            public WithAttach<ReturnT> withLoadDistribution(LoadDistribution var1);
        }

        public static interface WithIdleTimeoutInMinutes<ReturnT> {
            public WithAttach<ReturnT> withIdleTimeoutInMinutes(int var1);
        }

        public static interface WithFloatingIP<ReturnT>
        extends HasFloatingIP.DefinitionStages.WithFloatingIP<WithAttach<ReturnT>> {
        }

        public static interface WithAttach<ReturnT>
        extends Attachable.InDefinition<ReturnT>,
        WithFloatingIP<ReturnT>,
        WithIdleTimeoutInMinutes<ReturnT>,
        WithLoadDistribution<ReturnT>,
        WithProbe<ReturnT> {
        }

        public static interface WithBackendPort<ReturnT>
        extends HasBackendPort.DefinitionStages.WithBackendPort<WithAttach<ReturnT>>,
        WithAttach<ReturnT> {
        }

        public static interface WithVirtualMachine<ReturnT> {
            public WithBackendPort<ReturnT> toExistingVirtualMachines(HasNetworkInterfaces ... var1);

            public WithBackendPort<ReturnT> toExistingVirtualMachines(Collection<HasNetworkInterfaces> var1);
        }

        public static interface WithBackend<ReturnT>
        extends WithVirtualMachine<ReturnT> {
            public WithBackendPort<ReturnT> toBackend(String var1);
        }

        public static interface WithProbe<ReturnT> {
            public WithAttach<ReturnT> withProbe(String var1);
        }

        public static interface WithFrontend<ReturnT>
        extends HasFrontend.DefinitionStages.WithFrontend<WithFrontendPort<ReturnT>> {
        }

        public static interface WithFrontendPort<ReturnT>
        extends HasFrontendPort.DefinitionStages.WithFrontendPort<WithBackend<ReturnT>> {
        }

        public static interface WithProtocol<ReturnT>
        extends HasProtocol.DefinitionStages.WithProtocol<WithFrontend<ReturnT>, TransportProtocol> {
        }

        public static interface Blank<ReturnT>
        extends WithProtocol<ReturnT> {
        }
    }
}

