/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationProfileInner;
import com.azure.resourcemanager.network.fluent.models.NetworkProfileInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceConfiguration;
import com.azure.resourcemanager.network.models.NetworkProfile;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.network.models.TagsObject;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

final class NetworkProfileImpl
extends GroupableParentResourceWithTagsImpl<NetworkProfile, NetworkProfileInner, NetworkProfileImpl, NetworkManager>
implements NetworkProfile,
NetworkProfile.Definition,
NetworkProfile.Update {
    NetworkProfileImpl(String name, NetworkProfileInner innerObject, NetworkManager manager) {
        super(name, innerObject, manager);
    }

    @Override
    public List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations() {
        List<ContainerNetworkInterfaceConfiguration> inner = ((NetworkProfileInner)((Object)this.innerModel())).containerNetworkInterfaceConfigurations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    protected Mono<NetworkProfileInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkProfiles().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((NetworkProfileInner)((Object)this.innerModel())).tags()));
    }

    protected Mono<NetworkProfileInner> createInner() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkProfiles().createOrUpdateAsync(this.resourceGroupName(), this.name(), (NetworkProfileInner)((Object)this.innerModel()));
    }

    protected void initializeChildrenFromInner() {
    }

    protected Mono<NetworkProfileInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkProfiles().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public NetworkProfileImpl withContainerNetworkInterfaceConfiguration(String name, String ipConfigName, String virtualNetworkId, String subnetName) {
        String subnetId = String.format("%s/subnets/%s", virtualNetworkId, subnetName);
        return this.withContainerNetworkInterfaceConfiguration(name, ipConfigName, subnetId);
    }

    @Override
    public NetworkProfileImpl withContainerNetworkInterfaceConfiguration(String name, String ipConfigName, Subnet subnet) {
        return this.withContainerNetworkInterfaceConfiguration(name, ipConfigName, subnet.id());
    }

    private NetworkProfileImpl withContainerNetworkInterfaceConfiguration(String name, String ipConfigName, String subnetId) {
        ((NetworkProfileInner)((Object)this.innerModel())).withContainerNetworkInterfaceConfigurations(Collections.singletonList(new ContainerNetworkInterfaceConfiguration().withName(name).withIpConfigurations(Collections.singletonList(new IpConfigurationProfileInner().withName(ipConfigName).withSubnet(new SubnetInner().withId(subnetId))))));
        return this;
    }
}

